/*
    This file is part of the iText (R) project.
    Copyright (c) 1998-2023 iText Group NV
    Authors: Bruno Lowagie, Paulo Soares, et al.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU Affero General Public License version 3
    as published by the Free Software Foundation with the addition of the
    following permission added to Section 15 as permitted in Section 7(a):
    FOR ANY PART OF THE COVERED WORK IN WHICH THE COPYRIGHT IS OWNED BY
    ITEXT GROUP. ITEXT GROUP DISCLAIMS THE WARRANTY OF NON INFRINGEMENT
    OF THIRD PARTY RIGHTS

    This program is distributed in the hope that it will be useful, but
    WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
    or FITNESS FOR A PARTICULAR PURPOSE.
    See the GNU Affero General Public License for more details.
    You should have received a copy of the GNU Affero General Public License
    along with this program; if not, see http://www.gnu.org/licenses or write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA, 02110-1301 USA, or download the license from the following URL:
    http://itextpdf.com/terms-of-use/

    The interactive user interfaces in modified source and object code versions
    of this program must display Appropriate Legal Notices, as required under
    Section 5 of the GNU Affero General Public License.

    In accordance with Section 7(b) of the GNU Affero General Public License,
    a covered work must retain the producer line in every PDF that is created
    or manipulated using iText.

    You can be released from the requirements of the license by purchasing
    a commercial license. Buying such a license is mandatory as soon as you
    develop commercial activities involving the iText software without
    disclosing the source code of your own applications.
    These activities include: offering paid services to customers as an ASP,
    serving PDFs on the fly in a web application, shipping iText with a closed
    source product.

    For more information, please contact iText Software Corp. at this
    address: sales@itextpdf.com
 */
package com.itextpdf.html2pdf.html;

/**
 * Class that bundles a series of tag constants.
 */
public final class TagConstants {

    /**
     * Creates a new {@link TagConstants} instance.
     */
    private TagConstants() {
    }

    /** The Constant A. */
    public static final String A = "a";

    /** The Constant ABBR. */
    public static final String ABBR = "abbr";

    /** The Constant ADDRESS. */
    public static final String ADDRESS="address";

    /** The Constant ARTICLE. */
    public static final String ARTICLE = "article";

    /** The Constant ASIDE. */
    public static final String ASIDE = "aside";

    /** The Constant B. */
    public static final String B = "b";

    /** The Constant BDI. */
    public static final String BDI = "bdi";

    /** The Constant BDO. */
    public static final String BDO = "bdo";

    /** The Constant BIG. */
    public static final String BIG = "big";

    /** The Constant BLOCKQUOTE. */
    public static final String BLOCKQUOTE = "blockquote";

    /** The Constant BODY. */
    public static final String BODY = "body";

	/** The Constant BR. */
	public static final String BR = "br";

    /** The Constant BUTTON. */
    public static final String BUTTON = "button";

    /** The Constant CAPTION. */
    public static final String CAPTION = "caption";

    /** The Constant CENTER. */
    public static final String CENTER = "center";

    /** The Constant CITE. */
    public static final String CITE = "cite";

    /** The Constant CODE. */
    public static final String CODE = "code";

    /** The Constant COL. */
    public static final String COL = "col";

    /** The Constant COLGROUP. */
    public static final String COLGROUP = "colgroup";

    /** The Constant DD. */
    public static final String DD = "dd";

    /** The Constant DEL. */
    public static final String DEL = "del";

    /** The Constant DFN. */
    public static final String DFN = "dfn";

    /** The Constant DL. */
    public static final String DL = "dl";

    /** The Constant DT. */
    public static final String DT = "dt";

    /** The Constant DIV. */
    public static final String DIV = "div";

    /** The Constant EM. */
    public static final String EM = "em";

    /** The Constant FIELDSET. */
    public static final String FIELDSET = "fieldset";

    /** The Constant FIGCAPTION. */
    public static final String FIGCAPTION = "figcaption";

    /** The Constant FIGURE. */
    public static final String FIGURE = "figure";

    /** The Constant FONT. */
    public static final String FONT = "font";

    /** The Constant FOOTER. */
    public static final String FOOTER = "footer";

    /** The Constant FORM. */
    public static final String FORM = "form";

    /** The Constant H1. */
    public static final String H1 = "h1";

    /** The Constant H2. */
    public static final String H2 = "h2";

    /** The Constant H3. */
    public static final String H3 = "h3";

    /** The Constant H4. */
    public static final String H4 = "h4";

    /** The Constant H5. */
    public static final String H5 = "h5";

    /** The Constant H6. */
    public static final String H6 = "h6";

    /** The Constant HR. */
    public static final String HR = "hr";

    /** The Constant HEAD. */
    public static final String HEAD = "head";

    /** The Constant HEADER. */
    public static final String HEADER = "header";

    /** The Constant HTML. */
    public static final String HTML = "html";

    /** The Constant I. */
    public static final String I = "i";

    /** The Constant IMG. */
    public static final String IMG = "img";

    /** The Constant INPUT. */
    public static final String INPUT = "input";

    /** The Constant INS. */
    public static final String INS = "ins";

    /** The Constant KBD. */
    public static final String KBD = "kbd";

    /** The Constant LABEL. */
    public static final String LABEL = "label";

    /** The Constant LEGEND. */
    public static final String LEGEND = "legend";

    /** The Constant LI. */
    public static final String LI = "li";

    /** The Constant LINK. */
    public static final String LINK = "link";

    /** The Constant MAIN. */
    public static final String MAIN = "main";

    /** The Constant MARK. */
    public static final String MARK = "mark";

    /** The Constant MARQUEE. */
    public static final String MARQUEE = "marquee";

    /** The Constant META. */
    public static final String META = "meta";

    /** The Constant NAV. */
    public static final String NAV = "nav";

    /** The Constant OBJECT */
    public static final String OBJECT = "object";

    /** The Constant OL. */
    public static final String OL = "ol";

    /** The Constant OPTION. */
    public static final String OPTGROUP = "optgroup";

    /** The Constant OPTION. */
    public static final String OPTION = "option";

    /** The Constant P. */
    public static final String P = "p";

    /** The Constant PRE. */
    public static final String PRE = "pre";

    /** The Constant Q. */
    public static final String Q = "q";

    /** The Constant S. */
    public static final String S = "s";

    /** The Constant SVG. */
    public static final String SVG = "svg";

    /** The Constant SAMP. */
    public static final String SAMP = "samp";

    /** The Constant SCRIPT. */
    public static final String SCRIPT = "script";

    /** The Constant SECTION. */
    public static final String SECTION = "section";

    /** The Constant SELECT. */
    public static final String SELECT = "select";

    /** The Constant SMALL. */
    public static final String SMALL = "small";

    /** The Constant SPAN. */
    public static final String SPAN = "span";

    /** The Constant STRIKE. */
    public static final String STRIKE = "strike";

    /** The Constant STRONG. */
    public static final String STRONG = "strong";

    /** The Constant STYLE. */
    public static final String STYLE = "style";

    /** The Constant SUB. */
    public static final String SUB = "sub";

    /** The Constant SUP. */
    public static final String SUP = "sup";

    /** The Constant TABLE. */
    public static final String TABLE = "table";

    /** The Constant TBODY. */
    public static final String TBODY = "tbody";

    /** The Constant TEXTAREA. */
    public static final String TEXTAREA = "textarea";

    /** The Constant TD. */
    public static final String TD = "td";

    /** The Constant TFOOT. */
    public static final String TFOOT = "tfoot";

    /** The Constant TH. */
    public static final String TH = "th";

    /** The Constant THEAD. */
    public static final String THEAD = "thead";

    /** The Constant TIME. */
    public static final String TIME = "time";

    /** The Constant TITLE. */
    public static final String TITLE = "title";

    /** The Constant TR. */
    public static final String TR = "tr";

    /** The Constant TT. */
    public static final String TT = "tt";

    /** The Constant U. */
    public static final String U = "u";

    /** The Constant UL. */
    public static final String UL = "ul";

    /** The Constant VAR. */
    public static final String VAR = "var";
}
