/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.io.font;

import com.itextpdf.io.IOException;
import com.itextpdf.io.font.CidFont;
import com.itextpdf.io.font.FontCache;
import com.itextpdf.io.font.FontConstants;
import com.itextpdf.io.font.FontProgram;
import com.itextpdf.io.font.FontRegisterProvider;
import com.itextpdf.io.font.TrueTypeFont;
import com.itextpdf.io.font.Type1Font;
import com.itextpdf.io.util.ArrayUtil;
import java.util.Set;

public final class FontProgramFactory {
    private static boolean DEFAULT_CACHED = true;
    private static FontRegisterProvider fontRegisterProvider = new FontRegisterProvider();

    private FontProgramFactory() {
    }

    public static FontProgram createFont() throws java.io.IOException {
        return FontProgramFactory.createFont("Helvetica");
    }

    public static FontProgram createFont(String fontProgram) throws java.io.IOException {
        return FontProgramFactory.createFont(fontProgram, null, DEFAULT_CACHED);
    }

    public static FontProgram createFont(String fontProgram, boolean cached) throws java.io.IOException {
        return FontProgramFactory.createFont(fontProgram, null, cached);
    }

    public static FontProgram createFont(byte[] fontProgram) throws java.io.IOException {
        return FontProgramFactory.createFont(null, fontProgram, DEFAULT_CACHED);
    }

    public static FontProgram createFont(String name, byte[] font, boolean cached) throws java.io.IOException {
        FontProgram fontFound;
        String baseName = FontProgram.getBaseName(name);
        boolean isBuiltinFonts14 = FontConstants.BUILTIN_FONTS_14.contains(name);
        boolean isCidFont = !isBuiltinFonts14 && FontCache.isPredefinedCidFont(baseName);
        String fontKey = null;
        if (cached && (fontFound = FontCache.getFont(fontKey = name != null ? name : Integer.toString(ArrayUtil.hashCode(font)))) != null) {
            return fontFound;
        }
        FontProgram fontBuilt = null;
        if (name == null) {
            if (font != null) {
                try {
                    fontBuilt = new TrueTypeFont(font);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (fontBuilt == null) {
                    try {
                        fontBuilt = new Type1Font(null, null, font, null);
                    }
                    catch (Exception exception) {}
                }
            }
        } else if (isBuiltinFonts14 || name.toLowerCase().endsWith(".afm") || name.toLowerCase().endsWith(".pfm")) {
            fontBuilt = new Type1Font(name, null, font, null);
        } else if (baseName.toLowerCase().endsWith(".ttf") || baseName.toLowerCase().endsWith(".otf") || baseName.toLowerCase().indexOf(".ttc,") > 0) {
            fontBuilt = font != null ? new TrueTypeFont(font) : new TrueTypeFont(name);
        } else if (isCidFont) {
            fontBuilt = new CidFont(name, FontCache.getCompatibleCmaps(baseName));
        }
        if (fontBuilt == null) {
            if (name != null) {
                throw new IOException("Type of font {0} is not recognized.").setMessageParams(name);
            }
            throw new IOException("Type of font is not recognized.");
        }
        return cached ? FontCache.saveFont(fontBuilt, fontKey) : fontBuilt;
    }

    public static FontProgram createType1Font(String name, byte[] afm, byte[] pfb, boolean cached) throws java.io.IOException {
        FontProgram fontProgram;
        String fontKey = null;
        if (cached && (fontProgram = FontCache.getFont(fontKey = name != null ? name : Integer.toString(ArrayUtil.hashCode(afm)))) != null) {
            return fontProgram;
        }
        fontProgram = new Type1Font(name, null, afm, pfb);
        return cached ? FontCache.saveFont(fontProgram, fontKey) : fontProgram;
    }

    public static FontProgram createType1Font(byte[] afm, byte[] pfb) throws java.io.IOException {
        return FontProgramFactory.createType1Font(null, afm, pfb, false);
    }

    public static FontProgram createType1Font(String metricsPath, String binaryPath, boolean cached) throws java.io.IOException {
        FontProgram fontProgram;
        if (cached && metricsPath != null && (fontProgram = FontCache.getFont(metricsPath)) != null) {
            return fontProgram;
        }
        fontProgram = new Type1Font(metricsPath, binaryPath, null, null);
        return cached && metricsPath != null ? FontCache.saveFont(fontProgram, metricsPath) : fontProgram;
    }

    public static FontProgram createType1Font(String metricsPath, String binaryPath) throws java.io.IOException {
        return FontProgramFactory.createType1Font(metricsPath, binaryPath, DEFAULT_CACHED);
    }

    public static FontProgram createFont(String ttc, int ttcIndex, boolean cached) throws java.io.IOException {
        FontProgram fontFound;
        if (cached && (fontFound = FontCache.getFont(ttc + ttcIndex)) != null) {
            return fontFound;
        }
        TrueTypeFont fontBuilt = new TrueTypeFont(ttc, ttcIndex);
        return cached ? FontCache.saveFont(fontBuilt, ttc + ttcIndex) : fontBuilt;
    }

    public static FontProgram createFont(byte[] ttc, int ttcIndex, boolean cached) throws java.io.IOException {
        FontProgram fontFound;
        String fontKey = null;
        if (cached && (fontFound = FontCache.getFont(fontKey = Integer.toString(ArrayUtil.hashCode(ttc)) + Integer.toString(ttcIndex))) != null) {
            return fontFound;
        }
        TrueTypeFont fontBuilt = new TrueTypeFont(ttc, ttcIndex);
        return cached ? FontCache.saveFont(fontBuilt, fontKey) : fontBuilt;
    }

    public static FontProgram createRegisteredFont(String fontName, int style, boolean cached) throws java.io.IOException {
        return fontRegisterProvider.getFont(fontName, style, cached);
    }

    public static FontProgram createRegisteredFont(String fontName, int style) throws java.io.IOException {
        return fontRegisterProvider.getFont(fontName, style);
    }

    public static FontProgram createRegisteredFont(String fontName) throws java.io.IOException {
        return fontRegisterProvider.getFont(fontName, -1);
    }

    public static void registerFontFamily(String familyName, String fullName, String path) {
        fontRegisterProvider.registerFontFamily(familyName, fullName, path);
    }

    public static void registerFont(String path) {
        FontProgramFactory.registerFont(path, null);
    }

    public static void registerFont(String path, String alias) {
        fontRegisterProvider.registerFont(path, alias);
    }

    public static int registerFontDirectory(String dir) {
        return fontRegisterProvider.registerFontDirectory(dir);
    }

    public static int registerSystemFontDirectories() {
        return fontRegisterProvider.registerSystemFontDirectories();
    }

    public static Set<String> getRegisteredFonts() {
        return fontRegisterProvider.getRegisteredFonts();
    }

    public static Set<String> getRegisteredFontFamilies() {
        return fontRegisterProvider.getRegisteredFontFamilies();
    }

    public static boolean isRegisteredFont(String fontname) {
        return fontRegisterProvider.isRegisteredFont(fontname);
    }
}

