/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.io.font;

import com.itextpdf.io.IOException;
import com.itextpdf.io.font.FontProgram;
import com.itextpdf.io.font.TrueTypeFontSubset;
import com.itextpdf.io.source.RandomAccessFileOrArray;
import com.itextpdf.io.source.RandomAccessSourceFactory;
import com.itextpdf.io.util.IntHashtable;
import java.io.File;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

class OpenTypeParser {
    protected String fileName;
    protected RandomAccessFileOrArray raf;
    protected int ttcIndex = -1;
    protected int directoryOffset;
    protected String fontName;
    protected Map<Integer, List<String[]>> allNameEntries;
    protected boolean cff = false;
    protected int cffOffset;
    protected int cffLength;
    private int[] glyphWidthsByIndex;
    protected HeaderTable head;
    protected HorizontalHeader hhea;
    protected WindowsMetrics os_2;
    protected PostTable post;
    protected CmapTable cmaps;
    protected Map<String, int[]> tables;

    public OpenTypeParser(byte[] ttf) throws java.io.IOException {
        this.raf = new RandomAccessFileOrArray(new RandomAccessSourceFactory().createSource(ttf));
        this.process();
    }

    public OpenTypeParser(byte[] ttc, int ttcIndex) throws java.io.IOException {
        this.ttcIndex = ttcIndex;
        this.raf = new RandomAccessFileOrArray(new RandomAccessSourceFactory().createSource(ttc));
        this.process();
    }

    public OpenTypeParser(String ttcPath, int ttcIndex) throws java.io.IOException {
        this.ttcIndex = ttcIndex;
        this.raf = new RandomAccessFileOrArray(new RandomAccessSourceFactory().createBestSource(ttcPath));
        this.process();
    }

    public OpenTypeParser(String name) throws java.io.IOException {
        String ttcName;
        String nameBase = FontProgram.getBaseName(name);
        this.fileName = ttcName = OpenTypeParser.getTTCName(nameBase);
        if (ttcName.length() < nameBase.length()) {
            this.ttcIndex = Integer.parseInt(nameBase.substring(ttcName.length() + 1));
        }
        this.raf = new RandomAccessFileOrArray(new RandomAccessSourceFactory().createBestSource(this.fileName));
        this.process();
    }

    public String getPsFontName() {
        if (this.fontName == null) {
            List<String[]> names = this.allNameEntries.get(6);
            this.fontName = names != null && names.size() > 0 ? names.get(0)[3] : new File(this.fileName).getName().replace(' ', '-');
        }
        return this.fontName;
    }

    public Map<Integer, List<String[]>> getAllNameEntries() {
        return this.allNameEntries;
    }

    public PostTable getPostTable() {
        return this.post;
    }

    public WindowsMetrics getOs_2Table() {
        return this.os_2;
    }

    public HorizontalHeader getHheaTable() {
        return this.hhea;
    }

    public HeaderTable getHeadTable() {
        return this.head;
    }

    public CmapTable getCmapTable() {
        return this.cmaps;
    }

    public int[] getGlyphWidthsByIndex() {
        return this.glyphWidthsByIndex;
    }

    public boolean isCff() {
        return this.cff;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getFullFont() throws java.io.IOException {
        RandomAccessFileOrArray rf2 = null;
        try {
            rf2 = this.raf.createView();
            byte[] b = new byte[(int)rf2.length()];
            rf2.readFully(b);
            byte[] byArray = b;
            return byArray;
        }
        finally {
            try {
                if (rf2 != null) {
                    rf2.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] readCffFont() throws java.io.IOException {
        if (!this.isCff()) {
            return null;
        }
        RandomAccessFileOrArray rf2 = null;
        try {
            rf2 = this.raf.createView();
            rf2.seek(this.cffOffset);
            byte[] cff = new byte[this.cffLength];
            rf2.readFully(cff);
            byte[] byArray = cff;
            return byArray;
        }
        finally {
            try {
                if (rf2 != null) {
                    rf2.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public byte[] getSubset(Set<Integer> glyphs, boolean subset) throws java.io.IOException {
        TrueTypeFontSubset sb = new TrueTypeFontSubset(this.fileName, this.raf.createView(), glyphs, this.directoryOffset, true, !subset);
        return sb.process();
    }

    protected void process() throws java.io.IOException {
        this.tables = new LinkedHashMap<String, int[]>();
        if (this.ttcIndex >= 0) {
            int dirIdx = this.ttcIndex;
            if (dirIdx < 0) {
                if (this.fileName != null) {
                    throw new IOException("the.font.index.for.1.must.be.positive").setMessageParams(this.fileName);
                }
                throw new IOException("the.font.index.must.be.positive");
            }
            String mainTag = this.readStandardString(4);
            if (!mainTag.equals("ttcf")) {
                if (this.fileName != null) {
                    throw new IOException("1.is.not.a.valid.ttc.file").setMessageParams(this.fileName);
                }
                throw new IOException("not.a.valid.ttc.file");
            }
            this.raf.skipBytes(4);
            int dirCount = this.raf.readInt();
            if (dirIdx >= dirCount) {
                if (this.fileName != null) {
                    throw new IOException("the.font.index.for.1.must.be.between.0.and.2.it.was.3").setMessageParams(this.fileName, dirCount - 1, dirIdx);
                }
                throw new IOException("the.font.index.must.be.between.0.and.1.it.was.2").setMessageParams(dirCount - 1, dirIdx);
            }
            this.raf.skipBytes(dirIdx * 4);
            this.directoryOffset = this.raf.readInt();
        }
        this.raf.seek(this.directoryOffset);
        int ttId = this.raf.readInt();
        if (ttId != 65536 && ttId != 0x4F54544F) {
            if (this.fileName != null) {
                throw new IOException("1.is.not.a.valid.ttf.or.otf.file").setMessageParams(this.fileName);
            }
            throw new IOException("not.a.valid.ttf.or.otf.file");
        }
        int num_tables = this.raf.readUnsignedShort();
        this.raf.skipBytes(6);
        for (int k = 0; k < num_tables; ++k) {
            String tag = this.readStandardString(4);
            this.raf.skipBytes(4);
            int[] table_location = new int[]{this.raf.readInt(), this.raf.readInt()};
            this.tables.put(tag, table_location);
        }
        this.checkCff();
        this.readHheaTable();
        this.readNameTable();
        this.readHeadTable();
        this.readOs_2Table();
        this.readPostTable();
        this.readGlyphWidths();
        this.readCmapTable();
    }

    protected static String getTTCName(String name) {
        if (name == null) {
            return null;
        }
        int idx = name.toLowerCase().indexOf(".ttc,");
        if (idx < 0) {
            return name;
        }
        return name.substring(0, idx + 4);
    }

    protected void checkCff() {
        int[] table_location = this.tables.get("CFF ");
        if (table_location != null) {
            this.cff = true;
            this.cffOffset = table_location[0];
            this.cffLength = table_location[1];
        }
    }

    protected void readGlyphWidths() throws java.io.IOException {
        int numberOfHMetrics = this.hhea.numberOfHMetrics;
        int unitsPerEm = this.head.unitsPerEm;
        int[] table_location = this.tables.get("hmtx");
        if (table_location == null) {
            if (this.fileName != null) {
                throw new IOException("table.1.does.not.exist.in.2").setMessageParams("hmtx", this.fileName);
            }
            throw new IOException("table.1.does.not.exist").setMessageParams("hmtx");
        }
        this.raf.seek(table_location[0]);
        this.glyphWidthsByIndex = new int[numberOfHMetrics];
        for (int k = 0; k < numberOfHMetrics; ++k) {
            this.glyphWidthsByIndex[k] = this.raf.readUnsignedShort() * 1000 / unitsPerEm;
            int n = this.raf.readShort() * 1000 / unitsPerEm;
        }
    }

    protected IntHashtable readKerning(int unitsPerEm) throws java.io.IOException {
        int[] table_location = this.tables.get("kern");
        IntHashtable kerning = new IntHashtable();
        if (table_location == null) {
            return kerning;
        }
        this.raf.seek(table_location[0] + 2);
        int nTables = this.raf.readUnsignedShort();
        int checkpoint = table_location[0] + 4;
        int length = 0;
        for (int k = 0; k < nTables; ++k) {
            this.raf.seek(checkpoint += length);
            this.raf.skipBytes(2);
            length = this.raf.readUnsignedShort();
            int coverage = this.raf.readUnsignedShort();
            if ((coverage & 0xFFF7) != 1) continue;
            int nPairs = this.raf.readUnsignedShort();
            this.raf.skipBytes(6);
            for (int j = 0; j < nPairs; ++j) {
                int pair = this.raf.readInt();
                int value = this.raf.readShort() * 1000 / unitsPerEm;
                kerning.put(pair, value);
            }
        }
        return kerning;
    }

    protected int[][] readBbox(int unitsPerEm) throws java.io.IOException {
        int k;
        int[] locaTable;
        int entries;
        int[] tableLocation = this.tables.get("head");
        if (tableLocation == null) {
            if (this.fileName != null) {
                throw new IOException("table.1.does.not.exist.in.2").setMessageParams("head", this.fileName);
            }
            throw new IOException("table.1.does.not.exist").setMessageParams("head");
        }
        this.raf.seek(tableLocation[0] + 51);
        boolean locaShortTable = this.raf.readUnsignedShort() == 0;
        tableLocation = this.tables.get("loca");
        if (tableLocation == null) {
            return null;
        }
        this.raf.seek(tableLocation[0]);
        if (locaShortTable) {
            entries = tableLocation[1] / 2;
            locaTable = new int[entries];
            for (k = 0; k < entries; ++k) {
                locaTable[k] = this.raf.readUnsignedShort() * 2;
            }
        } else {
            entries = tableLocation[1] / 4;
            locaTable = new int[entries];
            for (k = 0; k < entries; ++k) {
                locaTable[k] = this.raf.readInt();
            }
        }
        if ((tableLocation = this.tables.get("glyf")) == null) {
            if (this.fileName != null) {
                throw new IOException("table.1.does.not.exist.in.2").setMessageParams("glyf", this.fileName);
            }
            throw new IOException("table.1.does.not.exist").setMessageParams("glyf");
        }
        int tableGlyphOffset = tableLocation[0];
        int[][] bboxes = new int[locaTable.length - 1][];
        for (int glyph = 0; glyph < locaTable.length - 1; ++glyph) {
            int start = locaTable[glyph];
            if (start == locaTable[glyph + 1]) continue;
            this.raf.seek(tableGlyphOffset + start + 2);
            bboxes[glyph] = new int[]{this.raf.readShort() * 1000 / unitsPerEm, this.raf.readShort() * 1000 / unitsPerEm, this.raf.readShort() * 1000 / unitsPerEm, this.raf.readShort() * 1000 / unitsPerEm};
        }
        return bboxes;
    }

    protected int readMaxGlyphId() throws java.io.IOException {
        int[] table_location = this.tables.get("maxp");
        if (table_location == null) {
            return 65536;
        }
        this.raf.seek(table_location[0] + 4);
        return this.raf.readUnsignedShort();
    }

    private void readNameTable() throws java.io.IOException {
        int[] table_location = this.tables.get("name");
        if (table_location == null) {
            if (this.fileName != null) {
                throw new IOException("table.1.does.not.exist.in.2").setMessageParams("name", this.fileName);
            }
            throw new IOException("table.1.does.not.exist").setMessageParams("name");
        }
        this.allNameEntries = new LinkedHashMap<Integer, List<String[]>>();
        this.raf.seek(table_location[0] + 2);
        int numRecords = this.raf.readUnsignedShort();
        int startOfStorage = this.raf.readUnsignedShort();
        for (int k = 0; k < numRecords; ++k) {
            List<String[]> names;
            int platformID = this.raf.readUnsignedShort();
            int platformEncodingID = this.raf.readUnsignedShort();
            int languageID = this.raf.readUnsignedShort();
            int nameID = this.raf.readUnsignedShort();
            int length = this.raf.readUnsignedShort();
            int offset = this.raf.readUnsignedShort();
            if (this.allNameEntries.containsKey(nameID)) {
                names = this.allNameEntries.get(nameID);
            } else {
                names = new ArrayList<String[]>();
                this.allNameEntries.put(nameID, names);
            }
            int pos = (int)this.raf.getPosition();
            this.raf.seek(table_location[0] + startOfStorage + offset);
            String name = platformID == 0 || platformID == 3 || platformID == 2 && platformEncodingID == 1 ? this.readUnicodeString(length) : this.readStandardString(length);
            names.add(new String[]{Integer.toString(platformID), Integer.toString(platformEncodingID), Integer.toString(languageID), name});
            this.raf.seek(pos);
        }
    }

    private void readHheaTable() throws java.io.IOException {
        int[] table_location = this.tables.get("hhea");
        if (table_location == null) {
            if (this.fileName != null) {
                throw new IOException("table.1.does.not.exist.in.2").setMessageParams("hhea", this.fileName);
            }
            throw new IOException("table.1.does.not.exist").setMessageParams("hhea");
        }
        this.raf.seek(table_location[0] + 4);
        this.hhea = new HorizontalHeader();
        this.hhea.Ascender = this.raf.readShort();
        this.hhea.Descender = this.raf.readShort();
        this.hhea.LineGap = this.raf.readShort();
        this.hhea.advanceWidthMax = this.raf.readUnsignedShort();
        this.hhea.minLeftSideBearing = this.raf.readShort();
        this.hhea.minRightSideBearing = this.raf.readShort();
        this.hhea.xMaxExtent = this.raf.readShort();
        this.hhea.caretSlopeRise = this.raf.readShort();
        this.hhea.caretSlopeRun = this.raf.readShort();
        this.raf.skipBytes(12);
        this.hhea.numberOfHMetrics = this.raf.readUnsignedShort();
    }

    private void readHeadTable() throws java.io.IOException {
        int[] table_location = this.tables.get("head");
        if (table_location == null) {
            if (this.fileName != null) {
                throw new IOException("table.1.does.not.exist.in.2").setMessageParams("head", this.fileName);
            }
            throw new IOException("table.1.does.not.exist").setMessageParams("head");
        }
        this.raf.seek(table_location[0] + 16);
        this.head = new HeaderTable();
        this.head.flags = this.raf.readUnsignedShort();
        this.head.unitsPerEm = this.raf.readUnsignedShort();
        this.raf.skipBytes(16);
        this.head.xMin = this.raf.readShort();
        this.head.yMin = this.raf.readShort();
        this.head.xMax = this.raf.readShort();
        this.head.yMax = this.raf.readShort();
        this.head.macStyle = this.raf.readUnsignedShort();
    }

    private void readOs_2Table() throws java.io.IOException {
        int[] table_location = this.tables.get("OS/2");
        if (table_location == null) {
            if (this.fileName != null) {
                throw new IOException("table.1.does.not.exist.in.2").setMessageParams("os/2", this.fileName);
            }
            throw new IOException("table.1.does.not.exist").setMessageParams("os/2");
        }
        this.os_2 = new WindowsMetrics();
        this.raf.seek(table_location[0]);
        int version = this.raf.readUnsignedShort();
        this.os_2.xAvgCharWidth = this.raf.readShort();
        this.os_2.usWeightClass = this.raf.readUnsignedShort();
        this.os_2.usWidthClass = this.raf.readUnsignedShort();
        this.os_2.fsType = this.raf.readShort();
        this.os_2.ySubscriptXSize = this.raf.readShort();
        this.os_2.ySubscriptYSize = this.raf.readShort();
        this.os_2.ySubscriptXOffset = this.raf.readShort();
        this.os_2.ySubscriptYOffset = this.raf.readShort();
        this.os_2.ySuperscriptXSize = this.raf.readShort();
        this.os_2.ySuperscriptYSize = this.raf.readShort();
        this.os_2.ySuperscriptXOffset = this.raf.readShort();
        this.os_2.ySuperscriptYOffset = this.raf.readShort();
        this.os_2.yStrikeoutSize = this.raf.readShort();
        this.os_2.yStrikeoutPosition = this.raf.readShort();
        this.os_2.sFamilyClass = this.raf.readShort();
        this.raf.readFully(this.os_2.panose);
        this.raf.skipBytes(16);
        this.raf.readFully(this.os_2.achVendID);
        this.os_2.fsSelection = this.raf.readUnsignedShort();
        this.os_2.usFirstCharIndex = this.raf.readUnsignedShort();
        this.os_2.usLastCharIndex = this.raf.readUnsignedShort();
        this.os_2.sTypoAscender = this.raf.readShort();
        this.os_2.sTypoDescender = this.raf.readShort();
        if (this.os_2.sTypoDescender > 0) {
            this.os_2.sTypoDescender = -this.os_2.sTypoDescender;
        }
        this.os_2.sTypoLineGap = this.raf.readShort();
        this.os_2.usWinAscent = this.raf.readUnsignedShort();
        this.os_2.usWinDescent = this.raf.readUnsignedShort();
        if (this.os_2.usWinDescent > 0) {
            this.os_2.usWinDescent = (short)(-this.os_2.usWinDescent);
        }
        this.os_2.ulCodePageRange1 = 0;
        this.os_2.ulCodePageRange2 = 0;
        if (version > 0) {
            this.os_2.ulCodePageRange1 = this.raf.readInt();
            this.os_2.ulCodePageRange2 = this.raf.readInt();
        }
        if (version > 1) {
            this.raf.skipBytes(2);
            this.os_2.sCapHeight = this.raf.readShort();
        } else {
            this.os_2.sCapHeight = (int)(0.7 * (double)this.head.unitsPerEm);
        }
    }

    private void readPostTable() throws java.io.IOException {
        int[] table_location = this.tables.get("post");
        if (table_location != null) {
            this.raf.seek(table_location[0] + 4);
            short mantissa = this.raf.readShort();
            int fraction = this.raf.readUnsignedShort();
            this.post = new PostTable();
            this.post.italicAngle = (float)((double)mantissa + (double)fraction / 16384.0);
            this.post.underlinePosition = this.raf.readShort();
            this.post.underlineThickness = this.raf.readShort();
            this.post.isFixedPitch = this.raf.readInt() != 0;
        } else {
            this.post = new PostTable();
            this.post.italicAngle = (float)(-Math.atan2(this.hhea.caretSlopeRun, this.hhea.caretSlopeRise) * 180.0 / Math.PI);
        }
    }

    private void readCmapTable() throws java.io.IOException {
        int format;
        int[] table_location = this.tables.get("cmap");
        if (table_location == null) {
            if (this.fileName != null) {
                throw new IOException("table.1.does.not.exist.in.2").setMessageParams("cmap", this.fileName);
            }
            throw new IOException("table.1.does.not.exist").setMessageParams("cmap");
        }
        this.raf.seek(table_location[0]);
        this.raf.skipBytes(2);
        int num_tables = this.raf.readUnsignedShort();
        int map10 = 0;
        int map31 = 0;
        int map30 = 0;
        int mapExt = 0;
        this.cmaps = new CmapTable();
        for (int k = 0; k < num_tables; ++k) {
            int platId = this.raf.readUnsignedShort();
            int platSpecId = this.raf.readUnsignedShort();
            int offset = this.raf.readInt();
            if (platId == 3 && platSpecId == 0) {
                this.cmaps.fontSpecific = true;
                map30 = offset;
                continue;
            }
            if (platId == 3 && platSpecId == 1) {
                map31 = offset;
                continue;
            }
            if (platId == 3 && platSpecId == 10) {
                mapExt = offset;
                continue;
            }
            if (platId != 1 || platSpecId != 0) continue;
            map10 = offset;
        }
        if (map10 > 0) {
            this.raf.seek(table_location[0] + map10);
            format = this.raf.readUnsignedShort();
            switch (format) {
                case 0: {
                    this.cmaps.cmap10 = this.readFormat0();
                    break;
                }
                case 4: {
                    this.cmaps.cmap10 = this.readFormat4(false);
                    break;
                }
                case 6: {
                    this.cmaps.cmap10 = this.readFormat6();
                }
            }
        }
        if (map31 > 0) {
            this.raf.seek(table_location[0] + map31);
            format = this.raf.readUnsignedShort();
            if (format == 4) {
                this.cmaps.cmap31 = this.readFormat4(false);
            }
        }
        if (map30 > 0) {
            this.raf.seek(table_location[0] + map30);
            format = this.raf.readUnsignedShort();
            if (format == 4) {
                this.cmaps.cmap10 = this.readFormat4(this.cmaps.fontSpecific);
            } else {
                this.cmaps.fontSpecific = false;
            }
        }
        if (mapExt > 0) {
            this.raf.seek(table_location[0] + mapExt);
            format = this.raf.readUnsignedShort();
            switch (format) {
                case 0: {
                    this.cmaps.cmapExt = this.readFormat0();
                    break;
                }
                case 4: {
                    this.cmaps.cmapExt = this.readFormat4(false);
                    break;
                }
                case 6: {
                    this.cmaps.cmapExt = this.readFormat6();
                    break;
                }
                case 12: {
                    this.cmaps.cmapExt = this.readFormat12();
                }
            }
        }
    }

    private String readStandardString(int length) throws java.io.IOException {
        return this.raf.readString(length, "Cp1252");
    }

    private String readUnicodeString(int length) throws java.io.IOException {
        StringBuilder buf = new StringBuilder();
        length /= 2;
        for (int k = 0; k < length; ++k) {
            buf.append(this.raf.readChar());
        }
        return buf.toString();
    }

    protected int getGlyphWidth(int glyph) {
        if (glyph >= this.glyphWidthsByIndex.length) {
            glyph = this.glyphWidthsByIndex.length - 1;
        }
        return this.glyphWidthsByIndex[glyph];
    }

    private Map<Integer, int[]> readFormat0() throws java.io.IOException {
        LinkedHashMap<Integer, int[]> h = new LinkedHashMap<Integer, int[]>();
        this.raf.skipBytes(4);
        for (int k = 0; k < 256; ++k) {
            int[] r;
            r = new int[]{this.raf.readUnsignedByte(), this.getGlyphWidth(r[0])};
            h.put(k, r);
        }
        return h;
    }

    private Map<Integer, int[]> readFormat4(boolean fontSpecific) throws java.io.IOException {
        int k;
        LinkedHashMap<Integer, int[]> h = new LinkedHashMap<Integer, int[]>();
        int table_lenght = this.raf.readUnsignedShort();
        this.raf.skipBytes(2);
        int segCount = this.raf.readUnsignedShort() / 2;
        this.raf.skipBytes(6);
        int[] endCount = new int[segCount];
        for (int k2 = 0; k2 < segCount; ++k2) {
            endCount[k2] = this.raf.readUnsignedShort();
        }
        this.raf.skipBytes(2);
        int[] startCount = new int[segCount];
        for (int k3 = 0; k3 < segCount; ++k3) {
            startCount[k3] = this.raf.readUnsignedShort();
        }
        int[] idDelta = new int[segCount];
        for (int k4 = 0; k4 < segCount; ++k4) {
            idDelta[k4] = this.raf.readUnsignedShort();
        }
        int[] idRO = new int[segCount];
        for (int k5 = 0; k5 < segCount; ++k5) {
            idRO[k5] = this.raf.readUnsignedShort();
        }
        int[] glyphId = new int[table_lenght / 2 - 8 - segCount * 4];
        for (k = 0; k < glyphId.length; ++k) {
            glyphId[k] = this.raf.readUnsignedShort();
        }
        for (k = 0; k < segCount; ++k) {
            for (int j = startCount[k]; j <= endCount[k] && j != 65535; ++j) {
                int[] r;
                int glyph;
                if (idRO[k] == 0) {
                    glyph = j + idDelta[k] & 0xFFFF;
                } else {
                    int idx = k + idRO[k] / 2 - segCount + j - startCount[k];
                    if (idx >= glyphId.length) continue;
                    glyph = glyphId[idx] + idDelta[k] & 0xFFFF;
                }
                r = new int[]{glyph, this.getGlyphWidth(r[0])};
                if (fontSpecific && (j & 0xFF00) == 61440) {
                    h.put(j & 0xFF, r);
                }
                h.put(j, r);
            }
        }
        return h;
    }

    private Map<Integer, int[]> readFormat6() throws java.io.IOException {
        LinkedHashMap<Integer, int[]> h = new LinkedHashMap<Integer, int[]>();
        this.raf.skipBytes(4);
        int start_code = this.raf.readUnsignedShort();
        int code_count = this.raf.readUnsignedShort();
        for (int k = 0; k < code_count; ++k) {
            int[] r;
            r = new int[]{this.raf.readUnsignedShort(), this.getGlyphWidth(r[0])};
            h.put(k + start_code, r);
        }
        return h;
    }

    private Map<Integer, int[]> readFormat12() throws java.io.IOException {
        LinkedHashMap<Integer, int[]> h = new LinkedHashMap<Integer, int[]>();
        this.raf.skipBytes(2);
        int table_length = this.raf.readInt();
        this.raf.skipBytes(4);
        int nGroups = this.raf.readInt();
        for (int k = 0; k < nGroups; ++k) {
            int startCharCode = this.raf.readInt();
            int endCharCode = this.raf.readInt();
            int startGlyphID = this.raf.readInt();
            for (int i = startCharCode; i <= endCharCode; ++i) {
                int[] r;
                r = new int[]{startGlyphID++, this.getGlyphWidth(r[0])};
                h.put(i, r);
            }
        }
        return h;
    }

    protected static class CmapTable {
        Map<Integer, int[]> cmap10;
        Map<Integer, int[]> cmap31;
        Map<Integer, int[]> cmapExt;
        boolean fontSpecific = false;

        protected CmapTable() {
        }
    }

    protected static class PostTable {
        float italicAngle;
        int underlinePosition;
        int underlineThickness;
        boolean isFixedPitch;

        protected PostTable() {
        }
    }

    protected static class WindowsMetrics {
        short xAvgCharWidth;
        int usWeightClass;
        int usWidthClass;
        short fsType;
        short ySubscriptXSize;
        short ySubscriptYSize;
        short ySubscriptXOffset;
        short ySubscriptYOffset;
        short ySuperscriptXSize;
        short ySuperscriptYSize;
        short ySuperscriptXOffset;
        short ySuperscriptYOffset;
        short yStrikeoutSize;
        short yStrikeoutPosition;
        short sFamilyClass;
        byte[] panose = new byte[10];
        byte[] achVendID = new byte[4];
        int fsSelection;
        int usFirstCharIndex;
        int usLastCharIndex;
        short sTypoAscender;
        short sTypoDescender;
        short sTypoLineGap;
        int usWinAscent;
        int usWinDescent;
        int ulCodePageRange1;
        int ulCodePageRange2;
        int sxHeight;
        int sCapHeight;

        protected WindowsMetrics() {
        }
    }

    protected static class HorizontalHeader {
        short Ascender;
        short Descender;
        short LineGap;
        int advanceWidthMax;
        short minLeftSideBearing;
        short minRightSideBearing;
        short xMaxExtent;
        short caretSlopeRise;
        short caretSlopeRun;
        int numberOfHMetrics;

        protected HorizontalHeader() {
        }
    }

    protected static class HeaderTable {
        int flags;
        int unitsPerEm;
        short xMin;
        short yMin;
        short xMax;
        short yMax;
        int macStyle;

        protected HeaderTable() {
        }
    }
}

