/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.io.util;

import com.itextpdf.io.IOException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;

public final class FilterUtil {
    private FilterUtil() {
    }

    public static byte[] flateDecode(byte[] input, boolean strict) {
        ByteArrayInputStream stream = new ByteArrayInputStream(input);
        InflaterInputStream zip = new InflaterInputStream(stream);
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        byte[] b = new byte[strict ? 4092 : 1];
        try {
            int n;
            while ((n = zip.read(b)) >= 0) {
                output.write(b, 0, n);
            }
            zip.close();
            output.close();
            return output.toByteArray();
        }
        catch (Exception e) {
            return strict ? null : output.toByteArray();
        }
    }

    public static byte[] flateDecode(byte[] input) {
        byte[] b = FilterUtil.flateDecode(input, true);
        if (b == null) {
            return FilterUtil.flateDecode(input, false);
        }
        return b;
    }

    public static void inflateData(byte[] deflated, byte[] inflated) {
        Inflater inflater = new Inflater();
        inflater.setInput(deflated);
        try {
            inflater.inflate(inflated);
        }
        catch (DataFormatException dfe) {
            throw new IOException("Cannot inflate TIFF image.");
        }
    }

    public static InputStream getInflaterInputStream(InputStream input) {
        return new InflaterInputStream(input, new Inflater());
    }
}

