/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.io.source;

import com.itextpdf.io.source.ByteBuffer;
import com.itextpdf.io.util.DecimalFormatUtil;
import java.nio.charset.StandardCharsets;

public class ByteUtils {
    static boolean HighPrecision = false;
    private static final byte[] bytes = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 97, 98, 99, 100, 101, 102};
    private static final byte[] zero = new byte[]{48};
    private static final byte[] one = new byte[]{49};
    private static final byte[] negOne = new byte[]{45, 49};

    public static byte[] getIsoBytes(String text) {
        if (text == null) {
            return null;
        }
        int len = text.length();
        byte[] b = new byte[len];
        for (int k = 0; k < len; ++k) {
            b[k] = (byte)text.charAt(k);
        }
        return b;
    }

    public static byte[] getIsoBytes(byte pre, String text) {
        return ByteUtils.getIsoBytes(pre, text, (byte)0);
    }

    public static byte[] getIsoBytes(byte pre, String text, byte post) {
        if (text == null) {
            return null;
        }
        int len = text.length();
        int start = 0;
        if (pre != 0) {
            ++len;
            start = 1;
        }
        if (post != 0) {
            ++len;
        }
        byte[] b = new byte[len];
        if (pre != 0) {
            b[0] = pre;
        }
        if (post != 0) {
            b[len - 1] = post;
        }
        for (int k = 0; k < text.length(); ++k) {
            b[k + start] = (byte)text.charAt(k);
        }
        return b;
    }

    public static byte[] getIsoBytes(int n) {
        return ByteUtils.getIsoBytes(n, null);
    }

    public static byte[] getIsoBytes(double d) {
        return ByteUtils.getIsoBytes(d, null);
    }

    static byte[] getIsoBytes(int n, ByteBuffer buffer) {
        boolean negative = false;
        if (n < 0) {
            negative = true;
            n = -n;
        }
        int intLen = ByteUtils.intSize(n);
        ByteBuffer buf = buffer == null ? new ByteBuffer(intLen + (negative ? 1 : 0)) : buffer;
        for (int i = 0; i < intLen; ++i) {
            buf.prepend(bytes[n % 10]);
            n /= 10;
        }
        if (negative) {
            buf.prepend((byte)45);
        }
        return buffer == null ? buf.getInternalBuffer() : null;
    }

    static byte[] getIsoBytes(double d, ByteBuffer buffer) {
        return ByteUtils.getIsoBytes(d, buffer, HighPrecision);
    }

    static byte[] getIsoBytes(double d, ByteBuffer buffer, boolean highPrecision) {
        ByteBuffer buf;
        if (highPrecision) {
            if (Math.abs(d) < 1.0E-6) {
                if (buffer != null) {
                    buffer.prepend(zero);
                    return null;
                }
                return zero;
            }
            byte[] result = DecimalFormatUtil.formatNumber(d, "0.######").getBytes(StandardCharsets.ISO_8859_1);
            if (buffer != null) {
                buffer.prepend(result);
                return null;
            }
            return result;
        }
        boolean negative = false;
        if (Math.abs(d) < 1.5E-5) {
            if (buffer != null) {
                buffer.prepend(zero);
                return null;
            }
            return zero;
        }
        if (d < 0.0) {
            negative = true;
            d = -d;
        }
        if (d < 1.0) {
            int len;
            if ((d += 5.0E-6) >= 1.0) {
                byte[] result = negative ? negOne : one;
                if (buffer != null) {
                    buffer.prepend(result);
                    return null;
                }
                return result;
            }
            int v = (int)(d * 100000.0);
            for (len = 5; len > 0 && v % 10 == 0; --len) {
                v /= 10;
            }
            buf = buffer != null ? buffer : new ByteBuffer(negative ? len + 3 : len + 2);
            for (int i = 0; i < len; ++i) {
                buf.prepend(bytes[v % 10]);
                v /= 10;
            }
            buf.prepend((byte)46).prepend((byte)48);
            if (negative) {
                buf.prepend((byte)45);
            }
        } else if (d <= 32767.0) {
            int i;
            int v = (int)((d += 0.005) * 100.0);
            int intLen = v >= 1000000 ? 5 : (v >= 100000 ? 4 : (v >= 10000 ? 3 : (v >= 1000 ? 2 : 1)));
            int fracLen = 0;
            if (v % 100 != 0) {
                fracLen = 2;
                if (v % 10 != 0) {
                    ++fracLen;
                } else {
                    v /= 10;
                }
            } else {
                v /= 100;
            }
            buf = buffer != null ? buffer : new ByteBuffer(intLen + fracLen + (negative ? 1 : 0));
            for (i = 0; i < fracLen - 1; ++i) {
                buf.prepend(bytes[v % 10]);
                v /= 10;
            }
            if (fracLen > 0) {
                buf.prepend((byte)46);
            }
            for (i = 0; i < intLen; ++i) {
                buf.prepend(bytes[v % 10]);
                v /= 10;
            }
            if (negative) {
                buf.prepend((byte)45);
            }
        } else {
            long v = (d += 0.5) > 9.223372036854776E18 ? Long.MAX_VALUE : (long)d;
            int intLen = ByteUtils.longSize(v);
            buf = buffer == null ? new ByteBuffer(intLen + (negative ? 1 : 0)) : buffer;
            for (int i = 0; i < intLen; ++i) {
                buf.prepend(bytes[(int)(v % 10L)]);
                v /= 10L;
            }
            if (negative) {
                buf.prepend((byte)45);
            }
        }
        return buffer == null ? buf.getInternalBuffer() : null;
    }

    private static int longSize(long l) {
        long m = 10L;
        for (int i = 1; i < 19; ++i) {
            if (l < m) {
                return i;
            }
            m *= 10L;
        }
        return 19;
    }

    private static int intSize(int l) {
        long m = 10L;
        for (int i = 1; i < 10; ++i) {
            if ((long)l < m) {
                return i;
            }
            m *= 10L;
        }
        return 10;
    }
}

