/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.io.font.cmap;

import com.itextpdf.io.font.cmap.AbstractCMap;
import com.itextpdf.io.font.cmap.CMapContentParser;
import com.itextpdf.io.font.cmap.CMapObject;
import com.itextpdf.io.font.cmap.ICMapLocation;
import java.io.IOException;
import java.util.ArrayList;
import org.slf4j.LoggerFactory;

public class CMapParser {
    private static final String def = "def";
    private static final String endcidrange = "endcidrange";
    private static final String endcidchar = "endcidchar";
    private static final String endbfrange = "endbfrange";
    private static final String endbfchar = "endbfchar";
    private static final String endcodespacerange = "endcodespacerange";
    private static final String usecmap = "usecmap";
    private static final String Registry = "Registry";
    private static final String Ordering = "Ordering";
    private static final String Supplement = "Supplement";
    private static final String CMapName = "CMapName";
    private static final int MAX_LEVEL = 10;

    public static void parseCid(String cmapName, AbstractCMap cmap, ICMapLocation location) throws IOException {
        CMapParser.parseCid(cmapName, cmap, location, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private static void parseCid(String cmapName, AbstractCMap cmap, ICMapLocation location, int level) throws IOException {
        if (level >= 10) {
            return;
        }
        inp = location.getLocation(cmapName);
        try {
            list = new ArrayList<CMapObject>();
            cp = new CMapContentParser(inp);
            maxExc = 50;
            block9: while (true) {
                try {
                    cp.parse(list);
                }
                catch (Exception ex) {
                    if (--maxExc >= 0) continue;
                    break;
                }
                if (list.size() == 0) {
                    break;
                }
                last = ((CMapObject)list.get(list.size() - 1)).toString();
                if (level == 0 && list.size() == 3 && last.equals("def")) {
                    cmapObject = (CMapObject)list.get(0);
                    if ("Registry".equals(cmapObject.toString())) {
                        cmap.setRegistry(((CMapObject)list.get(1)).toString());
                        continue;
                    }
                    if ("Ordering".equals(cmapObject.toString())) {
                        cmap.setOrdering(((CMapObject)list.get(1)).toString());
                        continue;
                    }
                    if ("CMapName".equals(cmapObject.toString())) {
                        cmap.setName(((CMapObject)list.get(1)).toString());
                        continue;
                    }
                    if (!"Supplement".equals(cmapObject.toString())) continue;
                    try {
                        cmap.setSupplement((Integer)((CMapObject)list.get(1)).getValue());
                    }
                    catch (Exception var10_16) {}
                    continue;
                }
                if ((last.equals("endcidchar") || last.equals("endbfchar")) && list.size() >= 3) {
                    lMax = list.size() - 2;
                    k = 0;
                    while (true) {
                        if (k >= lMax) continue block9;
                        if (((CMapObject)list.get(k)).isString()) {
                            cmap.addChar(((CMapObject)list.get(k)).toString(), (CMapObject)list.get(k + 1));
                        }
                        k += 2;
                    }
                }
                if ((last.equals("endcidrange") || last.equals("endbfrange")) && list.size() >= 4) {
                    lMax = list.size() - 3;
                    k = 0;
                    while (true) {
                        if (k >= lMax) continue block9;
                        if (((CMapObject)list.get(k)).isString() && ((CMapObject)list.get(k + 1)).isString()) {
                            cmap.addRange(((CMapObject)list.get(k)).toString(), ((CMapObject)list.get(k + 1)).toString(), (CMapObject)list.get(k + 2));
                        }
                        k += 3;
                    }
                }
                if (last.equals("usecmap") && list.size() == 2 && ((CMapObject)list.get(0)).isName()) {
                    CMapParser.parseCid(((CMapObject)list.get(0)).toString(), cmap, location, level + 1);
                    continue;
                }
                if (!last.equals("endcodespacerange")) continue;
                i = 0;
                while (true) {
                    if (i < list.size() + 1) ** break;
                    continue block9;
                    if (((CMapObject)list.get(i)).isHexString() && ((CMapObject)list.get(i + 1)).isHexString()) {
                        low = ((CMapObject)list.get(i)).toHexByteArray();
                        high = ((CMapObject)list.get(i + 1)).toHexByteArray();
                        cmap.addCodeSpaceRange(low, high);
                    }
                    i += 2;
                }
                break;
            }
        }
        catch (Exception ex) {
            logger = LoggerFactory.getLogger(CMapParser.class);
            logger.error("Unknown error while processing CMap.");
        }
        finally {
            inp.close();
        }
    }
}

