/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.io.font.otf;

import com.itextpdf.io.font.otf.ContextualSubstRule;
import com.itextpdf.io.font.otf.Glyph;
import com.itextpdf.io.font.otf.GlyphLine;
import com.itextpdf.io.font.otf.OpenTableLookup;
import com.itextpdf.io.font.otf.OpenTypeFontTableReader;
import java.io.Serializable;
import java.util.List;

public abstract class ContextualSubTable
implements Serializable {
    private static final long serialVersionUID = 1802216575331243298L;
    protected OpenTypeFontTableReader openReader;
    protected int lookupFlag;

    protected ContextualSubTable(OpenTypeFontTableReader openReader, int lookupFlag) {
        this.openReader = openReader;
        this.lookupFlag = lookupFlag;
    }

    public ContextualSubstRule getMatchingContextRule(GlyphLine line) {
        if (line.idx >= line.end) {
            return null;
        }
        Glyph g = line.get(line.idx);
        List<ContextualSubstRule> rules = this.getSetOfRulesForStartGlyph(g.getCode());
        for (ContextualSubstRule rule : rules) {
            int lastGlyphIndex = this.checkIfContextMatch(line, rule);
            if (lastGlyphIndex == -1) continue;
            line.start = line.idx;
            line.end = lastGlyphIndex + 1;
            return rule;
        }
        return null;
    }

    protected abstract List<ContextualSubstRule> getSetOfRulesForStartGlyph(int var1);

    protected int checkIfContextMatch(GlyphLine line, ContextualSubstRule rule) {
        boolean isMatch;
        int j;
        OpenTableLookup.GlyphIndexer gidx = new OpenTableLookup.GlyphIndexer();
        gidx.line = line;
        gidx.idx = line.idx;
        for (j = 1; j < rule.getContextLength(); ++j) {
            gidx.nextGlyph(this.openReader, this.lookupFlag);
            if (gidx.glyph == null || !rule.isGlyphMatchesInput(gidx.glyph.getCode(), j)) break;
        }
        boolean bl = isMatch = j == rule.getContextLength();
        if (isMatch) {
            return gidx.idx;
        }
        return -1;
    }
}

