/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.io.font;

import com.itextpdf.io.exceptions.IOException;
import com.itextpdf.io.font.CidFontProperties;
import com.itextpdf.io.font.FontCache;
import com.itextpdf.io.font.FontNames;
import com.itextpdf.io.font.FontProgram;
import com.itextpdf.io.font.cmap.CMapUniCid;
import com.itextpdf.io.font.otf.Glyph;
import com.itextpdf.io.util.IntHashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.StringTokenizer;

public class CidFont
extends FontProgram {
    private String fontName;
    private int pdfFontFlags;
    private Set<String> compatibleCmaps;

    CidFont(String fontName, Set<String> cmaps) {
        this.fontName = fontName;
        this.compatibleCmaps = cmaps;
        this.fontNames = new FontNames();
        this.initializeCidFontNameAndStyle(fontName);
        Map<String, Object> fontDesc = CidFontProperties.getAllFonts().get(this.fontNames.getFontName());
        if (fontDesc == null) {
            throw new IOException("There is no such predefined font: {0}").setMessageParams(fontName);
        }
        this.initializeCidFontProperties(fontDesc);
    }

    CidFont(String fontName, Set<String> cmaps, Map<String, Object> fontDescription) {
        this.initializeCidFontNameAndStyle(fontName);
        this.initializeCidFontProperties(fontDescription);
        this.compatibleCmaps = cmaps;
    }

    public boolean compatibleWith(String cmap) {
        if (cmap.equals("Identity-H") || cmap.equals("Identity-V")) {
            return true;
        }
        return this.compatibleCmaps != null && this.compatibleCmaps.contains(cmap);
    }

    @Override
    public int getKerning(Glyph glyph1, Glyph glyph2) {
        return 0;
    }

    @Override
    public int getPdfFontFlags() {
        return this.pdfFontFlags;
    }

    @Override
    public boolean isFontSpecific() {
        return false;
    }

    @Override
    public boolean isBuiltWith(String fontName) {
        return Objects.equals(this.fontName, fontName);
    }

    private void initializeCidFontNameAndStyle(String fontName) {
        String nameBase = CidFont.trimFontStyle(fontName);
        if (nameBase.length() < fontName.length()) {
            this.fontNames.setFontName(fontName);
            this.fontNames.setStyle(fontName.substring(nameBase.length()));
        } else {
            this.fontNames.setFontName(fontName);
        }
        this.fontNames.setFullName(new String[][]{{"", "", "", this.fontNames.getFontName()}});
    }

    private void initializeCidFontProperties(Map<String, Object> fontDesc) {
        this.fontIdentification.setPanose((String)fontDesc.get("Panose"));
        this.fontMetrics.setItalicAngle(Integer.parseInt((String)fontDesc.get("ItalicAngle")));
        this.fontMetrics.setCapHeight(Integer.parseInt((String)fontDesc.get("CapHeight")));
        this.fontMetrics.setTypoAscender(Integer.parseInt((String)fontDesc.get("Ascent")));
        this.fontMetrics.setTypoDescender(Integer.parseInt((String)fontDesc.get("Descent")));
        this.fontMetrics.setStemV(Integer.parseInt((String)fontDesc.get("StemV")));
        this.pdfFontFlags = Integer.parseInt((String)fontDesc.get("Flags"));
        String fontBBox = (String)fontDesc.get("FontBBox");
        StringTokenizer tk = new StringTokenizer(fontBBox, " []\r\n\t\f");
        int llx = Integer.parseInt(tk.nextToken());
        int lly = Integer.parseInt(tk.nextToken());
        int urx = Integer.parseInt(tk.nextToken());
        int ury = Integer.parseInt(tk.nextToken());
        this.fontMetrics.updateBbox(llx, lly, urx, ury);
        this.registry = (String)fontDesc.get("Registry");
        String uniMap = CidFont.getCompatibleUniMap(this.registry);
        if (uniMap != null) {
            IntHashtable metrics = (IntHashtable)fontDesc.get("W");
            CMapUniCid uni2cid = FontCache.getUni2CidCmap(uniMap);
            this.avgWidth = 0;
            for (int cp : uni2cid.getCodePoints()) {
                int cid = uni2cid.lookup(cp);
                int width = metrics.containsKey(cid) ? metrics.get(cid) : 1000;
                Glyph glyph = new Glyph(cid, width, cp);
                this.avgWidth += glyph.getWidth();
                this.codeToGlyph.put(cid, glyph);
                this.unicodeToGlyph.put(cp, glyph);
            }
            this.fixSpaceIssue();
            if (this.codeToGlyph.size() != 0) {
                this.avgWidth /= this.codeToGlyph.size();
            }
        }
    }

    private static String getCompatibleUniMap(String registry) {
        String uniMap = "";
        Iterator<String> iterator = CidFontProperties.getRegistryNames().get(registry + "_Uni").iterator();
        while (iterator.hasNext()) {
            String name;
            uniMap = name = iterator.next();
            if (!name.endsWith("H")) continue;
            break;
        }
        return uniMap;
    }
}

