/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.io.image;

import com.itextpdf.io.image.ImageData;
import com.itextpdf.io.image.ImageType;
import com.itextpdf.io.image.Jpeg2000ImageData;
import com.itextpdf.io.util.StreamUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

final class Jpeg2000ImageHelper {
    private static final int JPIP_JPIP = 1785751920;
    private static final int JP2_JP = 1783636000;
    private static final int JP2_IHDR = 1768449138;
    private static final int JP2_FTYP = 1718909296;
    private static final int JP2_JP2H = 1785737832;
    private static final int JP2_COLR = 1668246642;
    private static final int JP2_JP2C = 1785737827;
    private static final int JP2_URL = 1970433056;
    private static final int JP2_DBTL = 1685348972;
    private static final int JP2_BPCC = 1651532643;
    private static final int JP2_JP2 = 1785737760;
    private static final int JPX_JPXB = 1785755746;

    Jpeg2000ImageHelper() {
    }

    public static void processImage(ImageData image) {
        if (image.getOriginalType() != ImageType.JPEG2000) {
            throw new IllegalArgumentException("JPEG2000 image expected");
        }
        Jpeg2000ImageHelper.processParameters((Jpeg2000ImageData)image);
        image.setFilter("JPXDecode");
    }

    private static void processParameters(Jpeg2000ImageData jp2) {
        block19: {
            jp2.parameters = new Jpeg2000ImageData.Parameters();
            try {
                if (jp2.getData() == null) {
                    jp2.loadData();
                }
                ByteArrayInputStream jpeg2000Stream = new ByteArrayInputStream(jp2.getData());
                Jpeg2000Box box = new Jpeg2000Box();
                box.length = Jpeg2000ImageHelper.cio_read(4, jpeg2000Stream);
                if (box.length == 12) {
                    jp2.parameters.setJp2(true);
                    box.type = Jpeg2000ImageHelper.cio_read(4, jpeg2000Stream);
                    if (1783636000 != box.type) {
                        throw new com.itextpdf.io.exceptions.IOException("Expected JP marker.");
                    }
                    if (218793738 != Jpeg2000ImageHelper.cio_read(4, jpeg2000Stream)) {
                        throw new com.itextpdf.io.exceptions.IOException("Error with JP marker.");
                    }
                    Jpeg2000ImageHelper.jp2_read_boxhdr(box, jpeg2000Stream);
                    if (1718909296 != box.type) {
                        throw new com.itextpdf.io.exceptions.IOException("Expected FTYP marker.");
                    }
                    StreamUtil.skip(jpeg2000Stream, 8L);
                    for (int i = 4; i < box.length / 4; ++i) {
                        if (Jpeg2000ImageHelper.cio_read(4, jpeg2000Stream) != 1785755746) continue;
                        jp2.parameters.setJpxBaseline(true);
                    }
                    Jpeg2000ImageHelper.jp2_read_boxhdr(box, jpeg2000Stream);
                    do {
                        if (1785737832 == box.type) continue;
                        if (box.type == 1785737827) {
                            throw new com.itextpdf.io.exceptions.IOException("Expected JP2H marker.");
                        }
                        StreamUtil.skip(jpeg2000Stream, box.length - 8);
                        Jpeg2000ImageHelper.jp2_read_boxhdr(box, jpeg2000Stream);
                    } while (1785737832 != box.type);
                    Jpeg2000ImageHelper.jp2_read_boxhdr(box, jpeg2000Stream);
                    if (1768449138 != box.type) {
                        throw new com.itextpdf.io.exceptions.IOException("Expected IHDR marker.");
                    }
                    jp2.setHeight(Jpeg2000ImageHelper.cio_read(4, jpeg2000Stream));
                    jp2.setWidth(Jpeg2000ImageHelper.cio_read(4, jpeg2000Stream));
                    jp2.parameters.setNumOfComps(Jpeg2000ImageHelper.cio_read(2, jpeg2000Stream));
                    jp2.setBpc(Jpeg2000ImageHelper.cio_read(1, jpeg2000Stream));
                    StreamUtil.skip(jpeg2000Stream, 3L);
                    Jpeg2000ImageHelper.jp2_read_boxhdr(box, jpeg2000Stream);
                    if (box.type == 1651532643) {
                        jp2.parameters.setBpcBoxData(new byte[box.length - 8]);
                        ((InputStream)jpeg2000Stream).read(jp2.parameters.getBpcBoxData(), 0, box.length - 8);
                    } else if (box.type == 1668246642) {
                        do {
                            if (jp2.parameters.getColorSpecBoxes() == null) {
                                jp2.parameters.setColorSpecBoxes(new ArrayList<Jpeg2000ImageData.ColorSpecBox>());
                            }
                            List<Jpeg2000ImageData.ColorSpecBox> colorSpecBoxes = jp2.parameters.getColorSpecBoxes();
                            colorSpecBoxes.add(Jpeg2000ImageHelper.jp2_read_colr(box, jpeg2000Stream));
                            jp2.parameters.setColorSpecBoxes(colorSpecBoxes);
                            try {
                                Jpeg2000ImageHelper.jp2_read_boxhdr(box, jpeg2000Stream);
                            }
                            catch (ZeroBoxSizeException zeroBoxSizeException) {
                                // empty catch block
                            }
                        } while (1668246642 == box.type);
                    }
                    break block19;
                }
                if (box.length == -11534511) {
                    StreamUtil.skip(jpeg2000Stream, 4L);
                    int x1 = Jpeg2000ImageHelper.cio_read(4, jpeg2000Stream);
                    int y1 = Jpeg2000ImageHelper.cio_read(4, jpeg2000Stream);
                    int x0 = Jpeg2000ImageHelper.cio_read(4, jpeg2000Stream);
                    int y0 = Jpeg2000ImageHelper.cio_read(4, jpeg2000Stream);
                    StreamUtil.skip(jpeg2000Stream, 16L);
                    jp2.setColorEncodingComponentsNumber(Jpeg2000ImageHelper.cio_read(2, jpeg2000Stream));
                    jp2.setBpc(8);
                    jp2.setHeight(y1 - y0);
                    jp2.setWidth(x1 - x0);
                    break block19;
                }
                throw new com.itextpdf.io.exceptions.IOException("Invalid JPEG2000 file.");
            }
            catch (IOException e) {
                throw new com.itextpdf.io.exceptions.IOException("JPEG2000 image exception.", e);
            }
        }
    }

    private static Jpeg2000ImageData.ColorSpecBox jp2_read_colr(Jpeg2000Box box, InputStream jpeg2000Stream) throws IOException {
        int readBytes = 8;
        Jpeg2000ImageData.ColorSpecBox colorSpecBox = new Jpeg2000ImageData.ColorSpecBox();
        for (int i = 0; i < 3; ++i) {
            colorSpecBox.add(Jpeg2000ImageHelper.cio_read(1, jpeg2000Stream));
            ++readBytes;
        }
        if (colorSpecBox.getMeth() == 1) {
            colorSpecBox.add(Jpeg2000ImageHelper.cio_read(4, jpeg2000Stream));
            readBytes += 4;
        } else {
            colorSpecBox.add(0);
        }
        if (box.length - readBytes > 0) {
            byte[] colorProfile = new byte[box.length - readBytes];
            jpeg2000Stream.read(colorProfile, 0, box.length - readBytes);
            colorSpecBox.setColorProfile(colorProfile);
        }
        return colorSpecBox;
    }

    private static void jp2_read_boxhdr(Jpeg2000Box box, InputStream jpeg2000Stream) throws IOException {
        box.length = Jpeg2000ImageHelper.cio_read(4, jpeg2000Stream);
        box.type = Jpeg2000ImageHelper.cio_read(4, jpeg2000Stream);
        if (box.length == 1) {
            if (Jpeg2000ImageHelper.cio_read(4, jpeg2000Stream) != 0) {
                throw new com.itextpdf.io.exceptions.IOException("Cannot handle box sizes higher than 2^32.");
            }
            box.length = Jpeg2000ImageHelper.cio_read(4, jpeg2000Stream);
            if (box.length == 0) {
                throw new com.itextpdf.io.exceptions.IOException("Unsupported box size == 0.");
            }
        } else if (box.length == 0) {
            throw new ZeroBoxSizeException("Unsupported box size == 0");
        }
    }

    private static int cio_read(int n, InputStream jpeg2000Stream) throws IOException {
        int v = 0;
        for (int i = n - 1; i >= 0; --i) {
            v += jpeg2000Stream.read() << (i << 3);
        }
        return v;
    }

    private static class ZeroBoxSizeException
    extends IOException {
        ZeroBoxSizeException(String s) {
            super(s);
        }
    }

    private static class Jpeg2000Box {
        int length;
        int type;

        private Jpeg2000Box() {
        }
    }
}

