/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text.pdf.internal;

import com.itextpdf.text.BaseColor;
import com.itextpdf.text.ExceptionConverter;
import com.itextpdf.text.error_messages.MessageLocalization;
import com.itextpdf.text.pdf.BaseFont;
import com.itextpdf.text.pdf.DocumentFont;
import com.itextpdf.text.pdf.ExtendedColor;
import com.itextpdf.text.pdf.ICC_Profile;
import com.itextpdf.text.pdf.PatternColor;
import com.itextpdf.text.pdf.PdfAConformanceException;
import com.itextpdf.text.pdf.PdfAConformanceLevel;
import com.itextpdf.text.pdf.PdfAStamperImp;
import com.itextpdf.text.pdf.PdfAWriter;
import com.itextpdf.text.pdf.PdfAcroForm;
import com.itextpdf.text.pdf.PdfAction;
import com.itextpdf.text.pdf.PdfAnnotation;
import com.itextpdf.text.pdf.PdfArray;
import com.itextpdf.text.pdf.PdfBoolean;
import com.itextpdf.text.pdf.PdfDictionary;
import com.itextpdf.text.pdf.PdfFileSpecification;
import com.itextpdf.text.pdf.PdfFormField;
import com.itextpdf.text.pdf.PdfGState;
import com.itextpdf.text.pdf.PdfImage;
import com.itextpdf.text.pdf.PdfIndirectReference;
import com.itextpdf.text.pdf.PdfName;
import com.itextpdf.text.pdf.PdfNumber;
import com.itextpdf.text.pdf.PdfObject;
import com.itextpdf.text.pdf.PdfStream;
import com.itextpdf.text.pdf.PdfString;
import com.itextpdf.text.pdf.PdfStructureElement;
import com.itextpdf.text.pdf.PdfWriter;
import com.itextpdf.text.pdf.ShadingColor;
import com.itextpdf.text.pdf.SpotColor;
import com.itextpdf.text.pdf.internal.PdfAChecker;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.HashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PdfA1Checker
extends PdfAChecker {
    public static final PdfName setState = new PdfName("SetState");
    public static final PdfName noOp = new PdfName("NoOp");
    private static HashSet<PdfName> allowedAnnotTypes = new HashSet<PdfName>(Arrays.asList(PdfName.TEXT, PdfName.LINK, PdfName.FREETEXT, PdfName.LINE, PdfName.SQUARE, PdfName.CIRCLE, PdfName.POLYGON, PdfName.POLYLINE, PdfName.HIGHLIGHT, PdfName.UNDERLINE, PdfName.SQUIGGLY, PdfName.STRIKEOUT, PdfName.STAMP, PdfName.CARET, PdfName.INK, PdfName.POPUP, PdfName.FILEATTACHMENT, PdfName.WIDGET, PdfName.PRINTERMARK, PdfName.TRAPNET, PdfName.WATERMARK));
    public static final HashSet<PdfName> allowedNamedActions = new HashSet<PdfName>(Arrays.asList(PdfName.NEXTPAGE, PdfName.PREVPAGE, PdfName.FIRSTPAGE, PdfName.LASTPAGE));
    private static HashSet<PdfName> restrictedActions = new HashSet<PdfName>(Arrays.asList(PdfName.LAUNCH, PdfName.SOUND, PdfName.MOVIE, PdfName.RESETFORM, PdfName.IMPORTDATA, PdfName.JAVASCRIPT));
    public static final HashSet<PdfName> contentAnnotations = new HashSet<PdfName>(Arrays.asList(PdfName.TEXT, PdfName.FREETEXT, PdfName.LINE, PdfName.SQUARE, PdfName.CIRCLE, PdfName.STAMP, PdfName.INK, PdfName.POPUP));
    private static final HashSet<PdfName> keysForCheck = new HashSet<PdfName>(Arrays.asList(PdfName.FONTDESCRIPTOR, PdfName.FONTFILE, PdfName.FONTFILE2, PdfName.FONTFILE3, PdfName.FILTER, PdfName.GROUP, PdfName.S, PdfName.EMBEDDEDFILES, PdfName.MARKED, PdfName.DESTOUTPUTPROFILE));
    public static final double maxRealValue = 32767.0;
    public static final int maxStringLength = 65535;
    public static final int maxArrayLength = 8191;
    public static final int maxDictionaryLength = 4095;
    public static final int maxGsStackDepth = 28;
    protected int gsStackDepth = 0;
    protected boolean rgbUsed = false;
    protected boolean cmykUsed = false;
    protected boolean grayUsed = false;
    protected String pdfaOutputIntentColorSpace = null;
    protected PdfObject pdfaDestOutputIntent = null;

    PdfA1Checker(PdfAConformanceLevel conformanceLevel) {
        super(conformanceLevel);
    }

    @Override
    protected HashSet<PdfName> initKeysForCheck() {
        return keysForCheck;
    }

    @Override
    protected void checkFont(PdfWriter writer, int key, Object obj1) {
        BaseFont bf = (BaseFont)obj1;
        if (bf.getFontType() == 4) {
            PdfStream prs = null;
            PdfDictionary fontDictionary = ((DocumentFont)bf).getFontDictionary();
            PdfDictionary fontDescriptor = this.getDirectDictionary(fontDictionary.get(PdfName.FONTDESCRIPTOR));
            if (fontDescriptor != null) {
                prs = this.getDirectStream(fontDescriptor.get(PdfName.FONTFILE));
                if (prs == null) {
                    prs = this.getDirectStream(fontDescriptor.get(PdfName.FONTFILE2));
                }
                if (prs == null) {
                    prs = this.getDirectStream(fontDescriptor.get(PdfName.FONTFILE3));
                }
            }
            if (prs == null) {
                throw new PdfAConformanceException(obj1, MessageLocalization.getComposedMessage((String)"all.the.fonts.must.be.embedded.this.one.isn.t.1", (Object[])new Object[]{((BaseFont)obj1).getPostscriptFontName()}));
            }
        } else if (!bf.isEmbedded()) {
            throw new PdfAConformanceException(obj1, MessageLocalization.getComposedMessage((String)"all.the.fonts.must.be.embedded.this.one.isn.t.1", (Object[])new Object[]{((BaseFont)obj1).getPostscriptFontName()}));
        }
    }

    @Override
    protected void checkImage(PdfWriter writer, int key, Object obj1) {
        PdfImage image = (PdfImage)obj1;
        if (image.get(PdfName.SMASK) != null && !PdfName.NONE.equals((Object)image.getAsName(PdfName.SMASK))) {
            throw new PdfAConformanceException(obj1, MessageLocalization.getComposedMessage((String)"the.smask.key.is.not.allowed.in.images", (Object[])new Object[0]));
        }
        if (image.contains(PdfName.ALTERNATES)) {
            throw new PdfAConformanceException(obj1, MessageLocalization.getComposedMessage((String)"an.image.dictionary.shall.not.contain.alternates.key", (Object[])new Object[0]));
        }
        if (image.contains(PdfName.OPI)) {
            throw new PdfAConformanceException(obj1, MessageLocalization.getComposedMessage((String)"an.image.dictionary.shall.not.contain.opi.key", (Object[])new Object[0]));
        }
        PdfBoolean interpolate = image.getAsBoolean(PdfName.INTERPOLATE);
        if (interpolate != null && interpolate.booleanValue()) {
            throw new PdfAConformanceException(obj1, MessageLocalization.getComposedMessage((String)"the.value.of.interpolate.key.shall.not.be.true", (Object[])new Object[0]));
        }
        PdfName intent = image.getAsName(PdfName.INTENT);
        if (!(intent == null || PdfName.RELATIVECOLORIMETRIC.equals((Object)intent) || PdfName.ABSOLUTECOLORIMETRIC.equals((Object)intent) || PdfName.PERCEPTUAL.equals((Object)intent) || PdfName.SATURATION.equals((Object)intent))) {
            throw new PdfAConformanceException(obj1, MessageLocalization.getComposedMessage((String)"1.value.of.intent.key.is.not.allowed", (Object[])new Object[]{intent.toString()}));
        }
    }

    @Override
    protected void checkFormXObj(PdfWriter writer, int key, Object obj1) {
    }

    @Override
    protected void checkInlineImage(PdfWriter writer, int key, Object obj1) {
    }

    @Override
    protected void checkGState(PdfWriter writer, int key, Object obj1) {
        if (obj1 instanceof PdfDictionary) {
            PdfDictionary gs = (PdfDictionary)obj1;
            PdfObject obj = gs.get(PdfName.BM);
            if (obj != null && !PdfGState.BM_NORMAL.equals((Object)obj) && !PdfGState.BM_COMPATIBLE.equals((Object)obj)) {
                throw new PdfAConformanceException(obj1, MessageLocalization.getComposedMessage((String)"blend.mode.1.not.allowed", (Object[])new Object[]{obj.toString()}));
            }
            obj = gs.get(PdfName.CA);
            double v = 0.0;
            if (obj != null && (v = ((PdfNumber)obj).doubleValue()) != 1.0) {
                throw new PdfAConformanceException(obj1, MessageLocalization.getComposedMessage((String)"transparency.is.not.allowed.ca.eq.1", (Object[])new Object[]{String.valueOf(v)}));
            }
            obj = gs.get(PdfName.ca);
            v = 0.0;
            if (obj != null && (v = ((PdfNumber)obj).doubleValue()) != 1.0) {
                throw new PdfAConformanceException(obj1, MessageLocalization.getComposedMessage((String)"transparency.is.not.allowed.ca.eq.1", (Object[])new Object[]{String.valueOf(v)}));
            }
            if (gs.contains(PdfName.TR)) {
                throw new PdfAConformanceException(obj1, MessageLocalization.getComposedMessage((String)"an.extgstate.dictionary.shall.not.contain.the.tr.key", (Object[])new Object[0]));
            }
            PdfName tr2 = gs.getAsName(PdfName.TR2);
            if (tr2 != null && !tr2.equals((Object)PdfName.DEFAULT)) {
                throw new PdfAConformanceException(obj1, MessageLocalization.getComposedMessage((String)"an.extgstate.dictionary.shall.not.contain.the.TR2.key.with.a.value.other.than.default", (Object[])new Object[0]));
            }
            PdfName ri = gs.getAsName(PdfName.RI);
            if (!(ri == null || PdfName.RELATIVECOLORIMETRIC.equals((Object)ri) || PdfName.ABSOLUTECOLORIMETRIC.equals((Object)ri) || PdfName.PERCEPTUAL.equals((Object)ri) || PdfName.SATURATION.equals((Object)ri))) {
                throw new PdfAConformanceException(obj1, MessageLocalization.getComposedMessage((String)"1.value.of.ri.key.is.not.allowed", (Object[])new Object[]{ri.toString()}));
            }
            if (gs.get(PdfName.SMASK) != null && !PdfName.NONE.equals((Object)gs.getAsName(PdfName.SMASK))) {
                throw new PdfAConformanceException(obj1, MessageLocalization.getComposedMessage((String)"the.smask.key.is.not.allowed.in.extgstate", (Object[])new Object[0]));
            }
        }
    }

    @Override
    protected void checkLayer(PdfWriter writer, int key, Object obj1) {
        throw new PdfAConformanceException(obj1, MessageLocalization.getComposedMessage((String)"layers.are.not.allowed", (Object[])new Object[0]));
    }

    @Override
    protected void checkTrailer(PdfWriter writer, int key, Object obj1) {
        PdfWriter.PdfTrailer trailer;
        if (obj1 instanceof PdfWriter.PdfTrailer && (trailer = (PdfWriter.PdfTrailer)obj1).get(PdfName.ENCRYPT) != null) {
            throw new PdfAConformanceException(obj1, MessageLocalization.getComposedMessage((String)"keyword.encrypt.shall.not.be.used.in.the.trailer.dictionary", (Object[])new Object[0]));
        }
    }

    @Override
    protected void checkStream(PdfWriter writer, int key, Object obj1) {
        if (obj1 instanceof PdfStream) {
            PdfStream stream = (PdfStream)obj1;
            if (stream.contains(PdfName.F) || stream.contains(PdfName.FFILTER) || stream.contains(PdfName.FDECODEPARMS)) {
                throw new PdfAConformanceException(obj1, MessageLocalization.getComposedMessage((String)"stream.object.dictionary.shall.not.contain.the.f.ffilter.or.fdecodeparams.keys", (Object[])new Object[0]));
            }
            PdfObject filter = this.getDirectObject(stream.get(PdfName.FILTER));
            if (filter instanceof PdfName) {
                if (filter.equals(PdfName.LZWDECODE)) {
                    throw new PdfAConformanceException(obj1, MessageLocalization.getComposedMessage((String)"lzwdecode.filter.is.not.permitted", (Object[])new Object[0]));
                }
            } else if (filter instanceof PdfArray) {
                for (PdfObject f : (PdfArray)filter) {
                    if (!f.equals(PdfName.LZWDECODE)) continue;
                    throw new PdfAConformanceException(obj1, MessageLocalization.getComposedMessage((String)"lzwdecode.filter.is.not.permitted", (Object[])new Object[0]));
                }
            }
            if (PdfName.FORM.equals((Object)stream.getAsName(PdfName.SUBTYPE))) {
                PdfName s;
                if (stream.contains(PdfName.OPI)) {
                    throw new PdfAConformanceException(obj1, MessageLocalization.getComposedMessage((String)"a.form.xobject.dictionary.shall.not.contain.opi.key", (Object[])new Object[0]));
                }
                if (stream.contains(PdfName.PS)) {
                    throw new PdfAConformanceException(obj1, MessageLocalization.getComposedMessage((String)"a.form.xobject.dictionary.shall.not.contain.ps.key", (Object[])new Object[0]));
                }
                PdfDictionary group = this.getDirectDictionary(stream.get(PdfName.GROUP));
                if (group != null && PdfName.TRANSPARENCY.equals((Object)(s = group.getAsName(PdfName.S)))) {
                    throw new PdfAConformanceException(obj1, MessageLocalization.getComposedMessage((String)"a.group.object.with.an.s.key.with.a.value.of.transparency.shall.not.be.included.in.a.form.xobject", (Object[])new Object[0]));
                }
            }
            if (PdfName.PS.equals((Object)stream.getAsName(PdfName.SUBTYPE))) {
                throw new PdfAConformanceException(obj1, MessageLocalization.getComposedMessage((String)"postscript.xobjects.are.not.allowed", (Object[])new Object[0]));
            }
        }
    }

    @Override
    protected void checkFileSpec(PdfWriter writer, int key, Object obj1) {
        PdfFileSpecification fileSpec;
        if (obj1 instanceof PdfFileSpecification && (fileSpec = (PdfFileSpecification)obj1).contains(PdfName.EF)) {
            throw new PdfAConformanceException(obj1, MessageLocalization.getComposedMessage((String)"embedded.files.are.not.permitted", (Object[])new Object[0]));
        }
    }

    @Override
    protected void checkPdfObject(PdfWriter writer, int key, Object obj1) {
        if (obj1 instanceof PdfNumber) {
            PdfNumber number = (PdfNumber)obj1;
            if (Math.abs(number.doubleValue()) > 32767.0 && number.toString().contains(".")) {
                throw new PdfAConformanceException(obj1, MessageLocalization.getComposedMessage((String)"real.number.is.out.of.range", (Object[])new Object[0]));
            }
        } else if (obj1 instanceof PdfString) {
            PdfString string = (PdfString)obj1;
            if (string.getBytes().length > 65535) {
                throw new PdfAConformanceException(obj1, MessageLocalization.getComposedMessage((String)"pdf.string.is.too.long", (Object[])new Object[0]));
            }
        } else if (obj1 instanceof PdfArray) {
            PdfArray array = (PdfArray)obj1;
            if (array.size() > 8191) {
                throw new PdfAConformanceException(obj1, MessageLocalization.getComposedMessage((String)"pdf.array.exceeds.length.set.by.PDFA1.standard", (Object[])new Object[]{Integer.toString(array.size())}));
            }
        } else if (obj1 instanceof PdfDictionary) {
            PdfDictionary dictionary = (PdfDictionary)obj1;
            if (dictionary.size() > 4095) {
                throw new PdfAConformanceException(obj1, MessageLocalization.getComposedMessage((String)"pdf.dictionary.is.out.of.bounds", (Object[])new Object[0]));
            }
            PdfName type = dictionary.getAsName(PdfName.TYPE);
            if (PdfName.CATALOG.equals((Object)type)) {
                PdfDictionary names;
                if (!dictionary.contains(PdfName.METADATA)) {
                    throw new PdfAConformanceException(obj1, MessageLocalization.getComposedMessage((String)"the.document.catalog.dictionary.shall.contain.metadata", (Object[])new Object[0]));
                }
                if (dictionary.contains(PdfName.AA)) {
                    throw new PdfAConformanceException(obj1, MessageLocalization.getComposedMessage((String)"the.document.catalog.dictionary.shall.not.include.an.aa.entry", (Object[])new Object[0]));
                }
                if (dictionary.contains(PdfName.NAMES) && (names = this.getDirectDictionary(dictionary.get(PdfName.NAMES))) != null && names.contains(PdfName.EMBEDDEDFILES)) {
                    throw new PdfAConformanceException(obj1, MessageLocalization.getComposedMessage((String)"the.document.catalog.dictionary.shall.not.include.embeddedfiles.names.entry", (Object[])new Object[0]));
                }
                if (PdfA1Checker.checkStructure(this.conformanceLevel)) {
                    PdfDictionary markInfo = this.getDirectDictionary(dictionary.get(PdfName.MARKINFO));
                    if (markInfo == null || markInfo.getAsBoolean(PdfName.MARKED) == null || !markInfo.getAsBoolean(PdfName.MARKED).booleanValue()) {
                        throw new PdfAConformanceException(obj1, MessageLocalization.getComposedMessage((String)"document.catalog.dictionary.shall.include.a.markinfo.dictionary.whose.entry.marked.shall.have.a.value.of.true", (Object[])new Object[0]));
                    }
                    if (!dictionary.contains(PdfName.LANG)) {
                        throw new PdfAConformanceException(obj1, MessageLocalization.getComposedMessage((String)"document.catalog.dictionary.should.contain.lang.entry", (Object[])new Object[0]));
                    }
                }
            } else if (PdfName.PAGE.equals((Object)type)) {
                if (dictionary.contains(PdfName.AA)) {
                    throw new PdfAConformanceException(obj1, MessageLocalization.getComposedMessage((String)"page.dictionary.shall.not.include.aa.entry", (Object[])new Object[0]));
                }
            } else if (PdfName.OUTPUTINTENT.equals((Object)type)) {
                PdfObject destOutputIntent = dictionary.get(PdfName.DESTOUTPUTPROFILE);
                if (destOutputIntent != null && this.pdfaDestOutputIntent != null) {
                    if (this.pdfaDestOutputIntent.getIndRef() != destOutputIntent.getIndRef()) {
                        throw new PdfAConformanceException(obj1, MessageLocalization.getComposedMessage((String)"if.outputintents.array.more.than.one.entry.the.same.indirect.object", (Object[])new Object[0]));
                    }
                } else {
                    this.pdfaDestOutputIntent = destOutputIntent;
                }
                PdfName gts = dictionary.getAsName(PdfName.S);
                if (this.pdfaDestOutputIntent != null) {
                    if (PdfName.GTS_PDFA1.equals((Object)gts)) {
                        if (this.pdfaOutputIntentColorSpace != null) {
                            throw new PdfAConformanceException(obj1, MessageLocalization.getComposedMessage((String)"a.pdfa.file.may.have.only.one.pdfa.outputintent", (Object[])new Object[0]));
                        }
                        this.pdfaOutputIntentColorSpace = "";
                        ICC_Profile icc_profile = writer.getColorProfile();
                        try {
                            this.pdfaOutputIntentColorSpace = new String(icc_profile.getData(), 16, 4, "US-ASCII");
                        }
                        catch (UnsupportedEncodingException e) {
                            throw new ExceptionConverter((Exception)e);
                        }
                    }
                } else {
                    throw new PdfAConformanceException(obj1, MessageLocalization.getComposedMessage((String)"outputintent.shall.have.gtspdfa1.and.destoutputintent", (Object[])new Object[0]));
                }
            }
        }
    }

    @Override
    protected void checkCanvas(PdfWriter writer, int key, Object obj1) {
        if (obj1 instanceof String) {
            if ("q".equals(obj1)) {
                if (++this.gsStackDepth > 28) {
                    throw new PdfAConformanceException(obj1, MessageLocalization.getComposedMessage((String)"graphics.state.stack.depth.is.greater.than.28", (Object[])new Object[0]));
                }
            } else if ("Q".equals(obj1)) {
                --this.gsStackDepth;
            }
        }
    }

    @Override
    protected void checkColor(PdfWriter writer, int key, Object obj1) {
        switch (key) {
            case 1: {
                if (obj1 instanceof ExtendedColor) {
                    ExtendedColor ec = (ExtendedColor)obj1;
                    switch (ec.getType()) {
                        case 2: {
                            this.checkColor(writer, 2, obj1);
                            break;
                        }
                        case 1: {
                            this.checkColor(writer, 18, obj1);
                            return;
                        }
                        case 0: {
                            this.checkColor(writer, 3, obj1);
                            break;
                        }
                        case 3: {
                            SpotColor sc = (SpotColor)ec;
                            this.checkColor(writer, 1, sc.getPdfSpotColor().getAlternativeCS());
                            break;
                        }
                        case 5: {
                            ShadingColor xc = (ShadingColor)ec;
                            this.checkColor(writer, 1, xc.getPdfShadingPattern().getShading().getColorSpace());
                            break;
                        }
                        case 4: {
                            PatternColor pc = (PatternColor)ec;
                            this.checkColor(writer, 1, pc.getPainter().getDefaultColor());
                        }
                    }
                    break;
                }
                if (!(obj1 instanceof BaseColor)) break;
                this.checkColor(writer, 3, obj1);
                break;
            }
            case 2: {
                if (this.rgbUsed) {
                    throw new PdfAConformanceException(obj1, MessageLocalization.getComposedMessage((String)"devicergb.and.devicecmyk.colorspaces.cannot.be.used.both.in.one.file", (Object[])new Object[0]));
                }
                this.cmykUsed = true;
                break;
            }
            case 3: {
                if (this.cmykUsed) {
                    throw new PdfAConformanceException(obj1, MessageLocalization.getComposedMessage((String)"devicergb.and.devicecmyk.colorspaces.cannot.be.used.both.in.one.file", (Object[])new Object[0]));
                }
                this.rgbUsed = true;
                break;
            }
            case 18: {
                this.grayUsed = true;
            }
        }
    }

    @Override
    protected void checkAnnotation(PdfWriter writer, int key, Object obj1) {
        if (obj1 instanceof PdfFormField) {
            PdfFormField field = (PdfFormField)obj1;
            if (!field.contains(PdfName.SUBTYPE)) {
                return;
            }
            if (field.contains(PdfName.AA) || field.contains(PdfName.A)) {
                throw new PdfAConformanceException(obj1, MessageLocalization.getComposedMessage((String)"widget.annotation.dictionary.or.field.dictionary.shall.not.include.a.or.aa.entry", (Object[])new Object[0]));
            }
        }
        if (obj1 instanceof PdfAnnotation) {
            PdfDictionary ap;
            PdfAnnotation annot = (PdfAnnotation)obj1;
            PdfObject subtype = annot.get(PdfName.SUBTYPE);
            if (subtype == null) {
                throw new PdfAConformanceException(obj1, MessageLocalization.getComposedMessage((String)"annotation.type.1.not.allowed", (Object[])new Object[]{"null"}));
            }
            if (subtype != null && !allowedAnnotTypes.contains(subtype)) {
                throw new PdfAConformanceException(obj1, MessageLocalization.getComposedMessage((String)"annotation.type.1.not.allowed", (Object[])new Object[]{subtype.toString()}));
            }
            PdfNumber ca = annot.getAsNumber(PdfName.CA);
            if (ca != null && (double)ca.floatValue() != 1.0) {
                throw new PdfAConformanceException(obj1, MessageLocalization.getComposedMessage((String)"an.annotation.dictionary.shall.not.contain.the.ca.key.with.a.value.other.than.1", (Object[])new Object[0]));
            }
            PdfNumber f = annot.getAsNumber(PdfName.F);
            if (f == null) {
                throw new PdfAConformanceException(obj1, MessageLocalization.getComposedMessage((String)"an.annotation.dictionary.shall.contain.the.f.key", (Object[])new Object[0]));
            }
            int flags = f.intValue();
            if (!PdfA1Checker.checkFlag(flags, 4) || PdfA1Checker.checkFlag(flags, 2) || PdfA1Checker.checkFlag(flags, 1) || PdfA1Checker.checkFlag(flags, 32)) {
                throw new PdfAConformanceException(obj1, MessageLocalization.getComposedMessage((String)"the.f.keys.print.flag.bit.shall.be.set.to.1.and.its.hidden.invisible.and.noview.flag.bits.shall.be.set.to.0", (Object[])new Object[0]));
            }
            if (!(!PdfName.TEXT.equals((Object)annot.getAsName(PdfName.SUBTYPE)) || PdfA1Checker.checkFlag(flags, 8) && PdfA1Checker.checkFlag(flags, 16))) {
                throw new PdfAConformanceException(obj1, MessageLocalization.getComposedMessage((String)"text.annotations.should.set.the.nozoom.and.norotate.flag.bits.of.the.f.key.to.1", (Object[])new Object[0]));
            }
            if (annot.contains(PdfName.C) || annot.contains(PdfName.IC)) {
                ICC_Profile colorProfile = ((PdfAWriter)writer).getColorProfile();
                String cs = "";
                try {
                    cs = new String(colorProfile.getData(), 16, 4, "US-ASCII");
                }
                catch (UnsupportedEncodingException e) {
                    throw new ExceptionConverter((Exception)e);
                }
                if (!"RGB ".equalsIgnoreCase(cs)) {
                    throw new PdfAConformanceException(obj1, MessageLocalization.getComposedMessage((String)"destoutputprofile.in.the.pdfa1.outputintent.dictionary.shall.be.rgb", (Object[])new Object[0]));
                }
            }
            if ((ap = this.getDirectDictionary(annot.get(PdfName.AP))) != null) {
                if (ap.contains(PdfName.R) || ap.contains(PdfName.D)) {
                    throw new PdfAConformanceException(obj1, MessageLocalization.getComposedMessage((String)"appearance.dictionary.shall.contain.only.the.n.key.with.stream.value", (Object[])new Object[0]));
                }
                PdfObject n = ap.get(PdfName.N);
                if (!(n instanceof PdfIndirectReference)) {
                    throw new PdfAConformanceException(obj1, MessageLocalization.getComposedMessage((String)"appearance.dictionary.shall.contain.only.the.n.key.with.stream.value", (Object[])new Object[0]));
                }
            }
            if (PdfName.WIDGET.equals((Object)annot.getAsName(PdfName.SUBTYPE)) && (annot.contains(PdfName.AA) || annot.contains(PdfName.A))) {
                throw new PdfAConformanceException(obj1, MessageLocalization.getComposedMessage((String)"widget.annotation.dictionary.or.field.dictionary.shall.not.include.a.or.aa.entry", (Object[])new Object[0]));
            }
            if (PdfA1Checker.checkStructure(this.conformanceLevel) && contentAnnotations.contains(subtype) && !annot.contains(PdfName.CONTENTS)) {
                throw new PdfAConformanceException(obj1, MessageLocalization.getComposedMessage((String)"annotation.of.type.1.should.have.contents.key", (Object[])new Object[]{subtype.toString()}));
            }
        }
    }

    @Override
    protected void checkAction(PdfWriter writer, int key, Object obj1) {
        if (obj1 instanceof PdfAction) {
            PdfName n;
            PdfAction action = (PdfAction)obj1;
            PdfName s = action.getAsName(PdfName.S);
            if (setState.equals((Object)s) || noOp.equals((Object)s)) {
                throw new PdfAConformanceException(obj1, MessageLocalization.getComposedMessage((String)"deprecated.setstate.and.noop.actions.are.not.allowed", (Object[])new Object[0]));
            }
            if (restrictedActions.contains(s)) {
                throw new PdfAConformanceException(obj1, MessageLocalization.getComposedMessage((String)"launch.sound.movie.resetform.importdata.and.javascript.actions.are.not.allowed", (Object[])new Object[0]));
            }
            if (PdfName.NAMED.equals((Object)s) && (n = action.getAsName(PdfName.N)) != null && !allowedNamedActions.contains(n)) {
                throw new PdfAConformanceException(obj1, MessageLocalization.getComposedMessage((String)"named.action.type.1.not.allowed", (Object[])new Object[]{n.toString()}));
            }
        }
    }

    @Override
    protected void checkForm(PdfWriter writer, int key, Object obj1) {
        PdfAcroForm form;
        PdfBoolean needAppearances;
        if (obj1 instanceof PdfAcroForm && (needAppearances = (form = (PdfAcroForm)obj1).getAsBoolean(PdfName.NEEDAPPEARANCES)) != null && needAppearances.booleanValue()) {
            throw new PdfAConformanceException(obj1, MessageLocalization.getComposedMessage((String)"needappearances.flag.of.the.interactive.form.dictionary.shall.either.not.be.present.or.shall.be.false", (Object[])new Object[0]));
        }
    }

    @Override
    protected void checkStructElem(PdfWriter writer, int key, Object obj1) {
        PdfObject o;
        PdfStructureElement structElem;
        PdfName role;
        if (obj1 instanceof PdfStructureElement && (PdfName.FIGURE.equals((Object)(role = (structElem = (PdfStructureElement)obj1).getStructureType())) || PdfName.FORMULA.equals((Object)role) || PdfName.FORM.equals((Object)role)) && (!((o = structElem.get(PdfName.ALT)) instanceof PdfString) || o.toString().length() <= 0)) {
            throw new PdfAConformanceException(obj1, MessageLocalization.getComposedMessage((String)"alt.entry.should.specify.alternate.description.for.1.element", (Object[])new Object[]{role.toString()}));
        }
    }

    @Override
    protected void checkOutputIntent(PdfWriter writer, int key, Object obj1) {
        if (writer instanceof PdfAStamperImp && writer.getColorProfile() != null) {
            throw new PdfAConformanceException(obj1, MessageLocalization.getComposedMessage((String)"outputintent.shall.not.be.updated", (Object[])new Object[0]));
        }
    }

    @Override
    public void close(PdfWriter writer) {
        if ((this.rgbUsed || this.cmykUsed || this.grayUsed) && this.pdfaOutputIntentColorSpace == null) {
            throw new PdfAConformanceException(null, MessageLocalization.getComposedMessage((String)"if.device.rgb.cmyk.gray.used.in.file.that.file.shall.contain.pdfa.outputintent", (Object[])new Object[0]));
        }
        if ("RGB ".equals(this.pdfaOutputIntentColorSpace)) {
            if (this.cmykUsed) {
                throw new PdfAConformanceException(null, MessageLocalization.getComposedMessage((String)"devicecmyk.may.be.used.only.if.the.file.has.a.cmyk.pdfa.outputIntent", (Object[])new Object[0]));
            }
        } else if ("CMYK".equals(this.pdfaOutputIntentColorSpace)) {
            if (this.rgbUsed) {
                throw new PdfAConformanceException(null, MessageLocalization.getComposedMessage((String)"devicergb.may.be.used.only.if.the.file.has.a.rgb.pdfa.outputIntent", (Object[])new Object[0]));
            }
        } else {
            if (this.cmykUsed) {
                throw new PdfAConformanceException(null, MessageLocalization.getComposedMessage((String)"devicecmyk.may.be.used.only.if.the.file.has.a.cmyk.pdfa.outputIntent", (Object[])new Object[0]));
            }
            if (this.rgbUsed) {
                throw new PdfAConformanceException(null, MessageLocalization.getComposedMessage((String)"devicergb.may.be.used.only.if.the.file.has.a.rgb.pdfa.outputIntent", (Object[])new Object[0]));
            }
        }
    }
}

