/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text.zugferd.checkers;

import com.itextpdf.text.zugferd.checkers.CodeValidation;

public class NumberChecker
extends CodeValidation {
    public static final int INTEGER = 0;
    public static final int ANY_DECIMALS = 1;
    public static final int TWO_DECIMALS = 2;
    public static final int FOUR_DECIMALS = 4;
    protected int type;

    public NumberChecker(int type) {
        this.type = type;
    }

    public boolean isValid(String code) {
        if (this.type == 0) {
            return this.isNumeric(code, code.length());
        }
        if (code.endsWith(".")) {
            return false;
        }
        int pos = code.indexOf(".");
        if (pos < 1) {
            return false;
        }
        String part1 = code.substring(0, pos);
        if (!this.isNumeric(part1, part1.length())) {
            return false;
        }
        String part2 = code.substring(pos + 1);
        switch (this.type) {
            case 2: {
                return this.isNumeric(part2, 2);
            }
            case 4: {
                return this.isNumeric(part2, 4);
            }
        }
        return this.isNumeric(part2, part2.length());
    }
}

