/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text.pdf.mc;

import com.itextpdf.text.pdf.PdfDictionary;
import com.itextpdf.text.pdf.PdfIndirectReference;
import com.itextpdf.text.pdf.PdfName;
import com.itextpdf.text.pdf.PdfNumber;
import com.itextpdf.text.pdf.mc.StructureItem;

public class StructureMCID
extends StructureItem {
    protected int mcid = -1;

    public StructureMCID(PdfIndirectReference pg, PdfNumber mcid) {
        this.pageref = pg == null ? -1 : pg.getNumber();
        this.mcid = mcid.intValue();
    }

    public StructureMCID(PdfDictionary mcr) {
        this.mcid = mcr.getAsNumber(PdfName.MCID).intValue();
        this.pageref = mcr.getAsIndirectObject(PdfName.PG).getNumber();
    }

    public int checkMCID(int pg, int mcid) {
        if (this.pageref == -1) {
            throw new RuntimeException();
        }
        if (pg == this.pageref && this.mcid == mcid) {
            return 1;
        }
        return -1;
    }

    public String toString() {
        return "MCID " + this.mcid + " on page with reference " + this.pageref;
    }
}

