/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text.pdf.mc;

import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Rectangle;
import com.itextpdf.text.error_messages.MessageLocalization;
import com.itextpdf.text.io.RandomAccessSourceFactory;
import com.itextpdf.text.log.Level;
import com.itextpdf.text.log.Logger;
import com.itextpdf.text.log.LoggerFactory;
import com.itextpdf.text.pdf.ByteBuffer;
import com.itextpdf.text.pdf.PRStream;
import com.itextpdf.text.pdf.PRTokeniser;
import com.itextpdf.text.pdf.PdfArray;
import com.itextpdf.text.pdf.PdfContentParser;
import com.itextpdf.text.pdf.PdfDictionary;
import com.itextpdf.text.pdf.PdfIndirectReference;
import com.itextpdf.text.pdf.PdfLiteral;
import com.itextpdf.text.pdf.PdfName;
import com.itextpdf.text.pdf.PdfNumber;
import com.itextpdf.text.pdf.PdfObject;
import com.itextpdf.text.pdf.PdfReader;
import com.itextpdf.text.pdf.PdfStream;
import com.itextpdf.text.pdf.PdfString;
import com.itextpdf.text.pdf.RandomAccessFileOrArray;
import com.itextpdf.text.pdf.mc.StructureItem;
import com.itextpdf.text.pdf.mc.StructureItems;
import com.itextpdf.text.pdf.mc.StructureObject;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MCParser {
    protected static final Logger LOGGER = LoggerFactory.getLogger(MCParser.class);
    protected static final RandomAccessSourceFactory RASFACTORY = new RandomAccessSourceFactory();
    public static final String DEFAULTOPERATOR = "DefaultOperator";
    public static final PdfLiteral TSTAR = new PdfLiteral("T*");
    protected Map<String, PdfOperator> operators = null;
    protected StructureItems items;
    protected ByteArrayOutputStream baos;
    protected PdfDictionary page;
    protected PdfIndirectReference pageref;
    protected PdfArray annots;
    protected PdfNumber structParents;
    protected PdfDictionary xobjects;
    protected boolean btWrite = false;
    protected boolean etExtra = false;
    protected boolean inText = false;
    protected StringBuffer text;

    public MCParser(StructureItems items) {
        this.populateOperators();
        this.items = items;
    }

    protected void populateOperators() {
        if (this.operators != null) {
            return;
        }
        this.operators = new HashMap<String, PdfOperator>();
        this.operators.put(DEFAULTOPERATOR, new CopyContentOperator());
        BeginMarkedContentDictionaryOperator markedContent = new BeginMarkedContentDictionaryOperator();
        this.operators.put("BDC", markedContent);
        DoOperator doOperator = new DoOperator();
        this.operators.put("Do", doOperator);
        BeginTextOperator beginText = new BeginTextOperator();
        this.operators.put("BT", beginText);
        EndTextOperator endText = new EndTextOperator();
        this.operators.put("ET", endText);
        TextPositioningOperator textPos = new TextPositioningOperator();
        this.operators.put("Td", textPos);
        this.operators.put("TD", textPos);
        this.operators.put("Tm", textPos);
        this.operators.put("T*", textPos);
        TextStateOperator textState = new TextStateOperator();
        this.operators.put("Tc", textState);
        this.operators.put("Tw", textState);
        this.operators.put("Tz", textState);
        this.operators.put("TL", textState);
        this.operators.put("Tf", textState);
        this.operators.put("Tr", textState);
        this.operators.put("Ts", textState);
        TextNewLineOperator textNL = new TextNewLineOperator();
        this.operators.put("'", textNL);
        this.operators.put("\"", textNL);
    }

    public void parse(PdfDictionary page, PdfIndirectReference pageref) throws IOException, DocumentException {
        LOGGER.info("Parsing page with reference " + pageref);
        this.baos = new ByteArrayOutputStream();
        this.page = page;
        this.pageref = pageref;
        this.structParents = page.getAsNumber(PdfName.STRUCTPARENTS);
        if (this.structParents == null) {
            throw new DocumentException(MessageLocalization.getComposedMessage((String)"can.t.read.document.structure", (Object[])new Object[0]));
        }
        this.annots = page.getAsArray(PdfName.ANNOTS);
        if (this.annots == null) {
            this.annots = new PdfArray();
        }
        PdfDictionary resources = page.getAsDict(PdfName.RESOURCES);
        this.xobjects = resources.getAsDict(PdfName.XOBJECT);
        if (this.xobjects == null) {
            this.xobjects = new PdfDictionary();
            resources.put(PdfName.XOBJECT, (PdfObject)this.xobjects);
        }
        PRStream stream = (PRStream)page.getAsStream(PdfName.CONTENTS);
        byte[] contentBytes = PdfReader.getStreamBytes((PRStream)stream);
        PRTokeniser tokeniser = new PRTokeniser(new RandomAccessFileOrArray(RASFACTORY.createSource(contentBytes)));
        PdfContentParser ps = new PdfContentParser(tokeniser);
        ArrayList<PdfObject> operands = new ArrayList<PdfObject>();
        while (ps.parse(operands).size() > 0) {
            PdfLiteral operator = (PdfLiteral)operands.get(operands.size() - 1);
            this.processOperator(operator, operands);
        }
        while (this.items.size() > 0 && ((StructureItem)this.items.get(0)).getPageref() == pageref.getNumber()) {
            StructureItem item = (StructureItem)this.items.get(0);
            if (!(item instanceof StructureObject)) continue;
            this.convertToXObject((StructureObject)item);
            this.items.remove(0);
        }
        if (this.annots.size() == 0) {
            page.remove(PdfName.ANNOTS);
        } else {
            for (int i = 0; i < this.annots.size(); ++i) {
                PdfDictionary annot = this.annots.getAsDict(i);
                if (annot.getAsNumber(PdfName.STRUCTPARENT) != null) continue;
                throw new DocumentException(MessageLocalization.getComposedMessage((String)"could.not.flatten.file.untagged.annotations.found", (Object[])new Object[0]));
            }
        }
        this.baos.flush();
        this.baos.close();
        stream.setData(this.baos.toByteArray());
        if (LOGGER.isLogging(Level.INFO)) {
            LOGGER.info(String.format("There are %d items left for processing", this.items.size()));
        }
    }

    protected void dealWithXObj(PdfName xobj) {
        PdfStream dict = this.xobjects.getAsStream(xobj);
        PdfNumber structParent = dict.getAsNumber(PdfName.STRUCTPARENT);
        if (LOGGER.isLogging(Level.INFO)) {
            LOGGER.info(String.format("Encountered StructParent %s in content", structParent));
        }
        if (structParent == null) {
            return;
        }
        StructureItem item = (StructureItem)this.items.get(0);
        if (item.checkStructParent(this.pageref.getNumber(), structParent.intValue()) == 1) {
            this.items.remove(0);
        }
    }

    protected void dealWithMcid(PdfNumber mcid) throws IOException, DocumentException {
        if (mcid == null) {
            return;
        }
        StructureItem item = (StructureItem)this.items.get(0);
        if (LOGGER.isLogging(Level.INFO)) {
            LOGGER.info(String.format("Encountered MCID %s in content, comparing with %s", mcid, item));
        }
        switch (item.checkMCID(this.pageref.getNumber(), mcid.intValue())) {
            case 0: {
                StructureObject obj = (StructureObject)item;
                this.convertToXObject(obj);
                LOGGER.info("Removed structure item from stack.");
                this.items.remove(0);
                this.dealWithMcid(mcid);
                return;
            }
            case 1: {
                LOGGER.info("Removed structure item from stack.");
                this.items.remove(0);
                return;
            }
        }
        LOGGER.warn("MCID not found! There's probably an error in your form!");
        for (int i = 1; i < this.items.size(); ++i) {
            item = (StructureItem)this.items.get(i);
            int check = item.checkMCID(this.pageref.getNumber(), mcid.intValue());
            switch (check) {
                case 1: {
                    LOGGER.info("Removed structure item from stack.");
                    this.items.remove(i);
                    return;
                }
            }
        }
        throw new DocumentException(MessageLocalization.getComposedMessage((String)"can.t.read.document.structure", (Object[])new Object[0]));
    }

    protected void convertToXObject(StructureObject item) throws IOException, DocumentException {
        PdfDictionary structElem = item.getStructElem();
        if (structElem == null) {
            return;
        }
        PdfDictionary dict = item.getObjAsDict();
        if (dict == null || !dict.checkType(PdfName.ANNOT)) {
            return;
        }
        PdfDictionary ap = dict.getAsDict(PdfName.AP);
        if (ap == null) {
            return;
        }
        PdfNumber structParent = dict.getAsNumber(PdfName.STRUCTPARENT);
        if (structParent == null) {
            return;
        }
        PdfStream stream = ap.getAsStream(PdfName.N);
        if (stream == null) {
            return;
        }
        PdfIndirectReference xobjr = ap.getAsIndirectObject(PdfName.N);
        if (xobjr == null) {
            return;
        }
        for (int i = 0; i < this.annots.size(); ++i) {
            PdfIndirectReference annotref = this.annots.getAsIndirectObject(i);
            if (item.getObjRef().getNumber() != annotref.getNumber()) continue;
            this.annots.remove(i);
            break;
        }
        PdfDictionary attribute = new PdfDictionary();
        attribute.put(PdfName.O, (PdfObject)PdfName.PRINTFIELD);
        PdfString description = dict.getAsString(PdfName.TU);
        if (description == null) {
            description = dict.getAsString(PdfName.T);
        }
        if (PdfName.BTN.equals((Object)dict.get(PdfName.FT))) {
            PdfNumber fflags = dict.getAsNumber(PdfName.FF);
            if (fflags != null) {
                int ff = fflags.intValue();
                if ((ff & 0x10000) != 0) {
                    attribute.put(PdfName.ROLE, (PdfObject)PdfName.PB);
                }
                if ((ff & 0x8000) != 0) {
                    attribute.put(PdfName.ROLE, (PdfObject)PdfName.rb);
                } else {
                    attribute.put(PdfName.ROLE, (PdfObject)PdfName.CB);
                }
            }
        } else {
            attribute.put(PdfName.ROLE, (PdfObject)PdfName.TV);
        }
        attribute.put(PdfName.DESC, (PdfObject)description);
        PdfString t = structElem.getAsString(PdfName.T);
        if (t == null || t.toString().trim().length() == 0) {
            structElem.put(PdfName.T, (PdfObject)dict.getAsString(PdfName.T));
        }
        structElem.put(PdfName.A, (PdfObject)attribute);
        structElem.put(PdfName.S, (PdfObject)PdfName.P);
        structElem.put(PdfName.PG, (PdfObject)this.pageref);
        int mcid = this.items.processMCID(this.structParents, item.getRef());
        LOGGER.info("Using MCID " + mcid);
        structElem.put(PdfName.K, (PdfObject)new PdfNumber(mcid));
        this.items.removeFromParentTree(structParent);
        PdfName xobj = new PdfName("XObj" + structParent.intValue());
        LOGGER.info("Creating XObject with name " + xobj);
        this.xobjects.put(xobj, (PdfObject)xobjr);
        PdfArray array = dict.getAsArray(PdfName.RECT);
        Rectangle rect = new Rectangle(array.getAsNumber(0).floatValue(), array.getAsNumber(1).floatValue(), array.getAsNumber(2).floatValue(), array.getAsNumber(3).floatValue());
        rect.normalize();
        if (this.inText && !this.btWrite) {
            LOGGER.debug("Introducing extra ET");
            this.baos.write("ET\n".getBytes());
            this.etExtra = true;
        }
        ByteBuffer buf = new ByteBuffer();
        buf.append("/P <</MCID ");
        buf.append(mcid);
        buf.append(">> BDC\n");
        buf.append("q 1 0 0 1 ");
        buf.append(rect.getLeft());
        buf.append(" ");
        buf.append(rect.getBottom());
        buf.append(" cm ");
        buf.append(xobj.getBytes());
        buf.append(" Do Q\n");
        buf.append("EMC\n");
        buf.flush();
        buf.writeTo((OutputStream)this.baos);
        if (this.inText) {
            this.btWrite = true;
        }
    }

    protected void processOperator(PdfLiteral operator, List<PdfObject> operands) throws IOException, DocumentException {
        PdfOperator op = this.operators.get(operator.toString());
        if (op == null) {
            op = this.operators.get(DEFAULTOPERATOR);
        }
        op.process(this, operator, operands);
    }

    protected void printOperator(PdfLiteral operator, List<PdfObject> operands) throws IOException {
        operands.remove(operator);
        for (PdfObject o : operands) {
            this.printsp(o);
        }
        this.println((PdfObject)operator);
    }

    protected void printTextOperator(PdfLiteral operator, List<PdfObject> operands) throws IOException {
        for (PdfObject obj : operands) {
            this.text.append(obj).append(" ");
        }
        this.text.append("\n");
        this.printOperator(operator, operands);
    }

    protected void printsp(PdfObject o) throws IOException {
        this.checkBT();
        o.toPdf(null, (OutputStream)this.baos);
        this.baos.write(32);
    }

    protected void println(PdfObject o) throws IOException {
        this.checkBT();
        o.toPdf(null, (OutputStream)this.baos);
        this.baos.write(10);
    }

    protected void checkBT() throws IOException {
        if (this.btWrite) {
            this.baos.write("BT ".getBytes());
            if (this.etExtra) {
                this.baos.write(this.text.toString().getBytes());
                this.etExtra = false;
                this.text = new StringBuffer();
            }
            LOGGER.debug("BT written");
        }
        this.btWrite = false;
    }

    protected void setInText(boolean inText) {
        if (inText) {
            this.text = new StringBuffer();
            this.btWrite = true;
        } else {
            this.etExtra = false;
        }
        this.inText = inText;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TextNewLineOperator
    implements PdfOperator {
        private TextNewLineOperator() {
        }

        @Override
        public void process(MCParser parser, PdfLiteral operator, List<PdfObject> operands) throws IOException {
            ArrayList<PdfObject> list = new ArrayList<PdfObject>();
            list.add((PdfObject)TSTAR);
            parser.printTextOperator(TSTAR, list);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TextStateOperator
    implements PdfOperator {
        private TextStateOperator() {
        }

        @Override
        public void process(MCParser parser, PdfLiteral operator, List<PdfObject> operands) throws IOException {
            parser.printTextOperator(operator, operands);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TextPositioningOperator
    implements PdfOperator {
        private TextPositioningOperator() {
        }

        @Override
        public void process(MCParser parser, PdfLiteral operator, List<PdfObject> operands) throws IOException {
            parser.printTextOperator(operator, operands);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class EndTextOperator
    implements PdfOperator {
        private EndTextOperator() {
        }

        @Override
        public void process(MCParser parser, PdfLiteral operator, List<PdfObject> operands) throws IOException {
            LOGGER.debug("ET: end text block");
            parser.setInText(false);
            parser.printOperator(operator, operands);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class BeginTextOperator
    implements PdfOperator {
        private BeginTextOperator() {
        }

        @Override
        public void process(MCParser parser, PdfLiteral operator, List<PdfObject> operands) throws IOException {
            LOGGER.debug("BT: begin text on hold");
            parser.setInText(true);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DoOperator
    implements PdfOperator {
        private DoOperator() {
        }

        @Override
        public void process(MCParser parser, PdfLiteral operator, List<PdfObject> operands) throws IOException {
            if (operands.get(0).isName()) {
                parser.dealWithXObj((PdfName)operands.get(0));
            }
            parser.printOperator(operator, operands);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class BeginMarkedContentDictionaryOperator
    implements PdfOperator {
        private BeginMarkedContentDictionaryOperator() {
        }

        @Override
        public void process(MCParser parser, PdfLiteral operator, List<PdfObject> operands) throws IOException, DocumentException {
            if (operands.get(1).isDictionary()) {
                PdfDictionary dict = (PdfDictionary)operands.get(1);
                parser.dealWithMcid(dict.getAsNumber(PdfName.MCID));
            }
            parser.printOperator(operator, operands);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CopyContentOperator
    implements PdfOperator {
        private CopyContentOperator() {
        }

        @Override
        public void process(MCParser parser, PdfLiteral operator, List<PdfObject> operands) throws IOException {
            parser.printOperator(operator, operands);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface PdfOperator {
        public void process(MCParser var1, PdfLiteral var2, List<PdfObject> var3) throws DocumentException, IOException;
    }
}

