/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text.pdf.pdfcleanup;

import com.itextpdf.awt.geom.AffineTransform;
import com.itextpdf.awt.geom.NoninvertibleTransformException;
import com.itextpdf.awt.geom.Point;
import com.itextpdf.awt.geom.Point2D;
import com.itextpdf.text.Rectangle;
import com.itextpdf.text.pdf.parser.BezierCurve;
import com.itextpdf.text.pdf.parser.ImageRenderInfo;
import com.itextpdf.text.pdf.parser.Line;
import com.itextpdf.text.pdf.parser.LineDashPattern;
import com.itextpdf.text.pdf.parser.LineSegment;
import com.itextpdf.text.pdf.parser.Matrix;
import com.itextpdf.text.pdf.parser.Path;
import com.itextpdf.text.pdf.parser.RenderFilter;
import com.itextpdf.text.pdf.parser.Shape;
import com.itextpdf.text.pdf.parser.Subpath;
import com.itextpdf.text.pdf.parser.TextRenderInfo;
import com.itextpdf.text.pdf.parser.clipper.Clipper;
import com.itextpdf.text.pdf.parser.clipper.ClipperOffset;
import com.itextpdf.text.pdf.parser.clipper.DefaultClipper;
import com.itextpdf.text.pdf.parser.clipper.Paths;
import com.itextpdf.text.pdf.parser.clipper.Point;
import com.itextpdf.text.pdf.parser.clipper.PolyNode;
import com.itextpdf.text.pdf.parser.clipper.PolyTree;
import com.itextpdf.text.pdf.pdfcleanup.PdfCleanUpProcessor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PdfCleanUpRegionFilter
extends RenderFilter {
    private List<Rectangle> rectangles;
    private static final double circleApproximationConst = 0.55191502449;

    public PdfCleanUpRegionFilter(List<Rectangle> rectangles) {
        this.rectangles = rectangles;
    }

    public boolean allowText(TextRenderInfo renderInfo) {
        LineSegment ascent = renderInfo.getAscentLine();
        LineSegment descent = renderInfo.getDescentLine();
        Point2D[] glyphRect = new Point2D[]{new Point2D.Float(ascent.getStartPoint().get(0), ascent.getStartPoint().get(1)), new Point2D.Float(ascent.getEndPoint().get(0), ascent.getEndPoint().get(1)), new Point2D.Float(descent.getEndPoint().get(0), descent.getEndPoint().get(1)), new Point2D.Float(descent.getStartPoint().get(0), descent.getStartPoint().get(1))};
        for (Rectangle rectangle : this.rectangles) {
            Point2D[] redactRect = this.getVertices(rectangle);
            if (!this.intersect(glyphRect, redactRect)) continue;
            return false;
        }
        return true;
    }

    public boolean allowImage(ImageRenderInfo renderInfo) {
        throw new UnsupportedOperationException();
    }

    protected List<Rectangle> getCoveredAreas(ImageRenderInfo renderInfo) {
        Rectangle imageRect = this.calcImageRect(renderInfo);
        ArrayList<Rectangle> coveredAreas = new ArrayList<Rectangle>();
        if (imageRect == null) {
            return null;
        }
        for (Rectangle rectangle : this.rectangles) {
            Rectangle intersectionRect = this.intersection(imageRect, rectangle);
            if (intersectionRect == null) continue;
            if (imageRect.equals((Object)intersectionRect)) {
                return null;
            }
            coveredAreas.add(this.transformIntersection(renderInfo.getImageCTM(), intersectionRect));
        }
        return coveredAreas;
    }

    protected Path filterStrokePath(Path sourcePath, Matrix ctm, float lineWidth, int lineCapStyle, int lineJoinStyle, float miterLimit, LineDashPattern lineDashPattern) {
        Path path = sourcePath;
        Clipper.JoinType joinType = PdfCleanUpRegionFilter.getJoinType(lineJoinStyle);
        Clipper.EndType endType = PdfCleanUpRegionFilter.getEndType(lineCapStyle);
        if (lineDashPattern != null && !lineDashPattern.isSolid()) {
            path = PdfCleanUpRegionFilter.applyDashPattern(path, lineDashPattern);
        }
        ClipperOffset offset = new ClipperOffset((double)miterLimit, PdfCleanUpProcessor.arcTolerance * PdfCleanUpProcessor.floatMultiplier);
        List<Subpath> degenerateSubpaths = PdfCleanUpRegionFilter.addPath(offset, path, joinType, endType);
        PolyTree resultTree = new PolyTree();
        offset.execute(resultTree, (double)lineWidth * PdfCleanUpProcessor.floatMultiplier / 2.0);
        Path offsetedPath = PdfCleanUpRegionFilter.convertToPath(resultTree);
        if (degenerateSubpaths.size() > 0) {
            if (endType == Clipper.EndType.OPEN_ROUND) {
                List<Subpath> circles = PdfCleanUpRegionFilter.convertToCircles(degenerateSubpaths, lineWidth / 2.0f);
                offsetedPath.addSubpaths(circles);
            } else if (endType == Clipper.EndType.OPEN_SQUARE && lineDashPattern != null) {
                List<Subpath> squares = PdfCleanUpRegionFilter.convertToSquares(degenerateSubpaths, lineWidth, sourcePath);
                offsetedPath.addSubpaths(squares);
            }
        }
        return this.filterFillPath(offsetedPath, ctm, 1);
    }

    protected Path filterFillPath(Path path, Matrix ctm, int fillingRule) {
        path.closeAllSubpaths();
        DefaultClipper clipper = new DefaultClipper();
        PdfCleanUpRegionFilter.addPath((Clipper)clipper, path);
        for (Rectangle rectangle : this.rectangles) {
            Point2D[] transfRectVertices = this.transformPoints(ctm, true, this.getVertices(rectangle));
            PdfCleanUpRegionFilter.addRect((Clipper)clipper, transfRectVertices, Clipper.PolyType.CLIP);
        }
        Clipper.PolyFillType fillType = Clipper.PolyFillType.NON_ZERO;
        if (fillingRule == 2) {
            fillType = Clipper.PolyFillType.EVEN_ODD;
        }
        PolyTree resultTree = new PolyTree();
        clipper.execute(Clipper.ClipType.DIFFERENCE, resultTree, fillType, Clipper.PolyFillType.NON_ZERO);
        return PdfCleanUpRegionFilter.convertToPath(resultTree);
    }

    private static Clipper.JoinType getJoinType(int lineJoinStyle) {
        switch (lineJoinStyle) {
            case 2: {
                return Clipper.JoinType.BEVEL;
            }
            case 0: {
                return Clipper.JoinType.MITER;
            }
        }
        return Clipper.JoinType.ROUND;
    }

    private static Clipper.EndType getEndType(int lineCapStyle) {
        switch (lineCapStyle) {
            case 0: {
                return Clipper.EndType.OPEN_BUTT;
            }
            case 2: {
                return Clipper.EndType.OPEN_SQUARE;
            }
        }
        return Clipper.EndType.OPEN_ROUND;
    }

    private static List<Subpath> convertToCircles(List<Subpath> degenerateSubpaths, double radius) {
        ArrayList<Subpath> circles = new ArrayList<Subpath>(degenerateSubpaths.size());
        for (Subpath subpath : degenerateSubpaths) {
            BezierCurve[] circleSectors = PdfCleanUpRegionFilter.approximateCircle(subpath.getStartPoint(), radius);
            Subpath circle = new Subpath();
            circle.addSegment((Shape)circleSectors[0]);
            circle.addSegment((Shape)circleSectors[1]);
            circle.addSegment((Shape)circleSectors[2]);
            circle.addSegment((Shape)circleSectors[3]);
            circles.add(circle);
        }
        return circles;
    }

    private static List<Subpath> convertToSquares(List<Subpath> degenerateSubpaths, double squareWidth, Path sourcePath) {
        List<Point2D> pathApprox = PdfCleanUpRegionFilter.getPathApproximation(sourcePath);
        if (pathApprox.size() < 2) {
            return Collections.EMPTY_LIST;
        }
        Iterator<Point2D> approxIter = pathApprox.iterator();
        Point2D approxPt1 = approxIter.next();
        Point2D approxPt2 = approxIter.next();
        StandardLine line = new StandardLine(approxPt1, approxPt2);
        ArrayList<Subpath> squares = new ArrayList<Subpath>(degenerateSubpaths.size());
        float widthHalf = (float)squareWidth / 2.0f;
        for (int i = 0; i < degenerateSubpaths.size(); ++i) {
            Point2D point = degenerateSubpaths.get(i).getStartPoint();
            while (!line.contains(point)) {
                approxPt1 = approxPt2;
                approxPt2 = approxIter.next();
                line = new StandardLine(approxPt1, approxPt2);
            }
            double slope = line.getSlope();
            double angle = slope != Double.POSITIVE_INFINITY ? Math.atan(slope) : 1.5707963267948966;
            squares.add(PdfCleanUpRegionFilter.constructSquare(point, widthHalf, angle));
        }
        return squares;
    }

    private static List<Point2D> getPathApproximation(Path path) {
        ArrayList<Point2D> approx = new ArrayList<Point2D>(){

            @Override
            public boolean addAll(Collection<? extends Point2D> c) {
                Point2D prevPoint = this.size() - 1 < 0 ? null : (Point2D)this.get(this.size() - 1);
                boolean ret = false;
                for (Point2D point2D : c) {
                    if (point2D.equals((Object)prevPoint)) continue;
                    this.add(point2D);
                    prevPoint = point2D;
                    ret = true;
                }
                return true;
            }
        };
        for (Subpath subpath : path.getSubpaths()) {
            approx.addAll(subpath.getPiecewiseLinearApproximation());
        }
        return approx;
    }

    private static Subpath constructSquare(Point2D squareCenter, double widthHalf, double rotationAngle) {
        Point2D[] ortogonalSquareVertices = new Point2D[]{new Point2D.Double(-widthHalf, -widthHalf), new Point2D.Double(-widthHalf, widthHalf), new Point2D.Double(widthHalf, widthHalf), new Point2D.Double(widthHalf, -widthHalf)};
        Point2D[] rotatedSquareVertices = PdfCleanUpRegionFilter.getRotatedSquareVertices(ortogonalSquareVertices, rotationAngle, squareCenter);
        Subpath square = new Subpath();
        square.addSegment((Shape)new Line(rotatedSquareVertices[0], rotatedSquareVertices[1]));
        square.addSegment((Shape)new Line(rotatedSquareVertices[1], rotatedSquareVertices[2]));
        square.addSegment((Shape)new Line(rotatedSquareVertices[2], rotatedSquareVertices[3]));
        square.addSegment((Shape)new Line(rotatedSquareVertices[3], rotatedSquareVertices[0]));
        return square;
    }

    private static Point2D[] getRotatedSquareVertices(Point2D[] orthogonalSquareVertices, double angle, Point2D squareCenter) {
        Point2D[] rotatedSquareVertices = new Point2D[orthogonalSquareVertices.length];
        AffineTransform.getRotateInstance((double)angle).transform(orthogonalSquareVertices, 0, rotatedSquareVertices, 0, rotatedSquareVertices.length);
        AffineTransform.getTranslateInstance((double)squareCenter.getX(), (double)squareCenter.getY()).transform(rotatedSquareVertices, 0, rotatedSquareVertices, 0, orthogonalSquareVertices.length);
        return rotatedSquareVertices;
    }

    private static List<Subpath> addPath(ClipperOffset offset, Path path, Clipper.JoinType joinType, Clipper.EndType endType) {
        ArrayList<Subpath> degenerateSubpaths = new ArrayList<Subpath>();
        for (Subpath subpath : path.getSubpaths()) {
            if (subpath.isDegenerate()) {
                degenerateSubpaths.add(subpath);
                continue;
            }
            if (subpath.isSinglePointClosed() || subpath.isSinglePointOpen()) continue;
            Clipper.EndType et = subpath.isClosed() ? Clipper.EndType.CLOSED_LINE : endType;
            List linearApproxPoints = subpath.getPiecewiseLinearApproximation();
            offset.addPath(PdfCleanUpRegionFilter.convertToIntPoints(linearApproxPoints), joinType, et);
        }
        return degenerateSubpaths;
    }

    private static BezierCurve[] approximateCircle(Point2D center, double radius) {
        BezierCurve[] approximation = new BezierCurve[4];
        double x = center.getX();
        double y = center.getY();
        approximation[0] = new BezierCurve(Arrays.asList(new Point2D.Double(x, y + radius), new Point2D.Double(x + radius * 0.55191502449, y + radius), new Point2D.Double(x + radius, y + radius * 0.55191502449), new Point2D.Double(x + radius, y)));
        approximation[1] = new BezierCurve(Arrays.asList(new Point2D.Double(x + radius, y), new Point2D.Double(x + radius, y - radius * 0.55191502449), new Point2D.Double(x + radius * 0.55191502449, y - radius), new Point2D.Double(x, y - radius)));
        approximation[2] = new BezierCurve(Arrays.asList(new Point2D.Double(x, y - radius), new Point2D.Double(x - radius * 0.55191502449, y - radius), new Point2D.Double(x - radius, y - radius * 0.55191502449), new Point2D.Double(x - radius, y)));
        approximation[3] = new BezierCurve(Arrays.asList(new Point2D.Double(x - radius, y), new Point2D.Double(x - radius, y + radius * 0.55191502449), new Point2D.Double(x - radius * 0.55191502449, y + radius), new Point2D.Double(x, y + radius)));
        return approximation;
    }

    private static void addPath(Clipper clipper, Path path) {
        for (Subpath subpath : path.getSubpaths()) {
            if (subpath.isSinglePointClosed() || subpath.isSinglePointOpen()) continue;
            List linearApproxPoints = subpath.getPiecewiseLinearApproximation();
            clipper.addPath(PdfCleanUpRegionFilter.convertToIntPoints(linearApproxPoints), Clipper.PolyType.SUBJECT, subpath.isClosed());
        }
    }

    private static void addRect(Clipper clipper, Point2D[] rectVertices, Clipper.PolyType polyType) {
        clipper.addPath(PdfCleanUpRegionFilter.convertToIntPoints(new ArrayList<Point2D>(Arrays.asList(rectVertices))), polyType, true);
    }

    private static com.itextpdf.text.pdf.parser.clipper.Path convertToIntPoints(List<Point2D> points) {
        ArrayList<Point.LongPoint> convertedPoints = new ArrayList<Point.LongPoint>(points.size());
        for (Point2D point : points) {
            convertedPoints.add(new Point.LongPoint(PdfCleanUpProcessor.floatMultiplier * point.getX(), PdfCleanUpProcessor.floatMultiplier * point.getY()));
        }
        return new com.itextpdf.text.pdf.parser.clipper.Path(convertedPoints);
    }

    private static List<Point2D> convertToFloatPoints(List<Point.LongPoint> points) {
        ArrayList<Point2D> convertedPoints = new ArrayList<Point2D>(points.size());
        for (Point.LongPoint point : points) {
            convertedPoints.add((Point2D)new Point2D.Float((float)((double)point.getX() / PdfCleanUpProcessor.floatMultiplier), (float)((double)point.getY() / PdfCleanUpProcessor.floatMultiplier)));
        }
        return convertedPoints;
    }

    private static Path convertToPath(PolyTree result) {
        Path path = new Path();
        for (PolyNode node = result.getFirst(); node != null; node = node.getNext()) {
            PdfCleanUpRegionFilter.addContour(path, node.getContour(), !node.isOpen());
        }
        return path;
    }

    private static void addContour(Path path, List<Point.LongPoint> contour, Boolean close) {
        List<Point2D> floatContour = PdfCleanUpRegionFilter.convertToFloatPoints(contour);
        Iterator<Point2D> iter = floatContour.iterator();
        Point2D point = iter.next();
        path.moveTo((float)point.getX(), (float)point.getY());
        while (iter.hasNext()) {
            point = iter.next();
            path.lineTo((float)point.getX(), (float)point.getY());
        }
        if (close.booleanValue()) {
            path.closeSubpath();
        }
    }

    private Point2D[] getVertices(Rectangle rect) {
        Point2D[] points = new Point2D[]{new Point2D.Double((double)rect.getLeft(), (double)rect.getBottom()), new Point2D.Double((double)rect.getRight(), (double)rect.getBottom()), new Point2D.Double((double)rect.getRight(), (double)rect.getTop()), new Point2D.Double((double)rect.getLeft(), (double)rect.getTop())};
        return points;
    }

    private boolean intersect(Point2D[] rect1, Point2D[] rect2) {
        DefaultClipper clipper = new DefaultClipper();
        PdfCleanUpRegionFilter.addRect((Clipper)clipper, rect1, Clipper.PolyType.SUBJECT);
        PdfCleanUpRegionFilter.addRect((Clipper)clipper, rect2, Clipper.PolyType.CLIP);
        Paths paths = new Paths();
        clipper.execute(Clipper.ClipType.INTERSECTION, paths, Clipper.PolyFillType.NON_ZERO, Clipper.PolyFillType.NON_ZERO);
        return !paths.isEmpty();
    }

    private Rectangle calcImageRect(ImageRenderInfo renderInfo) {
        Matrix ctm = renderInfo.getImageCTM();
        if (ctm == null) {
            return null;
        }
        Point2D[] points = this.transformPoints(ctm, false, new Point2D[]{new Point(0, 0), new Point(0, 1), new Point(1, 0), new Point(1, 1)});
        return this.getRectangle(points[0], points[1], points[2], points[3]);
    }

    private Rectangle intersection(Rectangle rect1, Rectangle rect2) {
        com.itextpdf.awt.geom.Rectangle awtRect1 = new com.itextpdf.awt.geom.Rectangle(rect1);
        com.itextpdf.awt.geom.Rectangle awtRect2 = new com.itextpdf.awt.geom.Rectangle(rect2);
        com.itextpdf.awt.geom.Rectangle awtIntersection = awtRect1.intersection(awtRect2);
        return awtIntersection.isEmpty() ? null : new Rectangle(awtIntersection);
    }

    private Rectangle transformIntersection(Matrix imageCTM, Rectangle rect) {
        Point2D[] points = this.transformPoints(imageCTM, true, new Point2D[]{new Point((double)rect.getLeft(), (double)rect.getBottom()), new Point((double)rect.getLeft(), (double)rect.getTop()), new Point((double)rect.getRight(), (double)rect.getBottom()), new Point((double)rect.getRight(), (double)rect.getTop())});
        return this.getRectangle(points[0], points[1], points[2], points[3]);
    }

    private Rectangle getRectangle(Point2D p1, Point2D p2, Point2D p3, Point2D p4) {
        List<Double> xs = Arrays.asList(p1.getX(), p2.getX(), p3.getX(), p4.getX());
        List<Double> ys = Arrays.asList(p1.getY(), p2.getY(), p3.getY(), p4.getY());
        double left = Collections.min(xs);
        double bottom = Collections.min(ys);
        double right = Collections.max(xs);
        double top = Collections.max(ys);
        return new Rectangle((float)left, (float)bottom, (float)right, (float)top);
    }

    private static Path applyDashPattern(Path path, LineDashPattern lineDashPattern) {
        HashSet modifiedSubpaths = new HashSet(path.replaceCloseWithLine());
        Path dashedPath = new Path();
        int currentSubpath = 0;
        for (Subpath subpath : path.getSubpaths()) {
            List subpathApprox = subpath.getPiecewiseLinearApproximation();
            if (subpathApprox.size() > 1) {
                Point2D nextPoint;
                dashedPath.moveTo((float)((Point2D)subpathApprox.get(0)).getX(), (float)((Point2D)subpathApprox.get(0)).getY());
                float remainingDist = 0.0f;
                boolean remainingIsGap = false;
                for (int i = 1; i < subpathApprox.size(); ++i) {
                    nextPoint = null;
                    if (remainingDist != 0.0f) {
                        nextPoint = PdfCleanUpRegionFilter.getNextPoint((Point2D)subpathApprox.get(i - 1), (Point2D)subpathApprox.get(i), remainingDist);
                        remainingDist = PdfCleanUpRegionFilter.applyDash(dashedPath, (Point2D)subpathApprox.get(i - 1), (Point2D)subpathApprox.get(i), nextPoint, remainingIsGap);
                    }
                    while (Float.compare(remainingDist, 0.0f) == 0 && !dashedPath.getCurrentPoint().equals(subpathApprox.get(i))) {
                        LineDashPattern.DashArrayElem currentElem = lineDashPattern.next();
                        nextPoint = PdfCleanUpRegionFilter.getNextPoint(nextPoint != null ? nextPoint : (Point2D)subpathApprox.get(i - 1), (Point2D)subpathApprox.get(i), currentElem.getVal());
                        remainingDist = PdfCleanUpRegionFilter.applyDash(dashedPath, (Point2D)subpathApprox.get(i - 1), (Point2D)subpathApprox.get(i), nextPoint, currentElem.isGap());
                        remainingIsGap = currentElem.isGap();
                    }
                }
                if (modifiedSubpaths.contains(currentSubpath)) {
                    lineDashPattern.reset();
                    LineDashPattern.DashArrayElem currentElem = lineDashPattern.next();
                    nextPoint = PdfCleanUpRegionFilter.getNextPoint((Point2D)subpathApprox.get(0), (Point2D)subpathApprox.get(1), currentElem.getVal());
                    PdfCleanUpRegionFilter.applyDash(dashedPath, (Point2D)subpathApprox.get(0), (Point2D)subpathApprox.get(1), nextPoint, currentElem.isGap());
                }
            }
            lineDashPattern.reset();
            ++currentSubpath;
        }
        return dashedPath;
    }

    private static Point2D getNextPoint(Point2D segStart, Point2D segEnd, float dist) {
        Point2D vector = PdfCleanUpRegionFilter.componentwiseDiff(segEnd, segStart);
        Point2D unitVector = PdfCleanUpRegionFilter.getUnitVector(vector);
        return new Point2D.Float((float)(segStart.getX() + (double)dist * unitVector.getX()), (float)(segStart.getY() + (double)dist * unitVector.getY()));
    }

    private static Point2D componentwiseDiff(Point2D minuend, Point2D subtrahend) {
        return new Point2D.Float((float)(minuend.getX() - subtrahend.getX()), (float)(minuend.getY() - subtrahend.getY()));
    }

    private static Point2D getUnitVector(Point2D vector) {
        double vectorLength = PdfCleanUpRegionFilter.getVectorEuclideanNorm(vector);
        return new Point2D.Float((float)(vector.getX() / vectorLength), (float)(vector.getY() / vectorLength));
    }

    private static double getVectorEuclideanNorm(Point2D vector) {
        return vector.distance(0.0, 0.0);
    }

    private static float applyDash(Path dashedPath, Point2D segStart, Point2D segEnd, Point2D dashTo, boolean isGap) {
        float remainingDist = 0.0f;
        if (!PdfCleanUpRegionFilter.liesOnSegment(segStart, segEnd, dashTo)) {
            remainingDist = (float)dashTo.distance(segEnd);
            dashTo = segEnd;
        }
        if (isGap) {
            dashedPath.moveTo((float)dashTo.getX(), (float)dashTo.getY());
        } else {
            dashedPath.lineTo((float)dashTo.getX(), (float)dashTo.getY());
        }
        return remainingDist;
    }

    private static boolean liesOnSegment(Point2D segStart, Point2D segEnd, Point2D point) {
        return point.getX() >= Math.min(segStart.getX(), segEnd.getX()) && point.getX() <= Math.max(segStart.getX(), segEnd.getX()) && point.getY() >= Math.min(segStart.getY(), segEnd.getY()) && point.getY() <= Math.max(segStart.getY(), segEnd.getY());
    }

    private Point2D[] transformPoints(Matrix transormationMatrix, boolean inverse, Point2D ... points) {
        AffineTransform t = new AffineTransform(transormationMatrix.get(0), transormationMatrix.get(1), transormationMatrix.get(3), transormationMatrix.get(4), transormationMatrix.get(6), transormationMatrix.get(7));
        Point2D[] transformed = new Point2D[points.length];
        if (inverse) {
            try {
                t = t.createInverse();
            }
            catch (NoninvertibleTransformException e) {
                throw new RuntimeException(e);
            }
        }
        t.transform(points, 0, transformed, 0, points.length);
        return transformed;
    }

    private static class StandardLine {
        float A;
        float B;
        float C;

        StandardLine(Point2D p1, Point2D p2) {
            this.A = (float)(p2.getY() - p1.getY());
            this.B = (float)(p1.getX() - p2.getX());
            this.C = (float)(p1.getY() * (double)(-this.B) - p1.getX() * (double)this.A);
        }

        float getSlope() {
            if (this.B == 0.0f) {
                return Float.POSITIVE_INFINITY;
            }
            return -this.A / this.B;
        }

        boolean contains(Point2D point) {
            return Float.compare(Math.abs(this.A * (float)point.getX() + this.B * (float)point.getY() + this.C), 0.1f) < 0;
        }
    }
}

