/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text.pdf.pdfcleanup;

import com.itextpdf.text.DocWriter;
import com.itextpdf.text.pdf.PRStream;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfDictionary;
import com.itextpdf.text.pdf.PdfLiteral;
import com.itextpdf.text.pdf.PdfName;
import com.itextpdf.text.pdf.PdfNumber;
import com.itextpdf.text.pdf.PdfObject;
import com.itextpdf.text.pdf.PdfStream;
import com.itextpdf.text.pdf.PdfWriter;
import com.itextpdf.text.pdf.parser.ContentOperator;
import com.itextpdf.text.pdf.parser.PdfContentStreamProcessor;
import com.itextpdf.text.pdf.pdfcleanup.PdfCleanUpContentChunk;
import com.itextpdf.text.pdf.pdfcleanup.PdfCleanUpRenderListener;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PdfCleanUpContentOperator
implements ContentOperator {
    private static final byte[] TStar = DocWriter.getISOBytes((String)"T*\n");
    private static final byte[] Tw = DocWriter.getISOBytes((String)" Tw ");
    private static final byte[] TcTStar = DocWriter.getISOBytes((String)" Tc T*\n");
    private static final byte[] TJ = DocWriter.getISOBytes((String)"] TJ\n");
    private static final byte[] Tc = DocWriter.getISOBytes((String)" Tc\n");
    private static final Set<String> textShowingOperators = new HashSet<String>(){
        {
            this.add("TJ");
            this.add("Tj");
            this.add("'");
            this.add("\"");
        }
    };
    protected PdfCleanUpRenderListener cleanUpStrategy;
    protected ContentOperator originalContentOperator;

    public static void populateOperators(PdfContentStreamProcessor contentProcessor, PdfCleanUpRenderListener pdfCleanUpRenderListener) {
        String[] operators;
        for (String operator : operators = new String[]{"DefaultOperator", "q", "Q", "g", "G", "rg", "RG", "k", "K", "cs", "CS", "sc", "SC", "scn", "SCN", "cm", "gs", "Tc", "Tw", "Tz", "TL", "Tf", "Tr", "Ts", "BT", "ET", "BMC", "BDC", "EMC", "Td", "TD", "Tm", "T*", "Tj", "'", "\"", "TJ", "Do"}) {
            PdfCleanUpContentOperator contentOperator = new PdfCleanUpContentOperator(pdfCleanUpRenderListener);
            contentOperator.originalContentOperator = contentProcessor.registerContentOperator(operator, (ContentOperator)contentOperator);
        }
    }

    public PdfCleanUpContentOperator(PdfCleanUpRenderListener cleanUpStrategy) {
        this.cleanUpStrategy = cleanUpStrategy;
    }

    public void invoke(PdfContentStreamProcessor pdfContentStreamProcessor, PdfLiteral operator, ArrayList<PdfObject> operands) throws Exception {
        PdfStream xObj;
        PdfDictionary xObjResources;
        PdfContentByte canvas = this.cleanUpStrategy.getContext().getCanvas();
        PRStream xFormStream = null;
        if ("Do".equals(operator.toString()) && operands.size() == 2 && operands.get(0).isName() && (xObjResources = this.cleanUpStrategy.getContext().getResources().getAsDict(PdfName.XOBJECT)) != null && (xObj = xObjResources.getAsStream((PdfName)operands.get(0))) instanceof PRStream && xObj.getAsName(PdfName.SUBTYPE) != null && xObj.getAsName(PdfName.SUBTYPE).compareTo(PdfName.FORM) == 0) {
            xFormStream = (PRStream)xObj;
            this.cleanUpStrategy.registerNewContext(xObj.getAsDict(PdfName.RESOURCES), null);
        }
        this.originalContentOperator.invoke(pdfContentStreamProcessor, operator, operands);
        List<PdfCleanUpContentChunk> chunks = this.cleanUpStrategy.getChunks();
        boolean disableOutput = false;
        if (xFormStream != null) {
            xFormStream.setData(this.cleanUpStrategy.getContext().getCanvas().toPdf(this.cleanUpStrategy.getContext().getCanvas().getPdfWriter()));
            this.cleanUpStrategy.popContext();
            canvas = this.cleanUpStrategy.getContext().getCanvas();
        }
        if ("Do".equals(operator.toString())) {
            if (chunks.size() > 0 && chunks.get(0).isImage() && !chunks.get(0).isVisible()) {
                disableOutput = true;
            }
        } else if ("Tc".equals(operator.toString())) {
            this.cleanUpStrategy.getContext().setCharSpacing((PdfNumber)operands.get(0));
        } else if ("\"".equals(operator.toString())) {
            this.cleanUpStrategy.getContext().setCharSpacing((PdfNumber)operands.get(1));
        } else if (textShowingOperators.contains(operator.toString()) && !this.allChunksAreVisible(this.cleanUpStrategy.getChunks())) {
            disableOutput = true;
            if (operator.toString().equals("'")) {
                canvas.getInternalBuffer().append(TStar);
            } else if ("\"".equals(operator.toString())) {
                operands.get(0).toPdf(canvas.getPdfWriter(), (OutputStream)canvas.getInternalBuffer());
                canvas.getInternalBuffer().append(Tw);
                operands.get(1).toPdf(canvas.getPdfWriter(), (OutputStream)canvas.getInternalBuffer());
                canvas.getInternalBuffer().append(TcTStar);
                this.cleanUpStrategy.getContext().setCharSpacing((PdfNumber)operands.get(1));
            }
            canvas.setCharacterSpacing(0.0f);
            canvas.getInternalBuffer().append((byte)91);
            PdfCleanUpContentChunk prevChunk = null;
            for (PdfCleanUpContentChunk chunk : chunks) {
                if (prevChunk != null) {
                    canvas.getInternalBuffer().append(-(chunk.getStartX() - prevChunk.getEndX()) * 1000.0f / chunk.getSize()).append(' ');
                }
                if (chunk.isVisible()) {
                    chunk.getString().toPdf(canvas.getPdfWriter(), (OutputStream)canvas.getInternalBuffer());
                    canvas.getInternalBuffer().append(' ');
                } else {
                    float length = chunk.getEndX() - chunk.getStartX();
                    canvas.getInternalBuffer().append(-length * 1000.0f / chunk.getSize()).append(' ');
                }
                prevChunk = chunk;
            }
            canvas.getInternalBuffer().append(TJ);
            this.cleanUpStrategy.getContext().getCharSpacing().toPdf(canvas.getPdfWriter(), (OutputStream)canvas.getInternalBuffer());
            canvas.getInternalBuffer().append(Tc);
        }
        if (!disableOutput) {
            int index = 0;
            for (PdfObject o : operands) {
                PdfCleanUpContentOperator.toPdf(o, canvas.getPdfWriter(), (OutputStream)canvas.getInternalBuffer());
                canvas.getInternalBuffer().append(operands.size() > ++index ? (byte)32 : 10);
            }
        }
        chunks.clear();
    }

    private boolean allChunksAreVisible(List<PdfCleanUpContentChunk> chunks) {
        for (PdfCleanUpContentChunk chunk : chunks) {
            if (chunk.isVisible()) continue;
            return false;
        }
        return true;
    }

    private static void toPdf(PdfObject object, PdfWriter writer, OutputStream os) throws IOException {
        if (object instanceof PdfDictionary) {
            os.write(60);
            os.write(60);
            ArrayList keys = new ArrayList(((PdfDictionary)object).getKeys());
            Collections.sort(keys);
            for (PdfName key : keys) {
                PdfCleanUpContentOperator.toPdf((PdfObject)key, writer, os);
                PdfObject value = ((PdfDictionary)object).get(key);
                int type = value.type();
                if (type != 5 && type != 6 && type != 4 && type != 3) {
                    os.write(32);
                }
                PdfCleanUpContentOperator.toPdf(value, writer, os);
            }
            os.write(62);
            os.write(62);
        } else {
            object.toPdf(writer, os);
        }
    }
}

