/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text.pdf.pdfcleanup;

import com.itextpdf.text.Image;
import com.itextpdf.text.pdf.PdfBoolean;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfDictionary;
import com.itextpdf.text.pdf.PdfName;
import com.itextpdf.text.pdf.PdfNumber;
import com.itextpdf.text.pdf.PdfObject;
import com.itextpdf.text.pdf.PdfStamper;
import com.itextpdf.text.pdf.parser.ImageRenderInfo;
import com.itextpdf.text.pdf.parser.LineSegment;
import com.itextpdf.text.pdf.parser.PdfImageObject;
import com.itextpdf.text.pdf.parser.RenderListener;
import com.itextpdf.text.pdf.parser.TextRenderInfo;
import com.itextpdf.text.pdf.pdfcleanup.PdfCleanUpContentChunk;
import com.itextpdf.text.pdf.pdfcleanup.PdfCleanUpRegionFilter;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PdfCleanUpRenderListener
implements RenderListener {
    private List<PdfCleanUpRegionFilter> filters;
    protected List<PdfCleanUpContentChunk> chunks = new ArrayList<PdfCleanUpContentChunk>();
    private PdfStamper pdfStamper;
    private Stack<PdfCleanUpContext> contextStack = new Stack();

    public PdfCleanUpRenderListener(PdfStamper pdfStamper, List<PdfCleanUpRegionFilter> filters) {
        this.pdfStamper = pdfStamper;
        this.filters = filters;
    }

    public void renderText(TextRenderInfo renderInfo) {
        for (TextRenderInfo ri : renderInfo.getCharacterRenderInfos()) {
            boolean chunkIsInsideRegion = this.chunkIsInsideRegion(ri);
            LineSegment baseline = ri.getBaseline();
            LineSegment ascent = ri.getAscentLine();
            LineSegment descent = ri.getDescentLine();
            float y1 = descent.getStartPoint().get(1);
            float y2 = ascent.getStartPoint().get(1);
            this.chunks.add(new PdfCleanUpContentChunk(ri.getPdfString(), baseline.getStartPoint(), baseline.getEndPoint(), Math.abs(y2 - y1), !chunkIsInsideRegion));
        }
    }

    public void renderImage(ImageRenderInfo renderInfo) {
        boolean chunkIsInsideRegion = this.chunkIsInsideRegion(renderInfo);
        if (chunkIsInsideRegion) {
            this.chunks.add(new PdfCleanUpContentChunk(false));
        } else {
            try {
                PdfImageObject pdfImage = renderInfo.getImage();
                if (renderInfo.getRef() == null && pdfImage != null && pdfImage.getDictionary() != null) {
                    Image image = Image.getInstance((byte[])pdfImage.getImageAsBytes());
                    PdfDictionary dict = pdfImage.getDictionary();
                    PdfObject imageMask = dict.get(PdfName.IMAGEMASK);
                    if (imageMask == null) {
                        imageMask = dict.get(PdfName.IM);
                    }
                    if (imageMask != null && imageMask.equals(PdfBoolean.PDFTRUE)) {
                        image.makeMask();
                    }
                    PdfContentByte canvas = this.getContext().getCanvas();
                    canvas.addImage(image, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, true);
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void beginTextBlock() {
    }

    public void endTextBlock() {
    }

    public List<PdfCleanUpContentChunk> getChunks() {
        return this.chunks;
    }

    public PdfCleanUpContext getContext() {
        return this.contextStack.peek();
    }

    public void registerNewContext(PdfDictionary resources, PdfContentByte canvas) {
        canvas = canvas == null ? new PdfContentByte(this.pdfStamper.getWriter()) : canvas;
        this.contextStack.push(new PdfCleanUpContext(resources, canvas));
    }

    public void popContext() {
        this.contextStack.pop();
    }

    private boolean chunkIsInsideRegion(Object renderInfo) {
        boolean chunkIsInsideRegion = false;
        for (PdfCleanUpRegionFilter filter : this.filters) {
            if (!filter.allowObject(renderInfo)) continue;
            chunkIsInsideRegion = true;
            break;
        }
        return chunkIsInsideRegion;
    }

    static class PdfCleanUpContext {
        protected PdfDictionary resources = null;
        protected PdfContentByte canvas = null;
        protected PdfNumber charSpacing = new PdfNumber(0);

        public PdfCleanUpContext(PdfDictionary resources, PdfContentByte canvas) {
            this.resources = resources;
            this.canvas = canvas;
        }

        public PdfDictionary getResources() {
            return this.resources;
        }

        public PdfContentByte getCanvas() {
            return this.canvas;
        }

        public PdfNumber getCharSpacing() {
            return this.charSpacing;
        }

        public void setCharSpacing(PdfNumber charSpacing) {
            this.charSpacing = charSpacing;
        }
    }
}

