/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text.pdf.util;

import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.log.Logger;
import com.itextpdf.text.log.LoggerFactory;
import com.itextpdf.text.pdf.PdfObject;
import com.itextpdf.text.pdf.PdfReader;
import com.itextpdf.text.pdf.PdfSmartCopy;
import com.itextpdf.text.pdf.util.PdfResourceCounter;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;

public class SmartPdfSplitter {
    private final Logger LOGGER = LoggerFactory.getLogger(SmartPdfSplitter.class);
    protected PdfReader reader;
    protected int numberOfPages = 0;
    protected int currentPage = 1;
    protected boolean overSized = false;

    public SmartPdfSplitter(PdfReader reader) throws IOException {
        this.reader = reader;
        reader.setAppendable(true);
        this.numberOfPages = reader.getNumberOfPages();
        this.LOGGER.info(String.format("Creating a splitter for a document with %s pages", this.numberOfPages));
    }

    public boolean hasMorePages() {
        return this.currentPage <= this.numberOfPages;
    }

    public boolean isOverSized() {
        return this.overSized;
    }

    public boolean split(OutputStream os, long sizeInBytes) throws IOException, DocumentException {
        if (!this.hasMorePages()) {
            os.close();
            return false;
        }
        this.overSized = false;
        Document document = new Document();
        PdfSmartCopy copy = new PdfSmartCopy(document, os);
        document.open();
        boolean hasPage = false;
        PdfResourceCounter counter = new PdfResourceCounter((PdfObject)this.reader.getTrailer());
        long trailer = counter.getLength(null);
        Map<Integer, PdfObject> resources = counter.getResources();
        long length = 0L;
        while (this.hasMorePages()) {
            counter = new PdfResourceCounter((PdfObject)this.reader.getPageN(this.currentPage));
            long page = counter.getLength(resources);
            resources = counter.getResources();
            this.LOGGER.info(String.format("Page %s: Comparing %s with %s", this.currentPage, length += page + trailer + this.xrefLength(resources.size()), sizeInBytes));
            this.LOGGER.info(String.format("   page %s trailer %s xref %s", page, trailer, this.xrefLength(resources.size())));
            if (!hasPage || length < sizeInBytes) {
                hasPage = true;
                copy.addPage(copy.getImportedPage(this.reader, this.currentPage));
                length = copy.getOs().getCounter();
                this.LOGGER.info(String.format("Size after adding page: %s", length));
                if (length > sizeInBytes) {
                    this.overSized = true;
                }
                ++this.currentPage;
                continue;
            }
            this.LOGGER.info("Page doesn't fit");
            break;
        }
        document.close();
        return true;
    }

    private long xrefLength(int size) {
        return 20L * (long)(size + 1);
    }
}

