/*
 * $Id: 22693ba39ff1759429e0b5c721e0f24c977bb953 $
 *
 * This file is part of the iText (R) project.
 * Copyright (c) 1998-2015 iText Group NV
 * Authors: Bruno Lowagie, Paulo Soares, et al.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License version 3
 * as published by the Free Software Foundation with the addition of the
 * following permission added to Section 15 as permitted in Section 7(a):
 * FOR ANY PART OF THE COVERED WORK IN WHICH THE COPYRIGHT IS OWNED BY
 * ITEXT GROUP. ITEXT GROUP DISCLAIMS THE WARRANTY OF NON INFRINGEMENT
 * OF THIRD PARTY RIGHTS
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Affero General Public License for more details.
 * You should have received a copy of the GNU Affero General Public License
 * along with this program; if not, see http://www.gnu.org/licenses or write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA, 02110-1301 USA, or download the license from the following URL:
 * http://itextpdf.com/terms-of-use/
 *
 * The interactive user interfaces in modified source and object code versions
 * of this program must display Appropriate Legal Notices, as required under
 * Section 5 of the GNU Affero General Public License.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License,
 * a covered work must retain the producer line in every PDF that is created
 * or manipulated using iText.
 *
 * You can be released from the requirements of the license by purchasing
 * a commercial license. Buying such a license is mandatory as soon as you
 * develop commercial activities involving the iText software without
 * disclosing the source code of your own applications.
 * These activities include: offering paid services to customers as an ASP,
 * serving PDFs on the fly in a web application, shipping iText with a closed
 * source product.
 *
 * For more information, please contact iText Software Corp. at this
 * address: sales@itextpdf.com
 */
package com.itextpdf.text.pdf.richmedia;

import com.itextpdf.text.pdf.PdfDictionary;
import com.itextpdf.text.pdf.PdfName;
import com.itextpdf.text.pdf.PdfNumber;

/**
 * A RichMediaAnimation dictionary specifies the preferred method that
 * conforming readers should use to apply timeline scaling to keyframe
 * animations. It can also specify that keyframe animations be played
 * repeatedly.
 * See ExtensionLevel 3 p80
 * @see		RichMediaActivation
 * @since	5.0.0
 */
public class RichMediaAnimation extends PdfDictionary {
	
	/**
	 * Constructs a RichMediaAnimation. Also sets the animation style
	 * described by this dictionary. Valid values are None, Linear, and
	 * Oscillating.
	 * @param	subtype	possible values are
	 * 		PdfName.NONE, PdfName.LINEAR, PdfName.OSCILLATING
	 */
	public RichMediaAnimation(PdfName subtype) {
		super(PdfName.RICHMEDIAANIMATION);
		put(PdfName.SUBTYPE, subtype);
	}
	
	/**
	 * Sets the number of times the animation is played.
	 * @param	playCount	the play count
	 */
	public void setPlayCount(int playCount) {
		put(PdfName.PLAYCOUNT, new PdfNumber(playCount));
	}
	
	/**
	 * Sets the speed to be used when running the animation.
	 * A value greater than one shortens the time it takes to play
	 * the animation, or effectively speeds up the animation.
	 * @param	speed	a speed value
	 */
	public void setSpeed(int speed) {
		put(PdfName.SPEED, new PdfNumber(speed));
	}
	
	/**
	 * Sets the speed to be used when running the animation.
	 * A value greater than one shortens the time it takes to play
	 * the animation, or effectively speeds up the animation.
	 * @param	speed	a speed value
	 */
	public void setSpeed(float speed) {
		put(PdfName.SPEED, new PdfNumber(speed));
	}
}
