/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.kernel.pdf;

import com.itextpdf.kernel.PdfException;
import com.itextpdf.kernel.geom.Rectangle;
import com.itextpdf.kernel.pdf.PdfBoolean;
import com.itextpdf.kernel.pdf.PdfDictionary;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.PdfIndirectReference;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.PdfNumber;
import com.itextpdf.kernel.pdf.PdfObject;
import com.itextpdf.kernel.pdf.PdfStream;
import com.itextpdf.kernel.pdf.PdfString;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class PdfArray
extends PdfObject
implements Iterable<PdfObject> {
    private static final long serialVersionUID = 1617495612878046869L;
    protected List<PdfObject> list;

    public PdfArray() {
        this.list = new ArrayList<PdfObject>();
    }

    public PdfArray(PdfObject obj) {
        this();
        this.list.add(obj);
    }

    public PdfArray(PdfArray arr) {
        this();
        this.list.addAll(arr.list);
    }

    public PdfArray(Rectangle rectangle) {
        this.list = new ArrayList<PdfObject>(4);
        this.add(new PdfNumber(rectangle.getLeft()));
        this.add(new PdfNumber(rectangle.getBottom()));
        this.add(new PdfNumber(rectangle.getRight()));
        this.add(new PdfNumber(rectangle.getTop()));
    }

    public PdfArray(List<? extends PdfObject> objects) {
        this.list = new ArrayList<PdfObject>(objects.size());
        for (PdfObject pdfObject : objects) {
            this.add(pdfObject);
        }
    }

    public PdfArray(float[] numbers) {
        this.list = new ArrayList<PdfObject>(numbers.length);
        for (float f : numbers) {
            this.list.add(new PdfNumber(f));
        }
    }

    public PdfArray(double[] numbers) {
        this.list = new ArrayList<PdfObject>(numbers.length);
        for (double f : numbers) {
            this.list.add(new PdfNumber(f));
        }
    }

    public PdfArray(int[] numbers) {
        this.list = new ArrayList<PdfObject>(numbers.length);
        int[] nArray = numbers;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            float i2 = nArray[i];
            this.list.add(new PdfNumber(i2));
        }
    }

    public PdfArray(boolean[] values) {
        this.list = new ArrayList<PdfObject>(values.length);
        for (boolean b : values) {
            this.list.add(new PdfBoolean(b));
        }
    }

    public PdfArray(List<String> strings, boolean asNames) {
        this.list = new ArrayList<PdfObject>(strings.size());
        for (String s : strings) {
            this.list.add(asNames ? new PdfName(s) : new PdfString(s));
        }
    }

    public int size() {
        return this.list.size();
    }

    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    public boolean contains(PdfObject o) {
        return this.list.contains(o);
    }

    @Override
    public Iterator<PdfObject> iterator() {
        return this.list.iterator();
    }

    public void add(PdfObject pdfObject) {
        this.list.add(pdfObject);
    }

    public void remove(PdfObject o) {
        this.list.remove(o);
    }

    public void addAll(Collection<PdfObject> c) {
        this.list.addAll(c);
    }

    public void addAll(PdfArray a) {
        if (a != null) {
            this.addAll(a.list);
        }
    }

    public void clear() {
        this.list.clear();
    }

    public PdfObject get(int index) {
        return this.get(index, true);
    }

    public PdfObject set(int index, PdfObject element) {
        return this.list.set(index, element);
    }

    public void add(int index, PdfObject element) {
        this.list.add(index, element);
    }

    public void remove(int index) {
        this.list.remove(index);
    }

    public int indexOf(PdfObject o) {
        return this.list.indexOf(o);
    }

    public List<PdfObject> subList(int fromIndex, int toIndex) {
        return this.list.subList(fromIndex, toIndex);
    }

    @Override
    public byte getType() {
        return 1;
    }

    @Override
    public PdfArray makeIndirect(PdfDocument document) {
        return (PdfArray)super.makeIndirect(document);
    }

    @Override
    public PdfArray makeIndirect(PdfDocument document, PdfIndirectReference reference) {
        return (PdfArray)super.makeIndirect(document, reference);
    }

    @Override
    public PdfArray copyTo(PdfDocument document) {
        return (PdfArray)super.copyTo(document, true);
    }

    @Override
    public PdfArray copyTo(PdfDocument document, boolean allowDuplicating) {
        return (PdfArray)super.copyTo(document, allowDuplicating);
    }

    public String toString() {
        String string = "[";
        for (PdfObject entry : this.list) {
            PdfIndirectReference indirectReference = entry.getIndirectReference();
            string = string + (indirectReference == null ? entry.toString() : indirectReference.toString()) + " ";
        }
        string = string + "]";
        return string;
    }

    public PdfObject get(int index, boolean asDirect) {
        if (!asDirect) {
            return this.list.get(index);
        }
        PdfObject obj = this.list.get(index);
        if (obj.getType() == 5) {
            return ((PdfIndirectReference)obj).getRefersTo(true);
        }
        return obj;
    }

    public PdfArray getAsArray(int index) {
        PdfObject direct = this.get(index, true);
        if (direct != null && direct.getType() == 1) {
            return (PdfArray)direct;
        }
        return null;
    }

    public PdfDictionary getAsDictionary(int index) {
        PdfObject direct = this.get(index, true);
        if (direct != null && direct.getType() == 3) {
            return (PdfDictionary)direct;
        }
        return null;
    }

    public PdfStream getAsStream(int index) {
        PdfObject direct = this.get(index, true);
        if (direct != null && direct.getType() == 9) {
            return (PdfStream)direct;
        }
        return null;
    }

    public PdfNumber getAsNumber(int index) {
        PdfObject direct = this.get(index, true);
        if (direct != null && direct.getType() == 8) {
            return (PdfNumber)direct;
        }
        return null;
    }

    public PdfName getAsName(int index) {
        PdfObject direct = this.get(index, true);
        if (direct != null && direct.getType() == 6) {
            return (PdfName)direct;
        }
        return null;
    }

    public PdfString getAsString(int index) {
        PdfObject direct = this.get(index, true);
        if (direct != null && direct.getType() == 10) {
            return (PdfString)direct;
        }
        return null;
    }

    public PdfBoolean getAsBoolean(int index) {
        PdfObject direct = this.get(index, true);
        if (direct != null && direct.getType() == 2) {
            return (PdfBoolean)direct;
        }
        return null;
    }

    public Rectangle toRectangle() {
        try {
            float x1 = this.getAsNumber(0).floatValue();
            float y1 = this.getAsNumber(1).floatValue();
            float x2 = this.getAsNumber(2).floatValue();
            float y2 = this.getAsNumber(3).floatValue();
            return new Rectangle(x1, y1, x2 - x1, y2 - y1);
        }
        catch (Exception e) {
            throw new PdfException("cannot.convert.pdfarray.to.rectangle", e, this);
        }
    }

    @Override
    protected PdfArray newInstance() {
        return new PdfArray();
    }

    @Override
    protected void copyContent(PdfObject from, PdfDocument document) {
        super.copyContent(from, document);
        PdfArray array = (PdfArray)from;
        for (PdfObject entry : array.list) {
            this.add(entry.processCopying(document, false));
        }
    }

    protected void releaseContent() {
        this.list = null;
    }
}

