/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.kernel.pdf.colorspace;

import com.itextpdf.kernel.PdfException;
import com.itextpdf.kernel.pdf.PdfArray;
import com.itextpdf.kernel.pdf.PdfDictionary;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.PdfNumber;
import com.itextpdf.kernel.pdf.PdfObject;
import com.itextpdf.kernel.pdf.PdfObjectWrapper;
import com.itextpdf.kernel.pdf.PdfStream;
import com.itextpdf.kernel.pdf.colorspace.PdfColorSpace;
import com.itextpdf.kernel.pdf.colorspace.PdfSpecialCs;
import com.itextpdf.kernel.pdf.function.PdfFunction;

public abstract class PdfShading
extends PdfObjectWrapper<PdfDictionary> {
    private static final long serialVersionUID = 4781809723744243508L;

    public static PdfShading makeShading(PdfDictionary shadingDictionary) {
        PdfShading shading;
        if (!shadingDictionary.containsKey(PdfName.ShadingType)) {
            throw new PdfException("unexpected.shading.type");
        }
        switch (shadingDictionary.getAsNumber(PdfName.ShadingType).intValue()) {
            case 1: {
                shading = new FunctionBased(shadingDictionary);
                break;
            }
            case 2: {
                shading = new Axial(shadingDictionary);
                break;
            }
            case 3: {
                shading = new Radial(shadingDictionary);
                break;
            }
            case 4: {
                if (!shadingDictionary.isStream()) {
                    throw new PdfException("unexpected.shading.type");
                }
                shading = new FreeFormGouraudShadedTriangleMesh((PdfStream)shadingDictionary);
                break;
            }
            case 5: {
                if (!shadingDictionary.isStream()) {
                    throw new PdfException("unexpected.shading.type");
                }
                shading = new LatticeFormGouraudShadedTriangleMesh((PdfStream)shadingDictionary);
                break;
            }
            case 6: {
                if (!shadingDictionary.isStream()) {
                    throw new PdfException("unexpected.shading.type");
                }
                shading = new CoonsPatchMesh((PdfStream)shadingDictionary);
                break;
            }
            case 7: {
                if (!shadingDictionary.isStream()) {
                    throw new PdfException("unexpected.shading.type");
                }
                shading = new TensorProductPatchMesh((PdfStream)shadingDictionary);
                break;
            }
            default: {
                throw new PdfException("unexpected.shading.type");
            }
        }
        return shading;
    }

    protected PdfShading(PdfDictionary pdfObject) {
        super(pdfObject);
    }

    protected PdfShading(PdfDictionary pdfObject, int type, PdfObject colorSpace) {
        super(pdfObject);
        ((PdfDictionary)this.getPdfObject()).put(PdfName.ShadingType, new PdfNumber(type));
        ((PdfDictionary)this.getPdfObject()).put(PdfName.ColorSpace, colorSpace);
    }

    public int getShadingType() {
        return ((PdfDictionary)this.getPdfObject()).getAsInt(PdfName.ShadingType);
    }

    public PdfObject getColorSpace() {
        return ((PdfDictionary)this.getPdfObject()).get(PdfName.ColorSpace);
    }

    public PdfObject getFunction() {
        return ((PdfDictionary)this.getPdfObject()).get(PdfName.Function);
    }

    public void setFunction(PdfFunction function) {
        ((PdfDictionary)this.getPdfObject()).put(PdfName.Function, (PdfObject)function.getPdfObject());
        this.setModified();
    }

    public void setFunction(PdfFunction[] functions) {
        PdfArray arr = new PdfArray();
        for (PdfFunction func : functions) {
            arr.add((PdfObject)func.getPdfObject());
        }
        ((PdfDictionary)this.getPdfObject()).put(PdfName.Function, arr);
        this.setModified();
    }

    @Override
    protected boolean isWrappedObjectMustBeIndirect() {
        return true;
    }

    public static class TensorProductPatchMesh
    extends PdfShading {
        private static final long serialVersionUID = -2750695839303504742L;

        public TensorProductPatchMesh(PdfStream pdfStream) {
            super(pdfStream);
        }

        public TensorProductPatchMesh(PdfColorSpace cs, int bitsPerCoordinate, int bitsPerComponent, int bitsPerFlag, float[] decode) {
            this(cs, bitsPerCoordinate, bitsPerComponent, bitsPerFlag, new PdfArray(decode));
        }

        public TensorProductPatchMesh(PdfColorSpace cs, int bitsPerCoordinate, int bitsPerComponent, int bitsPerFlag, PdfArray decode) {
            super(new PdfStream(), 7, (PdfObject)cs.getPdfObject());
            this.setBitsPerCoordinate(bitsPerCoordinate);
            this.setBitsPerComponent(bitsPerComponent);
            this.setBitsPerFlag(bitsPerFlag);
            this.setDecode(decode);
        }

        public int getBitsPerCoordinate() {
            return ((PdfDictionary)this.getPdfObject()).getAsInt(PdfName.BitsPerCoordinate);
        }

        public void setBitsPerCoordinate(int bitsPerCoordinate) {
            ((PdfDictionary)this.getPdfObject()).put(PdfName.BitsPerCoordinate, new PdfNumber(bitsPerCoordinate));
            this.setModified();
        }

        public int getBitsPerComponent() {
            return ((PdfDictionary)this.getPdfObject()).getAsInt(PdfName.BitsPerComponent);
        }

        public void setBitsPerComponent(int bitsPerComponent) {
            ((PdfDictionary)this.getPdfObject()).put(PdfName.BitsPerComponent, new PdfNumber(bitsPerComponent));
            this.setModified();
        }

        public int getBitsPerFlag() {
            return ((PdfDictionary)this.getPdfObject()).getAsInt(PdfName.BitsPerFlag);
        }

        public void setBitsPerFlag(int bitsPerFlag) {
            ((PdfDictionary)this.getPdfObject()).put(PdfName.BitsPerFlag, new PdfNumber(bitsPerFlag));
            this.setModified();
        }

        public PdfArray getDecode() {
            return ((PdfDictionary)this.getPdfObject()).getAsArray(PdfName.Decode);
        }

        public void setDecode(float[] decode) {
            ((PdfDictionary)this.getPdfObject()).put(PdfName.Decode, new PdfArray(decode));
        }

        public void setDecode(PdfArray decode) {
            ((PdfDictionary)this.getPdfObject()).put(PdfName.Decode, decode);
        }
    }

    public static class CoonsPatchMesh
    extends PdfShading {
        private static final long serialVersionUID = 7296891352801419708L;

        public CoonsPatchMesh(PdfStream pdfStream) {
            super(pdfStream);
        }

        public CoonsPatchMesh(PdfColorSpace cs, int bitsPerCoordinate, int bitsPerComponent, int bitsPerFlag, float[] decode) {
            this(cs, bitsPerCoordinate, bitsPerComponent, bitsPerFlag, new PdfArray(decode));
        }

        public CoonsPatchMesh(PdfColorSpace cs, int bitsPerCoordinate, int bitsPerComponent, int bitsPerFlag, PdfArray decode) {
            super(new PdfStream(), 6, (PdfObject)cs.getPdfObject());
            this.setBitsPerCoordinate(bitsPerCoordinate);
            this.setBitsPerComponent(bitsPerComponent);
            this.setBitsPerFlag(bitsPerFlag);
            this.setDecode(decode);
        }

        public int getBitsPerCoordinate() {
            return ((PdfDictionary)this.getPdfObject()).getAsInt(PdfName.BitsPerCoordinate);
        }

        public void setBitsPerCoordinate(int bitsPerCoordinate) {
            ((PdfDictionary)this.getPdfObject()).put(PdfName.BitsPerCoordinate, new PdfNumber(bitsPerCoordinate));
            this.setModified();
        }

        public int getBitsPerComponent() {
            return ((PdfDictionary)this.getPdfObject()).getAsInt(PdfName.BitsPerComponent);
        }

        public void setBitsPerComponent(int bitsPerComponent) {
            ((PdfDictionary)this.getPdfObject()).put(PdfName.BitsPerComponent, new PdfNumber(bitsPerComponent));
            this.setModified();
        }

        public int getBitsPerFlag() {
            return ((PdfDictionary)this.getPdfObject()).getAsInt(PdfName.BitsPerFlag);
        }

        public void setBitsPerFlag(int bitsPerFlag) {
            ((PdfDictionary)this.getPdfObject()).put(PdfName.BitsPerFlag, new PdfNumber(bitsPerFlag));
            this.setModified();
        }

        public PdfArray getDecode() {
            return ((PdfDictionary)this.getPdfObject()).getAsArray(PdfName.Decode);
        }

        public void setDecode(float[] decode) {
            ((PdfDictionary)this.getPdfObject()).put(PdfName.Decode, new PdfArray(decode));
        }

        public void setDecode(PdfArray decode) {
            ((PdfDictionary)this.getPdfObject()).put(PdfName.Decode, decode);
        }
    }

    public static class LatticeFormGouraudShadedTriangleMesh
    extends PdfShading {
        private static final long serialVersionUID = -8776232978423888214L;

        public LatticeFormGouraudShadedTriangleMesh(PdfStream pdfStream) {
            super(pdfStream);
        }

        public LatticeFormGouraudShadedTriangleMesh(PdfColorSpace cs, int bitsPerCoordinate, int bitsPerComponent, int verticesPerRow, float[] decode) {
            this(cs, bitsPerCoordinate, bitsPerComponent, verticesPerRow, new PdfArray(decode));
        }

        public LatticeFormGouraudShadedTriangleMesh(PdfColorSpace cs, int bitsPerCoordinate, int bitsPerComponent, int verticesPerRow, PdfArray decode) {
            super(new PdfStream(), 5, (PdfObject)cs.getPdfObject());
            this.setBitsPerCoordinate(bitsPerCoordinate);
            this.setBitsPerComponent(bitsPerComponent);
            this.setVerticesPerRow(verticesPerRow);
            this.setDecode(decode);
        }

        public int getBitsPerCoordinate() {
            return ((PdfDictionary)this.getPdfObject()).getAsInt(PdfName.BitsPerCoordinate);
        }

        public void setBitsPerCoordinate(int bitsPerCoordinate) {
            ((PdfDictionary)this.getPdfObject()).put(PdfName.BitsPerCoordinate, new PdfNumber(bitsPerCoordinate));
            this.setModified();
        }

        public int getBitsPerComponent() {
            return ((PdfDictionary)this.getPdfObject()).getAsInt(PdfName.BitsPerComponent);
        }

        public void setBitsPerComponent(int bitsPerComponent) {
            ((PdfDictionary)this.getPdfObject()).put(PdfName.BitsPerComponent, new PdfNumber(bitsPerComponent));
            this.setModified();
        }

        public int getVerticesPerRow() {
            return ((PdfDictionary)this.getPdfObject()).getAsInt(PdfName.VerticesPerRow);
        }

        public void setVerticesPerRow(int verticesPerRow) {
            ((PdfDictionary)this.getPdfObject()).put(PdfName.VerticesPerRow, new PdfNumber(verticesPerRow));
            this.setModified();
        }

        public PdfArray getDecode() {
            return ((PdfDictionary)this.getPdfObject()).getAsArray(PdfName.Decode);
        }

        public void setDecode(float[] decode) {
            ((PdfDictionary)this.getPdfObject()).put(PdfName.Decode, new PdfArray(decode));
        }

        public void setDecode(PdfArray decode) {
            ((PdfDictionary)this.getPdfObject()).put(PdfName.Decode, decode);
        }
    }

    public static class FreeFormGouraudShadedTriangleMesh
    extends PdfShading {
        private static final long serialVersionUID = -2690557760051875972L;

        public FreeFormGouraudShadedTriangleMesh(PdfStream pdfStream) {
            super(pdfStream);
        }

        public FreeFormGouraudShadedTriangleMesh(PdfColorSpace cs, int bitsPerCoordinate, int bitsPerComponent, int bitsPerFlag, float[] decode) {
            this(cs, bitsPerCoordinate, bitsPerComponent, bitsPerFlag, new PdfArray(decode));
        }

        public FreeFormGouraudShadedTriangleMesh(PdfColorSpace cs, int bitsPerCoordinate, int bitsPerComponent, int bitsPerFlag, PdfArray decode) {
            super(new PdfStream(), 4, (PdfObject)cs.getPdfObject());
            this.setBitsPerCoordinate(bitsPerCoordinate);
            this.setBitsPerComponent(bitsPerComponent);
            this.setBitsPerFlag(bitsPerFlag);
            this.setDecode(decode);
        }

        public int getBitsPerCoordinate() {
            return ((PdfDictionary)this.getPdfObject()).getAsInt(PdfName.BitsPerCoordinate);
        }

        public void setBitsPerCoordinate(int bitsPerCoordinate) {
            ((PdfDictionary)this.getPdfObject()).put(PdfName.BitsPerCoordinate, new PdfNumber(bitsPerCoordinate));
            this.setModified();
        }

        public int getBitsPerComponent() {
            return ((PdfDictionary)this.getPdfObject()).getAsInt(PdfName.BitsPerComponent);
        }

        public void setBitsPerComponent(int bitsPerComponent) {
            ((PdfDictionary)this.getPdfObject()).put(PdfName.BitsPerComponent, new PdfNumber(bitsPerComponent));
            this.setModified();
        }

        public int getBitsPerFlag() {
            return ((PdfDictionary)this.getPdfObject()).getAsInt(PdfName.BitsPerFlag);
        }

        public void setBitsPerFlag(int bitsPerFlag) {
            ((PdfDictionary)this.getPdfObject()).put(PdfName.BitsPerFlag, new PdfNumber(bitsPerFlag));
            this.setModified();
        }

        public PdfArray getDecode() {
            return ((PdfDictionary)this.getPdfObject()).getAsArray(PdfName.Decode);
        }

        public void setDecode(float[] decode) {
            ((PdfDictionary)this.getPdfObject()).put(PdfName.Decode, new PdfArray(decode));
        }

        public void setDecode(PdfArray decode) {
            ((PdfDictionary)this.getPdfObject()).put(PdfName.Decode, decode);
        }
    }

    public static class Radial
    extends PdfShading {
        private static final long serialVersionUID = -5012819396006804845L;

        public Radial(PdfDictionary pdfDictionary) {
            super(pdfDictionary);
        }

        public Radial(PdfColorSpace cs, float x0, float y0, float r0, float[] color0, float x1, float y1, float r1, float[] color1) {
            super(new PdfDictionary(), 3, (PdfObject)cs.getPdfObject());
            this.setCoords(x0, y0, r0, x1, y1, r1);
            PdfFunction.Type2 func = new PdfFunction.Type2(new PdfArray(new float[]{0.0f, 1.0f}), null, new PdfArray(color0), new PdfArray(color1), new PdfNumber(1));
            this.setFunction(func);
        }

        public Radial(PdfColorSpace cs, float x0, float y0, float r0, float[] color0, float x1, float y1, float r1, float[] color1, boolean[] extend) {
            this(cs, x0, y0, r0, color0, x1, y1, r1, color1);
            if (extend != null) {
                this.setExtend(extend[0], extend[1]);
            }
        }

        public Radial(PdfColorSpace cs, PdfArray coords, PdfFunction function) {
            super(new PdfDictionary(), 3, (PdfObject)cs.getPdfObject());
            this.setCoords(coords);
            this.setFunction(function);
        }

        public PdfArray getCoords() {
            return ((PdfDictionary)this.getPdfObject()).getAsArray(PdfName.Coords);
        }

        public void setCoords(float x0, float y0, float r0, float x1, float y1, float r1) {
            this.setCoords(new PdfArray(new float[]{x0, y0, r0, x1, y1, r1}));
        }

        public void setCoords(PdfArray coords) {
            ((PdfDictionary)this.getPdfObject()).put(PdfName.Coords, coords);
            this.setModified();
        }

        public float[] getDomain() {
            PdfArray domain = ((PdfDictionary)this.getPdfObject()).getAsArray(PdfName.Domain);
            if (domain == null) {
                return new float[]{0.0f, 1.0f};
            }
            return new float[]{domain.getAsNumber(0).floatValue(), domain.getAsNumber(1).floatValue()};
        }

        public void setDomain(float t0, float t1) {
            ((PdfDictionary)this.getPdfObject()).put(PdfName.Domain, new PdfArray(new float[]{t0, t1}));
            this.setModified();
        }

        public boolean[] getExtend() {
            PdfArray extend = ((PdfDictionary)this.getPdfObject()).getAsArray(PdfName.Extend);
            if (extend == null) {
                return new boolean[]{true, true};
            }
            return new boolean[]{extend.getAsBoolean(0).getValue(), extend.getAsBoolean(1).getValue()};
        }

        public void setExtend(boolean extendStart, boolean extendEnd) {
            ((PdfDictionary)this.getPdfObject()).put(PdfName.Extend, new PdfArray(new boolean[]{extendStart, extendEnd}));
            this.setModified();
        }
    }

    public static class Axial
    extends PdfShading {
        private static final long serialVersionUID = 5504688740677023792L;

        public Axial(PdfDictionary pdfDictionary) {
            super(pdfDictionary);
        }

        public Axial(PdfColorSpace cs, float x0, float y0, float[] color0, float x1, float y1, float[] color1) {
            super(new PdfDictionary(), 2, (PdfObject)cs.getPdfObject());
            if (cs instanceof PdfSpecialCs.Pattern) {
                throw new IllegalArgumentException("colorSpace");
            }
            this.setCoords(x0, y0, x1, y1);
            PdfFunction.Type2 func = new PdfFunction.Type2(new PdfArray(new float[]{0.0f, 1.0f}), null, new PdfArray(color0), new PdfArray(color1), new PdfNumber(1));
            this.setFunction(func);
        }

        public Axial(PdfColorSpace cs, float x0, float y0, float[] color0, float x1, float y1, float[] color1, boolean[] extend) {
            this(cs, x0, y0, color0, x1, y1, color1);
            if (extend != null) {
                this.setExtend(extend[0], extend[1]);
            }
        }

        public Axial(PdfColorSpace cs, PdfArray coords, PdfFunction function) {
            super(new PdfDictionary(), 2, (PdfObject)cs.getPdfObject());
            this.setCoords(coords);
            this.setFunction(function);
        }

        public PdfArray getCoords() {
            return ((PdfDictionary)this.getPdfObject()).getAsArray(PdfName.Coords);
        }

        public void setCoords(float x0, float y0, float x1, float y1) {
            this.setCoords(new PdfArray(new float[]{x0, y0, x1, y1}));
        }

        public void setCoords(PdfArray coords) {
            ((PdfDictionary)this.getPdfObject()).put(PdfName.Coords, coords);
            this.setModified();
        }

        public float[] getDomain() {
            PdfArray domain = ((PdfDictionary)this.getPdfObject()).getAsArray(PdfName.Domain);
            if (domain == null) {
                return new float[]{0.0f, 1.0f};
            }
            return new float[]{domain.getAsNumber(0).floatValue(), domain.getAsNumber(1).floatValue()};
        }

        public void setDomain(float t0, float t1) {
            ((PdfDictionary)this.getPdfObject()).put(PdfName.Domain, new PdfArray(new float[]{t0, t1}));
            this.setModified();
        }

        public boolean[] getExtend() {
            PdfArray extend = ((PdfDictionary)this.getPdfObject()).getAsArray(PdfName.Extend);
            if (extend == null) {
                return new boolean[]{true, true};
            }
            return new boolean[]{extend.getAsBoolean(0).getValue(), extend.getAsBoolean(1).getValue()};
        }

        public void setExtend(boolean extendStart, boolean extendEnd) {
            ((PdfDictionary)this.getPdfObject()).put(PdfName.Extend, new PdfArray(new boolean[]{extendStart, extendEnd}));
            this.setModified();
        }
    }

    public static class FunctionBased
    extends PdfShading {
        private static final long serialVersionUID = -4459197498902558052L;

        public FunctionBased(PdfDictionary pdfObject) {
            super(pdfObject);
        }

        public FunctionBased(PdfColorSpace colorSpace, PdfFunction function) {
            this((PdfObject)colorSpace.getPdfObject(), function);
        }

        public FunctionBased(PdfObject colorSpace, PdfFunction function) {
            super(new PdfDictionary(), 1, colorSpace);
            this.setFunction(function);
        }

        public PdfArray getDomain() {
            return ((PdfDictionary)this.getPdfObject()).getAsArray(PdfName.Domain);
        }

        public void setDomain(float xmin, float xmax, float ymin, float ymax) {
            ((PdfDictionary)this.getPdfObject()).put(PdfName.Domain, new PdfArray(new float[]{xmin, xmax, ymin, ymax}));
            this.setModified();
        }

        public void setDomain(PdfArray domain) {
            ((PdfDictionary)this.getPdfObject()).put(PdfName.Domain, domain);
            this.setModified();
        }

        public float[] getMatrix() {
            PdfArray matrix = ((PdfDictionary)this.getPdfObject()).getAsArray(PdfName.Matrix);
            if (matrix == null) {
                return new float[]{1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f};
            }
            float[] result = new float[6];
            for (int i = 0; i < 6; ++i) {
                result[i] = matrix.getAsNumber(i).floatValue();
            }
            return result;
        }

        public void setMatrix(float[] matrix) {
            this.setMatrix(new PdfArray(matrix));
        }

        public void setMatrix(PdfArray matrix) {
            ((PdfDictionary)this.getPdfObject()).put(PdfName.Matrix, matrix);
            this.setModified();
        }
    }

    private static class ShadingType {
        public static final int FUNCTION_BASED = 1;
        public static final int AXIAL = 2;
        public static final int RADIAL = 3;
        public static final int FREE_FORM_GOURAUD_SHADED_TRIANGLE_MESH = 4;
        public static final int LATTICE_FORM_GOURAUD_SHADED_TRIANGLE_MESH = 5;
        public static final int COONS_PATCH_MESH = 6;
        public static final int TENSOR_PRODUCT_PATCH_MESH = 7;

        private ShadingType() {
        }
    }
}

