/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.kernel.pdf;

import com.itextpdf.io.source.ByteArrayOutputStream;
import com.itextpdf.io.source.ByteUtils;
import com.itextpdf.io.util.FileUtil;
import com.itextpdf.kernel.PdfException;
import com.itextpdf.kernel.pdf.ByteBufferOutputStream;
import com.itextpdf.kernel.pdf.EncryptionProperties;
import com.itextpdf.kernel.pdf.PdfArray;
import com.itextpdf.kernel.pdf.PdfDictionary;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.PdfEncryption;
import com.itextpdf.kernel.pdf.PdfIndirectReference;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.PdfNull;
import com.itextpdf.kernel.pdf.PdfObject;
import com.itextpdf.kernel.pdf.PdfObjectStream;
import com.itextpdf.kernel.pdf.PdfOutputStream;
import com.itextpdf.kernel.pdf.PdfPrimitiveObject;
import com.itextpdf.kernel.pdf.PdfReader;
import com.itextpdf.kernel.pdf.PdfStream;
import com.itextpdf.kernel.pdf.PdfXrefTable;
import com.itextpdf.kernel.pdf.WriterProperties;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PdfWriter
extends PdfOutputStream
implements Serializable {
    private static final long serialVersionUID = -6875544505477707103L;
    private static final byte[] obj = ByteUtils.getIsoBytes((String)" obj\n");
    private static final byte[] endobj = ByteUtils.getIsoBytes((String)"\nendobj\n");
    private PdfOutputStream duplicateStream = null;
    protected WriterProperties properties;
    PdfObjectStream objectStream = null;
    private Map<PdfDocument.IndirectRefDescription, PdfIndirectReference> copiedObjects = new HashMap<PdfDocument.IndirectRefDescription, PdfIndirectReference>();
    private HashMap<SerializedPdfObject, PdfIndirectReference> serializedContentToObjectRef = new HashMap();
    private HashMap<PdfDocument.IndirectRefDescription, byte[]> objectRefToSerializedContent = new HashMap();
    protected boolean isUserWarnedAboutAcroFormCopying;

    public PdfWriter(OutputStream os) {
        this(os, new WriterProperties());
    }

    public PdfWriter(OutputStream os, WriterProperties properties) {
        super(FileUtil.wrapWithBufferedOutputStream((OutputStream)os));
        this.properties = properties;
        EncryptionProperties encryptProps = properties.encryptionProperties;
        if (properties.isStandardEncryptionUsed()) {
            this.crypto = new PdfEncryption(encryptProps.userPassword, encryptProps.ownerPassword, encryptProps.standardEncryptPermissions, encryptProps.encryptionAlgorithm, PdfEncryption.generateNewDocumentId());
        } else if (properties.isPublicKeyEncryptionUsed()) {
            this.crypto = new PdfEncryption(encryptProps.publicCertificates, encryptProps.publicKeyEncryptPermissions, encryptProps.encryptionAlgorithm);
        }
        if (properties.debugMode) {
            this.setDebugMode();
        }
    }

    public PdfWriter(String filename) throws FileNotFoundException {
        this(filename, new WriterProperties());
    }

    public PdfWriter(String filename, WriterProperties properties) throws FileNotFoundException {
        this(FileUtil.getBufferedOutputStream((String)filename), properties);
    }

    public boolean isFullCompression() {
        return this.properties.isFullCompression != null ? this.properties.isFullCompression : false;
    }

    public int getCompressionLevel() {
        return this.properties.compressionLevel;
    }

    public PdfWriter setCompressionLevel(int compressionLevel) {
        this.properties.setCompressionLevel(compressionLevel);
        return this;
    }

    public PdfWriter setSmartMode(boolean smartMode) {
        this.properties.smartMode = smartMode;
        return this;
    }

    public void write(int b) throws IOException {
        super.write(b);
        if (this.duplicateStream != null) {
            this.duplicateStream.write(b);
        }
    }

    public void write(byte[] b) throws IOException {
        super.write(b);
        if (this.duplicateStream != null) {
            this.duplicateStream.write(b);
        }
    }

    public void write(byte[] b, int off, int len) throws IOException {
        super.write(b, off, len);
        if (this.duplicateStream != null) {
            this.duplicateStream.write(b, off, len);
        }
    }

    public void close() throws IOException {
        try {
            super.close();
        }
        finally {
            try {
                if (this.duplicateStream != null) {
                    this.duplicateStream.close();
                }
            }
            catch (Exception ex) {
                Logger logger = LoggerFactory.getLogger(PdfWriter.class);
                logger.error("Closing of the duplicatedStream failed.", (Throwable)ex);
            }
        }
    }

    PdfObjectStream getObjectStream() throws IOException {
        if (!this.isFullCompression()) {
            return null;
        }
        if (this.objectStream == null) {
            this.objectStream = new PdfObjectStream(this.document);
        } else if (this.objectStream.getSize() == 200) {
            this.objectStream.flush();
            this.objectStream = new PdfObjectStream(this.objectStream);
        }
        return this.objectStream;
    }

    protected void flushObject(PdfObject pdfObject, boolean canBeInObjStm) throws IOException {
        PdfIndirectReference indirectReference = pdfObject.getIndirectReference();
        if (this.isFullCompression() && canBeInObjStm) {
            PdfObjectStream objectStream = this.getObjectStream();
            objectStream.addObject(pdfObject);
        } else {
            indirectReference.setOffset(this.getCurrentPos());
            this.writeToBody(pdfObject);
        }
        indirectReference.setState((short)1).clearState((short)32);
        switch (pdfObject.getType()) {
            case 2: 
            case 6: 
            case 7: 
            case 8: 
            case 10: {
                ((PdfPrimitiveObject)pdfObject).content = null;
                break;
            }
            case 1: {
                PdfArray array = (PdfArray)pdfObject;
                this.markArrayContentToFlush(array);
                array.releaseContent();
                break;
            }
            case 3: 
            case 9: {
                PdfDictionary dictionary = (PdfDictionary)pdfObject;
                this.markDictionaryContentToFlush(dictionary);
                dictionary.releaseContent();
                break;
            }
            case 5: {
                this.markObjectToFlush(((PdfIndirectReference)pdfObject).getRefersTo(false));
            }
        }
    }

    protected PdfObject copyObject(PdfObject obj, PdfDocument document, boolean allowDuplicating) {
        PdfIndirectReference copiedObjectRef;
        PdfName subtype;
        PdfIndirectReference copiedIndirectReference;
        boolean tryToFindDuplicate;
        if (obj instanceof PdfIndirectReference) {
            obj = ((PdfIndirectReference)obj).getRefersTo();
        }
        if (obj == null) {
            obj = PdfNull.PDF_NULL;
        }
        if (PdfWriter.checkTypeOfPdfDictionary(obj, PdfName.Catalog)) {
            Logger logger = LoggerFactory.getLogger(PdfReader.class);
            logger.warn("Make copy of Catalog dictionary is forbidden.");
            obj = PdfNull.PDF_NULL;
        }
        PdfIndirectReference indirectReference = obj.getIndirectReference();
        PdfDocument.IndirectRefDescription copiedObjectKey = null;
        boolean bl = tryToFindDuplicate = !allowDuplicating && indirectReference != null;
        if (tryToFindDuplicate && (copiedIndirectReference = this.copiedObjects.get(copiedObjectKey = new PdfDocument.IndirectRefDescription(indirectReference))) != null) {
            return copiedIndirectReference.getRefersTo();
        }
        if (obj.isDictionary() && (subtype = ((PdfDictionary)obj).getAsName(PdfName.Subtype)) != null && subtype.equals(PdfName.Widget)) {
            tryToFindDuplicate = false;
        }
        if (this.properties.smartMode && tryToFindDuplicate && !PdfWriter.checkTypeOfPdfDictionary(obj, PdfName.Page) && (copiedObjectRef = this.tryToFindPreviouslyCopiedEqualObject(obj)) != null) {
            PdfIndirectReference copiedIndirectReference2 = this.copiedObjects.get(new PdfDocument.IndirectRefDescription(copiedObjectRef));
            this.copiedObjects.put(copiedObjectKey, copiedIndirectReference2);
            return copiedIndirectReference2.getRefersTo();
        }
        PdfObject newObject = obj.newInstance();
        if (indirectReference != null) {
            if (copiedObjectKey == null) {
                copiedObjectKey = new PdfDocument.IndirectRefDescription(indirectReference);
            }
            PdfIndirectReference indRef = newObject.makeIndirect(document).getIndirectReference();
            this.copiedObjects.put(copiedObjectKey, indRef);
        }
        newObject.copyContent(obj, document);
        return newObject;
    }

    protected void writeToBody(PdfObject pdfObj) throws IOException {
        if (this.crypto != null) {
            this.crypto.setHashKeyForNextObject(pdfObj.getIndirectReference().getObjNumber(), pdfObj.getIndirectReference().getGenNumber());
        }
        ((PdfOutputStream)((Object)((PdfOutputStream)((Object)((PdfOutputStream)((Object)this.writeInteger(pdfObj.getIndirectReference().getObjNumber()))).writeSpace())).writeInteger(pdfObj.getIndirectReference().getGenNumber()))).writeBytes(obj);
        this.write(pdfObj);
        this.writeBytes(endobj);
    }

    protected void writeHeader() {
        ((PdfOutputStream)((Object)((PdfOutputStream)((Object)this.writeByte(37))).writeString(this.document.getPdfVersion().toString()))).writeString("\n%\u00e2\u00e3\u00cf\u00d3\n");
    }

    protected void flushWaitingObjects() {
        PdfXrefTable xref = this.document.getXref();
        boolean needFlush = true;
        while (needFlush) {
            needFlush = false;
            for (int i = 1; i < xref.size(); ++i) {
                PdfObject obj;
                PdfIndirectReference indirectReference = xref.get(i);
                if (indirectReference == null || !indirectReference.checkState((short)32) || (obj = indirectReference.getRefersTo(false)) == null) continue;
                obj.flush();
                needFlush = true;
            }
        }
        if (this.objectStream != null && this.objectStream.getSize() > 0) {
            this.objectStream.flush();
            this.objectStream = null;
        }
    }

    protected void flushModifiedWaitingObjects() {
        PdfXrefTable xref = this.document.getXref();
        for (int i = 1; i < xref.size(); ++i) {
            PdfObject obj;
            PdfIndirectReference indirectReference = xref.get(i);
            if (null == indirectReference || (obj = indirectReference.getRefersTo(false)) == null || obj.equals(this.objectStream) || !obj.isModified()) continue;
            obj.flush();
        }
        if (this.objectStream != null && this.objectStream.getSize() > 0) {
            this.objectStream.flush();
            this.objectStream = null;
        }
    }

    @Deprecated
    protected static int calculateIndRefKey(PdfIndirectReference indRef) {
        int result = indRef.hashCode();
        result = 31 * result + indRef.getDocument().hashCode();
        return result;
    }

    @Deprecated
    protected int getCopyObjectKey(PdfObject obj) {
        return PdfWriter.calculateIndRefKey(obj.getIndirectReference());
    }

    private PdfIndirectReference tryToFindPreviouslyCopiedEqualObject(PdfObject object) {
        if (object.isStream() || object.isDictionary()) {
            SerializedPdfObject objectKey = new SerializedPdfObject(object, this.objectRefToSerializedContent);
            PdfIndirectReference objectRef = this.serializedContentToObjectRef.get(objectKey);
            if (objectRef != null) {
                return objectRef;
            }
            this.serializedContentToObjectRef.put(objectKey, object.getIndirectReference());
        }
        return null;
    }

    private void markArrayContentToFlush(PdfArray array) {
        for (int i = 0; i < array.size(); ++i) {
            this.markObjectToFlush(array.get(i, false));
        }
    }

    private void markDictionaryContentToFlush(PdfDictionary dictionary) {
        for (PdfObject item : dictionary.values(false)) {
            this.markObjectToFlush(item);
        }
    }

    private void markObjectToFlush(PdfObject pdfObject) {
        if (pdfObject != null) {
            PdfIndirectReference indirectReference = pdfObject.getIndirectReference();
            if (indirectReference != null) {
                if (!indirectReference.checkState((short)1)) {
                    indirectReference.setState((short)32);
                }
            } else if (pdfObject.getType() == 5) {
                if (!pdfObject.checkState((short)1)) {
                    pdfObject.setState((short)32);
                }
            } else if (pdfObject.getType() == 1) {
                this.markArrayContentToFlush((PdfArray)pdfObject);
            } else if (pdfObject.getType() == 3) {
                this.markDictionaryContentToFlush((PdfDictionary)pdfObject);
            }
        }
    }

    private PdfWriter setDebugMode() {
        this.duplicateStream = new PdfOutputStream((OutputStream)new ByteArrayOutputStream());
        return this;
    }

    private byte[] getDebugBytes() throws IOException {
        if (this.duplicateStream != null) {
            this.duplicateStream.flush();
            return ((ByteArrayOutputStream)this.duplicateStream.getOutputStream()).toByteArray();
        }
        return null;
    }

    private static boolean checkTypeOfPdfDictionary(PdfObject dictionary, PdfName expectedType) {
        return dictionary.isDictionary() && expectedType.equals(((PdfDictionary)dictionary).getAsName(PdfName.Type));
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.outputStream == null) {
            this.outputStream = new ByteArrayOutputStream().assignBytes(this.getDebugBytes());
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        if (this.duplicateStream == null) {
            throw new NotSerializableException(this.getClass().getName() + ": debug mode is disabled!");
        }
        OutputStream tempOutputStream = this.outputStream;
        this.outputStream = null;
        out.defaultWriteObject();
        this.outputStream = tempOutputStream;
    }

    static class SerializedPdfObject {
        private final byte[] serializedContent;
        private final int hash;
        private MessageDigest md5;
        private HashMap<PdfDocument.IndirectRefDescription, byte[]> objToSerializedContent;

        SerializedPdfObject(PdfObject obj, HashMap<PdfDocument.IndirectRefDescription, byte[]> objToSerializedContent) {
            assert (obj.isDictionary() || obj.isStream());
            this.objToSerializedContent = objToSerializedContent;
            try {
                this.md5 = MessageDigest.getInstance("MD5");
            }
            catch (Exception e) {
                throw new PdfException(e);
            }
            ByteBufferOutputStream bb = new ByteBufferOutputStream();
            int level = 100;
            this.serObject(obj, level, bb);
            this.serializedContent = bb.toByteArray();
            this.hash = SerializedPdfObject.calculateHash(this.serializedContent);
            this.md5 = null;
        }

        private void serObject(PdfObject obj, int level, ByteBufferOutputStream bb) {
            if (level <= 0) {
                return;
            }
            if (obj == null) {
                bb.append("$Lnull");
                return;
            }
            PdfIndirectReference reference = null;
            ByteBufferOutputStream savedBb = null;
            PdfDocument.IndirectRefDescription indRefKey = null;
            if (obj.isIndirectReference()) {
                reference = (PdfIndirectReference)obj;
                indRefKey = new PdfDocument.IndirectRefDescription(reference);
                byte[] cached = this.objToSerializedContent.get(indRefKey);
                if (cached != null) {
                    bb.append(cached);
                    return;
                }
                savedBb = bb;
                bb = new ByteBufferOutputStream();
                obj = reference.getRefersTo();
            }
            if (obj.isStream()) {
                bb.append("$B");
                this.serDic((PdfDictionary)obj, level - 1, bb);
                if (level > 0) {
                    this.md5.reset();
                    bb.append(this.md5.digest(((PdfStream)obj).getBytes(false)));
                }
            } else if (obj.isDictionary()) {
                this.serDic((PdfDictionary)obj, level - 1, bb);
            } else if (obj.isArray()) {
                this.serArray((PdfArray)obj, level - 1, bb);
            } else if (obj.isString()) {
                bb.append("$S").append(obj.toString());
            } else if (obj.isName()) {
                bb.append("$N").append(obj.toString());
            } else {
                bb.append("$L").append(obj.toString());
            }
            if (savedBb != null) {
                this.objToSerializedContent.put(indRefKey, bb.getBuffer());
                savedBb.append(bb);
            }
        }

        private void serDic(PdfDictionary dic, int level, ByteBufferOutputStream bb) {
            bb.append("$D");
            if (level <= 0) {
                return;
            }
            Object[] keys = new PdfName[dic.keySet().size()];
            keys = dic.keySet().toArray(keys);
            Arrays.sort(keys);
            for (Object key : keys) {
                if (key.equals(PdfName.P) && (dic.get((PdfName)key).isIndirectReference() || dic.get((PdfName)key).isDictionary()) || key.equals(PdfName.Parent)) continue;
                this.serObject((PdfObject)key, level, bb);
                this.serObject(dic.get((PdfName)key, false), level, bb);
            }
        }

        private void serArray(PdfArray array, int level, ByteBufferOutputStream bb) {
            bb.append("$A");
            if (level <= 0) {
                return;
            }
            for (int k = 0; k < array.size(); ++k) {
                this.serObject(array.get(k, false), level, bb);
            }
        }

        private static int calculateHash(byte[] b) {
            int hash = 0;
            int len = b.length;
            for (int k = 0; k < len; ++k) {
                hash = hash * 31 + (b[k] & 0xFF);
            }
            return hash;
        }

        public boolean equals(Object obj) {
            return obj instanceof SerializedPdfObject && this.hashCode() == obj.hashCode() && Arrays.equals(this.serializedContent, ((SerializedPdfObject)obj).serializedContent);
        }

        public int hashCode() {
            return this.hash;
        }
    }
}

