/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.kernel.font;

import com.itextpdf.io.font.CidFont;
import com.itextpdf.io.font.FontProgram;
import com.itextpdf.io.font.FontProgramFactory;
import com.itextpdf.io.font.TrueTypeFont;
import com.itextpdf.io.font.Type1Font;
import com.itextpdf.kernel.PdfException;
import com.itextpdf.kernel.font.PdfFont;
import com.itextpdf.kernel.font.PdfTrueTypeFont;
import com.itextpdf.kernel.font.PdfType0Font;
import com.itextpdf.kernel.font.PdfType1Font;
import com.itextpdf.kernel.font.PdfType3Font;
import com.itextpdf.kernel.pdf.PdfDictionary;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.PdfObject;
import java.io.IOException;
import java.util.Set;

public final class PdfFontFactory {
    private static final String DEFAULT_ENCODING = "";
    private static final EmbeddingStrategy DEFAULT_EMBEDDING = EmbeddingStrategy.PREFER_NOT_EMBEDDED;
    private static final boolean DEFAULT_CACHED = true;

    public static PdfFont createFont() throws IOException {
        return PdfFontFactory.createFont("Helvetica", DEFAULT_ENCODING);
    }

    public static PdfFont createFont(PdfDictionary fontDictionary) {
        if (fontDictionary == null) {
            throw new PdfException("Cannot create font from null pdf dictionary.");
        }
        PdfObject subtypeObject = fontDictionary.get(PdfName.Subtype);
        if (PdfName.Type1.equals(subtypeObject)) {
            return new PdfType1Font(fontDictionary);
        }
        if (PdfName.Type0.equals(subtypeObject)) {
            return new PdfType0Font(fontDictionary);
        }
        if (PdfName.TrueType.equals(subtypeObject)) {
            return new PdfTrueTypeFont(fontDictionary);
        }
        if (PdfName.Type3.equals(subtypeObject)) {
            return new PdfType3Font(fontDictionary);
        }
        if (PdfName.MMType1.equals(subtypeObject)) {
            return new PdfType1Font(fontDictionary);
        }
        throw new PdfException("Dictionary doesn't have supported font data.");
    }

    public static PdfFont createFont(String fontProgram, String encoding, PdfDocument cacheTo) throws IOException {
        if (cacheTo == null) {
            return PdfFontFactory.createFont(fontProgram, encoding);
        }
        PdfFont pdfFont = cacheTo.findFont(fontProgram, encoding);
        if (pdfFont == null && (pdfFont = PdfFontFactory.createFont(fontProgram, encoding)) != null) {
            pdfFont.makeIndirect(cacheTo);
        }
        return pdfFont;
    }

    public static PdfFont createFont(String fontProgram) throws IOException {
        return PdfFontFactory.createFont(fontProgram, DEFAULT_ENCODING);
    }

    public static PdfFont createFont(String fontProgram, String encoding) throws IOException {
        return PdfFontFactory.createFont(fontProgram, encoding, DEFAULT_EMBEDDING);
    }

    @Deprecated
    public static PdfFont createFont(String fontProgram, boolean embedded) throws IOException {
        return PdfFontFactory.createFont(fontProgram, PdfFontFactory.getEmbeddingStrategy(embedded));
    }

    @Deprecated
    public static PdfFont createFont(String fontProgram, String encoding, boolean embedded) throws IOException {
        return PdfFontFactory.createFont(fontProgram, encoding, PdfFontFactory.getEmbeddingStrategy(embedded));
    }

    @Deprecated
    public static PdfFont createFont(String fontProgram, String encoding, boolean embedded, boolean cached) throws IOException {
        return PdfFontFactory.createFont(fontProgram, encoding, PdfFontFactory.getEmbeddingStrategy(embedded), cached);
    }

    @Deprecated
    public static PdfFont createFont(FontProgram fontProgram, String encoding, boolean embedded) {
        return PdfFontFactory.createFont(fontProgram, encoding, PdfFontFactory.getEmbeddingStrategy(embedded));
    }

    public static PdfFont createFont(String fontProgram, EmbeddingStrategy embeddingStrategy) throws IOException {
        return PdfFontFactory.createFont(fontProgram, DEFAULT_ENCODING, embeddingStrategy);
    }

    public static PdfFont createFont(String fontProgram, String encoding, EmbeddingStrategy embeddingStrategy) throws IOException {
        return PdfFontFactory.createFont(fontProgram, encoding, embeddingStrategy, true);
    }

    public static PdfFont createFont(String fontProgram, String encoding, EmbeddingStrategy embeddingStrategy, boolean cached) throws IOException {
        FontProgram fp = FontProgramFactory.createFont((String)fontProgram, (boolean)cached);
        return PdfFontFactory.createFont(fp, encoding, embeddingStrategy);
    }

    public static PdfFont createFont(FontProgram fontProgram, String encoding, EmbeddingStrategy embeddingStrategy) {
        if (fontProgram == null) {
            return null;
        }
        if (fontProgram instanceof Type1Font) {
            return PdfFontFactory.createFontFromType1FontProgram((Type1Font)fontProgram, encoding, embeddingStrategy);
        }
        if (fontProgram instanceof TrueTypeFont) {
            if ("Identity-H".equals(encoding) || "Identity-V".equals(encoding)) {
                return PdfFontFactory.createType0FontFromTrueTypeFontProgram((TrueTypeFont)fontProgram, encoding, embeddingStrategy);
            }
            return PdfFontFactory.createTrueTypeFontFromTrueTypeFontProgram((TrueTypeFont)fontProgram, encoding, embeddingStrategy);
        }
        if (fontProgram instanceof CidFont) {
            return PdfFontFactory.createType0FontFromCidFontProgram((CidFont)fontProgram, encoding, embeddingStrategy);
        }
        return null;
    }

    public static PdfFont createFont(FontProgram fontProgram, String encoding) {
        return PdfFontFactory.createFont(fontProgram, encoding, DEFAULT_EMBEDDING);
    }

    public static PdfFont createFont(FontProgram fontProgram) {
        return PdfFontFactory.createFont(fontProgram, DEFAULT_ENCODING);
    }

    public static PdfFont createFont(byte[] fontProgram, String encoding) throws IOException {
        return PdfFontFactory.createFont(fontProgram, encoding, DEFAULT_EMBEDDING);
    }

    @Deprecated
    public static PdfFont createFont(byte[] fontProgram, boolean embedded) throws IOException {
        return PdfFontFactory.createFont(fontProgram, PdfFontFactory.getEmbeddingStrategy(embedded));
    }

    @Deprecated
    public static PdfFont createFont(byte[] fontProgram, String encoding, boolean embedded) throws IOException {
        return PdfFontFactory.createFont(fontProgram, encoding, PdfFontFactory.getEmbeddingStrategy(embedded));
    }

    @Deprecated
    public static PdfFont createFont(byte[] fontProgram, String encoding, boolean embedded, boolean cached) throws IOException {
        return PdfFontFactory.createFont(fontProgram, encoding, PdfFontFactory.getEmbeddingStrategy(embedded), cached);
    }

    public static PdfFont createFont(byte[] fontProgram, EmbeddingStrategy embeddingStrategy) throws IOException {
        return PdfFontFactory.createFont(fontProgram, DEFAULT_ENCODING, embeddingStrategy);
    }

    public static PdfFont createFont(byte[] fontProgram, String encoding, EmbeddingStrategy embeddingStrategy) throws IOException {
        return PdfFontFactory.createFont(fontProgram, encoding, embeddingStrategy, true);
    }

    public static PdfFont createFont(byte[] fontProgram, String encoding, EmbeddingStrategy embeddingStrategy, boolean cached) throws IOException {
        FontProgram fp = FontProgramFactory.createFont((byte[])fontProgram, (boolean)cached);
        return PdfFontFactory.createFont(fp, encoding, embeddingStrategy);
    }

    @Deprecated
    public static PdfFont createTtcFont(byte[] ttc, int ttcIndex, String encoding, boolean embedded, boolean cached) throws IOException {
        return PdfFontFactory.createTtcFont(ttc, ttcIndex, encoding, PdfFontFactory.getEmbeddingStrategy(embedded), cached);
    }

    @Deprecated
    public static PdfFont createTtcFont(String ttc, int ttcIndex, String encoding, boolean embedded, boolean cached) throws IOException {
        return PdfFontFactory.createTtcFont(ttc, ttcIndex, encoding, PdfFontFactory.getEmbeddingStrategy(embedded), cached);
    }

    public static PdfFont createTtcFont(byte[] ttc, int ttcIndex, String encoding, EmbeddingStrategy embeddingStrategy, boolean cached) throws IOException {
        FontProgram fontProgram = FontProgramFactory.createFont((byte[])ttc, (int)ttcIndex, (boolean)cached);
        return PdfFontFactory.createFont(fontProgram, encoding, embeddingStrategy);
    }

    public static PdfFont createTtcFont(String ttc, int ttcIndex, String encoding, EmbeddingStrategy embeddingStrategy, boolean cached) throws IOException {
        FontProgram fontProgram = FontProgramFactory.createFont((String)ttc, (int)ttcIndex, (boolean)cached);
        return PdfFontFactory.createFont(fontProgram, encoding, embeddingStrategy);
    }

    public static PdfType3Font createType3Font(PdfDocument document, boolean colorized) {
        return new PdfType3Font(document, colorized);
    }

    public static PdfType3Font createType3Font(PdfDocument document, String fontName, String fontFamily, boolean colorized) {
        return new PdfType3Font(document, fontName, fontFamily, colorized);
    }

    @Deprecated
    public static PdfFont createRegisteredFont(String fontName, String encoding, boolean embedded, int style, boolean cached) throws IOException {
        return PdfFontFactory.createRegisteredFont(fontName, encoding, PdfFontFactory.getEmbeddingStrategy(embedded), style, cached);
    }

    @Deprecated
    public static PdfFont createRegisteredFont(String fontName, String encoding, boolean embedded, boolean cached) throws IOException {
        return PdfFontFactory.createRegisteredFont(fontName, encoding, PdfFontFactory.getEmbeddingStrategy(embedded), cached);
    }

    @Deprecated
    public static PdfFont createRegisteredFont(String fontName, String encoding, boolean embedded) throws IOException {
        return PdfFontFactory.createRegisteredFont(fontName, encoding, PdfFontFactory.getEmbeddingStrategy(embedded));
    }

    @Deprecated
    public static PdfFont createRegisteredFont(String fontName, String encoding, boolean embedded, int style) throws IOException {
        return PdfFontFactory.createRegisteredFont(fontName, encoding, PdfFontFactory.getEmbeddingStrategy(embedded), style);
    }

    public static PdfFont createRegisteredFont(String fontName, String encoding, EmbeddingStrategy embeddingStrategy, int style, boolean cached) throws IOException {
        FontProgram fp = FontProgramFactory.createRegisteredFont((String)fontName, (int)style, (boolean)cached);
        return PdfFontFactory.createFont(fp, encoding, embeddingStrategy);
    }

    public static PdfFont createRegisteredFont(String fontName, String encoding, EmbeddingStrategy embeddingStrategy, boolean cached) throws IOException {
        return PdfFontFactory.createRegisteredFont(fontName, encoding, embeddingStrategy, -1, cached);
    }

    public static PdfFont createRegisteredFont(String fontName, String encoding, EmbeddingStrategy embeddingStrategy) throws IOException {
        return PdfFontFactory.createRegisteredFont(fontName, encoding, embeddingStrategy, -1);
    }

    public static PdfFont createRegisteredFont(String fontName, String encoding, EmbeddingStrategy embeddingStrategy, int style) throws IOException {
        return PdfFontFactory.createRegisteredFont(fontName, encoding, embeddingStrategy, style, true);
    }

    public static PdfFont createRegisteredFont(String fontName, String encoding) throws IOException {
        return PdfFontFactory.createRegisteredFont(fontName, encoding, DEFAULT_EMBEDDING);
    }

    public static PdfFont createRegisteredFont(String fontName) throws IOException {
        return PdfFontFactory.createRegisteredFont(fontName, DEFAULT_ENCODING);
    }

    public static void registerFamily(String familyName, String fullName, String path) {
        FontProgramFactory.registerFontFamily((String)familyName, (String)fullName, (String)path);
    }

    public static void register(String path) {
        PdfFontFactory.register(path, null);
    }

    public static void register(String path, String alias) {
        FontProgramFactory.registerFont((String)path, (String)alias);
    }

    public static int registerDirectory(String dirPath) {
        return FontProgramFactory.registerFontDirectory((String)dirPath);
    }

    public static int registerSystemDirectories() {
        return FontProgramFactory.registerSystemFontDirectories();
    }

    public static Set<String> getRegisteredFonts() {
        return FontProgramFactory.getRegisteredFonts();
    }

    public static Set<String> getRegisteredFamilies() {
        return FontProgramFactory.getRegisteredFontFamilies();
    }

    public static boolean isRegistered(String fontName) {
        return FontProgramFactory.isRegisteredFont((String)fontName);
    }

    private static PdfType1Font createFontFromType1FontProgram(Type1Font fontProgram, String encoding, EmbeddingStrategy embeddingStrategy) {
        boolean embedded;
        switch (embeddingStrategy) {
            case FORCE_EMBEDDED: {
                if (fontProgram.isBuiltInFont()) {
                    throw new PdfException("Standard fonts cannot be embedded.");
                }
                embedded = true;
                break;
            }
            case PREFER_EMBEDDED: {
                embedded = !fontProgram.isBuiltInFont();
                break;
            }
            case PREFER_NOT_EMBEDDED: 
            case FORCE_NOT_EMBEDDED: {
                embedded = false;
                break;
            }
            default: {
                throw new PdfException("Unsupported font embedding strategy.");
            }
        }
        return new PdfType1Font(fontProgram, encoding, embedded);
    }

    private static PdfType0Font createType0FontFromTrueTypeFontProgram(TrueTypeFont fontProgram, String encoding, EmbeddingStrategy embeddingStrategy) {
        if (!fontProgram.getFontNames().allowEmbedding()) {
            throw new PdfException("{0} cannot be embedded due to licensing restrictions.").setMessageParams(fontProgram.getFontNames().getFontName() + fontProgram.getFontNames().getStyle());
        }
        switch (embeddingStrategy) {
            case FORCE_EMBEDDED: 
            case PREFER_EMBEDDED: 
            case PREFER_NOT_EMBEDDED: {
                return new PdfType0Font(fontProgram, encoding);
            }
            case FORCE_NOT_EMBEDDED: {
                throw new PdfException("Cannot create Type0 font with true type font program without embedding it.");
            }
        }
        throw new PdfException("Unsupported font embedding strategy.");
    }

    private static PdfTrueTypeFont createTrueTypeFontFromTrueTypeFontProgram(TrueTypeFont fontProgram, String encoding, EmbeddingStrategy embeddingStrategy) {
        boolean embedded;
        switch (embeddingStrategy) {
            case FORCE_EMBEDDED: {
                if (!fontProgram.getFontNames().allowEmbedding()) {
                    throw new PdfException("{0} cannot be embedded due to licensing restrictions.").setMessageParams(fontProgram.getFontNames().getFontName() + fontProgram.getFontNames().getStyle());
                }
                embedded = true;
                break;
            }
            case PREFER_EMBEDDED: {
                embedded = fontProgram.getFontNames().allowEmbedding();
                break;
            }
            case PREFER_NOT_EMBEDDED: 
            case FORCE_NOT_EMBEDDED: {
                embedded = false;
                break;
            }
            default: {
                throw new PdfException("Unsupported font embedding strategy.");
            }
        }
        return new PdfTrueTypeFont(fontProgram, encoding, embedded);
    }

    private static PdfType0Font createType0FontFromCidFontProgram(CidFont fontProgram, String encoding, EmbeddingStrategy embeddingStrategy) {
        if (!fontProgram.compatibleWith(encoding)) {
            return null;
        }
        switch (embeddingStrategy) {
            case FORCE_EMBEDDED: {
                throw new PdfException("Cannot embed Type0 font with CID font program based on non-generic predefined CMap.");
            }
            case PREFER_EMBEDDED: 
            case PREFER_NOT_EMBEDDED: 
            case FORCE_NOT_EMBEDDED: {
                return new PdfType0Font(fontProgram, encoding);
            }
        }
        throw new PdfException("Unsupported font embedding strategy.");
    }

    private static EmbeddingStrategy getEmbeddingStrategy(boolean embedded) {
        return embedded ? EmbeddingStrategy.PREFER_EMBEDDED : EmbeddingStrategy.PREFER_NOT_EMBEDDED;
    }

    public static enum EmbeddingStrategy {
        FORCE_EMBEDDED,
        FORCE_NOT_EMBEDDED,
        PREFER_EMBEDDED,
        PREFER_NOT_EMBEDDED;

    }
}

