/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.kernel.pdf.annot;

import com.itextpdf.kernel.colors.Color;
import com.itextpdf.kernel.geom.Rectangle;
import com.itextpdf.kernel.pdf.PdfArray;
import com.itextpdf.kernel.pdf.PdfDictionary;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.annot.BorderStyleUtil;
import com.itextpdf.kernel.pdf.annot.InteriorColorUtil;
import com.itextpdf.kernel.pdf.annot.PdfMarkupAnnotation;
import com.itextpdf.kernel.pdf.annot.PdfPolygonAnnotation;
import com.itextpdf.kernel.pdf.annot.PdfPolylineAnnotation;
import org.slf4j.LoggerFactory;

public abstract class PdfPolyGeomAnnotation
extends PdfMarkupAnnotation {
    private static final long serialVersionUID = -9038993253308315792L;
    @Deprecated
    public static final PdfName Polygon = PdfName.Polygon;
    @Deprecated
    public static final PdfName PolyLine = PdfName.PolyLine;

    PdfPolyGeomAnnotation(Rectangle rect, float[] vertices) {
        super(rect);
        this.setVertices(vertices);
    }

    protected PdfPolyGeomAnnotation(PdfDictionary pdfObject) {
        super(pdfObject);
    }

    public static PdfPolyGeomAnnotation createPolygon(Rectangle rect, float[] vertices) {
        return new PdfPolygonAnnotation(rect, vertices);
    }

    public static PdfPolyGeomAnnotation createPolyLine(Rectangle rect, float[] vertices) {
        return new PdfPolylineAnnotation(rect, vertices);
    }

    public PdfArray getVertices() {
        return ((PdfDictionary)this.getPdfObject()).getAsArray(PdfName.Vertices);
    }

    public PdfPolyGeomAnnotation setVertices(PdfArray vertices) {
        if (((PdfDictionary)this.getPdfObject()).containsKey(PdfName.Path)) {
            LoggerFactory.getLogger(this.getClass()).warn("Path key is present. Vertices will be ignored");
        }
        return (PdfPolyGeomAnnotation)this.put(PdfName.Vertices, vertices);
    }

    public PdfPolyGeomAnnotation setVertices(float[] vertices) {
        if (((PdfDictionary)this.getPdfObject()).containsKey(PdfName.Path)) {
            LoggerFactory.getLogger(this.getClass()).warn("Path key is present. Vertices will be ignored");
        }
        return (PdfPolyGeomAnnotation)this.put(PdfName.Vertices, new PdfArray(vertices));
    }

    public PdfArray getLineEndingStyles() {
        return ((PdfDictionary)this.getPdfObject()).getAsArray(PdfName.LE);
    }

    public PdfPolyGeomAnnotation setLineEndingStyles(PdfArray lineEndingStyles) {
        return (PdfPolyGeomAnnotation)this.put(PdfName.LE, lineEndingStyles);
    }

    public PdfDictionary getMeasure() {
        return ((PdfDictionary)this.getPdfObject()).getAsDictionary(PdfName.Measure);
    }

    public PdfPolyGeomAnnotation setMeasure(PdfDictionary measure) {
        return (PdfPolyGeomAnnotation)this.put(PdfName.Measure, measure);
    }

    public PdfArray getPath() {
        return ((PdfDictionary)this.getPdfObject()).getAsArray(PdfName.Path);
    }

    public PdfPolyGeomAnnotation setPath(PdfArray path) {
        if (((PdfDictionary)this.getPdfObject()).containsKey(PdfName.Vertices)) {
            LoggerFactory.getLogger(this.getClass()).error("If Path key is set, Vertices key shall not be present. Remove Vertices key before setting Path");
        }
        return (PdfPolyGeomAnnotation)this.put(PdfName.Path, path);
    }

    public PdfDictionary getBorderStyle() {
        return ((PdfDictionary)this.getPdfObject()).getAsDictionary(PdfName.BS);
    }

    public PdfPolyGeomAnnotation setBorderStyle(PdfDictionary borderStyle) {
        return (PdfPolyGeomAnnotation)this.put(PdfName.BS, borderStyle);
    }

    public PdfPolyGeomAnnotation setBorderStyle(PdfName style) {
        return this.setBorderStyle(BorderStyleUtil.setStyle(this.getBorderStyle(), style));
    }

    public PdfPolyGeomAnnotation setDashPattern(PdfArray dashPattern) {
        return this.setBorderStyle(BorderStyleUtil.setDashPattern(this.getBorderStyle(), dashPattern));
    }

    public PdfDictionary getBorderEffect() {
        return ((PdfDictionary)this.getPdfObject()).getAsDictionary(PdfName.BE);
    }

    public PdfPolyGeomAnnotation setBorderEffect(PdfDictionary borderEffect) {
        return (PdfPolyGeomAnnotation)this.put(PdfName.BE, borderEffect);
    }

    public Color getInteriorColor() {
        return InteriorColorUtil.parseInteriorColor(((PdfDictionary)this.getPdfObject()).getAsArray(PdfName.IC));
    }

    public PdfPolyGeomAnnotation setInteriorColor(PdfArray interiorColor) {
        return (PdfPolyGeomAnnotation)this.put(PdfName.IC, interiorColor);
    }

    public PdfPolyGeomAnnotation setInteriorColor(float[] interiorColor) {
        return this.setInteriorColor(new PdfArray(interiorColor));
    }
}

