/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.kernel.colors;

import com.itextpdf.kernel.colors.Color;
import com.itextpdf.kernel.pdf.colorspace.PdfDeviceCs;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeviceGray
extends Color {
    public static final DeviceGray WHITE = new DeviceGray(1.0f);
    public static final DeviceGray GRAY = new DeviceGray(0.5f);
    public static final DeviceGray BLACK = new DeviceGray();
    private static final long serialVersionUID = 8307729543359242834L;

    public DeviceGray(float value) {
        super(new PdfDeviceCs.Gray(), new float[]{value > 1.0f ? 1.0f : (value > 0.0f ? value : 0.0f)});
        if (value > 1.0f || value < 0.0f) {
            Logger LOGGER = LoggerFactory.getLogger(DeviceGray.class);
            LOGGER.warn("Some of colorant intensities are invalid: they are bigger than 1 or less than 0. We will force them to become 1 or 0 respectively.");
        }
    }

    public DeviceGray() {
        this(0.0f);
    }

    public static DeviceGray makeLighter(DeviceGray grayColor) {
        float v = grayColor.getColorValue()[0];
        if (v == 0.0f) {
            return new DeviceGray(0.3f);
        }
        float multiplier = Math.min(1.0f, v + 0.33f) / v;
        return new DeviceGray(v * multiplier);
    }

    public static DeviceGray makeDarker(DeviceGray grayColor) {
        float v = grayColor.getColorValue()[0];
        float multiplier = Math.max(0.0f, (v - 0.33f) / v);
        return new DeviceGray(v * multiplier);
    }
}

