/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.kernel.pdf;

import com.itextpdf.io.source.ByteUtils;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.PdfObject;
import com.itextpdf.kernel.pdf.PdfPrimitiveObject;
import java.nio.charset.StandardCharsets;

public class PdfNumber
extends PdfPrimitiveObject {
    private double value;
    private boolean isDouble;

    public PdfNumber(double value) {
        this.setValue(value);
    }

    public PdfNumber(int value) {
        this.setValue(value);
    }

    public PdfNumber(byte[] content) {
        super(content);
        this.isDouble = true;
        this.value = Double.NaN;
    }

    private PdfNumber() {
    }

    @Override
    public byte getType() {
        return 8;
    }

    public double getValue() {
        if (Double.isNaN(this.value)) {
            this.generateValue();
        }
        return this.value;
    }

    public double doubleValue() {
        return this.getValue();
    }

    public float floatValue() {
        return (float)this.getValue();
    }

    public long longValue() {
        return (long)this.getValue();
    }

    public int intValue() {
        if (this.getValue() > 2.147483647E9) {
            return Integer.MAX_VALUE;
        }
        return (int)this.getValue();
    }

    public void setValue(int value) {
        this.value = value;
        this.isDouble = false;
        this.content = null;
    }

    public void setValue(double value) {
        this.value = value;
        this.isDouble = true;
        this.content = null;
    }

    public void increment() {
        this.setValue(this.value += 1.0);
    }

    public void decrement() {
        this.setValue(this.value -= 1.0);
    }

    public String toString() {
        if (this.content != null) {
            return new String(this.content, StandardCharsets.ISO_8859_1);
        }
        if (this.isDouble) {
            return new String(ByteUtils.getIsoBytes((double)this.getValue()), StandardCharsets.ISO_8859_1);
        }
        return new String(ByteUtils.getIsoBytes((int)this.intValue()), StandardCharsets.ISO_8859_1);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return Double.compare(((PdfNumber)o).getValue(), this.getValue()) == 0;
    }

    public boolean hasDecimalPoint() {
        return this.toString().contains(".");
    }

    public int hashCode() {
        long hash = Double.doubleToLongBits(this.getValue());
        return (int)(hash ^ hash >>> 32);
    }

    @Override
    protected PdfObject newInstance() {
        return new PdfNumber();
    }

    protected boolean isDoubleNumber() {
        return this.isDouble;
    }

    @Override
    protected void generateContent() {
        this.content = this.isDouble ? ByteUtils.getIsoBytes((double)this.value) : ByteUtils.getIsoBytes((int)((int)this.value));
    }

    protected void generateValue() {
        try {
            this.value = Double.parseDouble(new String(this.content, StandardCharsets.ISO_8859_1));
        }
        catch (NumberFormatException e) {
            this.value = Double.NaN;
        }
        this.isDouble = true;
    }

    @Override
    protected void copyContent(PdfObject from, PdfDocument document) {
        super.copyContent(from, document);
        PdfNumber number = (PdfNumber)from;
        this.value = number.value;
        this.isDouble = number.isDouble;
    }
}

