/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.kernel.pdf.annot;

import com.itextpdf.kernel.colors.Color;
import com.itextpdf.kernel.geom.Rectangle;
import com.itextpdf.kernel.pdf.PdfAnnotationBorder;
import com.itextpdf.kernel.pdf.PdfArray;
import com.itextpdf.kernel.pdf.PdfDictionary;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.PdfIndirectReference;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.PdfNumber;
import com.itextpdf.kernel.pdf.PdfObject;
import com.itextpdf.kernel.pdf.PdfObjectWrapper;
import com.itextpdf.kernel.pdf.PdfPage;
import com.itextpdf.kernel.pdf.PdfString;
import com.itextpdf.kernel.pdf.annot.Pdf3DAnnotation;
import com.itextpdf.kernel.pdf.annot.PdfAnnotationAppearance;
import com.itextpdf.kernel.pdf.annot.PdfCaretAnnotation;
import com.itextpdf.kernel.pdf.annot.PdfCircleAnnotation;
import com.itextpdf.kernel.pdf.annot.PdfFileAttachmentAnnotation;
import com.itextpdf.kernel.pdf.annot.PdfFreeTextAnnotation;
import com.itextpdf.kernel.pdf.annot.PdfInkAnnotation;
import com.itextpdf.kernel.pdf.annot.PdfLineAnnotation;
import com.itextpdf.kernel.pdf.annot.PdfLinkAnnotation;
import com.itextpdf.kernel.pdf.annot.PdfPolygonAnnotation;
import com.itextpdf.kernel.pdf.annot.PdfPolylineAnnotation;
import com.itextpdf.kernel.pdf.annot.PdfPopupAnnotation;
import com.itextpdf.kernel.pdf.annot.PdfPrinterMarkAnnotation;
import com.itextpdf.kernel.pdf.annot.PdfRedactAnnotation;
import com.itextpdf.kernel.pdf.annot.PdfScreenAnnotation;
import com.itextpdf.kernel.pdf.annot.PdfSoundAnnotation;
import com.itextpdf.kernel.pdf.annot.PdfSquareAnnotation;
import com.itextpdf.kernel.pdf.annot.PdfStampAnnotation;
import com.itextpdf.kernel.pdf.annot.PdfTextAnnotation;
import com.itextpdf.kernel.pdf.annot.PdfTextMarkupAnnotation;
import com.itextpdf.kernel.pdf.annot.PdfTrapNetworkAnnotation;
import com.itextpdf.kernel.pdf.annot.PdfWatermarkAnnotation;
import com.itextpdf.kernel.pdf.annot.PdfWidgetAnnotation;
import com.itextpdf.kernel.pdf.filespec.PdfFileSpec;
import com.itextpdf.kernel.pdf.layer.IPdfOCG;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PdfAnnotation
extends PdfObjectWrapper<PdfDictionary> {
    public static final int INVISIBLE = 1;
    public static final int HIDDEN = 2;
    public static final int PRINT = 4;
    public static final int NO_ZOOM = 8;
    public static final int NO_ROTATE = 16;
    public static final int NO_VIEW = 32;
    public static final int READ_ONLY = 64;
    public static final int LOCKED = 128;
    public static final int TOGGLE_NO_VIEW = 256;
    public static final int LOCKED_CONTENTS = 512;
    public static final PdfName HIGHLIGHT_NONE = PdfName.N;
    public static final PdfName HIGHLIGHT_INVERT = PdfName.I;
    public static final PdfName HIGHLIGHT_OUTLINE = PdfName.O;
    public static final PdfName HIGHLIGHT_PUSH = PdfName.P;
    public static final PdfName HIGHLIGHT_TOGGLE = PdfName.T;
    public static final PdfName STYLE_SOLID = PdfName.S;
    public static final PdfName STYLE_DASHED = PdfName.D;
    public static final PdfName STYLE_BEVELED = PdfName.B;
    public static final PdfName STYLE_INSET = PdfName.I;
    public static final PdfName STYLE_UNDERLINE = PdfName.U;
    public static final PdfString Marked = new PdfString("Marked");
    public static final PdfString Unmarked = new PdfString("Unmarked");
    public static final PdfString Accepted = new PdfString("Accepted");
    public static final PdfString Rejected = new PdfString("Rejected");
    public static final PdfString Canceled = new PdfString("Cancelled");
    public static final PdfString Completed = new PdfString("Completed");
    public static final PdfString None = new PdfString("None");
    public static final PdfString MarkedModel = new PdfString("Marked");
    public static final PdfString ReviewModel = new PdfString("Review");
    protected PdfPage page;

    public static PdfAnnotation makeAnnotation(PdfObject pdfObject) {
        PdfAnnotation annotation = null;
        if (pdfObject.isIndirectReference()) {
            pdfObject = ((PdfIndirectReference)pdfObject).getRefersTo();
        }
        if (pdfObject.isDictionary()) {
            PdfDictionary dictionary = (PdfDictionary)pdfObject;
            PdfName subtype = dictionary.getAsName(PdfName.Subtype);
            annotation = PdfName.Link.equals(subtype) ? new PdfLinkAnnotation((PdfDictionary)pdfObject) : (PdfName.Popup.equals(subtype) ? new PdfPopupAnnotation((PdfDictionary)pdfObject) : (PdfName.Widget.equals(subtype) ? new PdfWidgetAnnotation((PdfDictionary)pdfObject) : (PdfName.Screen.equals(subtype) ? new PdfScreenAnnotation((PdfDictionary)pdfObject) : (PdfName._3D.equals(subtype) ? new Pdf3DAnnotation((PdfDictionary)pdfObject) : (PdfName.Highlight.equals(subtype) || PdfName.Underline.equals(subtype) || PdfName.Squiggly.equals(subtype) || PdfName.StrikeOut.equals(subtype) ? new PdfTextMarkupAnnotation((PdfDictionary)pdfObject) : (PdfName.Caret.equals(subtype) ? new PdfCaretAnnotation((PdfDictionary)pdfObject) : (PdfName.Text.equals(subtype) ? new PdfTextAnnotation((PdfDictionary)pdfObject) : (PdfName.Sound.equals(subtype) ? new PdfSoundAnnotation((PdfDictionary)pdfObject) : (PdfName.Stamp.equals(subtype) ? new PdfStampAnnotation((PdfDictionary)pdfObject) : (PdfName.FileAttachment.equals(subtype) ? new PdfFileAttachmentAnnotation((PdfDictionary)pdfObject) : (PdfName.Ink.equals(subtype) ? new PdfInkAnnotation((PdfDictionary)pdfObject) : (PdfName.PrinterMark.equals(subtype) ? new PdfPrinterMarkAnnotation((PdfDictionary)pdfObject) : (PdfName.TrapNet.equals(subtype) ? new PdfTrapNetworkAnnotation((PdfDictionary)pdfObject) : (PdfName.FreeText.equals(subtype) ? new PdfFreeTextAnnotation((PdfDictionary)pdfObject) : (PdfName.Square.equals(subtype) ? new PdfSquareAnnotation((PdfDictionary)pdfObject) : (PdfName.Circle.equals(subtype) ? new PdfCircleAnnotation((PdfDictionary)pdfObject) : (PdfName.Line.equals(subtype) ? new PdfLineAnnotation((PdfDictionary)pdfObject) : (PdfName.Polygon.equals(subtype) ? new PdfPolygonAnnotation((PdfDictionary)pdfObject) : (PdfName.PolyLine.equals(subtype) ? new PdfPolylineAnnotation((PdfDictionary)pdfObject) : (PdfName.Redact.equals(subtype) ? new PdfRedactAnnotation((PdfDictionary)pdfObject) : (PdfName.Watermark.equals(subtype) ? new PdfWatermarkAnnotation((PdfDictionary)pdfObject) : new PdfUnknownAnnotation((PdfDictionary)pdfObject))))))))))))))))))))));
        }
        return annotation;
    }

    protected PdfAnnotation(Rectangle rect) {
        this(new PdfDictionary());
        this.put(PdfName.Rect, new PdfArray(rect));
        this.put(PdfName.Subtype, this.getSubtype());
    }

    protected PdfAnnotation(PdfDictionary pdfObject) {
        super(pdfObject);
        PdfAnnotation.markObjectAsIndirect(this.getPdfObject());
    }

    public abstract PdfName getSubtype();

    public void setLayer(IPdfOCG layer) {
        ((PdfDictionary)this.getPdfObject()).put(PdfName.OC, layer.getIndirectReference());
    }

    public PdfString getContents() {
        return ((PdfDictionary)this.getPdfObject()).getAsString(PdfName.Contents);
    }

    public PdfAnnotation setContents(PdfString contents) {
        return this.put(PdfName.Contents, contents);
    }

    public PdfAnnotation setContents(String contents) {
        return this.setContents(new PdfString(contents, "UnicodeBig"));
    }

    public PdfDictionary getPageObject() {
        return ((PdfDictionary)this.getPdfObject()).getAsDictionary(PdfName.P);
    }

    public PdfPage getPage() {
        PdfIndirectReference annotationIndirectReference;
        if (this.page == null && (annotationIndirectReference = ((PdfDictionary)this.getPdfObject()).getIndirectReference()) != null) {
            PdfDocument doc = annotationIndirectReference.getDocument();
            PdfDictionary pageDictionary = this.getPageObject();
            if (pageDictionary != null) {
                this.page = doc.getPage(pageDictionary);
            } else {
                block0: for (int i = 1; i <= doc.getNumberOfPages(); ++i) {
                    PdfPage docPage = doc.getPage(i);
                    if (docPage.isFlushed()) continue;
                    for (PdfAnnotation annot : docPage.getAnnotations()) {
                        if (!annotationIndirectReference.equals(((PdfDictionary)annot.getPdfObject()).getIndirectReference())) continue;
                        this.page = docPage;
                        continue block0;
                    }
                }
            }
        }
        return this.page;
    }

    public PdfAnnotation setPage(PdfPage page) {
        this.page = page;
        return this.put(PdfName.P, ((PdfDictionary)page.getPdfObject()).getIndirectReference());
    }

    public PdfString getName() {
        return ((PdfDictionary)this.getPdfObject()).getAsString(PdfName.NM);
    }

    public PdfAnnotation setName(PdfString name) {
        return this.put(PdfName.NM, name);
    }

    public PdfString getDate() {
        return ((PdfDictionary)this.getPdfObject()).getAsString(PdfName.M);
    }

    public PdfAnnotation setDate(PdfString date) {
        return this.put(PdfName.M, date);
    }

    public int getFlags() {
        PdfNumber f = ((PdfDictionary)this.getPdfObject()).getAsNumber(PdfName.F);
        if (f != null) {
            return f.intValue();
        }
        return 0;
    }

    public PdfAnnotation setFlags(int flags) {
        return this.put(PdfName.F, new PdfNumber(flags));
    }

    public PdfAnnotation setFlag(int flag) {
        int flags = this.getFlags();
        return this.setFlags(flags |= flag);
    }

    public PdfAnnotation resetFlag(int flag) {
        int flags = this.getFlags();
        return this.setFlags(flags &= ~flag);
    }

    public boolean hasFlag(int flag) {
        if (flag == 0) {
            return false;
        }
        if ((flag & flag - 1) != 0) {
            throw new IllegalArgumentException("Only one flag must be checked at once.");
        }
        int flags = this.getFlags();
        return (flags & flag) != 0;
    }

    public PdfDictionary getAppearanceDictionary() {
        return ((PdfDictionary)this.getPdfObject()).getAsDictionary(PdfName.AP);
    }

    public PdfDictionary getAppearanceObject(PdfName appearanceType) {
        PdfObject apObject;
        PdfDictionary ap = this.getAppearanceDictionary();
        if (ap != null && (apObject = ap.get(appearanceType)) instanceof PdfDictionary) {
            return (PdfDictionary)apObject;
        }
        return null;
    }

    public PdfDictionary getNormalAppearanceObject() {
        return this.getAppearanceObject(PdfName.N);
    }

    public PdfDictionary getRolloverAppearanceObject() {
        return this.getAppearanceObject(PdfName.R);
    }

    public PdfDictionary getDownAppearanceObject() {
        return this.getAppearanceObject(PdfName.D);
    }

    public PdfAnnotation setAppearance(PdfName appearanceType, PdfDictionary appearance) {
        PdfDictionary ap = this.getAppearanceDictionary();
        if (ap == null) {
            ap = new PdfDictionary();
            ((PdfDictionary)this.getPdfObject()).put(PdfName.AP, ap);
        }
        ap.put(appearanceType, appearance);
        return this;
    }

    public PdfAnnotation setNormalAppearance(PdfDictionary appearance) {
        return this.setAppearance(PdfName.N, appearance);
    }

    public PdfAnnotation setRolloverAppearance(PdfDictionary appearance) {
        return this.setAppearance(PdfName.R, appearance);
    }

    public PdfAnnotation setDownAppearance(PdfDictionary appearance) {
        return this.setAppearance(PdfName.D, appearance);
    }

    public PdfAnnotation setAppearance(PdfName appearanceType, PdfAnnotationAppearance appearance) {
        return this.setAppearance(appearanceType, (PdfDictionary)appearance.getPdfObject());
    }

    public PdfAnnotation setNormalAppearance(PdfAnnotationAppearance appearance) {
        return this.setAppearance(PdfName.N, appearance);
    }

    public PdfAnnotation setRolloverAppearance(PdfAnnotationAppearance appearance) {
        return this.setAppearance(PdfName.R, appearance);
    }

    public PdfAnnotation setDownAppearance(PdfAnnotationAppearance appearance) {
        return this.setAppearance(PdfName.D, appearance);
    }

    public PdfName getAppearanceState() {
        return ((PdfDictionary)this.getPdfObject()).getAsName(PdfName.AS);
    }

    public PdfAnnotation setAppearanceState(PdfName as) {
        return this.put(PdfName.AS, as);
    }

    public PdfArray getBorder() {
        return ((PdfDictionary)this.getPdfObject()).getAsArray(PdfName.Border);
    }

    public PdfAnnotation setBorder(PdfAnnotationBorder border) {
        return this.put(PdfName.Border, (PdfObject)border.getPdfObject());
    }

    public PdfAnnotation setBorder(PdfArray border) {
        return this.put(PdfName.Border, border);
    }

    public PdfArray getColorObject() {
        return ((PdfDictionary)this.getPdfObject()).getAsArray(PdfName.C);
    }

    public PdfAnnotation setColor(PdfArray color) {
        return this.put(PdfName.C, color);
    }

    public PdfAnnotation setColor(float[] color) {
        return this.setColor(new PdfArray(color));
    }

    public PdfAnnotation setColor(Color color) {
        return this.setColor(new PdfArray(color.getColorValue()));
    }

    public int getStructParentIndex() {
        PdfNumber n = ((PdfDictionary)this.getPdfObject()).getAsNumber(PdfName.StructParent);
        if (n == null) {
            return -1;
        }
        return n.intValue();
    }

    public PdfAnnotation setStructParentIndex(int structParentIndex) {
        return this.put(PdfName.StructParent, new PdfNumber(structParentIndex));
    }

    public PdfAnnotation setTitle(PdfString title) {
        return this.put(PdfName.T, title);
    }

    public PdfString getTitle() {
        return ((PdfDictionary)this.getPdfObject()).getAsString(PdfName.T);
    }

    public PdfAnnotation setRectangle(PdfArray array) {
        return this.put(PdfName.Rect, array);
    }

    public PdfArray getRectangle() {
        return ((PdfDictionary)this.getPdfObject()).getAsArray(PdfName.Rect);
    }

    public String getLang() {
        PdfString lang = ((PdfDictionary)this.getPdfObject()).getAsString(PdfName.Lang);
        return lang != null ? lang.toUnicodeString() : null;
    }

    public PdfAnnotation setLang(String lang) {
        return this.put(PdfName.Lang, new PdfString(lang, "UnicodeBig"));
    }

    public PdfName getBlendMode() {
        return ((PdfDictionary)this.getPdfObject()).getAsName(PdfName.BM);
    }

    public PdfAnnotation setBlendMode(PdfName blendMode) {
        return this.put(PdfName.BM, blendMode);
    }

    public float getNonStrokingOpacity() {
        PdfNumber nonStrokingOpacity = ((PdfDictionary)this.getPdfObject()).getAsNumber(PdfName.ca);
        return nonStrokingOpacity != null ? nonStrokingOpacity.floatValue() : 1.0f;
    }

    public PdfAnnotation setNonStrokingOpacity(float nonStrokingOpacity) {
        return this.put(PdfName.ca, new PdfNumber(nonStrokingOpacity));
    }

    public float getStrokingOpacity() {
        PdfNumber strokingOpacity = ((PdfDictionary)this.getPdfObject()).getAsNumber(PdfName.CA);
        return strokingOpacity != null ? strokingOpacity.floatValue() : 1.0f;
    }

    public PdfAnnotation setStrokingOpacity(float strokingOpacity) {
        return this.put(PdfName.CA, new PdfNumber(strokingOpacity));
    }

    public PdfAnnotation put(PdfName key, PdfObject value) {
        ((PdfDictionary)this.getPdfObject()).put(key, value);
        this.setModified();
        return this;
    }

    public PdfAnnotation remove(PdfName key) {
        ((PdfDictionary)this.getPdfObject()).remove(key);
        return this;
    }

    public void addAssociatedFile(PdfFileSpec fs) {
        PdfArray afArray;
        if (null == ((PdfDictionary)fs.getPdfObject()).get(PdfName.AFRelationship)) {
            Logger logger = LoggerFactory.getLogger(PdfAnnotation.class);
            logger.error("For associated files their associated file specification dictionaries shall include the AFRelationship key.");
        }
        if ((afArray = ((PdfDictionary)this.getPdfObject()).getAsArray(PdfName.AF)) == null) {
            afArray = new PdfArray();
            this.put(PdfName.AF, afArray);
        }
        afArray.add((PdfObject)fs.getPdfObject());
    }

    public PdfArray getAssociatedFiles(boolean create) {
        PdfArray afArray = ((PdfDictionary)this.getPdfObject()).getAsArray(PdfName.AF);
        if (afArray == null && create) {
            afArray = new PdfArray();
            this.put(PdfName.AF, afArray);
        }
        return afArray;
    }

    @Override
    public void flush() {
        super.flush();
    }

    @Override
    protected boolean isWrappedObjectMustBeIndirect() {
        return true;
    }

    static class PdfUnknownAnnotation
    extends PdfAnnotation {
        protected PdfUnknownAnnotation(PdfDictionary pdfObject) {
            super(pdfObject);
        }

        @Override
        public PdfName getSubtype() {
            return ((PdfDictionary)this.getPdfObject()).getAsName(PdfName.Subtype);
        }
    }
}

