/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.kernel.pdf;

import com.itextpdf.kernel.pdf.MemoryLimitsAwareHandler;
import com.itextpdf.kernel.security.IExternalDecryptionProcess;
import java.security.Key;
import java.security.cert.Certificate;
import java.util.Arrays;

public class ReaderProperties {
    protected byte[] password;
    protected Key certificateKey;
    protected Certificate certificate;
    protected String certificateKeyProvider;
    protected IExternalDecryptionProcess externalDecryptionProcess;
    protected MemoryLimitsAwareHandler memoryLimitsAwareHandler;

    public ReaderProperties() {
    }

    ReaderProperties(ReaderProperties readerProperties) {
        this.password = readerProperties.password == null ? null : Arrays.copyOf(readerProperties.password, readerProperties.password.length);
        this.certificateKey = readerProperties.certificateKey;
        this.certificate = readerProperties.certificate;
        this.certificateKeyProvider = readerProperties.certificateKeyProvider;
        this.externalDecryptionProcess = readerProperties.externalDecryptionProcess;
        this.memoryLimitsAwareHandler = readerProperties.memoryLimitsAwareHandler == null ? null : readerProperties.memoryLimitsAwareHandler.createNewInstance();
    }

    public ReaderProperties setPassword(byte[] password) {
        this.clearEncryptionParams();
        this.password = password;
        return this;
    }

    public ReaderProperties setPublicKeySecurityParams(Certificate certificate, Key certificateKey, String certificateKeyProvider, IExternalDecryptionProcess externalDecryptionProcess) {
        this.clearEncryptionParams();
        this.certificate = certificate;
        this.certificateKey = certificateKey;
        this.certificateKeyProvider = certificateKeyProvider;
        this.externalDecryptionProcess = externalDecryptionProcess;
        return this;
    }

    public ReaderProperties setPublicKeySecurityParams(Certificate certificate, IExternalDecryptionProcess externalDecryptionProcess) {
        this.clearEncryptionParams();
        this.certificate = certificate;
        this.externalDecryptionProcess = externalDecryptionProcess;
        return this;
    }

    public ReaderProperties setMemoryLimitsAwareHandler(MemoryLimitsAwareHandler memoryLimitsAwareHandler) {
        this.memoryLimitsAwareHandler = memoryLimitsAwareHandler;
        return this;
    }

    private void clearEncryptionParams() {
        this.password = null;
        this.certificate = null;
        this.certificateKey = null;
        this.certificateKeyProvider = null;
        this.externalDecryptionProcess = null;
    }
}

