/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.layout.element;

import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.tagutils.AccessibilityProperties;
import com.itextpdf.layout.Document;
import com.itextpdf.layout.border.Border;
import com.itextpdf.layout.element.BlockElement;
import com.itextpdf.layout.element.Cell;
import com.itextpdf.layout.element.IElement;
import com.itextpdf.layout.element.ILargeElement;
import com.itextpdf.layout.element.Image;
import com.itextpdf.layout.element.Paragraph;
import com.itextpdf.layout.property.UnitValue;
import com.itextpdf.layout.renderer.IRenderer;
import com.itextpdf.layout.renderer.TableRenderer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Table
extends BlockElement<Table>
implements ILargeElement {
    protected PdfName role = PdfName.Table;
    protected AccessibilityProperties tagProperties;
    private List<Cell[]> rows;
    private float[] columnWidths;
    private int currentColumn = 0;
    private int currentRow = -1;
    private Table header;
    private Table footer;
    private boolean skipFirstHeader;
    private boolean skipLastFooter;
    private boolean isComplete;
    private List<RowRange> lastAddedRowGroups;
    private int rowWindowStart = 0;
    private Document document;
    private Cell[] lastAddedRow;

    public Table(float[] columnWidths, boolean largeTable) {
        boolean bl = this.isComplete = !largeTable;
        if (columnWidths == null) {
            throw new NullPointerException("the.widths.array.in.table.constructor.can.not.be.null");
        }
        if (columnWidths.length == 0) {
            throw new IllegalArgumentException("the.widths.array.in.pdfptable.constructor.can.not.have.zero.length");
        }
        this.columnWidths = new float[columnWidths.length];
        float width = 0.0f;
        for (int i = 0; i < columnWidths.length; ++i) {
            this.columnWidths[i] = columnWidths[i];
            width += columnWidths[i];
        }
        super.setWidth(width);
        this.initializeRows();
    }

    public Table(float[] columnWidths) {
        this(columnWidths, false);
    }

    public Table(int numColumns, boolean largeTable) {
        boolean bl = this.isComplete = !largeTable;
        if (numColumns <= 0) {
            throw new IllegalArgumentException("the.number.of.columns.in.pdfptable.constructor.must.be.greater.than.zero");
        }
        this.columnWidths = new float[numColumns];
        for (int k = 0; k < numColumns; ++k) {
            this.columnWidths[k] = 1.0f;
        }
        super.setWidth(UnitValue.createPercentValue(100.0f));
        this.initializeRows();
    }

    public Table(int numColumns) {
        this(numColumns, false);
    }

    @Override
    public Table setWidth(UnitValue width) {
        UnitValue currWidth;
        if (width.isPointValue() && width.getValue() == 0.0f) {
            width = UnitValue.createPercentValue(100.0f);
        }
        if (!width.equals(currWidth = this.getWidth())) {
            super.setWidth(width);
            this.calculateWidths();
        }
        return this;
    }

    public float getColumnWidth(int column) {
        return this.columnWidths[column];
    }

    public int getNumberOfColumns() {
        return this.columnWidths.length;
    }

    public int getNumberOfRows() {
        return this.rows.size();
    }

    public Table addHeaderCell(Cell headerCell) {
        this.ensureHeaderIsInitialized();
        this.header.addCell(headerCell);
        return this;
    }

    public <T extends IElement> Table addHeaderCell(BlockElement<T> blockElement) {
        this.ensureHeaderIsInitialized();
        this.header.addCell(blockElement);
        return this;
    }

    public Table addHeaderCell(Image image) {
        this.ensureHeaderIsInitialized();
        this.header.addCell(image);
        return this;
    }

    public Table addHeaderCell(String content) {
        this.ensureHeaderIsInitialized();
        this.header.addCell(content);
        return this;
    }

    public Table getHeader() {
        return this.header;
    }

    public Table addFooterCell(Cell footerCell) {
        this.ensureFooterIsInitialized();
        this.footer.addCell(footerCell);
        return this;
    }

    public <T extends IElement> Table addFooterCell(BlockElement<T> blockElement) {
        this.ensureFooterIsInitialized();
        this.footer.addCell(blockElement);
        return this;
    }

    public Table addFooterCell(Image image) {
        this.ensureFooterIsInitialized();
        this.footer.addCell(image);
        return this;
    }

    public Table addFooterCell(String content) {
        this.ensureFooterIsInitialized();
        this.footer.addCell(content);
        return this;
    }

    public Table getFooter() {
        return this.footer;
    }

    public boolean isSkipFirstHeader() {
        return this.skipFirstHeader;
    }

    public boolean isSkipLastFooter() {
        return this.skipLastFooter;
    }

    public Table setSkipFirstHeader(boolean skipFirstHeader) {
        this.skipFirstHeader = skipFirstHeader;
        return this;
    }

    public Table setSkipLastFooter(boolean skipLastFooter) {
        this.skipLastFooter = skipLastFooter;
        return this;
    }

    public Table startNewRow() {
        this.currentColumn = 0;
        ++this.currentRow;
        if (this.currentRow >= this.rows.size()) {
            this.rows.add(new Cell[this.columnWidths.length]);
        }
        return this;
    }

    public Table addCell(Cell cell) {
        while (true) {
            if (this.currentColumn >= this.columnWidths.length) {
                this.startNewRow();
            }
            if (this.rows.get(this.currentRow - this.rowWindowStart)[this.currentColumn] == null) break;
            ++this.currentColumn;
        }
        this.childElements.add(cell);
        cell.updateCellIndexes(this.currentRow, this.currentColumn, this.columnWidths.length);
        while (this.currentRow - this.rowWindowStart + cell.getRowspan() > this.rows.size()) {
            this.rows.add(new Cell[this.columnWidths.length]);
        }
        for (int i = this.currentRow; i < this.currentRow + cell.getRowspan(); ++i) {
            Cell[] row = this.rows.get(i - this.rowWindowStart);
            for (int j = this.currentColumn; j < this.currentColumn + cell.getColspan(); ++j) {
                if (row[j] != null) continue;
                row[j] = cell;
            }
        }
        this.currentColumn += cell.getColspan();
        return this;
    }

    public <T extends IElement> Table addCell(BlockElement<T> blockElement) {
        return this.addCell(new Cell().add(blockElement));
    }

    public Table addCell(Image image) {
        return this.addCell(new Cell().add(image));
    }

    public Table addCell(String content) {
        return this.addCell(new Cell().add(new Paragraph(content)));
    }

    public Cell getCell(int row, int column) {
        Cell cell;
        if (row - this.rowWindowStart < this.rows.size() && (cell = this.rows.get(row - this.rowWindowStart)[column]) != null && cell.getRow() == row && cell.getCol() == column) {
            return cell;
        }
        return null;
    }

    @Override
    public IRenderer createRendererSubTree() {
        TableRenderer rendererRoot = (TableRenderer)this.getRenderer();
        for (IElement child : this.childElements) {
            boolean childShouldBeAdded = this.isComplete || this.cellBelongsToAnyRowGroup((Cell)child, this.lastAddedRowGroups);
            if (!childShouldBeAdded) continue;
            rendererRoot.addChild(child.createRendererSubTree());
        }
        return rendererRoot;
    }

    @Override
    protected IRenderer makeNewRenderer() {
        return new TableRenderer(this);
    }

    @Override
    public IRenderer getRenderer() {
        if (this.nextRenderer != null) {
            if (this.nextRenderer instanceof TableRenderer) {
                IRenderer renderer = this.nextRenderer;
                this.nextRenderer = this.nextRenderer.getNextRenderer();
                return renderer;
            }
            Logger logger = LoggerFactory.getLogger(Table.class);
            logger.error("Invalid renderer for Table: must be inherited from TableRenderer");
        }
        List<RowRange> list = this.lastAddedRowGroups = this.isComplete ? null : this.getRowGroups();
        if (this.isComplete) {
            return new TableRenderer(this, new RowRange(this.rowWindowStart, this.rowWindowStart + this.rows.size() - 1));
        }
        int rowWindowFinish = this.lastAddedRowGroups.size() != 0 ? this.lastAddedRowGroups.get((int)(this.lastAddedRowGroups.size() - 1)).finishRow : -1;
        return new TableRenderer(this, new RowRange(this.rowWindowStart, rowWindowFinish));
    }

    @Override
    public boolean isComplete() {
        return this.isComplete;
    }

    @Override
    public void complete() {
        this.isComplete = true;
        this.flush();
    }

    @Override
    public void flush() {
        Cell[] row = null;
        if (!this.rows.isEmpty()) {
            row = this.rows.get(this.rows.size() - 1);
        }
        this.document.add((BlockElement)this);
        if (row != null) {
            this.lastAddedRow = row;
        }
    }

    @Override
    public void flushContent() {
        if (this.lastAddedRowGroups == null || this.lastAddedRowGroups.isEmpty()) {
            return;
        }
        int firstRow = this.lastAddedRowGroups.get((int)0).startRow;
        int lastRow = this.lastAddedRowGroups.get((int)(this.lastAddedRowGroups.size() - 1)).finishRow;
        Iterator iterator = this.childElements.iterator();
        while (iterator.hasNext()) {
            IElement cell = (IElement)iterator.next();
            if (((Cell)cell).getRow() < firstRow || ((Cell)cell).getRow() > lastRow) continue;
            iterator.remove();
        }
        for (int i = 0; i <= lastRow - firstRow; ++i) {
            this.rows.remove(firstRow - this.rowWindowStart);
        }
        this.rowWindowStart = this.lastAddedRowGroups.get(this.lastAddedRowGroups.size() - 1).getFinishRow() + 1;
        this.lastAddedRowGroups = null;
    }

    @Override
    public void setDocument(Document document) {
        this.document = document;
    }

    public ArrayList<Border> getLastRowBottomBorder() {
        ArrayList<Border> horizontalBorder = new ArrayList<Border>();
        if (this.lastAddedRow != null) {
            for (int i = 0; i < this.lastAddedRow.length; ++i) {
                Cell cell = this.lastAddedRow[i];
                if (cell == null) continue;
                Border border = (Border)cell.getProperty(9);
                if (border == null) {
                    border = (Border)cell.getProperty(10);
                }
                horizontalBorder.add(border);
            }
        }
        return horizontalBorder;
    }

    public PdfName getRole() {
        return this.role;
    }

    public void setRole(PdfName role) {
        this.role = role;
        if (PdfName.Artifact.equals((Object)role)) {
            this.propagateArtifactRoleToChildElements();
        }
    }

    public AccessibilityProperties getAccessibilityProperties() {
        if (this.tagProperties == null) {
            this.tagProperties = new AccessibilityProperties();
        }
        return this.tagProperties;
    }

    protected void calculateWidths() {
        int k;
        UnitValue width = this.getWidth();
        float total = 0.0f;
        int numCols = this.getNumberOfColumns();
        for (k = 0; k < numCols; ++k) {
            total += this.columnWidths[k];
        }
        for (k = 0; k < numCols; ++k) {
            this.columnWidths[k] = width.getValue() * this.columnWidths[k] / total;
        }
    }

    protected List<RowRange> getRowGroups() {
        int lastRowWeCanFlush = this.currentColumn == this.columnWidths.length ? this.currentRow : this.currentRow - 1;
        int[] cellBottomRows = new int[this.columnWidths.length];
        int currentRowGroupStart = this.rowWindowStart;
        ArrayList<RowRange> rowGroups = new ArrayList<RowRange>();
        while (currentRowGroupStart <= lastRowWeCanFlush) {
            for (int i = 0; i < this.columnWidths.length; ++i) {
                cellBottomRows[i] = currentRowGroupStart;
            }
            int maxRowGroupFinish = cellBottomRows[0] + this.rows.get(cellBottomRows[0] - this.rowWindowStart)[0].getRowspan() - 1;
            boolean converged = false;
            boolean rowGroupComplete = true;
            while (!converged) {
                converged = true;
                for (int i = 0; i < this.columnWidths.length; ++i) {
                    while (cellBottomRows[i] < lastRowWeCanFlush && cellBottomRows[i] + this.rows.get(cellBottomRows[i] - this.rowWindowStart)[i].getRowspan() - 1 < maxRowGroupFinish) {
                        int n = i;
                        cellBottomRows[n] = cellBottomRows[n] + this.rows.get(cellBottomRows[i] - this.rowWindowStart)[i].getRowspan();
                    }
                    if (cellBottomRows[i] + this.rows.get(cellBottomRows[i] - this.rowWindowStart)[i].getRowspan() - 1 > maxRowGroupFinish) {
                        maxRowGroupFinish = cellBottomRows[i] + this.rows.get(cellBottomRows[i] - this.rowWindowStart)[i].getRowspan() - 1;
                        converged = false;
                        continue;
                    }
                    if (cellBottomRows[i] + this.rows.get(cellBottomRows[i] - this.rowWindowStart)[i].getRowspan() - 1 >= maxRowGroupFinish) continue;
                    rowGroupComplete = false;
                }
            }
            if (rowGroupComplete) {
                rowGroups.add(new RowRange(currentRowGroupStart, maxRowGroupFinish));
            }
            currentRowGroupStart = maxRowGroupFinish + 1;
        }
        return rowGroups;
    }

    private void initializeRows() {
        this.rows = new ArrayList<Cell[]>();
        this.startNewRow();
    }

    private boolean cellBelongsToAnyRowGroup(Cell cell, List<RowRange> rowGroups) {
        return rowGroups != null && rowGroups.size() > 0 && cell.getRow() >= rowGroups.get(0).getStartRow() && cell.getRow() <= rowGroups.get(rowGroups.size() - 1).getFinishRow();
    }

    private void ensureHeaderIsInitialized() {
        if (this.header == null) {
            this.header = new Table(this.columnWidths);
            this.header.setWidth(this.getWidth());
            this.header.setRole(PdfName.THead);
        }
    }

    private void ensureFooterIsInitialized() {
        if (this.footer == null) {
            this.footer = new Table(this.columnWidths);
            this.footer.setWidth(this.getWidth());
            this.footer.setRole(PdfName.TFoot);
        }
    }

    public static class RowRange {
        int startRow;
        int finishRow;

        public RowRange(int startRow, int finishRow) {
            this.startRow = startRow;
            this.finishRow = finishRow;
        }

        public int getStartRow() {
            return this.startRow;
        }

        public int getFinishRow() {
            return this.finishRow;
        }
    }
}

