/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.layout.element;

import com.itextpdf.kernel.pdf.action.PdfAction;
import com.itextpdf.layout.ElementPropertyContainer;
import com.itextpdf.layout.Style;
import com.itextpdf.layout.element.IElement;
import com.itextpdf.layout.renderer.IRenderer;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public abstract class AbstractElement<T extends IElement>
extends ElementPropertyContainer<T>
implements IElement {
    protected IRenderer nextRenderer;
    protected List<IElement> childElements = new ArrayList<IElement>();
    protected Set<Style> styles;

    @Override
    public IRenderer getRenderer() {
        if (this.nextRenderer != null) {
            IRenderer renderer = this.nextRenderer;
            this.nextRenderer = this.nextRenderer.getNextRenderer();
            return renderer;
        }
        return this.makeNewRenderer();
    }

    @Override
    public void setNextRenderer(IRenderer renderer) {
        this.nextRenderer = renderer;
    }

    @Override
    public IRenderer createRendererSubTree() {
        IRenderer rendererRoot = this.getRenderer();
        for (IElement child : this.childElements) {
            rendererRoot.addChild(child.createRendererSubTree());
        }
        return rendererRoot;
    }

    @Override
    public boolean hasProperty(int property) {
        boolean hasProperty = super.hasProperty(property);
        if (this.styles != null && this.styles.size() > 0 && !hasProperty) {
            for (Style style : this.styles) {
                if (!style.hasProperty(property)) continue;
                hasProperty = true;
                break;
            }
        }
        return hasProperty;
    }

    @Override
    public <T1> T1 getProperty(int property) {
        Object result = super.getProperty(property);
        if (this.styles != null && this.styles.size() > 0 && result == null && !super.hasProperty(property)) {
            for (Style style : this.styles) {
                Object foundInStyle = style.getProperty(property);
                if (foundInStyle == null && !style.hasProperty(property)) continue;
                result = foundInStyle;
            }
        }
        return result;
    }

    public T addStyle(Style style) {
        if (this.styles == null) {
            this.styles = new LinkedHashSet<Style>();
        }
        this.styles.add(style);
        return (T)this;
    }

    public List<IElement> getChildren() {
        return this.childElements;
    }

    public boolean isEmpty() {
        return 0 == this.childElements.size();
    }

    public T setAction(PdfAction action) {
        this.setProperty(1, action);
        return (T)this;
    }

    public T setPageNumber(int pageNumber) {
        this.setProperty(51, pageNumber);
        return (T)this;
    }

    protected abstract IRenderer makeNewRenderer();
}

