/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.layout.renderer;

import com.itextpdf.layout.borders.Border;
import com.itextpdf.layout.properties.ContinuousContainer;
import com.itextpdf.layout.properties.UnitValue;
import com.itextpdf.layout.renderer.AbstractRenderer;
import com.itextpdf.layout.renderer.IRenderer;
import java.util.List;

final class GridMulticolUtil {
    private GridMulticolUtil() {
    }

    static AbstractRenderer createSplitRenderer(List<IRenderer> children, AbstractRenderer renderer) {
        AbstractRenderer splitRenderer = (AbstractRenderer)renderer.getNextRenderer();
        splitRenderer.parent = renderer.parent;
        splitRenderer.modelElement = renderer.modelElement;
        splitRenderer.occupiedArea = renderer.occupiedArea;
        splitRenderer.isLastRendererForModelElement = false;
        splitRenderer.setChildRenderers(children);
        splitRenderer.addAllProperties(renderer.getOwnProperties());
        ContinuousContainer.setupContinuousContainerIfNeeded(splitRenderer);
        return splitRenderer;
    }

    static float updateOccupiedWidth(float initialWidth, AbstractRenderer renderer) {
        float result = initialWidth;
        result += GridMulticolUtil.safelyRetrieveFloatProperty(48, renderer);
        result += GridMulticolUtil.safelyRetrieveFloatProperty(49, renderer);
        result += GridMulticolUtil.safelyRetrieveFloatProperty(44, renderer);
        result += GridMulticolUtil.safelyRetrieveFloatProperty(45, renderer);
        result += GridMulticolUtil.safelyRetrieveFloatProperty(11, renderer);
        return result += GridMulticolUtil.safelyRetrieveFloatProperty(12, renderer);
    }

    static float updateOccupiedHeight(float initialHeight, boolean isFull, AbstractRenderer renderer) {
        float result = initialHeight;
        if (isFull) {
            result += GridMulticolUtil.safelyRetrieveFloatProperty(47, renderer);
            result += GridMulticolUtil.safelyRetrieveFloatProperty(43, renderer);
            result += GridMulticolUtil.safelyRetrieveFloatProperty(10, renderer);
        }
        result += GridMulticolUtil.safelyRetrieveFloatProperty(50, renderer);
        result += GridMulticolUtil.safelyRetrieveFloatProperty(46, renderer);
        return result += GridMulticolUtil.safelyRetrieveFloatProperty(13, renderer);
    }

    private static float safelyRetrieveFloatProperty(int property, AbstractRenderer renderer) {
        Object value = renderer.getProperty(property);
        if (value instanceof UnitValue) {
            return ((UnitValue)value).getValue();
        }
        if (value instanceof Border) {
            return ((Border)value).getWidth();
        }
        return 0.0f;
    }
}

