/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.pdfa.checker;

import com.itextpdf.io.colors.IccProfile;
import com.itextpdf.kernel.colors.Color;
import com.itextpdf.kernel.font.PdfFont;
import com.itextpdf.kernel.font.PdfTrueTypeFont;
import com.itextpdf.kernel.pdf.PdfAConformanceLevel;
import com.itextpdf.kernel.pdf.PdfArray;
import com.itextpdf.kernel.pdf.PdfCatalog;
import com.itextpdf.kernel.pdf.PdfDictionary;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.PdfNumber;
import com.itextpdf.kernel.pdf.PdfObject;
import com.itextpdf.kernel.pdf.PdfPage;
import com.itextpdf.kernel.pdf.PdfStream;
import com.itextpdf.kernel.pdf.PdfString;
import com.itextpdf.kernel.pdf.canvas.CanvasGraphicsState;
import com.itextpdf.kernel.pdf.colorspace.PdfColorSpace;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class PdfAChecker
implements Serializable {
    private static final long serialVersionUID = -9138950508285715228L;
    public static final String ICC_COLOR_SPACE_RGB = "RGB ";
    public static final String ICC_COLOR_SPACE_CMYK = "CMYK";
    public static final String ICC_COLOR_SPACE_GRAY = "GRAY";
    public static final String ICC_DEVICE_CLASS_OUTPUT_PROFILE = "prtr";
    public static final String ICC_DEVICE_CLASS_MONITOR_PROFILE = "mntr";
    public static final int maxGsStackDepth = 28;
    protected PdfAConformanceLevel conformanceLevel;
    protected String pdfAOutputIntentColorSpace;
    protected int gsStackDepth = 0;
    protected boolean rgbIsUsed = false;
    protected boolean cmykIsUsed = false;
    protected boolean grayIsUsed = false;
    protected Set<PdfObject> checkedObjects = new HashSet<PdfObject>();
    protected Map<PdfObject, PdfColorSpace> checkedObjectsColorspace = new HashMap<PdfObject, PdfColorSpace>();

    protected PdfAChecker(PdfAConformanceLevel conformanceLevel) {
        this.conformanceLevel = conformanceLevel;
    }

    public void checkDocument(PdfCatalog catalog) {
        PdfDictionary catalogDict = (PdfDictionary)catalog.getPdfObject();
        this.setPdfAOutputIntentColorSpace(catalogDict);
        this.checkOutputIntents(catalogDict);
        this.checkMetaData(catalogDict);
        this.checkCatalogValidEntries(catalogDict);
        this.checkTrailer(catalog.getDocument().getTrailer());
        this.checkLogicalStructure(catalogDict);
        this.checkForm(catalogDict.getAsDictionary(PdfName.AcroForm));
        this.checkOutlines(catalogDict);
        this.checkPages(catalog.getDocument());
        this.checkOpenAction(catalogDict.get(PdfName.OpenAction));
        this.checkColorsUsages();
    }

    public void checkSinglePage(PdfPage page) {
        this.checkPage(page);
    }

    public void checkPdfObject(PdfObject obj) {
        switch (obj.getType()) {
            case 8: {
                this.checkPdfNumber((PdfNumber)obj);
                break;
            }
            case 9: {
                this.checkPdfStream((PdfStream)obj);
                break;
            }
            case 10: {
                this.checkPdfString((PdfString)obj);
                break;
            }
            case 3: {
                PdfDictionary dict = (PdfDictionary)obj;
                PdfName type = dict.getAsName(PdfName.Type);
                if (!PdfName.Filespec.equals((Object)type)) break;
                this.checkFileSpec(dict);
            }
        }
    }

    public PdfAConformanceLevel getConformanceLevel() {
        return this.conformanceLevel;
    }

    public boolean objectIsChecked(PdfObject object) {
        return this.checkedObjects.contains(object);
    }

    public void checkTagStructureElement(PdfObject obj) {
        this.checkedObjects.add(obj);
    }

    public abstract void checkCanvasStack(char var1);

    public abstract void checkInlineImage(PdfStream var1, PdfDictionary var2);

    public abstract void checkColor(Color var1, PdfDictionary var2, Boolean var3);

    public abstract void checkColorSpace(PdfColorSpace var1, PdfDictionary var2, boolean var3, Boolean var4);

    public abstract void checkRenderingIntent(PdfName var1);

    public abstract void checkExtGState(CanvasGraphicsState var1);

    public abstract void checkFont(PdfFont var1);

    protected abstract Set<PdfName> getForbiddenActions();

    protected abstract Set<PdfName> getAllowedNamedActions();

    protected abstract void checkAction(PdfDictionary var1);

    protected abstract void checkAnnotation(PdfDictionary var1);

    protected abstract void checkCatalogValidEntries(PdfDictionary var1);

    protected abstract void checkColorsUsages();

    protected abstract void checkImage(PdfStream var1, PdfDictionary var2);

    protected abstract void checkFileSpec(PdfDictionary var1);

    protected abstract void checkForm(PdfDictionary var1);

    protected abstract void checkFormXObject(PdfStream var1);

    protected abstract void checkLogicalStructure(PdfDictionary var1);

    protected abstract void checkMetaData(PdfDictionary var1);

    protected abstract void checkNonSymbolicTrueTypeFont(PdfTrueTypeFont var1);

    protected abstract void checkOutputIntents(PdfDictionary var1);

    protected abstract void checkPageObject(PdfDictionary var1, PdfDictionary var2);

    protected abstract void checkPageSize(PdfDictionary var1);

    protected abstract void checkPdfNumber(PdfNumber var1);

    protected abstract void checkPdfStream(PdfStream var1);

    protected abstract void checkPdfString(PdfString var1);

    protected abstract void checkSymbolicTrueTypeFont(PdfTrueTypeFont var1);

    protected abstract void checkTrailer(PdfDictionary var1);

    protected void checkResources(PdfDictionary resources) {
        if (resources == null) {
            return;
        }
        PdfDictionary xObjects = resources.getAsDictionary(PdfName.XObject);
        PdfDictionary shadings = resources.getAsDictionary(PdfName.Shading);
        PdfDictionary patterns = resources.getAsDictionary(PdfName.Pattern);
        if (xObjects != null) {
            for (PdfObject xObject : xObjects.values()) {
                PdfStream xObjStream = (PdfStream)xObject;
                PdfObject subtype = null;
                boolean isFlushed = xObjStream.isFlushed();
                if (!isFlushed) {
                    subtype = xObjStream.get(PdfName.Subtype);
                }
                if (PdfName.Image.equals(subtype) || isFlushed) {
                    this.checkImage(xObjStream, resources.getAsDictionary(PdfName.ColorSpace));
                    continue;
                }
                if (!PdfName.Form.equals((Object)subtype)) continue;
                this.checkFormXObject(xObjStream);
            }
        }
        if (shadings != null) {
            for (PdfObject shading : shadings.values()) {
                PdfDictionary shadingDict = (PdfDictionary)shading;
                if (this.isAlreadyChecked(shadingDict)) continue;
                this.checkColorSpace(PdfColorSpace.makeColorSpace((PdfObject)shadingDict.get(PdfName.ColorSpace)), resources.getAsDictionary(PdfName.ColorSpace), true, null);
            }
        }
        if (patterns != null) {
            for (PdfObject p : patterns.values()) {
                PdfStream pStream;
                if (!p.isStream() || this.isAlreadyChecked((PdfDictionary)(pStream = (PdfStream)p))) continue;
                this.checkResources(pStream.getAsDictionary(PdfName.Resources));
            }
        }
    }

    protected static boolean checkFlag(int flags, int flag) {
        return (flags & flag) != 0;
    }

    protected static boolean checkStructure(PdfAConformanceLevel conformanceLevel) {
        return conformanceLevel == PdfAConformanceLevel.PDF_A_1A || conformanceLevel == PdfAConformanceLevel.PDF_A_2A || conformanceLevel == PdfAConformanceLevel.PDF_A_3A;
    }

    protected boolean isAlreadyChecked(PdfDictionary dictionary) {
        if (this.checkedObjects.contains(dictionary)) {
            return true;
        }
        this.checkedObjects.add((PdfObject)dictionary);
        return false;
    }

    protected void checkResourcesOfAppearanceStreams(PdfDictionary appearanceStreamsDict) {
        for (PdfObject val : appearanceStreamsDict.values()) {
            if (!(val instanceof PdfDictionary)) continue;
            PdfDictionary ap = (PdfDictionary)val;
            if (ap.isDictionary()) {
                this.checkResourcesOfAppearanceStreams(ap);
                continue;
            }
            if (!ap.isStream() || this.isAlreadyChecked(ap)) continue;
            this.checkResources(ap.getAsDictionary(PdfName.Resources));
        }
    }

    private void checkPages(PdfDocument document) {
        for (int i = 1; i <= document.getNumberOfPages(); ++i) {
            this.checkPage(document.getPage(i));
        }
    }

    private void checkPage(PdfPage page) {
        PdfDictionary pageDict = (PdfDictionary)page.getPdfObject();
        if (this.isAlreadyChecked(pageDict)) {
            return;
        }
        this.checkPageObject(pageDict, (PdfDictionary)page.getResources().getPdfObject());
        PdfDictionary pageResources = (PdfDictionary)page.getResources().getPdfObject();
        this.checkResources(pageResources);
        this.checkAnnotations(pageDict);
        this.checkPageSize(pageDict);
        int contentStreamCount = page.getContentStreamCount();
        for (int j = 0; j < contentStreamCount; ++j) {
            this.checkedObjects.add((PdfObject)page.getContentStream(j));
        }
    }

    private void checkOpenAction(PdfObject openAction) {
        if (openAction != null && openAction.isDictionary()) {
            this.checkAction((PdfDictionary)openAction);
        }
    }

    private void checkAnnotations(PdfDictionary page) {
        PdfArray annots = page.getAsArray(PdfName.Annots);
        if (annots != null) {
            for (int i = 0; i < annots.size(); ++i) {
                PdfDictionary annot = annots.getAsDictionary(i);
                this.checkAnnotation(annot);
                PdfDictionary action = annot.getAsDictionary(PdfName.A);
                if (action == null) continue;
                this.checkAction(action);
            }
        }
    }

    private void checkOutlines(PdfDictionary catalogDict) {
        PdfDictionary outlines = catalogDict.getAsDictionary(PdfName.Outlines);
        if (outlines != null) {
            for (PdfDictionary outline : this.getOutlines(outlines)) {
                PdfDictionary action = outline.getAsDictionary(PdfName.A);
                if (action == null) continue;
                this.checkAction(action);
            }
        }
    }

    private List<PdfDictionary> getOutlines(PdfDictionary item) {
        ArrayList<PdfDictionary> outlines = new ArrayList<PdfDictionary>();
        outlines.add(item);
        PdfDictionary processItem = item.getAsDictionary(PdfName.First);
        if (processItem != null) {
            outlines.addAll(this.getOutlines(processItem));
        }
        if ((processItem = item.getAsDictionary(PdfName.Next)) != null) {
            outlines.addAll(this.getOutlines(processItem));
        }
        return outlines;
    }

    private void setPdfAOutputIntentColorSpace(PdfDictionary catalog) {
        PdfArray outputIntents = catalog.getAsArray(PdfName.OutputIntents);
        if (outputIntents == null) {
            return;
        }
        PdfDictionary pdfAOutputIntent = this.getPdfAOutputIntent(outputIntents);
        this.setCheckerOutputIntent(pdfAOutputIntent);
    }

    private PdfDictionary getPdfAOutputIntent(PdfArray outputIntents) {
        for (int i = 0; i < outputIntents.size(); ++i) {
            PdfName outputIntentSubtype = outputIntents.getAsDictionary(i).getAsName(PdfName.S);
            if (!PdfName.GTS_PDFA1.equals((Object)outputIntentSubtype)) continue;
            return outputIntents.getAsDictionary(i);
        }
        return null;
    }

    private void setCheckerOutputIntent(PdfDictionary outputIntent) {
        PdfStream destOutputProfile;
        if (outputIntent != null && (destOutputProfile = outputIntent.getAsStream(PdfName.DestOutputProfile)) != null) {
            String intentCS;
            this.pdfAOutputIntentColorSpace = intentCS = IccProfile.getIccColorSpaceName((byte[])destOutputProfile.getBytes());
        }
    }
}

