/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.pdfa.checker;

import com.itextpdf.kernel.pdf.PdfAConformanceLevel;
import com.itextpdf.kernel.pdf.PdfDictionary;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.PdfObject;
import com.itextpdf.kernel.pdf.PdfStream;
import com.itextpdf.pdfa.checker.PdfA2Checker;
import com.itextpdf.pdfa.checker.PdfAChecker;
import com.itextpdf.pdfa.exceptions.PdfAConformanceException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PdfA3Checker
extends PdfA2Checker {
    protected static final Set<PdfName> allowedAFRelationships = Collections.unmodifiableSet(new HashSet<PdfName>(Arrays.asList(PdfName.Source, PdfName.Data, PdfName.Alternative, PdfName.Supplement, PdfName.Unspecified)));

    public PdfA3Checker(PdfAConformanceLevel conformanceLevel) {
        super(conformanceLevel);
    }

    @Override
    protected void checkFileSpec(PdfDictionary fileSpec) {
        PdfName relationship = fileSpec.getAsName(PdfName.AFRelationship);
        if (relationship == null || !allowedAFRelationships.contains(relationship)) {
            throw new PdfAConformanceException("File specification dictionary shall contain one of the predefined afrelationship keys");
        }
        if (fileSpec.containsKey(PdfName.EF)) {
            if (!(fileSpec.containsKey(PdfName.F) && fileSpec.containsKey(PdfName.UF) && fileSpec.containsKey(PdfName.Desc))) {
                throw new PdfAConformanceException("File specification dictionary shall contain f key and uf key");
            }
            PdfDictionary ef = fileSpec.getAsDictionary(PdfName.EF);
            PdfStream embeddedFile = ef.getAsStream(PdfName.F);
            if (embeddedFile == null) {
                throw new PdfAConformanceException("Ef key of file specification dictionary shall contain dictionary with valid f key");
            }
            if (!embeddedFile.containsKey(PdfName.Subtype)) {
                throw new PdfAConformanceException("Mime type shall be specified using the subtype key of the file specification stream dictionary");
            }
            if (embeddedFile.containsKey(PdfName.Params)) {
                PdfObject params = embeddedFile.get(PdfName.Params);
                if (!params.isDictionary()) {
                    throw new PdfAConformanceException("Embedded file shall contain params key with dictionary as value");
                }
                if (((PdfDictionary)params).getAsString(PdfName.ModDate) == null) {
                    throw new PdfAConformanceException("Embedded file shall contain params key with valid moddate key");
                }
            } else {
                Logger logger = LoggerFactory.getLogger(PdfAChecker.class);
                logger.warn("Embedded file should contain params key ");
            }
        }
    }
}

