/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.pdfocr;

import com.itextpdf.io.font.otf.ActualTextIterator;
import com.itextpdf.io.font.otf.Glyph;
import com.itextpdf.io.font.otf.GlyphLine;
import com.itextpdf.io.image.ImageData;
import com.itextpdf.io.util.MessageFormatUtil;
import com.itextpdf.kernel.counter.event.IMetaInfo;
import com.itextpdf.kernel.font.PdfFont;
import com.itextpdf.kernel.font.PdfTrueTypeFont;
import com.itextpdf.kernel.font.PdfType0Font;
import com.itextpdf.kernel.font.PdfType1Font;
import com.itextpdf.kernel.font.PdfType3Font;
import com.itextpdf.kernel.geom.PageSize;
import com.itextpdf.kernel.geom.Point;
import com.itextpdf.kernel.geom.Rectangle;
import com.itextpdf.kernel.pdf.DocumentProperties;
import com.itextpdf.kernel.pdf.PdfAConformanceLevel;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.PdfDocumentInfo;
import com.itextpdf.kernel.pdf.PdfOutputIntent;
import com.itextpdf.kernel.pdf.PdfPage;
import com.itextpdf.kernel.pdf.PdfString;
import com.itextpdf.kernel.pdf.PdfViewerPreferences;
import com.itextpdf.kernel.pdf.PdfWriter;
import com.itextpdf.kernel.pdf.canvas.PdfCanvas;
import com.itextpdf.kernel.pdf.layer.IPdfOCG;
import com.itextpdf.kernel.pdf.layer.PdfLayer;
import com.itextpdf.layout.Canvas;
import com.itextpdf.layout.Document;
import com.itextpdf.layout.element.Paragraph;
import com.itextpdf.layout.element.Text;
import com.itextpdf.layout.font.FontProvider;
import com.itextpdf.layout.property.TextAlignment;
import com.itextpdf.pdfa.PdfADocument;
import com.itextpdf.pdfocr.IOcrEngine;
import com.itextpdf.pdfocr.OcrException;
import com.itextpdf.pdfocr.OcrPdfCreatorMetaInfo;
import com.itextpdf.pdfocr.OcrPdfCreatorProperties;
import com.itextpdf.pdfocr.PdfCreatorUtil;
import com.itextpdf.pdfocr.PdfOcrMetaInfo;
import com.itextpdf.pdfocr.TextInfo;
import com.itextpdf.pdfocr.events.IThreadLocalMetaInfoAware;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OcrPdfCreator {
    private static final Logger LOGGER = LoggerFactory.getLogger(OcrPdfCreator.class);
    private IOcrEngine ocrEngine;
    private OcrPdfCreatorProperties ocrPdfCreatorProperties;

    public OcrPdfCreator(IOcrEngine ocrEngine) {
        this(ocrEngine, new OcrPdfCreatorProperties());
    }

    public OcrPdfCreator(IOcrEngine ocrEngine, OcrPdfCreatorProperties ocrPdfCreatorProperties) {
        this.setOcrEngine(ocrEngine);
        this.setOcrPdfCreatorProperties(ocrPdfCreatorProperties);
    }

    public final OcrPdfCreatorProperties getOcrPdfCreatorProperties() {
        return this.ocrPdfCreatorProperties;
    }

    public final void setOcrPdfCreatorProperties(OcrPdfCreatorProperties ocrPdfCreatorProperties) {
        this.ocrPdfCreatorProperties = ocrPdfCreatorProperties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final PdfDocument createPdfA(List<File> inputImages, PdfWriter pdfWriter, PdfOutputIntent pdfOutputIntent) throws OcrException {
        LOGGER.info(MessageFormatUtil.format((String)"Starting ocr for {0} image(s)", (Object[])new Object[]{inputImages.size()}));
        IMetaInfo storedMetaInfo = null;
        if (this.ocrEngine instanceof IThreadLocalMetaInfoAware) {
            storedMetaInfo = ((IThreadLocalMetaInfoAware)((Object)this.ocrEngine)).getThreadLocalMetaInfo();
            ((IThreadLocalMetaInfoAware)((Object)this.ocrEngine)).setThreadLocalMetaInfo(new OcrPdfCreatorMetaInfo(((IThreadLocalMetaInfoAware)((Object)this.ocrEngine)).getThreadLocalMetaInfo(), UUID.randomUUID(), null != pdfOutputIntent ? OcrPdfCreatorMetaInfo.PdfDocumentType.PDFA : OcrPdfCreatorMetaInfo.PdfDocumentType.PDF));
        }
        LinkedHashMap<File, Map<Integer, List<TextInfo>>> imagesTextData = new LinkedHashMap<File, Map<Integer, List<TextInfo>>>();
        try {
            for (File inputImage : inputImages) {
                imagesTextData.put(inputImage, this.ocrEngine.doImageOcr(inputImage));
            }
        }
        finally {
            if (this.ocrEngine instanceof IThreadLocalMetaInfoAware) {
                ((IThreadLocalMetaInfoAware)((Object)this.ocrEngine)).setThreadLocalMetaInfo(storedMetaInfo);
            }
        }
        return this.createPdfDocument(pdfWriter, pdfOutputIntent, imagesTextData);
    }

    public final PdfDocument createPdf(List<File> inputImages, PdfWriter pdfWriter) throws OcrException {
        return this.createPdfA(inputImages, pdfWriter, null);
    }

    public final IOcrEngine getOcrEngine() {
        return this.ocrEngine;
    }

    public final void setOcrEngine(IOcrEngine reader) {
        this.ocrEngine = reader;
    }

    private void addToCanvas(PdfDocument pdfDocument, Rectangle imageSize, List<TextInfo> pageText, ImageData imageData, boolean createPdfA3u) throws OcrException {
        float multiplier;
        Rectangle rectangleSize = this.ocrPdfCreatorProperties.getPageSize() == null ? imageSize : this.ocrPdfCreatorProperties.getPageSize();
        PageSize size = new PageSize(rectangleSize);
        PdfPage pdfPage = pdfDocument.addNewPage(size);
        NotDefCheckingPdfCanvas canvas = new NotDefCheckingPdfCanvas(pdfPage, createPdfA3u);
        PdfLayer[] layers = OcrPdfCreator.createPdfLayers(this.ocrPdfCreatorProperties.getImageLayerName(), this.ocrPdfCreatorProperties.getTextLayerName(), pdfDocument);
        if (layers[0] != null) {
            canvas.beginLayer((IPdfOCG)layers[0]);
        }
        this.addImageToCanvas(imageData, imageSize, canvas);
        if (layers[0] != null && layers[0] != layers[1]) {
            canvas.endLayer();
        }
        float f = multiplier = imageData == null ? 1.0f : imageSize.getWidth() / PdfCreatorUtil.getPoints(imageData.getWidth());
        if (layers[1] != null && layers[0] != layers[1]) {
            canvas.beginLayer((IPdfOCG)layers[1]);
        }
        try {
            this.addTextToCanvas(imageSize, pageText, canvas, multiplier, pdfPage.getMediaBox());
        }
        catch (OcrException e) {
            LOGGER.error(MessageFormatUtil.format((String)"Cannot create PDF document: {0}", (Object[])new Object[]{e.getMessage()}));
            throw new OcrException("Cannot create PDF document: {0}").setMessageParams(e.getMessage());
        }
        if (layers[1] != null) {
            canvas.endLayer();
        }
    }

    private PdfDocument createPdfDocument(PdfWriter pdfWriter, PdfOutputIntent pdfOutputIntent, Map<File, Map<Integer, List<TextInfo>>> imagesTextData) {
        boolean hasPdfLangProperty;
        boolean createPdfA3u = pdfOutputIntent != null;
        Object pdfDocument = createPdfA3u ? new PdfADocument(pdfWriter, PdfAConformanceLevel.PDF_A_3U, pdfOutputIntent, new DocumentProperties().setEventCountingMetaInfo((IMetaInfo)new PdfOcrMetaInfo())) : new PdfDocument(pdfWriter, new DocumentProperties().setEventCountingMetaInfo((IMetaInfo)new PdfOcrMetaInfo()));
        boolean bl = hasPdfLangProperty = this.ocrPdfCreatorProperties.getPdfLang() != null && !this.ocrPdfCreatorProperties.getPdfLang().equals("");
        if (createPdfA3u && !hasPdfLangProperty) {
            LOGGER.error(MessageFormatUtil.format((String)"Cannot create PDF document: {0}", (Object[])new Object[]{"PDF language property is not set"}));
            throw new OcrException("Cannot create PDF document: {0}").setMessageParams("PDF language property is not set");
        }
        if (hasPdfLangProperty) {
            pdfDocument.getCatalog().setLang(new PdfString(this.ocrPdfCreatorProperties.getPdfLang()));
        }
        if (this.ocrPdfCreatorProperties.getTitle() != null) {
            pdfDocument.getCatalog().setViewerPreferences(new PdfViewerPreferences().setDisplayDocTitle(true));
            PdfDocumentInfo info = pdfDocument.getDocumentInfo();
            info.setTitle(this.ocrPdfCreatorProperties.getTitle());
        }
        this.ocrPdfCreatorProperties.getFontProvider().reset();
        this.addDataToPdfDocument(imagesTextData, (PdfDocument)pdfDocument, createPdfA3u);
        return pdfDocument;
    }

    private void addDataToPdfDocument(Map<File, Map<Integer, List<TextInfo>>> imagesTextData, PdfDocument pdfDocument, boolean createPdfA3u) throws OcrException {
        for (Map.Entry<File, Map<Integer, List<TextInfo>>> entry : imagesTextData.entrySet()) {
            try {
                File inputImage = entry.getKey();
                List<ImageData> imageDataList = PdfCreatorUtil.getImageData(inputImage);
                LOGGER.info(MessageFormatUtil.format((String)"Image {0} contains {1} page(s)", (Object[])new Object[]{inputImage.toString(), imageDataList.size()}));
                Map<Integer, List<TextInfo>> imageTextData = entry.getValue();
                if (imageTextData.keySet().size() <= 0) continue;
                for (int page = 0; page < imageDataList.size(); ++page) {
                    ImageData imageData = imageDataList.get(page);
                    Rectangle imageSize = PdfCreatorUtil.calculateImageSize(imageData, this.ocrPdfCreatorProperties.getScaleMode(), this.ocrPdfCreatorProperties.getPageSize());
                    if (!imageTextData.containsKey(page + 1)) continue;
                    this.addToCanvas(pdfDocument, imageSize, imageTextData.get(page + 1), imageData, createPdfA3u);
                }
            }
            catch (IOException e) {
                LOGGER.error(MessageFormatUtil.format((String)"Cannot add data to PDF document: {1}", (Object[])new Object[]{e.getMessage()}));
            }
        }
    }

    private void addImageToCanvas(ImageData imageData, Rectangle imageSize, PdfCanvas pdfCanvas) {
        if (imageData != null) {
            if (this.ocrPdfCreatorProperties.getPageSize() == null) {
                pdfCanvas.addImage(imageData, imageSize, false);
            } else {
                Point coordinates = PdfCreatorUtil.calculateImageCoordinates(this.ocrPdfCreatorProperties.getPageSize(), imageSize);
                Rectangle rect = new Rectangle((float)coordinates.x, (float)coordinates.y, imageSize.getWidth(), imageSize.getHeight());
                pdfCanvas.addImage(imageData, rect, false);
            }
        }
    }

    private void addTextToCanvas(Rectangle imageSize, List<TextInfo> pageText, PdfCanvas pdfCanvas, float multiplier, Rectangle pageMediaBox) throws OcrException {
        if (pageText != null && pageText.size() > 0) {
            Point imageCoordinates = PdfCreatorUtil.calculateImageCoordinates(this.ocrPdfCreatorProperties.getPageSize(), imageSize);
            for (TextInfo item : pageText) {
                String line = item.getText();
                List<Float> coordinates = item.getBbox();
                float left = coordinates.get(0).floatValue() * multiplier;
                float right = (coordinates.get(2).floatValue() + 1.0f) * multiplier - 1.0f;
                float top = coordinates.get(1).floatValue() * multiplier;
                float bottom = (coordinates.get(3).floatValue() + 1.0f) * multiplier - 1.0f;
                float bboxWidthPt = PdfCreatorUtil.getPoints(right - left);
                float bboxHeightPt = PdfCreatorUtil.getPoints(bottom - top);
                FontProvider fontProvider = this.getOcrPdfCreatorProperties().getFontProvider();
                String fontFamily = this.getOcrPdfCreatorProperties().getDefaultFontFamily();
                if (line.isEmpty() || !(bboxHeightPt > 0.0f) || !(bboxWidthPt > 0.0f)) continue;
                Document document = new Document(pdfCanvas.getDocument());
                document.setFontProvider(fontProvider);
                float fontSize = PdfCreatorUtil.calculateFontSize(document, line, fontFamily, bboxHeightPt, bboxWidthPt);
                float lineWidth = PdfCreatorUtil.getRealLineWidth(document, line, fontFamily, fontSize);
                float deltaX = PdfCreatorUtil.getPoints(left);
                float deltaY = imageSize.getHeight() - PdfCreatorUtil.getPoints(bottom);
                Canvas canvas = new Canvas(pdfCanvas, pageMediaBox);
                canvas.setFontProvider(fontProvider);
                Text text = new Text(line).setHorizontalScaling(bboxWidthPt / lineWidth);
                Paragraph paragraph = ((Paragraph)new Paragraph(text).setMargin(0.0f)).setMultipliedLeading(1.2f);
                ((Paragraph)paragraph.setFontFamily(new String[]{fontFamily})).setFontSize(fontSize);
                paragraph.setWidth(bboxWidthPt * 1.5f);
                if (this.ocrPdfCreatorProperties.getTextColor() != null) {
                    paragraph.setFontColor(this.ocrPdfCreatorProperties.getTextColor());
                } else {
                    paragraph.setTextRenderingMode(3);
                }
                canvas.showTextAligned(paragraph, deltaX + (float)imageCoordinates.x, deltaY + (float)imageCoordinates.y, TextAlignment.LEFT);
                canvas.close();
            }
        }
    }

    private static PdfLayer[] createPdfLayers(String imageLayerName, String textLayerName, PdfDocument pdfDocument) {
        if (imageLayerName == null && textLayerName == null) {
            return new PdfLayer[]{null, null};
        }
        if (imageLayerName == null) {
            return new PdfLayer[]{null, new PdfLayer(textLayerName, pdfDocument)};
        }
        if (textLayerName == null) {
            return new PdfLayer[]{new PdfLayer(imageLayerName, pdfDocument), null};
        }
        if (imageLayerName.equals(textLayerName)) {
            PdfLayer pdfLayer = new PdfLayer(imageLayerName, pdfDocument);
            return new PdfLayer[]{pdfLayer, pdfLayer};
        }
        return new PdfLayer[]{new PdfLayer(imageLayerName, pdfDocument), new PdfLayer(textLayerName, pdfDocument)};
    }

    private static class ActualTextCheckingGlyphLine
    extends GlyphLine {
        private static final long serialVersionUID = -946356392098459518L;

        public ActualTextCheckingGlyphLine(GlyphLine other) {
            super(other);
        }

        public void setActualTextToGlyph(int i, String text) {
            if (this.actualText == null || this.actualText.size() <= i || this.actualText.get(i) == null) {
                super.setActualText(i, i + 1, text);
            }
        }
    }

    private static class NotDefCheckingPdfCanvas
    extends PdfCanvas {
        private static final long serialVersionUID = 708713860707664107L;
        private final boolean createPdfA3u;

        public NotDefCheckingPdfCanvas(PdfPage page, boolean createPdfA3u) {
            super(page);
            this.createPdfA3u = createPdfA3u;
        }

        public PdfCanvas showText(GlyphLine text) {
            ActualTextCheckingGlyphLine glyphLine = new ActualTextCheckingGlyphLine(text);
            PdfFont currentFont = this.getGraphicsState().getFont();
            boolean notDefGlyphsExists = false;
            String message = "Could not find a glyph corresponding to Unicode character {0} in any of the fonts";
            for (int i = glyphLine.start; i < glyphLine.end; ++i) {
                if (!NotDefCheckingPdfCanvas.isNotDefGlyph(currentFont, glyphLine.get(i))) continue;
                notDefGlyphsExists = true;
                message = MessageFormatUtil.format((String)"Could not find a glyph corresponding to Unicode character {0} in any of the fonts", (Object[])new Object[]{glyphLine.get(i).getUnicode()});
                if (this.createPdfA3u) {
                    throw new OcrException(message);
                }
                glyphLine.setActualTextToGlyph(i, glyphLine.toUnicodeString(i, i + 1));
                Glyph glyph = new Glyph(glyphLine.get(i));
                glyph.setUnicode(-1);
                glyphLine.set(i, glyph);
            }
            if (notDefGlyphsExists) {
                LOGGER.warn(message);
            }
            return this.showText(glyphLine, (Iterator)new ActualTextIterator((GlyphLine)glyphLine));
        }

        private static boolean isNotDefGlyph(PdfFont font, Glyph glyph) {
            if (font instanceof PdfType0Font || font instanceof PdfTrueTypeFont) {
                return glyph.getCode() == 0;
            }
            if (font instanceof PdfType1Font || font instanceof PdfType3Font) {
                return glyph.getCode() == -1;
            }
            return false;
        }
    }
}

