/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.pdfocr;

import com.itextpdf.commons.utils.MessageFormatUtil;
import com.itextpdf.io.image.ImageData;
import com.itextpdf.io.image.ImageDataFactory;
import com.itextpdf.io.image.ImageType;
import com.itextpdf.io.image.ImageTypeDetector;
import com.itextpdf.io.image.TiffImageData;
import com.itextpdf.io.source.RandomAccessFileOrArray;
import com.itextpdf.io.source.RandomAccessSourceFactory;
import com.itextpdf.kernel.geom.Point;
import com.itextpdf.kernel.geom.Rectangle;
import com.itextpdf.layout.Document;
import com.itextpdf.layout.element.Paragraph;
import com.itextpdf.layout.layout.LayoutArea;
import com.itextpdf.layout.layout.LayoutContext;
import com.itextpdf.layout.renderer.IRenderer;
import com.itextpdf.layout.renderer.ParagraphRenderer;
import com.itextpdf.pdfocr.IImageRotationHandler;
import com.itextpdf.pdfocr.ScaleMode;
import com.itextpdf.pdfocr.exceptions.PdfOcrException;
import com.itextpdf.pdfocr.exceptions.PdfOcrInputException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PdfCreatorUtil {
    static final float PX_TO_PT = 0.75f;
    private static final float POINTS_PER_INCH = 72.0f;
    private static final Logger LOGGER = LoggerFactory.getLogger(PdfCreatorUtil.class);

    PdfCreatorUtil() {
    }

    static float calculateFontSize(Document document, String line, String fontFamily, float bboxHeightPt, float bboxWidthPt) throws PdfOcrException {
        Rectangle bbox = new Rectangle(bboxWidthPt * 1.5f, bboxHeightPt * 1.5f);
        float fontSize = 1.0f;
        float maxFontSize = bbox.getHeight();
        try {
            Paragraph paragraph = new Paragraph(line);
            paragraph.setWidth(bbox.getWidth());
            paragraph.setFontFamily(new String[]{fontFamily});
            while ((double)Math.abs(fontSize - maxFontSize) > 0.1) {
                float curFontSize = (fontSize + maxFontSize) / 2.0f;
                paragraph.setFontSize(curFontSize);
                ParagraphRenderer renderer = (ParagraphRenderer)paragraph.createRendererSubTree().setParent((IRenderer)document.getRenderer());
                LayoutContext context = new LayoutContext(new LayoutArea(1, bbox));
                if (renderer.layout(context).getStatus() == 1 && renderer.getLines().size() == 1) {
                    fontSize = curFontSize;
                    continue;
                }
                maxFontSize = curFontSize;
            }
        }
        catch (IllegalStateException e) {
            LOGGER.error("Provided FontProvider is invalid. Please check that it contains valid fonts and default font family name.");
            throw new PdfOcrInputException("Cannot resolve any of provided fonts. Please check provided FontProvider.", e);
        }
        return fontSize;
    }

    static float getRealLineWidth(Document document, String line, String fontFamily, float fontSize) {
        Paragraph paragraph = new Paragraph(line);
        paragraph.setFontFamily(new String[]{fontFamily});
        paragraph.setFontSize(fontSize);
        IRenderer renderer = paragraph.createRendererSubTree().setParent((IRenderer)document.getRenderer());
        return ((ParagraphRenderer)renderer).getMinMaxWidth().getMaxWidth();
    }

    static Point calculateImageCoordinates(Rectangle size, Rectangle imageSize) {
        float x = 0.0f;
        float y = 0.0f;
        if (size != null) {
            if (imageSize.getHeight() < size.getHeight()) {
                y = (size.getHeight() - imageSize.getHeight()) / 2.0f;
            }
            if (imageSize.getWidth() < size.getWidth()) {
                x = (size.getWidth() - imageSize.getWidth()) / 2.0f;
            }
        }
        return new Point((double)x, (double)y);
    }

    static List<ImageData> getImageData(File inputImage, IImageRotationHandler imageRotationHandler) throws PdfOcrException {
        ArrayList<ImageData> images = new ArrayList<ImageData>();
        try (FileInputStream imageStream = new FileInputStream(inputImage);){
            ImageType imageType = ImageTypeDetector.detectImageType((InputStream)imageStream);
            if (ImageType.TIFF == imageType) {
                int tiffPages = PdfCreatorUtil.getNumberOfPageTiff(inputImage);
                for (int page = 0; page < tiffPages; ++page) {
                    byte[] bytes = Files.readAllBytes(inputImage.toPath());
                    ImageData imageData = ImageDataFactory.createTiff((byte[])bytes, (boolean)true, (int)(page + 1), (boolean)true);
                    if (imageRotationHandler != null) {
                        imageData = imageRotationHandler.applyRotation(imageData);
                    }
                    images.add(imageData);
                }
            } else {
                ImageData imageData = ImageDataFactory.create((String)inputImage.getAbsolutePath());
                if (imageRotationHandler != null) {
                    imageData = imageRotationHandler.applyRotation(imageData);
                }
                images.add(imageData);
            }
        }
        catch (com.itextpdf.io.exceptions.IOException | IOException e) {
            LOGGER.error(MessageFormatUtil.format((String)"Cannot read input image {0}", (Object[])new Object[]{e.getMessage()}));
            throw new PdfOcrInputException("Cannot read input image", e);
        }
        return images;
    }

    static Rectangle calculateImageSize(ImageData imageData, ScaleMode scaleMode, Rectangle requiredSize) {
        if (imageData != null) {
            float imgWidthPt = PdfCreatorUtil.getPoints(imageData.getWidth());
            float imgHeightPt = PdfCreatorUtil.getPoints(imageData.getHeight());
            if (requiredSize == null || scaleMode == null) {
                return new Rectangle(imgWidthPt, imgHeightPt);
            }
            Rectangle size = new Rectangle(requiredSize.getWidth(), requiredSize.getHeight());
            if (scaleMode == ScaleMode.SCALE_HEIGHT) {
                float newHeight = imgHeightPt * requiredSize.getWidth() / imgWidthPt;
                size.setHeight(newHeight);
            } else if (scaleMode == ScaleMode.SCALE_WIDTH) {
                float newWidth = imgWidthPt * requiredSize.getHeight() / imgHeightPt;
                size.setWidth(newWidth);
            } else if (scaleMode == ScaleMode.SCALE_TO_FIT) {
                float ratio = Math.min(requiredSize.getWidth() / imgWidthPt, requiredSize.getHeight() / imgHeightPt);
                size.setWidth(imgWidthPt * ratio);
                size.setHeight(imgHeightPt * ratio);
            }
            return size;
        }
        return requiredSize;
    }

    static float getPoints(float pixels) {
        return pixels * 0.75f;
    }

    private static int getNumberOfPageTiff(File inputImage) throws IOException {
        RandomAccessFileOrArray raf = new RandomAccessFileOrArray(new RandomAccessSourceFactory().createBestSource(inputImage.getAbsolutePath()));
        int numOfPages = TiffImageData.getNumberOfPages((RandomAccessFileOrArray)raf);
        raf.close();
        return numOfPages;
    }
}

