/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.pdfocr.statistics;

import com.itextpdf.commons.actions.AbstractStatisticsAggregator;
import com.itextpdf.commons.actions.AbstractStatisticsEvent;
import com.itextpdf.commons.utils.MapUtil;
import com.itextpdf.pdfocr.exceptions.PdfOcrException;
import com.itextpdf.pdfocr.statistics.PdfOcrOutputType;
import com.itextpdf.pdfocr.statistics.PdfOcrOutputTypeStatisticsEvent;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

class PdfOcrOutputTypeStatisticsAggregator
extends AbstractStatisticsAggregator {
    private static final String STRING_FOR_DATA = "data";
    private static final String STRING_FOR_PDF = "pdf";
    private static final String STRING_FOR_PDFA = "pdfa";
    private static final Map<PdfOcrOutputType, String> OCR_OUTPUT_TYPES;
    private final Object lock = new Object();
    private final Map<String, Long> numberOfUsagesPerType = new LinkedHashMap<String, Long>();

    PdfOcrOutputTypeStatisticsAggregator() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void aggregate(AbstractStatisticsEvent event) {
        if (!(event instanceof PdfOcrOutputTypeStatisticsEvent)) {
            return;
        }
        PdfOcrOutputType type = ((PdfOcrOutputTypeStatisticsEvent)event).getPdfOcrStatisticsEventType();
        String fileTypeKey = PdfOcrOutputTypeStatisticsAggregator.getKeyForType(type);
        if (null == fileTypeKey) {
            throw new PdfOcrException("Statistics event type is not detected.");
        }
        Object object = this.lock;
        synchronized (object) {
            Long documentsOfThisRange = this.numberOfUsagesPerType.get(fileTypeKey);
            Long currentValue = documentsOfThisRange == null ? 1L : documentsOfThisRange + 1L;
            this.numberOfUsagesPerType.put(fileTypeKey, currentValue);
        }
    }

    public Object retrieveAggregation() {
        return Collections.unmodifiableMap(this.numberOfUsagesPerType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void merge(AbstractStatisticsAggregator aggregator) {
        if (!(aggregator instanceof PdfOcrOutputTypeStatisticsAggregator)) {
            return;
        }
        Map<String, Long> otherNumberOfFiles = ((PdfOcrOutputTypeStatisticsAggregator)aggregator).numberOfUsagesPerType;
        Object object = this.lock;
        synchronized (object) {
            MapUtil.merge(this.numberOfUsagesPerType, otherNumberOfFiles, (el1, el2) -> {
                if (el2 == null) {
                    return el1;
                }
                return el1 + el2;
            });
        }
    }

    static String getKeyForType(PdfOcrOutputType type) {
        return OCR_OUTPUT_TYPES.get((Object)type);
    }

    static {
        HashMap<PdfOcrOutputType, String> temp = new HashMap<PdfOcrOutputType, String>();
        temp.put(PdfOcrOutputType.DATA, STRING_FOR_DATA);
        temp.put(PdfOcrOutputType.PDF, STRING_FOR_PDF);
        temp.put(PdfOcrOutputType.PDFA, STRING_FOR_PDFA);
        OCR_OUTPUT_TYPES = Collections.unmodifiableMap(temp);
    }
}

