/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.pdfocr.statistics;

import com.itextpdf.commons.actions.AbstractStatisticsAggregator;
import com.itextpdf.commons.actions.AbstractStatisticsEvent;
import com.itextpdf.commons.actions.data.ProductData;
import com.itextpdf.pdfocr.exceptions.PdfOcrException;
import com.itextpdf.pdfocr.statistics.PdfOcrOutputType;
import com.itextpdf.pdfocr.statistics.PdfOcrOutputTypeStatisticsAggregator;
import java.util.Collections;
import java.util.List;

public class PdfOcrOutputTypeStatisticsEvent
extends AbstractStatisticsEvent {
    private static final String OCR_OUTPUT_TYPE = "ocrOutput";
    private final PdfOcrOutputType type;

    public PdfOcrOutputTypeStatisticsEvent(PdfOcrOutputType type, ProductData productData) {
        super(productData);
        if (type == null) {
            throw new PdfOcrException("Statistics event type can't be null");
        }
        if (null == PdfOcrOutputTypeStatisticsAggregator.getKeyForType(type)) {
            throw new PdfOcrException("Statistics event type is not detected.");
        }
        this.type = type;
    }

    public AbstractStatisticsAggregator createStatisticsAggregatorFromName(String statisticsName) {
        if (OCR_OUTPUT_TYPE.equals(statisticsName)) {
            return new PdfOcrOutputTypeStatisticsAggregator();
        }
        return super.createStatisticsAggregatorFromName(statisticsName);
    }

    public List<String> getStatisticsNames() {
        return Collections.singletonList(OCR_OUTPUT_TYPE);
    }

    public PdfOcrOutputType getPdfOcrStatisticsEventType() {
        return this.type;
    }
}

