/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.pdfocr;

import com.itextpdf.commons.actions.EventManager;
import com.itextpdf.commons.actions.IEvent;
import com.itextpdf.commons.actions.sequence.SequenceId;
import com.itextpdf.commons.utils.MessageFormatUtil;
import com.itextpdf.io.font.otf.ActualTextIterator;
import com.itextpdf.io.font.otf.Glyph;
import com.itextpdf.io.font.otf.GlyphLine;
import com.itextpdf.io.image.ImageData;
import com.itextpdf.kernel.actions.events.LinkDocumentIdEvent;
import com.itextpdf.kernel.font.PdfFont;
import com.itextpdf.kernel.font.PdfTrueTypeFont;
import com.itextpdf.kernel.font.PdfType0Font;
import com.itextpdf.kernel.font.PdfType1Font;
import com.itextpdf.kernel.font.PdfType3Font;
import com.itextpdf.kernel.geom.PageSize;
import com.itextpdf.kernel.geom.Point;
import com.itextpdf.kernel.geom.Rectangle;
import com.itextpdf.kernel.pdf.DocumentProperties;
import com.itextpdf.kernel.pdf.PdfAConformanceLevel;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.PdfDocumentInfo;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.PdfOutputIntent;
import com.itextpdf.kernel.pdf.PdfPage;
import com.itextpdf.kernel.pdf.PdfString;
import com.itextpdf.kernel.pdf.PdfViewerPreferences;
import com.itextpdf.kernel.pdf.PdfWriter;
import com.itextpdf.kernel.pdf.canvas.CanvasArtifact;
import com.itextpdf.kernel.pdf.canvas.CanvasTag;
import com.itextpdf.kernel.pdf.canvas.PdfCanvas;
import com.itextpdf.kernel.pdf.layer.IPdfOCG;
import com.itextpdf.kernel.pdf.layer.PdfLayer;
import com.itextpdf.kernel.pdf.tagutils.AccessibilityProperties;
import com.itextpdf.kernel.pdf.tagutils.DefaultAccessibilityProperties;
import com.itextpdf.kernel.pdf.tagutils.TagTreePointer;
import com.itextpdf.layout.Canvas;
import com.itextpdf.layout.Document;
import com.itextpdf.layout.element.Paragraph;
import com.itextpdf.layout.element.Text;
import com.itextpdf.layout.font.FontProvider;
import com.itextpdf.layout.properties.TextAlignment;
import com.itextpdf.pdfa.PdfADocument;
import com.itextpdf.pdfocr.IOcrEngine;
import com.itextpdf.pdfocr.IOcrProcessProperties;
import com.itextpdf.pdfocr.IProductAware;
import com.itextpdf.pdfocr.OcrPdfCreatorEventHelper;
import com.itextpdf.pdfocr.OcrPdfCreatorProperties;
import com.itextpdf.pdfocr.OcrProcessContext;
import com.itextpdf.pdfocr.PdfCreatorUtil;
import com.itextpdf.pdfocr.TextInfo;
import com.itextpdf.pdfocr.exceptions.PdfOcrException;
import com.itextpdf.pdfocr.statistics.PdfOcrOutputType;
import com.itextpdf.pdfocr.statistics.PdfOcrOutputTypeStatisticsEvent;
import com.itextpdf.pdfocr.structuretree.ArtifactItem;
import com.itextpdf.pdfocr.structuretree.LogicalStructureTreeItem;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OcrPdfCreator {
    private static final Logger LOGGER = LoggerFactory.getLogger(OcrPdfCreator.class);
    private IOcrEngine ocrEngine;
    private OcrPdfCreatorProperties ocrPdfCreatorProperties;

    public OcrPdfCreator(IOcrEngine ocrEngine) {
        this(ocrEngine, new OcrPdfCreatorProperties());
    }

    public OcrPdfCreator(IOcrEngine ocrEngine, OcrPdfCreatorProperties ocrPdfCreatorProperties) {
        this.setOcrEngine(ocrEngine);
        this.setOcrPdfCreatorProperties(ocrPdfCreatorProperties);
    }

    public final OcrPdfCreatorProperties getOcrPdfCreatorProperties() {
        return this.ocrPdfCreatorProperties;
    }

    public final void setOcrPdfCreatorProperties(OcrPdfCreatorProperties ocrPdfCreatorProperties) {
        this.ocrPdfCreatorProperties = ocrPdfCreatorProperties;
    }

    public final PdfDocument createPdfA(List<File> inputImages, PdfWriter pdfWriter, DocumentProperties documentProperties, PdfOutputIntent pdfOutputIntent, IOcrProcessProperties ocrProcessProperties) throws PdfOcrException {
        LOGGER.info(MessageFormatUtil.format((String)"Starting ocr for {0} image(s)", (Object[])new Object[]{inputImages.size()}));
        SequenceId pdfSequenceId = new SequenceId();
        OcrPdfCreatorEventHelper ocrEventHelper = new OcrPdfCreatorEventHelper(pdfSequenceId, this.ocrPdfCreatorProperties.getMetaInfo());
        OcrProcessContext ocrProcessContext = new OcrProcessContext(ocrEventHelper);
        ocrProcessContext.setOcrProcessProperties(ocrProcessProperties);
        LinkedHashMap<File, Map<Integer, List<TextInfo>>> imagesTextData = new LinkedHashMap<File, Map<Integer, List<TextInfo>>>();
        for (File inputImage : inputImages) {
            imagesTextData.put(inputImage, this.ocrEngine.doImageOcr(inputImage, ocrProcessContext));
        }
        return this.createPdfDocument(pdfWriter, pdfOutputIntent, imagesTextData, pdfSequenceId, documentProperties);
    }

    public final PdfDocument createPdfA(List<File> inputImages, PdfWriter pdfWriter, PdfOutputIntent pdfOutputIntent) throws PdfOcrException {
        return this.createPdfA(inputImages, pdfWriter, new DocumentProperties(), pdfOutputIntent);
    }

    public final PdfDocument createPdfA(List<File> inputImages, PdfWriter pdfWriter, DocumentProperties documentProperties, PdfOutputIntent pdfOutputIntent) throws PdfOcrException {
        return this.createPdfA(inputImages, pdfWriter, documentProperties, pdfOutputIntent, null);
    }

    public final PdfDocument createPdf(List<File> inputImages, PdfWriter pdfWriter, DocumentProperties documentProperties, IOcrProcessProperties ocrProcessProperties) throws PdfOcrException {
        return this.createPdfA(inputImages, pdfWriter, documentProperties, null, ocrProcessProperties);
    }

    public final PdfDocument createPdf(List<File> inputImages, PdfWriter pdfWriter, DocumentProperties documentProperties) throws PdfOcrException {
        return this.createPdfA(inputImages, pdfWriter, documentProperties, null, null);
    }

    public final PdfDocument createPdf(List<File> inputImages, PdfWriter pdfWriter) throws PdfOcrException {
        return this.createPdfA(inputImages, pdfWriter, new DocumentProperties(), null, null);
    }

    public void createPdfFile(List<File> inputImages, File outPdfFile) throws PdfOcrException, IOException {
        this.createPdfAFile(inputImages, outPdfFile, null);
    }

    public void createPdfAFile(List<File> inputImages, File outPdfFile, PdfOutputIntent pdfOutputIntent) throws PdfOcrException, IOException {
        DocumentProperties documentProperties = new DocumentProperties();
        if (this.ocrPdfCreatorProperties.getMetaInfo() != null) {
            documentProperties.setEventCountingMetaInfo(this.ocrPdfCreatorProperties.getMetaInfo());
        } else if (this.ocrEngine instanceof IProductAware) {
            documentProperties.setEventCountingMetaInfo(((IProductAware)((Object)this.ocrEngine)).getMetaInfoContainer().getMetaInfo());
        }
        try (PdfWriter pdfWriter = new PdfWriter(outPdfFile.getAbsolutePath());){
            PdfDocument pdfDocument = this.createPdfA(inputImages, pdfWriter, documentProperties, pdfOutputIntent);
            pdfDocument.close();
        }
    }

    public final IOcrEngine getOcrEngine() {
        return this.ocrEngine;
    }

    public final void setOcrEngine(IOcrEngine reader) {
        this.ocrEngine = reader;
    }

    private void addToCanvas(PdfDocument pdfDocument, Rectangle imageSize, List<TextInfo> pageText, ImageData imageData, boolean createPdfA3u) throws PdfOcrException {
        float multiplier;
        Rectangle rectangleSize = this.ocrPdfCreatorProperties.getPageSize() == null ? imageSize : this.ocrPdfCreatorProperties.getPageSize();
        PageSize size = new PageSize(rectangleSize);
        PdfPage pdfPage = pdfDocument.addNewPage(size);
        NotDefCheckingPdfCanvas canvas = new NotDefCheckingPdfCanvas(pdfPage, createPdfA3u);
        PdfLayer[] layers = OcrPdfCreator.createPdfLayers(this.ocrPdfCreatorProperties.getImageLayerName(), this.ocrPdfCreatorProperties.getTextLayerName(), pdfDocument);
        if (layers[0] != null) {
            canvas.beginLayer((IPdfOCG)layers[0]);
        }
        this.addImageToCanvas(imageData, imageSize, canvas);
        if (layers[0] != null && layers[0] != layers[1]) {
            canvas.endLayer();
        }
        float f = multiplier = imageData == null ? 1.0f : imageSize.getWidth() / PdfCreatorUtil.getPoints(imageData.getWidth());
        if (layers[1] != null && layers[0] != layers[1]) {
            canvas.beginLayer((IPdfOCG)layers[1]);
        }
        try {
            HashMap<TextInfo, TagTreePointer> flatLogicalTree = new HashMap<TextInfo, TagTreePointer>();
            if (this.ocrPdfCreatorProperties.isTagged()) {
                ArrayList<LogicalStructureTreeItem> logicalTree = new ArrayList<LogicalStructureTreeItem>();
                HashMap<LogicalStructureTreeItem, List<TextInfo>> leavesTextInfos = new HashMap<LogicalStructureTreeItem, List<TextInfo>>();
                boolean taggedSupported = OcrPdfCreator.getLogicalTree(pageText, logicalTree, leavesTextInfos);
                if (!taggedSupported) {
                    throw new PdfOcrException("Tagging is not supported by the OCR engine.");
                }
                pdfDocument.setTagged();
                this.buildLogicalTreeAndFlatten(logicalTree, leavesTextInfos, new TagTreePointer(pdfDocument).setPageForTagging(pdfPage), flatLogicalTree);
            }
            this.addTextToCanvas(imageSize, pageText, flatLogicalTree, canvas, multiplier, pdfPage);
        }
        catch (PdfOcrException e) {
            LOGGER.error(MessageFormatUtil.format((String)"Cannot create PDF document: {0}", (Object[])new Object[]{e.getMessage()}));
            throw new PdfOcrException("Cannot create PDF document: {0}").setMessageParams(e.getMessage());
        }
        if (layers[1] != null) {
            canvas.endLayer();
        }
    }

    private PdfDocument createPdfDocument(PdfWriter pdfWriter, PdfOutputIntent pdfOutputIntent, Map<File, Map<Integer, List<TextInfo>>> imagesTextData, SequenceId pdfSequenceId, DocumentProperties documentProperties) {
        boolean hasPdfLangProperty;
        boolean createPdfA3u = pdfOutputIntent != null;
        Object pdfDocument = createPdfA3u ? new PdfADocument(pdfWriter, PdfAConformanceLevel.PDF_A_3U, pdfOutputIntent, documentProperties) : new PdfDocument(pdfWriter, documentProperties);
        LinkDocumentIdEvent linkDocumentIdEvent = new LinkDocumentIdEvent(pdfDocument, pdfSequenceId);
        EventManager.getInstance().onEvent((IEvent)linkDocumentIdEvent);
        boolean bl = hasPdfLangProperty = this.ocrPdfCreatorProperties.getPdfLang() != null && !this.ocrPdfCreatorProperties.getPdfLang().equals("");
        if (createPdfA3u && !hasPdfLangProperty) {
            LOGGER.error(MessageFormatUtil.format((String)"Cannot create PDF document: {0}", (Object[])new Object[]{"PDF language property is not set"}));
            throw new PdfOcrException("Cannot create PDF document: {0}").setMessageParams("PDF language property is not set");
        }
        if (hasPdfLangProperty) {
            pdfDocument.getCatalog().setLang(new PdfString(this.ocrPdfCreatorProperties.getPdfLang()));
        }
        if (this.ocrPdfCreatorProperties.getTitle() != null) {
            pdfDocument.getCatalog().setViewerPreferences(new PdfViewerPreferences().setDisplayDocTitle(true));
            PdfDocumentInfo info = pdfDocument.getDocumentInfo();
            info.setTitle(this.ocrPdfCreatorProperties.getTitle());
        }
        this.ocrPdfCreatorProperties.getFontProvider().reset();
        this.addDataToPdfDocument(imagesTextData, (PdfDocument)pdfDocument, createPdfA3u);
        if (this.ocrEngine instanceof IProductAware && ((IProductAware)((Object)this.ocrEngine)).getProductData() != null) {
            PdfOcrOutputType eventType = createPdfA3u ? PdfOcrOutputType.PDFA : PdfOcrOutputType.PDF;
            PdfOcrOutputTypeStatisticsEvent docTypeStatisticsEvent = new PdfOcrOutputTypeStatisticsEvent(eventType, ((IProductAware)((Object)this.ocrEngine)).getProductData());
            EventManager.getInstance().onEvent((IEvent)docTypeStatisticsEvent);
        }
        return pdfDocument;
    }

    private void addDataToPdfDocument(Map<File, Map<Integer, List<TextInfo>>> imagesTextData, PdfDocument pdfDocument, boolean createPdfA3u) throws PdfOcrException {
        for (Map.Entry<File, Map<Integer, List<TextInfo>>> entry : imagesTextData.entrySet()) {
            File inputImage = entry.getKey();
            List<ImageData> imageDataList = PdfCreatorUtil.getImageData(inputImage, this.ocrPdfCreatorProperties.getImageRotationHandler());
            LOGGER.info(MessageFormatUtil.format((String)"Image {0} contains {1} page(s)", (Object[])new Object[]{inputImage.toString(), imageDataList.size()}));
            Map<Integer, List<TextInfo>> imageTextData = entry.getValue();
            if (imageTextData.keySet().size() <= 0) continue;
            for (int page = 0; page < imageDataList.size(); ++page) {
                ImageData imageData = imageDataList.get(page);
                Rectangle imageSize = PdfCreatorUtil.calculateImageSize(imageData, this.ocrPdfCreatorProperties.getScaleMode(), this.ocrPdfCreatorProperties.getPageSize());
                if (!imageTextData.containsKey(page + 1)) continue;
                this.addToCanvas(pdfDocument, imageSize, imageTextData.get(page + 1), imageData, createPdfA3u);
            }
        }
    }

    private void addImageToCanvas(ImageData imageData, Rectangle imageSize, PdfCanvas pdfCanvas) {
        if (imageData != null) {
            if (this.ocrPdfCreatorProperties.isTagged()) {
                pdfCanvas.openTag((CanvasTag)new CanvasArtifact());
            }
            if (this.ocrPdfCreatorProperties.getPageSize() == null) {
                pdfCanvas.addImageFittedIntoRectangle(imageData, imageSize, false);
            } else {
                Point coordinates = PdfCreatorUtil.calculateImageCoordinates(this.ocrPdfCreatorProperties.getPageSize(), imageSize);
                Rectangle rect = new Rectangle((float)coordinates.x, (float)coordinates.y, imageSize.getWidth(), imageSize.getHeight());
                pdfCanvas.addImageFittedIntoRectangle(imageData, rect, false);
            }
            if (this.ocrPdfCreatorProperties.isTagged()) {
                pdfCanvas.closeTag();
            }
        }
    }

    @Deprecated
    private static boolean getLogicalTree(List<TextInfo> textInfos, List<LogicalStructureTreeItem> logicalStructureTreeItems, Map<LogicalStructureTreeItem, List<TextInfo>> leavesTextInfos) {
        boolean taggedSupported = false;
        if (textInfos == null) {
            return taggedSupported;
        }
        for (TextInfo textInfo : textInfos) {
            LogicalStructureTreeItem topParent;
            LogicalStructureTreeItem structTreeItem = textInfo.getLogicalStructureTreeItem();
            if (structTreeItem instanceof ArtifactItem) continue;
            if (structTreeItem != null) {
                topParent = OcrPdfCreator.getTopParent(structTreeItem);
                taggedSupported = true;
            } else {
                structTreeItem = new LogicalStructureTreeItem();
                textInfo.setLogicalStructureTreeItem(structTreeItem);
                topParent = structTreeItem;
            }
            List<TextInfo> textInfosPerStructItem = leavesTextInfos.get(structTreeItem);
            if (textInfosPerStructItem == null) {
                textInfosPerStructItem = new ArrayList<TextInfo>();
                textInfosPerStructItem.add(textInfo);
                leavesTextInfos.put(structTreeItem, textInfosPerStructItem);
            } else {
                textInfosPerStructItem.add(textInfo);
            }
            if (logicalStructureTreeItems.contains(topParent)) continue;
            logicalStructureTreeItems.add(topParent);
        }
        return taggedSupported;
    }

    private static LogicalStructureTreeItem getTopParent(LogicalStructureTreeItem structInfo) {
        if (structInfo.getParent() != null) {
            return OcrPdfCreator.getTopParent(structInfo.getParent());
        }
        return structInfo;
    }

    private void buildLogicalTreeAndFlatten(List<LogicalStructureTreeItem> logicalStructureTreeItems, Map<LogicalStructureTreeItem, List<TextInfo>> leavesTextInfos, TagTreePointer tagPointer, Map<TextInfo, TagTreePointer> flatLogicalTree) {
        for (LogicalStructureTreeItem structTreeItem : logicalStructureTreeItems) {
            AccessibilityProperties accessibilityProperties = structTreeItem.getAccessibilityProperties();
            if (accessibilityProperties == null) {
                accessibilityProperties = new DefaultAccessibilityProperties(PdfName.Span.getValue());
            }
            tagPointer.addTag(accessibilityProperties);
            List<TextInfo> textItems = leavesTextInfos.get(structTreeItem);
            if (textItems != null) {
                for (TextInfo item : textItems) {
                    flatLogicalTree.put(item, new TagTreePointer(tagPointer));
                }
            }
            this.buildLogicalTreeAndFlatten(structTreeItem.getChildren(), leavesTextInfos, tagPointer, flatLogicalTree);
            tagPointer.moveToParent();
        }
    }

    private void addTextToCanvas(Rectangle imageSize, List<TextInfo> pageText, Map<TextInfo, TagTreePointer> flatLogicalTree, PdfCanvas pdfCanvas, float multiplier, PdfPage page) throws PdfOcrException {
        if (pageText == null || pageText.size() == 0) {
            return;
        }
        Rectangle pageMediaBox = page.getMediaBox();
        Point imageCoordinates = PdfCreatorUtil.calculateImageCoordinates(this.ocrPdfCreatorProperties.getPageSize(), imageSize);
        for (TextInfo item : pageText) {
            float bboxWidthPt = OcrPdfCreator.getWidthPt(item, multiplier);
            float bboxHeightPt = OcrPdfCreator.getHeightPt(item, multiplier);
            FontProvider fontProvider = this.getOcrPdfCreatorProperties().getFontProvider();
            String fontFamily = this.getOcrPdfCreatorProperties().getDefaultFontFamily();
            String line = item.getText();
            if (!OcrPdfCreator.lineNotEmpty(line, bboxHeightPt, bboxWidthPt)) continue;
            Document document = new Document(pdfCanvas.getDocument());
            document.setFontProvider(fontProvider);
            float fontSize = PdfCreatorUtil.calculateFontSize(document, line, fontFamily, bboxHeightPt, bboxWidthPt);
            float lineWidth = PdfCreatorUtil.getRealLineWidth(document, line, fontFamily, fontSize);
            float xOffset = OcrPdfCreator.getXOffsetPt(item, multiplier);
            float yOffset = OcrPdfCreator.getYOffsetPt(item, multiplier, imageSize);
            TagTreePointer tagPointer = flatLogicalTree.get(item);
            if (tagPointer != null) {
                pdfCanvas.openTag(tagPointer.getTagReference());
            } else if (this.ocrPdfCreatorProperties.isTagged()) {
                pdfCanvas.openTag((CanvasTag)new CanvasArtifact());
            }
            Canvas canvas = new Canvas(pdfCanvas, pageMediaBox);
            canvas.setFontProvider(fontProvider);
            Text text = new Text(line).setHorizontalScaling(bboxWidthPt / lineWidth);
            Paragraph paragraph = (Paragraph)new Paragraph(text).setMargin(0.0f);
            ((Paragraph)paragraph.setFontFamily(new String[]{fontFamily})).setFontSize(fontSize);
            paragraph.setWidth(bboxWidthPt * 1.5f);
            if (this.ocrPdfCreatorProperties.getTextColor() != null) {
                paragraph.setFontColor(this.ocrPdfCreatorProperties.getTextColor());
            } else {
                paragraph.setTextRenderingMode(3);
            }
            canvas.showTextAligned(paragraph, xOffset + (float)imageCoordinates.x, yOffset + (float)imageCoordinates.y, TextAlignment.LEFT);
            if (this.ocrPdfCreatorProperties.isTagged()) {
                pdfCanvas.closeTag();
            }
            canvas.close();
        }
    }

    private static PdfLayer[] createPdfLayers(String imageLayerName, String textLayerName, PdfDocument pdfDocument) {
        if (imageLayerName == null && textLayerName == null) {
            return new PdfLayer[]{null, null};
        }
        if (imageLayerName == null) {
            return new PdfLayer[]{null, new PdfLayer(textLayerName, pdfDocument)};
        }
        if (textLayerName == null) {
            return new PdfLayer[]{new PdfLayer(imageLayerName, pdfDocument), null};
        }
        if (imageLayerName.equals(textLayerName)) {
            PdfLayer pdfLayer = new PdfLayer(imageLayerName, pdfDocument);
            return new PdfLayer[]{pdfLayer, pdfLayer};
        }
        return new PdfLayer[]{new PdfLayer(imageLayerName, pdfDocument), new PdfLayer(textLayerName, pdfDocument)};
    }

    private static float getLeft(TextInfo textInfo, float multiplier) {
        return textInfo.getBboxRect().getLeft() * multiplier;
    }

    private static float getRight(TextInfo textInfo, float multiplier) {
        return (textInfo.getBboxRect().getRight() + 1.0f) * multiplier - 1.0f;
    }

    private static float getTop(TextInfo textInfo, float multiplier) {
        return textInfo.getBboxRect().getTop() * multiplier;
    }

    private static float getBottom(TextInfo textInfo, float multiplier) {
        return (textInfo.getBboxRect().getBottom() + 1.0f) * multiplier - 1.0f;
    }

    private static boolean lineNotEmpty(String line, float bboxHeightPt, float bboxWidthPt) {
        return !line.isEmpty() && bboxHeightPt > 0.0f && bboxWidthPt > 0.0f;
    }

    private static float getWidthPt(TextInfo textInfo, float multiplier) {
        if (textInfo.getBboxRect() == null) {
            return PdfCreatorUtil.getPoints(OcrPdfCreator.getRight(textInfo, multiplier) - OcrPdfCreator.getLeft(textInfo, multiplier));
        }
        return OcrPdfCreator.getRight(textInfo, multiplier) - OcrPdfCreator.getLeft(textInfo, multiplier);
    }

    private static float getHeightPt(TextInfo textInfo, float multiplier) {
        if (textInfo.getBboxRect() == null) {
            return PdfCreatorUtil.getPoints(OcrPdfCreator.getBottom(textInfo, multiplier) - OcrPdfCreator.getTop(textInfo, multiplier));
        }
        return OcrPdfCreator.getTop(textInfo, multiplier) - OcrPdfCreator.getBottom(textInfo, multiplier);
    }

    private static float getXOffsetPt(TextInfo textInfo, float multiplier) {
        if (textInfo.getBboxRect() == null) {
            return PdfCreatorUtil.getPoints(OcrPdfCreator.getLeft(textInfo, multiplier));
        }
        return OcrPdfCreator.getLeft(textInfo, multiplier);
    }

    private static float getYOffsetPt(TextInfo textInfo, float multiplier, Rectangle imageSize) {
        if (textInfo.getBboxRect() == null) {
            return imageSize.getHeight() - PdfCreatorUtil.getPoints(OcrPdfCreator.getBottom(textInfo, multiplier));
        }
        return OcrPdfCreator.getBottom(textInfo, multiplier);
    }

    private static class ActualTextCheckingGlyphLine
    extends GlyphLine {
        public ActualTextCheckingGlyphLine(GlyphLine other) {
            super(other);
        }

        public void setActualTextToGlyph(int i, String text) {
            if (this.actualText == null || this.actualText.size() <= i || this.actualText.get(i) == null) {
                super.setActualText(i, i + 1, text);
            }
        }
    }

    private static class NotDefCheckingPdfCanvas
    extends PdfCanvas {
        private final boolean createPdfA3u;

        public NotDefCheckingPdfCanvas(PdfPage page, boolean createPdfA3u) {
            super(page);
            this.createPdfA3u = createPdfA3u;
        }

        public PdfCanvas showText(GlyphLine text) {
            ActualTextCheckingGlyphLine glyphLine = new ActualTextCheckingGlyphLine(text);
            PdfFont currentFont = this.getGraphicsState().getFont();
            boolean notDefGlyphsExists = false;
            String message = "Could not find a glyph corresponding to Unicode character {0} in any of the fonts";
            for (int i = glyphLine.start; i < glyphLine.end; ++i) {
                if (!NotDefCheckingPdfCanvas.isNotDefGlyph(currentFont, glyphLine.get(i))) continue;
                notDefGlyphsExists = true;
                message = MessageFormatUtil.format((String)"Could not find a glyph corresponding to Unicode character {0} in any of the fonts", (Object[])new Object[]{glyphLine.get(i).getUnicode()});
                if (this.createPdfA3u) {
                    throw new PdfOcrException(message);
                }
                glyphLine.setActualTextToGlyph(i, glyphLine.toUnicodeString(i, i + 1));
                Glyph glyph = new Glyph(glyphLine.get(i));
                glyph.setUnicode(-1);
                glyphLine.set(i, glyph);
            }
            if (notDefGlyphsExists) {
                LOGGER.warn(message);
            }
            return this.showText(glyphLine, (Iterator)new ActualTextIterator((GlyphLine)glyphLine));
        }

        private static boolean isNotDefGlyph(PdfFont font, Glyph glyph) {
            if (font instanceof PdfType0Font || font instanceof PdfTrueTypeFont) {
                return glyph.getCode() == 0;
            }
            if (font instanceof PdfType1Font || font instanceof PdfType3Font) {
                return glyph.getCode() == -1;
            }
            return false;
        }
    }
}

