/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.pdfocr;

import com.itextpdf.commons.actions.contexts.IMetaInfo;
import com.itextpdf.kernel.colors.Color;
import com.itextpdf.kernel.geom.Rectangle;
import com.itextpdf.layout.font.FontProvider;
import com.itextpdf.pdfocr.IImageRotationHandler;
import com.itextpdf.pdfocr.PdfOcrFontProvider;
import com.itextpdf.pdfocr.ScaleMode;

public class OcrPdfCreatorProperties {
    private FontProvider fontProvider = null;
    private String defaultFontFamily = null;
    private Color textColor = null;
    private ScaleMode scaleMode = ScaleMode.SCALE_TO_FIT;
    private Rectangle pageSize = null;
    private String imageLayerName = null;
    private String textLayerName = null;
    private String pdfLang = "";
    private String title = null;
    private IImageRotationHandler imageRotationHandler;
    private IMetaInfo metaInfo;
    private boolean tagged = false;

    public OcrPdfCreatorProperties() {
    }

    public OcrPdfCreatorProperties(OcrPdfCreatorProperties other) {
        this.scaleMode = other.scaleMode;
        this.pageSize = other.pageSize;
        this.imageLayerName = other.imageLayerName;
        this.textLayerName = other.textLayerName;
        this.textColor = other.textColor;
        this.pdfLang = other.pdfLang;
        this.title = other.title;
        this.fontProvider = other.fontProvider;
        this.defaultFontFamily = other.defaultFontFamily;
        this.imageRotationHandler = other.imageRotationHandler;
    }

    public final Color getTextColor() {
        return this.textColor;
    }

    public final OcrPdfCreatorProperties setTextColor(Color textColor) {
        this.textColor = textColor;
        return this;
    }

    public final ScaleMode getScaleMode() {
        return this.scaleMode;
    }

    public final OcrPdfCreatorProperties setScaleMode(ScaleMode scaleMode) {
        this.scaleMode = scaleMode;
        return this;
    }

    public final Rectangle getPageSize() {
        return this.pageSize;
    }

    public final OcrPdfCreatorProperties setPageSize(Rectangle pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    public final String getImageLayerName() {
        return this.imageLayerName;
    }

    public final OcrPdfCreatorProperties setImageLayerName(String layerName) {
        this.imageLayerName = layerName;
        return this;
    }

    public final String getTextLayerName() {
        return this.textLayerName;
    }

    public final OcrPdfCreatorProperties setTextLayerName(String layerName) {
        this.textLayerName = layerName;
        return this;
    }

    public final String getPdfLang() {
        return this.pdfLang;
    }

    public final OcrPdfCreatorProperties setPdfLang(String language) {
        this.pdfLang = language;
        return this;
    }

    public final String getTitle() {
        return this.title;
    }

    public final OcrPdfCreatorProperties setTitle(String title) {
        this.title = title;
        return this;
    }

    public FontProvider getFontProvider() {
        if (this.fontProvider == null) {
            this.fontProvider = new PdfOcrFontProvider();
        }
        return this.fontProvider;
    }

    public OcrPdfCreatorProperties setFontProvider(FontProvider fontProvider) {
        this.fontProvider = fontProvider;
        return this;
    }

    public OcrPdfCreatorProperties setFontProvider(FontProvider fontProvider, String defaultFontFamily) {
        this.fontProvider = fontProvider;
        this.defaultFontFamily = defaultFontFamily;
        return this;
    }

    public String getDefaultFontFamily() {
        return this.defaultFontFamily == null || this.defaultFontFamily.length() == 0 ? this.getFontProvider().getDefaultFontFamily() : this.defaultFontFamily;
    }

    public IImageRotationHandler getImageRotationHandler() {
        return this.imageRotationHandler;
    }

    public OcrPdfCreatorProperties setImageRotationHandler(IImageRotationHandler imageRotationDetector) {
        this.imageRotationHandler = imageRotationDetector;
        return this;
    }

    public OcrPdfCreatorProperties setTagged(boolean tagged) {
        this.tagged = tagged;
        return this;
    }

    public boolean isTagged() {
        return this.tagged;
    }

    public OcrPdfCreatorProperties setMetaInfo(IMetaInfo metaInfo) {
        this.metaInfo = metaInfo;
        return this;
    }

    IMetaInfo getMetaInfo() {
        return this.metaInfo;
    }
}

