/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.pdfocr;

import com.itextpdf.commons.utils.MessageFormatUtil;
import com.itextpdf.io.util.ResourceUtil;
import com.itextpdf.io.util.StreamUtil;
import com.itextpdf.layout.font.FontProvider;
import com.itextpdf.layout.font.FontSet;
import java.io.IOException;
import java.io.InputStream;
import org.slf4j.LoggerFactory;

public class PdfOcrFontProvider
extends FontProvider {
    private static final String DEFAULT_FONT_PATH = "com/itextpdf/pdfocr/fonts/LiberationSans-Regular.ttf";
    private static final String DEFAULT_FONT_FAMILY = "LiberationSans";

    public PdfOcrFontProvider() {
        super(DEFAULT_FONT_FAMILY);
        this.addFont(this.getDefaultFont(), "Identity-H");
    }

    public PdfOcrFontProvider(FontSet fontSet, String defaultFontFamily) {
        super(fontSet, defaultFontFamily);
    }

    public String getDefaultFontFamily() {
        return DEFAULT_FONT_FAMILY;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private byte[] getDefaultFont() {
        try (InputStream stream = ResourceUtil.getResourceStream((String)DEFAULT_FONT_PATH);){
            byte[] byArray = StreamUtil.inputStreamToArray((InputStream)stream);
            return byArray;
        }
        catch (IOException e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error(MessageFormatUtil.format((String)"Cannot default read font: {0}", (Object[])new Object[]{e.getMessage()}));
            return new byte[0];
        }
    }
}

