/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.pdfocr.tesseract4;

import com.itextpdf.io.image.ImageType;
import com.itextpdf.io.util.MessageFormatUtil;
import com.itextpdf.kernel.counter.EventCounterHandler;
import com.itextpdf.kernel.counter.event.IEvent;
import com.itextpdf.kernel.counter.event.IMetaInfo;
import com.itextpdf.pdfocr.IOcrEngine;
import com.itextpdf.pdfocr.OcrPdfCreatorMetaInfo;
import com.itextpdf.pdfocr.TextInfo;
import com.itextpdf.pdfocr.events.IThreadLocalMetaInfoAware;
import com.itextpdf.pdfocr.tesseract4.ImagePreprocessingUtil;
import com.itextpdf.pdfocr.tesseract4.OutputFormat;
import com.itextpdf.pdfocr.tesseract4.ReflectionUtils;
import com.itextpdf.pdfocr.tesseract4.Tesseract4OcrEngineProperties;
import com.itextpdf.pdfocr.tesseract4.Tesseract4OcrException;
import com.itextpdf.pdfocr.tesseract4.TesseractHelper;
import com.itextpdf.pdfocr.tesseract4.TesseractOcrUtil;
import com.itextpdf.pdfocr.tesseract4.events.PdfOcrTesseract4Event;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.slf4j.LoggerFactory;

public abstract class AbstractTesseract4OcrEngine
implements IOcrEngine,
IThreadLocalMetaInfoAware {
    private static final Set<ImageType> SUPPORTED_IMAGE_FORMATS = Collections.unmodifiableSet(new HashSet<ImageType>(Arrays.asList(ImageType.BMP, ImageType.PNG, ImageType.TIFF, ImageType.JPEG)));
    Set<UUID> processedUUID = new HashSet<UUID>();
    private Tesseract4OcrEngineProperties tesseract4OcrEngineProperties;
    private ThreadLocal<IMetaInfo> threadLocalMetaInfo = new ThreadLocal();

    public AbstractTesseract4OcrEngine(Tesseract4OcrEngineProperties tesseract4OcrEngineProperties) {
        this.tesseract4OcrEngineProperties = tesseract4OcrEngineProperties;
    }

    public void doTesseractOcr(File inputImage, File outputFile, OutputFormat outputFormat) {
        this.doTesseractOcr(inputImage, Collections.singletonList(outputFile), outputFormat, 1);
    }

    public void createTxtFile(List<File> inputImages, File txtFile) {
        LoggerFactory.getLogger(this.getClass()).info(MessageFormatUtil.format((String)"Starting ocr for {0} image(s)", (Object[])new Object[]{inputImages.size()}));
        StringBuilder content = new StringBuilder();
        for (File inputImage : inputImages) {
            content.append(this.doImageOcr(inputImage, OutputFormat.TXT));
        }
        TesseractHelper.writeToTextFile(txtFile.getAbsolutePath(), content.toString());
    }

    public final Tesseract4OcrEngineProperties getTesseract4OcrEngineProperties() {
        return this.tesseract4OcrEngineProperties;
    }

    public final void setTesseract4OcrEngineProperties(Tesseract4OcrEngineProperties tesseract4OcrEngineProperties) {
        this.tesseract4OcrEngineProperties = tesseract4OcrEngineProperties;
    }

    public final String getLanguagesAsString() {
        if (this.getTesseract4OcrEngineProperties().getLanguages().size() > 0) {
            return String.join((CharSequence)"+", this.getTesseract4OcrEngineProperties().getLanguages());
        }
        return this.getTesseract4OcrEngineProperties().getDefaultLanguage();
    }

    public final Map<Integer, List<TextInfo>> doImageOcr(File input) {
        this.verifyImageFormatValidity(input);
        return ((TextInfoTesseractOcrResult)this.processInputFiles(input, OutputFormat.HOCR)).getTextInfos();
    }

    public final String doImageOcr(File input, OutputFormat outputFormat) {
        String result = "";
        this.verifyImageFormatValidity(input);
        ITesseractOcrResult processedData = this.processInputFiles(input, outputFormat);
        if (processedData != null) {
            if (outputFormat.equals((Object)OutputFormat.TXT)) {
                result = ((StringTesseractOcrResult)processedData).getData();
            } else {
                StringBuilder outputText = new StringBuilder();
                Map<Integer, List<TextInfo>> outputMap = ((TextInfoTesseractOcrResult)processedData).getTextInfos();
                for (int page : outputMap.keySet()) {
                    StringBuilder pageText = new StringBuilder();
                    for (TextInfo textInfo : outputMap.get(page)) {
                        pageText.append(textInfo.getText());
                        pageText.append(System.lineSeparator());
                    }
                    outputText.append((CharSequence)pageText);
                    outputText.append(System.lineSeparator());
                }
                result = outputText.toString();
            }
        }
        return result;
    }

    public boolean isWindows() {
        return this.identifyOsType().toLowerCase().contains("win");
    }

    public String identifyOsType() {
        String os = System.getProperty("os.name") == null ? System.getProperty("OS") : System.getProperty("os.name");
        return os.toLowerCase();
    }

    public void validateLanguages(List<String> languagesList) throws Tesseract4OcrException {
        String suffix = ".traineddata";
        if (languagesList.size() == 0) {
            if (!new File(this.getTessData() + File.separatorChar + this.getTesseract4OcrEngineProperties().getDefaultLanguage() + suffix).exists()) {
                throw new Tesseract4OcrException("{0} does not exist in {1}").setMessageParams(new String[]{this.getTesseract4OcrEngineProperties().getDefaultLanguage() + suffix, this.getTessData()});
            }
        } else {
            for (String lang : languagesList) {
                if (new File(this.getTessData() + File.separatorChar + lang + suffix).exists()) continue;
                throw new Tesseract4OcrException("{0} does not exist in {1}").setMessageParams(new String[]{lang + suffix, this.getTessData()});
            }
        }
    }

    public IMetaInfo getThreadLocalMetaInfo() {
        return this.threadLocalMetaInfo.get();
    }

    public IThreadLocalMetaInfoAware setThreadLocalMetaInfo(IMetaInfo metaInfo) {
        this.threadLocalMetaInfo.set(metaInfo);
        return this;
    }

    void doTesseractOcr(File inputImage, List<File> outputFiles, OutputFormat outputFormat, int pageNumber) {
        this.doTesseractOcr(inputImage, outputFiles, outputFormat, pageNumber, true);
    }

    abstract void doTesseractOcr(File var1, List<File> var2, OutputFormat var3, int var4, boolean var5);

    String getTessData() {
        if (this.getTesseract4OcrEngineProperties().getPathToTessData() == null) {
            throw new Tesseract4OcrException("Path to tess data directory cannot be null and must be set to a valid directory");
        }
        return this.getTesseract4OcrEngineProperties().getPathToTessData().getAbsolutePath();
    }

    void scheduledCheck() {
        ReflectionUtils.scheduledCheck();
    }

    void onEvent() {
        IMetaInfo metaInfo = this.getThreadLocalMetaInfo();
        if (!(metaInfo instanceof OcrPdfCreatorMetaInfo)) {
            EventCounterHandler.getInstance().onEvent((IEvent)PdfOcrTesseract4Event.TESSERACT4_IMAGE_OCR, this.getThreadLocalMetaInfo(), this.getClass());
        } else {
            UUID uuid = ((OcrPdfCreatorMetaInfo)metaInfo).getDocumentId();
            if (!this.processedUUID.contains(uuid)) {
                this.processedUUID.add(uuid);
                EventCounterHandler.getInstance().onEvent((IEvent)(OcrPdfCreatorMetaInfo.PdfDocumentType.PDFA.equals((Object)((OcrPdfCreatorMetaInfo)metaInfo).getPdfDocumentType()) ? PdfOcrTesseract4Event.TESSERACT4_IMAGE_TO_PDFA : PdfOcrTesseract4Event.TESSERACT4_IMAGE_TO_PDF), ((OcrPdfCreatorMetaInfo)metaInfo).getWrappedMetaInfo(), this.getClass());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ITesseractOcrResult processInputFiles(File input, OutputFormat outputFormat) {
        LinkedHashMap<Integer, List<TextInfo>> imageData = new LinkedHashMap<Integer, List<TextInfo>>();
        StringBuilder data = new StringBuilder();
        ArrayList<File> tempFiles = new ArrayList<File>();
        ITesseractOcrResult result = null;
        try {
            int realNumOfPages = !ImagePreprocessingUtil.isTiffImage(input) ? 1 : ImagePreprocessingUtil.getNumberOfPageTiff(input);
            int numOfPages = this.getTesseract4OcrEngineProperties().isPreprocessingImages() ? realNumOfPages : 1;
            int numOfFiles = this.getTesseract4OcrEngineProperties().isPreprocessingImages() ? 1 : realNumOfPages;
            for (int page = 1; page <= numOfPages; ++page) {
                String extension = outputFormat.equals((Object)OutputFormat.HOCR) ? ".hocr" : ".txt";
                for (int i = 0; i < numOfFiles; ++i) {
                    tempFiles.add(this.createTempFile(extension));
                }
                this.doTesseractOcr(input, tempFiles, outputFormat, page);
                if (outputFormat.equals((Object)OutputFormat.HOCR)) {
                    ArrayList<File> tempTxtFiles = null;
                    if (this.getTesseract4OcrEngineProperties().isUseTxtToImproveHocrParsing()) {
                        tempTxtFiles = new ArrayList<File>();
                        for (int i = 0; i < numOfFiles; ++i) {
                            tempTxtFiles.add(this.createTempFile(".txt"));
                        }
                        this.doTesseractOcr(input, tempTxtFiles, OutputFormat.TXT, page, false);
                    }
                    Map<Integer, List<TextInfo>> pageData = TesseractHelper.parseHocrFile(tempFiles, tempTxtFiles, this.getTesseract4OcrEngineProperties());
                    if (this.getTesseract4OcrEngineProperties().isPreprocessingImages()) {
                        imageData.put(page, pageData.get(1));
                    } else {
                        imageData = pageData;
                    }
                    result = new TextInfoTesseractOcrResult(imageData);
                    continue;
                }
                for (File tmpFile : tempFiles) {
                    if (!Files.exists(Paths.get(tmpFile.getAbsolutePath(), new String[0]), new LinkOption[0])) continue;
                    data.append(TesseractHelper.readTxtFile(tmpFile));
                }
                result = new StringTesseractOcrResult(data.toString());
            }
        }
        catch (IOException e) {
            LoggerFactory.getLogger(this.getClass()).error(MessageFormatUtil.format((String)"Cannot ocr input file: {1}", (Object[])new Object[]{e.getMessage()}));
        }
        finally {
            for (File file : tempFiles) {
                TesseractHelper.deleteFile(file.getAbsolutePath());
            }
        }
        return result;
    }

    private File createTempFile(String extension) {
        String tmpFileName = TesseractOcrUtil.getTempFilePath(UUID.randomUUID().toString(), extension);
        return new File(tmpFileName);
    }

    private void verifyImageFormatValidity(File image) throws Tesseract4OcrException {
        ImageType type = ImagePreprocessingUtil.getImageType(image);
        boolean isValid = SUPPORTED_IMAGE_FORMATS.contains(type);
        if (!isValid) {
            LoggerFactory.getLogger(this.getClass()).error(MessageFormatUtil.format((String)"Cannot read input image {0}", (Object[])new Object[]{image.getAbsolutePath()}));
            throw new Tesseract4OcrException("{0} format is not supported.").setMessageParams(new String[]{image.getName()});
        }
    }

    static class TextInfoTesseractOcrResult
    implements ITesseractOcrResult {
        private Map<Integer, List<TextInfo>> textInfos;

        TextInfoTesseractOcrResult(Map<Integer, List<TextInfo>> textInfos) {
            this.textInfos = textInfos;
        }

        Map<Integer, List<TextInfo>> getTextInfos() {
            return this.textInfos;
        }
    }

    static class StringTesseractOcrResult
    implements ITesseractOcrResult {
        private String data;

        StringTesseractOcrResult(String data) {
            this.data = data;
        }

        String getData() {
            return this.data;
        }
    }

    static interface ITesseractOcrResult {
    }
}

