/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.pdfocr.tesseract4;

import com.itextpdf.io.util.FileUtil;
import com.itextpdf.io.util.MessageFormatUtil;
import com.itextpdf.pdfocr.OcrEngineProperties;
import com.itextpdf.pdfocr.tesseract4.ImagePreprocessingOptions;
import com.itextpdf.pdfocr.tesseract4.Tesseract4OcrException;
import com.itextpdf.pdfocr.tesseract4.TesseractOcrUtil;
import com.itextpdf.pdfocr.tesseract4.TextPositioning;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.slf4j.LoggerFactory;

public class Tesseract4OcrEngineProperties
extends OcrEngineProperties {
    static final String DEFAULT_USER_WORDS_SUFFIX = "user-words";
    private static final String DEFAULT_LANGUAGE = "eng";
    private File tessDataDir;
    private Integer pageSegMode = 3;
    private TextPositioning textPositioning = TextPositioning.BY_LINES;
    private String pathToUserWordsFile = null;
    private boolean isUserWordsFileTemporary = false;
    private boolean useTxtToImproveHocrParsing;
    private ImagePreprocessingOptions imagePreprocessingOptions = new ImagePreprocessingOptions();
    private int minimalConfidenceLevel;

    public Tesseract4OcrEngineProperties() {
    }

    public Tesseract4OcrEngineProperties(Tesseract4OcrEngineProperties other) {
        super((OcrEngineProperties)other);
        this.tessDataDir = other.tessDataDir;
        this.pageSegMode = other.pageSegMode;
        this.textPositioning = other.textPositioning;
        this.pathToUserWordsFile = other.pathToUserWordsFile;
        this.useTxtToImproveHocrParsing = other.useTxtToImproveHocrParsing;
        this.imagePreprocessingOptions = other.imagePreprocessingOptions;
        this.minimalConfidenceLevel = other.minimalConfidenceLevel;
    }

    public final String getDefaultLanguage() {
        return DEFAULT_LANGUAGE;
    }

    public final String getDefaultUserWordsSuffix() {
        return DEFAULT_USER_WORDS_SUFFIX;
    }

    public final File getPathToTessData() {
        return this.tessDataDir;
    }

    public final Tesseract4OcrEngineProperties setPathToTessData(File tessData) {
        if (tessData == null || !FileUtil.directoryExists((String)tessData.getAbsolutePath())) {
            throw new Tesseract4OcrException("Provided path to tess data directory does not exist or it is an invalid directory");
        }
        this.tessDataDir = tessData;
        return this;
    }

    public final Integer getPageSegMode() {
        return this.pageSegMode;
    }

    public final Tesseract4OcrEngineProperties setPageSegMode(Integer mode) {
        this.pageSegMode = mode;
        return this;
    }

    public final boolean isPreprocessingImages() {
        return this.imagePreprocessingOptions != null;
    }

    public final Tesseract4OcrEngineProperties setPreprocessingImages(boolean preprocess) {
        if (preprocess) {
            if (this.imagePreprocessingOptions == null) {
                this.imagePreprocessingOptions = new ImagePreprocessingOptions();
            }
        } else {
            this.imagePreprocessingOptions = null;
        }
        return this;
    }

    public final TextPositioning getTextPositioning() {
        return this.textPositioning;
    }

    public final Tesseract4OcrEngineProperties setTextPositioning(TextPositioning positioning) {
        this.textPositioning = positioning;
        return this;
    }

    Tesseract4OcrEngineProperties setUserWords(String language, List<String> userWords) throws Tesseract4OcrException {
        this.setPathToUserWordsFile(null);
        if (userWords != null && userWords.size() > 0) {
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                for (String word : userWords) {
                    byte[] bytesWord = word.getBytes();
                    baos.write(bytesWord, 0, bytesWord.length);
                    byte[] bytesSeparator = System.lineSeparator().getBytes();
                    baos.write(bytesSeparator, 0, bytesSeparator.length);
                }
                ByteArrayInputStream inputStream = new ByteArrayInputStream(baos.toByteArray());
                baos.close();
                this.setUserWords(language, inputStream);
            }
            catch (IOException e) {
                LoggerFactory.getLogger(((Object)((Object)this)).getClass()).warn(MessageFormatUtil.format((String)"Cannot use custom user words: {0}", (Object[])new Object[]{e.getMessage()}));
            }
        }
        return this;
    }

    Tesseract4OcrEngineProperties setUserWords(String language, InputStream inputStream) throws Tesseract4OcrException {
        this.setPathToUserWordsFile(null);
        if (!this.getLanguages().contains(language)) {
            if (DEFAULT_LANGUAGE.equals(language.toLowerCase())) {
                List languagesList = this.getLanguages();
                languagesList.add(language);
                this.setLanguages(languagesList);
            } else {
                throw new Tesseract4OcrException("Provided list of languages doesn't contain {0} language").setMessageParams(new String[]{language});
            }
        }
        String userWordsFileName = TesseractOcrUtil.getTempFilePath(language, ".user-words");
        try (FileWriter writer = new FileWriter(userWordsFileName);){
            int data;
            InputStreamReader reader = new InputStreamReader(inputStream, StandardCharsets.UTF_8);
            while ((data = ((Reader)reader).read()) != -1) {
                writer.write(data);
            }
            writer.write(System.lineSeparator());
            this.setPathToUserWordsFile(userWordsFileName, true);
        }
        catch (IOException e) {
            this.setPathToUserWordsFile(null);
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).warn(MessageFormatUtil.format((String)"Cannot use custom user words: {0}", (Object[])new Object[]{e.getMessage()}));
        }
        return this;
    }

    final String getPathToUserWordsFile() {
        return this.pathToUserWordsFile;
    }

    final Tesseract4OcrEngineProperties setPathToUserWordsFile(String pathToUserWordsFile) {
        return this.setPathToUserWordsFile(pathToUserWordsFile, false);
    }

    final Tesseract4OcrEngineProperties setPathToUserWordsFile(String pathToUserWordsFile, boolean isTempFile) {
        this.pathToUserWordsFile = pathToUserWordsFile;
        this.isUserWordsFileTemporary = isTempFile;
        return this;
    }

    final boolean isUserWordsFileTemporary() {
        return this.isUserWordsFileTemporary;
    }

    public final boolean isUseTxtToImproveHocrParsing() {
        return this.useTxtToImproveHocrParsing;
    }

    public final Tesseract4OcrEngineProperties setUseTxtToImproveHocrParsing(boolean useTxtToImproveHocrParsing) {
        this.useTxtToImproveHocrParsing = useTxtToImproveHocrParsing;
        return this;
    }

    public final ImagePreprocessingOptions getImagePreprocessingOptions() {
        return this.imagePreprocessingOptions;
    }

    public final Tesseract4OcrEngineProperties setImagePreprocessingOptions(ImagePreprocessingOptions imagePreprocessingOptions) {
        this.imagePreprocessingOptions = imagePreprocessingOptions;
        return this;
    }

    public final int getMinimalConfidenceLevel() {
        return this.minimalConfidenceLevel;
    }

    public final Tesseract4OcrEngineProperties setMinimalConfidenceLevel(int minimalConfidenceLevel) {
        this.minimalConfidenceLevel = minimalConfidenceLevel;
        return this;
    }
}

