/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.pdfocr.tesseract4;

import com.itextpdf.io.image.ImageData;
import com.itextpdf.io.image.ImageDataFactory;
import com.itextpdf.io.util.MessageFormatUtil;
import com.itextpdf.pdfocr.tesseract4.ImagePreprocessingOptions;
import com.itextpdf.pdfocr.tesseract4.OutputFormat;
import com.itextpdf.pdfocr.tesseract4.Tesseract4OcrException;
import com.ochafik.lang.jnaerator.runtime.NativeSize;
import com.ochafik.lang.jnaerator.runtime.NativeSizeByReference;
import com.sun.jna.ptr.PointerByReference;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.imageio.ImageIO;
import net.sourceforge.lept4j.Leptonica;
import net.sourceforge.lept4j.Pix;
import net.sourceforge.tess4j.ITesseract;
import net.sourceforge.tess4j.Tesseract;
import net.sourceforge.tess4j.Tesseract1;
import net.sourceforge.tess4j.TesseractException;
import org.apache.commons.imaging.ImageReadException;
import org.apache.commons.imaging.Imaging;
import org.apache.commons.imaging.common.ImageMetadata;
import org.apache.commons.imaging.formats.jpeg.JpegImageMetadata;
import org.apache.commons.imaging.formats.tiff.TiffImageMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TesseractOcrUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(TesseractOcrUtil.class);
    private static final int ROTATION_0 = 0;
    private static final int ROTATION_90 = 90;
    private static final int ROTATION_180 = 180;
    private static final int ROTATION_270 = 270;
    private static final int EXIF_ROTATION_0 = 1;
    private static final int EXIF_ROTATION_90 = 6;
    private static final int EXIF_ROTATION_180 = 3;
    private static final int EXIF_ROTATION_270 = 8;
    private List<BufferedImage> imagePages = Collections.emptyList();

    TesseractOcrUtil() {
    }

    static Pix readPixPageFromTiff(File inputFile, int pageNumber) {
        Pix pix = null;
        BufferedImage img = TesseractOcrUtil.getImagePage(inputFile, pageNumber);
        if (img != null) {
            pix = TesseractOcrUtil.readPix(img);
        }
        return pix;
    }

    static Pix preprocessPix(Pix pix, ImagePreprocessingOptions imagePreprocessingOptions) {
        Pix pix1 = TesseractOcrUtil.convertToGrayscale(pix);
        pix1 = TesseractOcrUtil.otsuImageThresholding(pix1, imagePreprocessingOptions);
        return pix1;
    }

    static Pix convertToGrayscale(Pix pix) {
        Leptonica instance = Leptonica.INSTANCE;
        if (pix != null) {
            int depth = instance.pixGetDepth(pix);
            if (depth == 32) {
                return instance.pixConvertRGBToLuminance(pix);
            }
            return instance.pixRemoveColormap(pix, 1);
        }
        return pix;
    }

    static Pix otsuImageThresholding(Pix pix, ImagePreprocessingOptions imagePreprocessingOptions) {
        if (pix != null) {
            Pix thresholdPix = null;
            if (pix.d == 8) {
                PointerByReference pointer = new PointerByReference();
                Leptonica.INSTANCE.pixOtsuAdaptiveThreshold(pix, TesseractOcrUtil.getOtsuAdaptiveThresholdTileSize(pix.w, imagePreprocessingOptions.getTileWidth()), TesseractOcrUtil.getOtsuAdaptiveThresholdTileSize(pix.h, imagePreprocessingOptions.getTileHeight()), TesseractOcrUtil.getOtsuAdaptiveThresholdSmoothingTileSize(pix.w, imagePreprocessingOptions.isSmoothTiling()), TesseractOcrUtil.getOtsuAdaptiveThresholdSmoothingTileSize(pix.h, imagePreprocessingOptions.isSmoothTiling()), 0.0f, null, pointer);
                thresholdPix = new Pix(pointer.getValue());
                if (thresholdPix.w > 0 && thresholdPix.h > 0) {
                    TesseractOcrUtil.destroyPix(pix);
                    return thresholdPix;
                }
                LOGGER.info(MessageFormatUtil.format((String)"Cannot binarize image with depth {0}", (Object[])new Object[]{pix.d}));
                TesseractOcrUtil.destroyPix(thresholdPix);
                return pix;
            }
            LOGGER.info(MessageFormatUtil.format((String)"Cannot binarize image with depth {0}", (Object[])new Object[]{pix.d}));
            return pix;
        }
        return pix;
    }

    static int getOtsuAdaptiveThresholdTileSize(int imageSize, int tileSize) {
        if (tileSize == 0) {
            return imageSize;
        }
        return tileSize;
    }

    static int getOtsuAdaptiveThresholdSmoothingTileSize(int imageSize, boolean smoothTiling) {
        if (smoothTiling) {
            return imageSize;
        }
        return 0;
    }

    static int getImagePixelColor(BufferedImage image, int x, int y) {
        return image.getRGB(x, y);
    }

    static void destroyPix(Pix pix) {
        if (pix != null) {
            Leptonica.INSTANCE.lept_free(pix.getPointer());
        }
    }

    static void setTesseractProperties(ITesseract tesseractInstance, String tessData, String languages, Integer pageSegMode, String userWordsFilePath) {
        tesseractInstance.setDatapath(tessData);
        tesseractInstance.setLanguage(languages);
        if (pageSegMode != null) {
            tesseractInstance.setPageSegMode(pageSegMode.intValue());
        }
        tesseractInstance.setOcrEngineMode(userWordsFilePath != null ? 0 : 3);
    }

    static ITesseract initializeTesseractInstance(boolean isWindows, String tessData, String languages, String userWordsFilePath) {
        try {
            if (isWindows) {
                return new Tesseract1();
            }
            return new Tesseract();
        }
        catch (LinkageError e) {
            throw new Tesseract4OcrException(isWindows ? "Tesseract failed. Please ensure you have latest Visual C++ Redistributable installed" : "Tesseract failed. Please ensure you have tesseract library installed", e);
        }
    }

    static boolean isTesseractInstanceDisposed(ITesseract tesseractInstance) {
        return false;
    }

    static void disposeTesseractInstance(ITesseract tesseractInstance) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static BufferedImage convertPixToImage(Pix pix) throws IOException {
        if (pix != null) {
            Leptonica instance = Leptonica.INSTANCE;
            BufferedImage bi = null;
            PointerByReference pdata = new PointerByReference();
            try {
                NativeSizeByReference psize = new NativeSizeByReference();
                instance.pixWriteMem(pdata, psize, pix, 3);
                byte[] b = pdata.getValue().getByteArray(0L, psize.getValue().intValue());
                try (ByteArrayInputStream in = new ByteArrayInputStream(b);){
                    bi = ImageIO.read(in);
                }
            }
            finally {
                instance.lept_free(pdata.getValue());
            }
            return bi;
        }
        return null;
    }

    static String getTempFilePath(String name, String suffix) {
        String tmpFileName = name + suffix;
        try {
            Path tempPath = Files.createTempFile(name, suffix, new FileAttribute[0]);
            tmpFileName = tempPath.toString();
        }
        catch (IOException | IllegalArgumentException e) {
            LOGGER.info(MessageFormatUtil.format((String)"Cannot get temporary directory: {0}", (Object[])new Object[]{e.getMessage()}));
        }
        return tmpFileName;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static BufferedImage getImagePage(File inputFile, int page) {
        BufferedImage img = null;
        try (FileInputStream is = new FileInputStream(inputFile.getAbsolutePath());){
            List pages = Imaging.getAllBufferedImages((InputStream)is, (String)inputFile.getAbsolutePath());
            if (page >= pages.size()) {
                LOGGER.warn(MessageFormatUtil.format((String)"Provided number of page ({0}) is incorrect for {1}", (Object[])new Object[]{page, inputFile.getAbsolutePath()}));
                BufferedImage bufferedImage = null;
                return bufferedImage;
            }
            img = (BufferedImage)pages.get(page);
            return img;
        }
        catch (IOException | ImageReadException e) {
            LOGGER.error(MessageFormatUtil.format((String)"Cannot get pages from image {0}: {1}", (Object[])new Object[]{inputFile.getAbsolutePath(), e.getMessage()}));
        }
        return img;
    }

    static void saveImageToTempPngFile(String tmpFileName, BufferedImage image) {
        if (image != null) {
            try {
                ImageIO.write((RenderedImage)image, "png", new File(tmpFileName));
            }
            catch (Exception e) {
                LOGGER.error(MessageFormatUtil.format((String)"Cannot process image: {0}", (Object[])new Object[]{e.getMessage()}));
            }
        }
    }

    static void savePixToPngFile(String filename, Pix pix) {
        if (pix != null) {
            try {
                Leptonica.INSTANCE.pixWritePng(filename, pix, 3.0f);
            }
            catch (Exception e) {
                LOGGER.info(MessageFormatUtil.format((String)"Cannot process image: {0}", (Object[])new Object[]{e.getMessage()}));
            }
        }
    }

    static void createTempFileCopy(String src, String dst) throws IOException {
        Files.copy(Paths.get(src, new String[0]), Paths.get(dst, new String[0]), StandardCopyOption.REPLACE_EXISTING);
    }

    static String getParentDirectory(String path) {
        return new File(path).getParent();
    }

    void initializeImagesListFromTiff(File inputFile) {
        try (FileInputStream is = new FileInputStream(inputFile.getAbsolutePath());){
            this.setListOfPages(Imaging.getAllBufferedImages((InputStream)is, (String)inputFile.getAbsolutePath()));
        }
        catch (Exception e) {
            LOGGER.error(MessageFormatUtil.format((String)"Cannot get pages from image {0}: {1}", (Object[])new Object[]{inputFile.getAbsolutePath(), e.getMessage()}));
        }
    }

    List<BufferedImage> getListOfPages() {
        return new ArrayList<BufferedImage>(this.imagePages);
    }

    void setListOfPages(List<BufferedImage> listOfPages) {
        this.imagePages = Collections.unmodifiableList(listOfPages);
    }

    String getOcrResultAsString(ITesseract tesseractInstance, BufferedImage image, OutputFormat outputFormat) throws TesseractException {
        if (image != null) {
            return tesseractInstance.doOCR(image);
        }
        return null;
    }

    String getOcrResultAsString(ITesseract tesseractInstance, File image, OutputFormat outputFormat) throws TesseractException {
        if (image != null) {
            return tesseractInstance.doOCR(image);
        }
        return null;
    }

    String getOcrResultAsString(ITesseract tesseractInstance, Pix pix, OutputFormat outputFormat) throws TesseractException, IOException {
        if (pix != null) {
            BufferedImage bufferedImage = TesseractOcrUtil.convertPixToImage(pix);
            return this.getOcrResultAsString(tesseractInstance, bufferedImage, outputFormat);
        }
        return null;
    }

    static Pix readPix(BufferedImage image) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)image, "png", baos);
            return TesseractOcrUtil.readPix(baos.toByteArray());
        }
        catch (IOException e) {
            LOGGER.error(MessageFormatUtil.format((String)"Cannot read input image {0}", (Object[])new Object[]{e.getMessage()}));
            return null;
        }
    }

    static Pix readPix(File inputFile) {
        try {
            return TesseractOcrUtil.readPix(Files.readAllBytes(inputFile.toPath()));
        }
        catch (IOException e) {
            LOGGER.error(MessageFormatUtil.format((String)"Cannot read input image {0}", (Object[])new Object[]{e.getMessage()}));
            return null;
        }
    }

    static Pix readPix(byte[] imageBytes) {
        Pix pix = null;
        try {
            ByteBuffer bb = ByteBuffer.wrap(imageBytes);
            NativeSize size = new NativeSize((long)imageBytes.length);
            pix = Leptonica.INSTANCE.pixReadMem(bb, size);
        }
        catch (Exception e) {
            LOGGER.error(MessageFormatUtil.format((String)"Cannot read input image {0}", (Object[])new Object[]{e.getMessage()}));
        }
        if (pix != null) {
            int rotation = TesseractOcrUtil.detectRotation(imageBytes);
            pix = TesseractOcrUtil.rotate(pix, rotation);
        }
        return pix;
    }

    static int detectRotation(File file) {
        try {
            return TesseractOcrUtil.detectRotation(Files.readAllBytes(file.toPath()));
        }
        catch (Exception e) {
            LOGGER.error(MessageFormatUtil.format((String)"Cannot read input image {0}", (Object[])new Object[]{e.getMessage()}));
            return 0;
        }
    }

    static int detectRotation(ImageData imageData) {
        return TesseractOcrUtil.detectRotation(imageData.getData());
    }

    static int detectRotation(byte[] data) {
        int rotation = 0;
        try {
            ImageMetadata metadata = Imaging.getMetadata((byte[])data);
            Object tiffImageMetadata = metadata instanceof JpegImageMetadata ? ((JpegImageMetadata)metadata).getExif() : (metadata instanceof TiffImageMetadata ? (TiffImageMetadata)metadata : null);
            if (tiffImageMetadata != null) {
                rotation = TesseractOcrUtil.readRotationFromMetadata(tiffImageMetadata);
            }
        }
        catch (Exception e) {
            LOGGER.info(MessageFormatUtil.format((String)"Cannot read image metadata {0}", (Object[])new Object[]{e.getMessage()}));
        }
        return rotation;
    }

    static int readRotationFromMetadata(TiffImageMetadata tiffImageMetadata) {
        List items = tiffImageMetadata.getItems();
        for (Object item : items) {
            if (!(item instanceof TiffImageMetadata.TiffMetadataItem) || !"Orientation".equals(((TiffImageMetadata.TiffMetadataItem)item).getKeyword())) continue;
            int orientation = Integer.parseInt(((TiffImageMetadata.TiffMetadataItem)item).getText());
            switch (orientation) {
                case 1: {
                    return 0;
                }
                case 6: {
                    return 90;
                }
                case 3: {
                    return 180;
                }
                case 8: {
                    return 270;
                }
            }
            LOGGER.warn(MessageFormatUtil.format((String)"Unsuppoted EXIF Orientation value {0}. 1 is used by default", (Object[])new Object[]{orientation}));
            return 0;
        }
        return 0;
    }

    static Pix rotate(Pix pix, int rotation) {
        Leptonica instance = Leptonica.INSTANCE;
        switch (rotation) {
            case 90: {
                return instance.pixRotate90(pix, 1);
            }
            case 180: {
                return instance.pixRotate180(pix, pix);
            }
            case 270: {
                return instance.pixRotate90(pix, -1);
            }
        }
        return pix;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ImageData applyRotation(ImageData imageData) {
        Pix pix = TesseractOcrUtil.readPix(imageData.getData());
        if (pix == null) {
            return imageData;
        }
        ImageData newImageData = imageData;
        try {
            PointerByReference data = new PointerByReference();
            NativeSizeByReference size = new NativeSizeByReference();
            if (Leptonica.INSTANCE.pixWriteMemPng(data, size, pix, 0.0f) == 0) {
                newImageData = ImageDataFactory.create((byte[])data.getValue().getByteArray(0L, size.getValue().intValue()));
            }
        }
        finally {
            TesseractOcrUtil.destroyPix(pix);
        }
        return newImageData;
    }
}

