/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.pdfocr.tesseract4;

import com.itextpdf.commons.actions.AbstractProductITextEvent;
import com.itextpdf.commons.actions.AbstractProductProcessITextEvent;
import com.itextpdf.commons.actions.confirmations.ConfirmEvent;
import com.itextpdf.commons.actions.confirmations.EventConfirmationType;
import com.itextpdf.commons.actions.contexts.IMetaInfo;
import com.itextpdf.commons.actions.data.ProductData;
import com.itextpdf.commons.utils.MessageFormatUtil;
import com.itextpdf.io.image.ImageType;
import com.itextpdf.pdfocr.AbstractPdfOcrEventHelper;
import com.itextpdf.pdfocr.IOcrEngine;
import com.itextpdf.pdfocr.IProductAware;
import com.itextpdf.pdfocr.OcrProcessContext;
import com.itextpdf.pdfocr.PdfOcrMetaInfoContainer;
import com.itextpdf.pdfocr.TextInfo;
import com.itextpdf.pdfocr.statistics.PdfOcrOutputType;
import com.itextpdf.pdfocr.statistics.PdfOcrOutputTypeStatisticsEvent;
import com.itextpdf.pdfocr.tesseract4.ImagePreprocessingUtil;
import com.itextpdf.pdfocr.tesseract4.OutputFormat;
import com.itextpdf.pdfocr.tesseract4.Tesseract4EventHelper;
import com.itextpdf.pdfocr.tesseract4.Tesseract4FileResultEventHelper;
import com.itextpdf.pdfocr.tesseract4.Tesseract4MetaInfo;
import com.itextpdf.pdfocr.tesseract4.Tesseract4OcrEngineProperties;
import com.itextpdf.pdfocr.tesseract4.TesseractHelper;
import com.itextpdf.pdfocr.tesseract4.TesseractOcrUtil;
import com.itextpdf.pdfocr.tesseract4.actions.data.PdfOcrTesseract4ProductData;
import com.itextpdf.pdfocr.tesseract4.actions.events.PdfOcrTesseract4ProductEvent;
import com.itextpdf.pdfocr.tesseract4.exceptions.PdfOcrInputTesseract4Exception;
import com.itextpdf.pdfocr.tesseract4.exceptions.PdfOcrTesseract4Exception;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.slf4j.LoggerFactory;

public abstract class AbstractTesseract4OcrEngine
implements IOcrEngine,
IProductAware {
    private static final Set<ImageType> SUPPORTED_IMAGE_FORMATS = Collections.unmodifiableSet(new HashSet<ImageType>(Arrays.asList(ImageType.BMP, ImageType.PNG, ImageType.TIFF, ImageType.JPEG)));
    Set<UUID> processedUUID = new HashSet<UUID>();
    private Tesseract4OcrEngineProperties tesseract4OcrEngineProperties;
    private ThreadLocal<IMetaInfo> threadLocalMetaInfo = new ThreadLocal();

    public AbstractTesseract4OcrEngine(Tesseract4OcrEngineProperties tesseract4OcrEngineProperties) {
        this.tesseract4OcrEngineProperties = tesseract4OcrEngineProperties;
    }

    public void doTesseractOcr(File inputImage, File outputFile, OutputFormat outputFormat) {
        this.doTesseractOcr(inputImage, outputFile, outputFormat, new OcrProcessContext((AbstractPdfOcrEventHelper)new Tesseract4EventHelper()));
    }

    public void doTesseractOcr(File inputImage, File outputFile, OutputFormat outputFormat, OcrProcessContext ocrProcessContext) {
        this.doTesseractOcr(inputImage, Collections.singletonList(outputFile), outputFormat, 1, ocrProcessContext.getOcrEventHelper());
    }

    public void createTxtFile(List<File> inputImages, File txtFile) {
        this.createTxtFile(inputImages, txtFile, new OcrProcessContext((AbstractPdfOcrEventHelper)new Tesseract4EventHelper()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createTxtFile(List<File> inputImages, File txtFile, OcrProcessContext ocrProcessContext) {
        LoggerFactory.getLogger(this.getClass()).info(MessageFormatUtil.format((String)"Starting ocr for {0} image(s)", (Object[])new Object[]{inputImages.size()}));
        AbstractPdfOcrEventHelper storedEventHelper = ocrProcessContext.getOcrEventHelper() == null ? new Tesseract4EventHelper() : ocrProcessContext.getOcrEventHelper();
        PdfOcrTesseract4ProductEvent event = PdfOcrTesseract4ProductEvent.createProcessImageEvent(storedEventHelper.getSequenceId(), null, storedEventHelper.getConfirmationType());
        storedEventHelper.onEvent((AbstractProductITextEvent)event);
        try {
            ocrProcessContext.setOcrEventHelper((AbstractPdfOcrEventHelper)new Tesseract4FileResultEventHelper(storedEventHelper));
            StringBuilder content = new StringBuilder();
            for (File inputImage : inputImages) {
                content.append(this.doImageOcr(inputImage, OutputFormat.TXT, ocrProcessContext));
            }
            TesseractHelper.writeToTextFile(txtFile.getAbsolutePath(), content.toString());
            if (event.getConfirmationType() == EventConfirmationType.ON_DEMAND) {
                storedEventHelper.onEvent((AbstractProductITextEvent)new ConfirmEvent((AbstractProductProcessITextEvent)event));
            }
        }
        finally {
            ocrProcessContext.setOcrEventHelper(storedEventHelper);
        }
    }

    public final Tesseract4OcrEngineProperties getTesseract4OcrEngineProperties() {
        return this.tesseract4OcrEngineProperties;
    }

    public final void setTesseract4OcrEngineProperties(Tesseract4OcrEngineProperties tesseract4OcrEngineProperties) {
        this.tesseract4OcrEngineProperties = tesseract4OcrEngineProperties;
    }

    public final String getLanguagesAsString() {
        if (this.getTesseract4OcrEngineProperties().getLanguages().size() > 0) {
            return String.join((CharSequence)"+", this.getTesseract4OcrEngineProperties().getLanguages());
        }
        return this.getTesseract4OcrEngineProperties().getDefaultLanguage();
    }

    public final Map<Integer, List<TextInfo>> doImageOcr(File input) {
        this.verifyImageFormatValidity(input);
        return ((TextInfoTesseractOcrResult)this.processInputFiles(input, OutputFormat.HOCR, new Tesseract4EventHelper())).getTextInfos();
    }

    public final Map<Integer, List<TextInfo>> doImageOcr(File input, OcrProcessContext ocrProcessContext) {
        this.verifyImageFormatValidity(input);
        return ((TextInfoTesseractOcrResult)this.processInputFiles(input, OutputFormat.HOCR, ocrProcessContext.getOcrEventHelper())).getTextInfos();
    }

    public final String doImageOcr(File input, OutputFormat outputFormat, OcrProcessContext ocrProcessContext) {
        String result = "";
        this.verifyImageFormatValidity(input);
        ITesseractOcrResult processedData = this.processInputFiles(input, outputFormat, ocrProcessContext.getOcrEventHelper());
        if (processedData != null) {
            if (outputFormat.equals((Object)OutputFormat.TXT)) {
                result = ((StringTesseractOcrResult)processedData).getData();
            } else {
                StringBuilder outputText = new StringBuilder();
                Map<Integer, List<TextInfo>> outputMap = ((TextInfoTesseractOcrResult)processedData).getTextInfos();
                for (int page : outputMap.keySet()) {
                    StringBuilder pageText = new StringBuilder();
                    for (TextInfo textInfo : outputMap.get(page)) {
                        pageText.append(textInfo.getText());
                        pageText.append(System.lineSeparator());
                    }
                    outputText.append((CharSequence)pageText);
                    outputText.append(System.lineSeparator());
                }
                result = outputText.toString();
            }
        }
        return result;
    }

    public final String doImageOcr(File input, OutputFormat outputFormat) {
        return this.doImageOcr(input, outputFormat, new OcrProcessContext((AbstractPdfOcrEventHelper)new Tesseract4EventHelper()));
    }

    public boolean isWindows() {
        return this.identifyOsType().toLowerCase().contains("win");
    }

    public String identifyOsType() {
        String os = System.getProperty("os.name") == null ? System.getProperty("OS") : System.getProperty("os.name");
        return os.toLowerCase();
    }

    public void validateLanguages(List<String> languagesList) throws PdfOcrTesseract4Exception {
        String suffix = ".traineddata";
        if (languagesList.size() == 0) {
            if (!new File(this.getTessData() + File.separatorChar + this.getTesseract4OcrEngineProperties().getDefaultLanguage() + suffix).exists()) {
                throw new PdfOcrInputTesseract4Exception("{0} does not exist in {1}").setMessageParams(new String[]{this.getTesseract4OcrEngineProperties().getDefaultLanguage() + suffix, this.getTessData()});
            }
        } else {
            for (String lang : languagesList) {
                if (new File(this.getTessData() + File.separatorChar + lang + suffix).exists()) continue;
                throw new PdfOcrInputTesseract4Exception("{0} does not exist in {1}").setMessageParams(new String[]{lang + suffix, this.getTessData()});
            }
        }
    }

    public PdfOcrMetaInfoContainer getMetaInfoContainer() {
        return new PdfOcrMetaInfoContainer((IMetaInfo)new Tesseract4MetaInfo());
    }

    public ProductData getProductData() {
        return PdfOcrTesseract4ProductData.getInstance();
    }

    void doTesseractOcr(File inputImage, List<File> outputFiles, OutputFormat outputFormat, int pageNumber, AbstractPdfOcrEventHelper eventHelper) {
        this.doTesseractOcr(inputImage, outputFiles, outputFormat, pageNumber, true, eventHelper);
    }

    abstract void doTesseractOcr(File var1, List<File> var2, OutputFormat var3, int var4, boolean var5, AbstractPdfOcrEventHelper var6);

    String getTessData() {
        if (this.getTesseract4OcrEngineProperties().getPathToTessData() == null) {
            throw new PdfOcrTesseract4Exception("Path to tess data directory cannot be null and must be set to a valid directory");
        }
        return this.getTesseract4OcrEngineProperties().getPathToTessData().getAbsolutePath();
    }

    PdfOcrTesseract4ProductEvent onEvent(AbstractPdfOcrEventHelper eventHelper) {
        PdfOcrTesseract4ProductEvent event = PdfOcrTesseract4ProductEvent.createProcessImageEvent(eventHelper.getSequenceId(), null, eventHelper.getConfirmationType());
        eventHelper.onEvent((AbstractProductITextEvent)event);
        return event;
    }

    void onEventStatistics(AbstractPdfOcrEventHelper eventHelper) {
        eventHelper.onEvent((AbstractProductITextEvent)new PdfOcrOutputTypeStatisticsEvent(PdfOcrOutputType.DATA, PdfOcrTesseract4ProductData.getInstance()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ITesseractOcrResult processInputFiles(File input, OutputFormat outputFormat, AbstractPdfOcrEventHelper eventHelper) {
        LinkedHashMap<Integer, List<TextInfo>> imageData = new LinkedHashMap<Integer, List<TextInfo>>();
        StringBuilder data = new StringBuilder();
        ArrayList<File> tempFiles = new ArrayList<File>();
        ITesseractOcrResult result = null;
        try {
            int realNumOfPages = !ImagePreprocessingUtil.isTiffImage(input) ? 1 : ImagePreprocessingUtil.getNumberOfPageTiff(input);
            int numOfPages = this.getTesseract4OcrEngineProperties().isPreprocessingImages() ? realNumOfPages : 1;
            int numOfFiles = this.getTesseract4OcrEngineProperties().isPreprocessingImages() ? 1 : realNumOfPages;
            for (int page = 1; page <= numOfPages; ++page) {
                String extension = outputFormat.equals((Object)OutputFormat.HOCR) ? ".hocr" : ".txt";
                for (int i = 0; i < numOfFiles; ++i) {
                    tempFiles.add(this.createTempFile(extension));
                }
                this.doTesseractOcr(input, tempFiles, outputFormat, page, true, eventHelper);
                if (outputFormat.equals((Object)OutputFormat.HOCR)) {
                    ArrayList<File> tempTxtFiles = null;
                    if (this.getTesseract4OcrEngineProperties().isUseTxtToImproveHocrParsing()) {
                        tempTxtFiles = new ArrayList<File>();
                        for (int i = 0; i < numOfFiles; ++i) {
                            tempTxtFiles.add(this.createTempFile(".txt"));
                        }
                        this.doTesseractOcr(input, tempTxtFiles, OutputFormat.TXT, page, false, eventHelper);
                    }
                    Map<Integer, List<TextInfo>> pageData = TesseractHelper.parseHocrFile(tempFiles, tempTxtFiles, this.getTesseract4OcrEngineProperties());
                    if (this.getTesseract4OcrEngineProperties().isPreprocessingImages()) {
                        imageData.put(page, pageData.get(1));
                    } else {
                        imageData = pageData;
                    }
                    result = new TextInfoTesseractOcrResult(imageData);
                    continue;
                }
                for (File tmpFile : tempFiles) {
                    if (!Files.exists(Paths.get(tmpFile.getAbsolutePath(), new String[0]), new LinkOption[0])) continue;
                    data.append(TesseractHelper.readTxtFile(tmpFile));
                }
                result = new StringTesseractOcrResult(data.toString());
            }
        }
        catch (IOException e) {
            LoggerFactory.getLogger(this.getClass()).error(MessageFormatUtil.format((String)"Cannot ocr input file: {0}", (Object[])new Object[]{e.getMessage()}));
        }
        finally {
            for (File file : tempFiles) {
                TesseractHelper.deleteFile(file.getAbsolutePath());
            }
        }
        return result;
    }

    private File createTempFile(String extension) {
        String tmpFileName = TesseractOcrUtil.getTempFilePath(UUID.randomUUID().toString(), extension);
        return new File(tmpFileName);
    }

    private void verifyImageFormatValidity(File image) throws PdfOcrTesseract4Exception {
        ImageType type = ImagePreprocessingUtil.getImageType(image);
        boolean isValid = SUPPORTED_IMAGE_FORMATS.contains(type);
        if (!isValid) {
            LoggerFactory.getLogger(this.getClass()).error(MessageFormatUtil.format((String)"Cannot read input image {0}", (Object[])new Object[]{image.getAbsolutePath()}));
            throw new PdfOcrInputTesseract4Exception("{0} format is not supported.").setMessageParams(new String[]{image.getName()});
        }
    }

    static class TextInfoTesseractOcrResult
    implements ITesseractOcrResult {
        private Map<Integer, List<TextInfo>> textInfos;

        TextInfoTesseractOcrResult(Map<Integer, List<TextInfo>> textInfos) {
            this.textInfos = textInfos;
        }

        Map<Integer, List<TextInfo>> getTextInfos() {
            return this.textInfos;
        }
    }

    static class StringTesseractOcrResult
    implements ITesseractOcrResult {
        private String data;

        StringTesseractOcrResult(String data) {
            this.data = data;
        }

        String getData() {
            return this.data;
        }
    }

    static interface ITesseractOcrResult {
    }
}

