/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.pdfocr.tesseract4;

import com.ochafik.lang.jnaerator.runtime.NativeSize;
import com.ochafik.lang.jnaerator.runtime.NativeSizeByReference;
import com.sun.jna.Pointer;
import com.sun.jna.ptr.PointerByReference;
import java.nio.ByteBuffer;
import net.sourceforge.lept4j.Leptonica;
import net.sourceforge.lept4j.Leptonica1;
import net.sourceforge.lept4j.Pix;

final class LeptonicaWrapper {
    private static final int LEPTONICA_NOT_SUPPORTED_JDK_VERSION = 19;
    private static final int JDK_MAJOR_VERSION = LeptonicaWrapper.getJavaMajorVersion();

    private LeptonicaWrapper() {
    }

    public static int pixGetDepth(Pix pix) {
        if (JDK_MAJOR_VERSION < 19) {
            return Leptonica.INSTANCE.pixGetDepth(pix);
        }
        return Leptonica1.pixGetDepth((Pix)pix);
    }

    public static Pix pixConvertRGBToLuminance(Pix pix) {
        if (JDK_MAJOR_VERSION < 19) {
            return Leptonica.INSTANCE.pixConvertRGBToLuminance(pix);
        }
        return Leptonica1.pixConvertRGBToLuminance((Pix)pix);
    }

    public static Pix pixRemoveColormap(Pix pix, int option) {
        if (JDK_MAJOR_VERSION < 19) {
            return Leptonica.INSTANCE.pixRemoveColormap(pix, option);
        }
        return Leptonica1.pixRemoveColormap((Pix)pix, (int)option);
    }

    public static Pix pixRead(String var1) {
        if (JDK_MAJOR_VERSION < 19) {
            return Leptonica.INSTANCE.pixRead(var1);
        }
        return Leptonica1.pixRead((String)var1);
    }

    public static void pixOtsuAdaptiveThreshold(Pix pix, int i, int i1, int i2, int i3, float v, PointerByReference pointerByReference, PointerByReference pointerByReference1) {
        if (JDK_MAJOR_VERSION < 19) {
            Leptonica.INSTANCE.pixOtsuAdaptiveThreshold(pix, i, i1, i2, i3, v, pointerByReference, pointerByReference1);
            return;
        }
        Leptonica1.pixOtsuAdaptiveThreshold((Pix)pix, (int)i, (int)i1, (int)i2, (int)i3, (float)v, (PointerByReference)pointerByReference, (PointerByReference)pointerByReference1);
    }

    public static void lept_free(Pointer pointer) {
        if (JDK_MAJOR_VERSION < 19) {
            Leptonica.INSTANCE.lept_free(pointer);
            return;
        }
        Leptonica1.lept_free((Pointer)pointer);
    }

    public static void pixWriteMem(PointerByReference pointer, NativeSizeByReference nativeSize, Pix pix, int i) {
        if (JDK_MAJOR_VERSION < 19) {
            Leptonica.INSTANCE.pixWriteMem(pointer, nativeSize, pix, i);
            return;
        }
        Leptonica1.pixWriteMem((PointerByReference)pointer, (NativeSizeByReference)nativeSize, (Pix)pix, (int)i);
    }

    public static int pixWriteMemPng(PointerByReference pointer, NativeSizeByReference nativeSize, Pix pix, int i) {
        if (JDK_MAJOR_VERSION < 19) {
            return Leptonica.INSTANCE.pixWriteMemPng(pointer, nativeSize, pix, (float)i);
        }
        return Leptonica1.pixWriteMemPng((PointerByReference)pointer, (NativeSizeByReference)nativeSize, (Pix)pix, (float)i);
    }

    public static void pixWritePng(String s, Pix pix, float v) {
        if (JDK_MAJOR_VERSION < 19) {
            Leptonica.INSTANCE.pixWritePng(s, pix, v);
            return;
        }
        Leptonica1.pixWritePng((String)s, (Pix)pix, (float)v);
    }

    public static Pix pixReadMem(ByteBuffer buffer, NativeSize nativeSize) {
        if (JDK_MAJOR_VERSION < 19) {
            return Leptonica.INSTANCE.pixReadMem(buffer, nativeSize);
        }
        return Leptonica1.pixReadMem((ByteBuffer)buffer, (NativeSize)nativeSize);
    }

    public static Pix pixRotate90(Pix pix, int i) {
        if (JDK_MAJOR_VERSION < 19) {
            return Leptonica.INSTANCE.pixRotate90(pix, i);
        }
        return Leptonica1.pixRotate90((Pix)pix, (int)i);
    }

    public static Pix pixRotate180(Pix pix1, Pix pix2) {
        if (JDK_MAJOR_VERSION < 19) {
            return Leptonica.INSTANCE.pixRotate180(pix1, pix2);
        }
        return Leptonica1.pixRotate180((Pix)pix1, (Pix)pix2);
    }

    private static int getJavaMajorVersion() {
        String version = System.getProperty("java.version");
        if (version.startsWith("1.")) {
            version = version.substring(2, 3);
        } else {
            int dot = version.indexOf(46);
            if (dot != -1) {
                version = version.substring(0, dot);
            }
        }
        return Integer.parseInt(version);
    }
}

