/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.pdfocr.tesseract4;

import com.itextpdf.commons.actions.AbstractProductITextEvent;
import com.itextpdf.commons.actions.AbstractProductProcessITextEvent;
import com.itextpdf.commons.actions.confirmations.ConfirmEvent;
import com.itextpdf.commons.actions.confirmations.EventConfirmationType;
import com.itextpdf.commons.utils.MessageFormatUtil;
import com.itextpdf.pdfocr.AbstractPdfOcrEventHelper;
import com.itextpdf.pdfocr.tesseract4.AbstractTesseract4OcrEngine;
import com.itextpdf.pdfocr.tesseract4.ImagePreprocessingUtil;
import com.itextpdf.pdfocr.tesseract4.OutputFormat;
import com.itextpdf.pdfocr.tesseract4.Tesseract4EventHelper;
import com.itextpdf.pdfocr.tesseract4.Tesseract4OcrEngineProperties;
import com.itextpdf.pdfocr.tesseract4.TesseractHelper;
import com.itextpdf.pdfocr.tesseract4.TesseractOcrUtil;
import com.itextpdf.pdfocr.tesseract4.actions.events.PdfOcrTesseract4ProductEvent;
import com.itextpdf.pdfocr.tesseract4.exceptions.PdfOcrTesseract4Exception;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import net.sourceforge.lept4j.Pix;
import org.slf4j.LoggerFactory;

public class Tesseract4ExecutableOcrEngine
extends AbstractTesseract4OcrEngine {
    private String pathToExecutable;

    public Tesseract4ExecutableOcrEngine(Tesseract4OcrEngineProperties tesseract4OcrEngineProperties) {
        super(tesseract4OcrEngineProperties);
        this.setPathToExecutable("tesseract");
    }

    public Tesseract4ExecutableOcrEngine(String executablePath, Tesseract4OcrEngineProperties tesseract4OcrEngineProperties) {
        super(tesseract4OcrEngineProperties);
        this.setPathToExecutable(executablePath);
    }

    public final String getPathToExecutable() {
        return this.pathToExecutable;
    }

    public final void setPathToExecutable(String path) {
        this.pathToExecutable = path;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    void doTesseractOcr(File inputImage, List<File> outputFiles, OutputFormat outputFormat, int pageNumber, boolean dispatchEvent, AbstractPdfOcrEventHelper eventHelper) {
        ArrayList<String> params = new ArrayList<String>();
        String execPath = null;
        String imagePath = null;
        String workingDirectory = null;
        PdfOcrTesseract4ProductEvent event = null;
        if (eventHelper == null) {
            eventHelper = new Tesseract4EventHelper();
        }
        if (dispatchEvent) {
            event = this.onEvent(eventHelper);
        }
        try {
            imagePath = inputImage.getAbsolutePath();
            if (this.getPathToExecutable() == null) throw new PdfOcrTesseract4Exception("Cannot find path to tesseract executable.");
            if (this.getPathToExecutable().isEmpty()) {
                throw new PdfOcrTesseract4Exception("Cannot find path to tesseract executable.");
            }
            execPath = this.isWindows() ? this.addQuotes(this.getPathToExecutable()) : this.getPathToExecutable();
            this.checkTesseractInstalled(execPath);
            this.addTessData(params);
            this.validateLanguages(this.getTesseract4OcrEngineProperties().getLanguages());
            imagePath = this.preprocessImage(inputImage, pageNumber);
            String imageParentDir = TesseractOcrUtil.getParentDirectoryFile(imagePath);
            String replacement = this.isWindows() ? "" : "/";
            workingDirectory = imageParentDir.replace("file:///", replacement).replace("file:/", replacement);
            this.addInputFile(params, imagePath);
            this.addOutputFile(params, outputFiles.get(0), outputFormat, imagePath);
            this.addPageSegMode(params);
            this.addUserWords(params, imagePath);
            this.addLanguages(params);
            this.addOutputFormat(params, outputFormat);
            this.addPreserveInterwordSpaces(params);
            this.addDefaultDpi(params);
            TesseractHelper.runCommand(execPath, params, workingDirectory);
            this.onEventStatistics(eventHelper);
            if (event != null && event.getConfirmationType() == EventConfirmationType.ON_DEMAND) {
                eventHelper.onEvent((AbstractProductITextEvent)new ConfirmEvent((AbstractProductProcessITextEvent)event));
            }
        }
        catch (PdfOcrTesseract4Exception e) {
            try {
                LoggerFactory.getLogger(this.getClass()).error(e.getMessage());
                throw new PdfOcrTesseract4Exception(e.getMessage(), (Throwable)((Object)e));
            }
            catch (Throwable throwable) {
                try {
                    if (imagePath != null && !inputImage.getAbsolutePath().equals(imagePath)) {
                        TesseractHelper.deleteFile(imagePath);
                    }
                }
                catch (SecurityException e2) {
                    LoggerFactory.getLogger(this.getClass()).error(MessageFormatUtil.format((String)"File {0} cannot be deleted: {1}", (Object[])new Object[]{imagePath, e2.getMessage()}));
                }
                try {
                    if (this.getTesseract4OcrEngineProperties().getPathToUserWordsFile() == null) throw throwable;
                    if (!this.getTesseract4OcrEngineProperties().isUserWordsFileTemporary()) throw throwable;
                    TesseractHelper.deleteFile(this.getTesseract4OcrEngineProperties().getPathToUserWordsFile());
                    throw throwable;
                }
                catch (SecurityException e3) {
                    LoggerFactory.getLogger(this.getClass()).error(MessageFormatUtil.format((String)"File {0} cannot be deleted: {1}", (Object[])new Object[]{this.getTesseract4OcrEngineProperties().getPathToUserWordsFile(), e3.getMessage()}));
                }
                throw throwable;
            }
        }
        try {
            if (imagePath != null && !inputImage.getAbsolutePath().equals(imagePath)) {
                TesseractHelper.deleteFile(imagePath);
            }
        }
        catch (SecurityException e) {
            LoggerFactory.getLogger(this.getClass()).error(MessageFormatUtil.format((String)"File {0} cannot be deleted: {1}", (Object[])new Object[]{imagePath, e.getMessage()}));
        }
        try {
            if (this.getTesseract4OcrEngineProperties().getPathToUserWordsFile() == null) return;
            if (!this.getTesseract4OcrEngineProperties().isUserWordsFileTemporary()) return;
            TesseractHelper.deleteFile(this.getTesseract4OcrEngineProperties().getPathToUserWordsFile());
            return;
        }
        catch (SecurityException e) {
            LoggerFactory.getLogger(this.getClass()).error(MessageFormatUtil.format((String)"File {0} cannot be deleted: {1}", (Object[])new Object[]{this.getTesseract4OcrEngineProperties().getPathToUserWordsFile(), e.getMessage()}));
            return;
        }
    }

    private void setHocrOutput(List<String> command) {
        command.add("-c");
        command.add("tessedit_create_hocr=1");
    }

    private void addPreserveInterwordSpaces(List<String> command) {
        if (this.getTesseract4OcrEngineProperties().isUseTxtToImproveHocrParsing()) {
            command.add("-c");
            command.add("preserve_interword_spaces=1");
        }
    }

    private void addOutputFormat(List<String> command, OutputFormat outputFormat) {
        if (outputFormat == OutputFormat.HOCR) {
            this.setHocrOutput(command);
        }
    }

    private void addUserWords(List<String> command, String imgPath) {
        if (this.getTesseract4OcrEngineProperties().getPathToUserWordsFile() != null && !this.getTesseract4OcrEngineProperties().getPathToUserWordsFile().isEmpty()) {
            File userWordsFile = new File(this.getTesseract4OcrEngineProperties().getPathToUserWordsFile());
            String filePath = this.areEqualParentDirectories(imgPath, userWordsFile.getAbsolutePath()) ? userWordsFile.getName() : userWordsFile.getAbsolutePath();
            command.add("--user-words");
            command.add(this.addQuotes(filePath));
            command.add("--oem");
            command.add("0");
        }
    }

    private void addDefaultDpi(List<String> command) {
        command.add("-c");
        command.add("user_defined_dpi=300");
    }

    private void addTessData(List<String> command) {
        command.add("--tessdata-dir");
        command.add(this.addQuotes(this.getTessData()));
    }

    private void addPageSegMode(List<String> command) {
        if (this.getTesseract4OcrEngineProperties().getPageSegMode() != null) {
            command.add("-c");
            command.add("tessedit_pageseg_mode=" + this.getTesseract4OcrEngineProperties().getPageSegMode());
        }
    }

    private void addLanguages(List<String> command) {
        if (this.getTesseract4OcrEngineProperties().getLanguages().size() > 0) {
            command.add("-l");
            command.add(this.getLanguagesAsString());
        }
    }

    private void addInputFile(List<String> command, String imagePath) {
        command.add(this.addQuotes(new File(imagePath).getName()));
    }

    private void addOutputFile(List<String> command, File outputFile, OutputFormat outputFormat, String inputImagePath) {
        String extension = outputFormat.equals((Object)OutputFormat.HOCR) ? ".hocr" : ".txt";
        try {
            String filePath = this.areEqualParentDirectories(inputImagePath, outputFile.getAbsolutePath()) ? outputFile.getName() : outputFile.getAbsolutePath();
            String fileName = new String(filePath.toCharArray(), 0, filePath.indexOf(extension));
            LoggerFactory.getLogger(this.getClass()).info(MessageFormatUtil.format((String)"Created temp file {0}", (Object[])new Object[]{outputFile.getAbsolutePath()}));
            command.add(this.addQuotes(fileName));
        }
        catch (Exception e) {
            throw new PdfOcrTesseract4Exception("Tesseract failed. Please check provided parameters");
        }
    }

    private String addQuotes(String value) {
        if (this.isWindows()) {
            return "\"" + value + "\"";
        }
        return "'" + value + "'";
    }

    private String preprocessImage(File inputImage, int pageNumber) throws PdfOcrTesseract4Exception {
        String tmpFileName = TesseractOcrUtil.getTempFilePath(UUID.randomUUID().toString(), this.getExtension(inputImage));
        String path = inputImage.getAbsolutePath();
        try {
            if (this.getTesseract4OcrEngineProperties().isPreprocessingImages()) {
                BufferedImage img;
                Pix pix = ImagePreprocessingUtil.preprocessImage(inputImage, pageNumber, this.getTesseract4OcrEngineProperties().getImagePreprocessingOptions());
                TesseractOcrUtil.savePixToPngFile(tmpFileName, pix);
                if (!Files.exists(Paths.get(tmpFileName, new String[0]), new LinkOption[0]) && (img = TesseractOcrUtil.convertPixToImage(pix)) != null) {
                    TesseractOcrUtil.saveImageToTempPngFile(tmpFileName, img);
                }
            }
            if (!this.getTesseract4OcrEngineProperties().isPreprocessingImages() || !Files.exists(Paths.get(tmpFileName, new String[0]), new LinkOption[0])) {
                TesseractOcrUtil.createTempFileCopy(path, tmpFileName);
            }
            if (Files.exists(Paths.get(tmpFileName, new String[0]), new LinkOption[0])) {
                path = tmpFileName;
            }
        }
        catch (IOException e) {
            LoggerFactory.getLogger(this.getClass()).error(MessageFormatUtil.format((String)"Cannot read input image {0}", (Object[])new Object[]{e.getMessage()}));
        }
        return path;
    }

    private void checkTesseractInstalled(String execPath) throws PdfOcrTesseract4Exception {
        try {
            TesseractHelper.runCommand(execPath, Collections.singletonList("--version"));
        }
        catch (PdfOcrTesseract4Exception e) {
            throw new PdfOcrTesseract4Exception("Tesseract failed. Please check that tesseract is installed and provided path to tesseract executable directory is correct", (Throwable)((Object)e));
        }
    }

    private String getExtension(File inputImage) {
        int index;
        if (inputImage != null && (index = inputImage.getAbsolutePath().lastIndexOf(46)) > 0) {
            String extension = new String(inputImage.getAbsolutePath().toCharArray(), index, inputImage.getAbsolutePath().length() - index);
            return extension.toLowerCase();
        }
        return ".png";
    }

    private boolean areEqualParentDirectories(String firstPath, String secondPath) {
        String firstParentDir = TesseractOcrUtil.getParentDirectoryFile(firstPath);
        String secondParentDir = TesseractOcrUtil.getParentDirectoryFile(secondPath);
        return firstParentDir != null && firstParentDir.equals(secondParentDir);
    }
}

