/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.pdfocr.tesseract4;

import com.itextpdf.commons.utils.MessageFormatUtil;
import com.itextpdf.io.image.ImageType;
import com.itextpdf.io.image.ImageTypeDetector;
import com.itextpdf.io.image.TiffImageData;
import com.itextpdf.io.source.RandomAccessFileOrArray;
import com.itextpdf.io.source.RandomAccessSourceFactory;
import com.itextpdf.io.util.UrlUtil;
import com.itextpdf.pdfocr.tesseract4.ImagePreprocessingOptions;
import com.itextpdf.pdfocr.tesseract4.TesseractOcrUtil;
import com.itextpdf.pdfocr.tesseract4.exceptions.PdfOcrInputTesseract4Exception;
import com.itextpdf.pdfocr.tesseract4.exceptions.PdfOcrTesseract4Exception;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;
import javax.imageio.ImageIO;
import net.sourceforge.lept4j.Pix;
import org.slf4j.LoggerFactory;

class ImagePreprocessingUtil {
    private ImagePreprocessingUtil() {
    }

    static int getNumberOfPageTiff(File inputImage) throws IOException {
        RandomAccessFileOrArray raf = new RandomAccessFileOrArray(new RandomAccessSourceFactory().createBestSource(inputImage.getAbsolutePath()));
        int numOfPages = TiffImageData.getNumberOfPages((RandomAccessFileOrArray)raf);
        raf.close();
        return numOfPages;
    }

    static boolean isTiffImage(File inputImage) {
        return ImagePreprocessingUtil.getImageType(inputImage) == ImageType.TIFF;
    }

    static ImageType getImageType(File inputImage) {
        ImageType type;
        try {
            type = ImageTypeDetector.detectImageType((URL)UrlUtil.toURL((String)inputImage.getAbsolutePath()));
        }
        catch (Exception e) {
            LoggerFactory.getLogger(ImagePreprocessingUtil.class).error(MessageFormatUtil.format((String)"Cannot read input image {0}", (Object[])new Object[]{e.getMessage()}));
            throw new PdfOcrInputTesseract4Exception("Cannot read input image {0}").setMessageParams(new String[]{inputImage.getAbsolutePath()});
        }
        return type;
    }

    static BufferedImage readImageFromFile(File inputFile) throws IllegalArgumentException, IOException {
        FileInputStream is = new FileInputStream(inputFile.getAbsolutePath());
        BufferedImage bi = ImageIO.read(is);
        is.close();
        return bi;
    }

    static BufferedImage readAsPixAndConvertToBufferedImage(File inputImage) throws IOException {
        Pix pix = TesseractOcrUtil.readPixFromFile(inputImage);
        return TesseractOcrUtil.convertPixToImage(pix);
    }

    static Pix preprocessImage(File inputFile, int pageNumber, ImagePreprocessingOptions imagePreprocessingOptions) throws PdfOcrTesseract4Exception {
        Pix pix = null;
        pix = ImagePreprocessingUtil.isTiffImage(inputFile) ? TesseractOcrUtil.readPixPageFromTiff(inputFile, pageNumber - 1) : TesseractOcrUtil.readPix(inputFile);
        if (pix == null) {
            throw new PdfOcrInputTesseract4Exception("Cannot read input image {0}").setMessageParams(new String[]{inputFile.getAbsolutePath()});
        }
        return TesseractOcrUtil.preprocessPix(pix, imagePreprocessingOptions);
    }

    static BufferedImage readImage(File inputImage) {
        BufferedImage bufferedImage = null;
        try {
            bufferedImage = ImagePreprocessingUtil.readAsPixAndConvertToBufferedImage(inputImage);
        }
        catch (IOException | IllegalArgumentException ex) {
            LoggerFactory.getLogger(ImagePreprocessingUtil.class).info(MessageFormatUtil.format((String)"Cannot read input image {0}", (Object[])new Object[]{ex.getMessage()}));
        }
        if (bufferedImage == null) {
            try {
                bufferedImage = ImagePreprocessingUtil.readImageFromFile(inputImage);
            }
            catch (IOException | IllegalArgumentException ex) {
                LoggerFactory.getLogger(ImagePreprocessingUtil.class).info(MessageFormatUtil.format((String)"Cannot create a buffered image from the input image: {0}", (Object[])new Object[]{ex.getMessage()}));
            }
        }
        return bufferedImage;
    }
}

