/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.test;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.IThrowableProxy;
import ch.qos.logback.classic.spi.StackTraceElementProxy;
import ch.qos.logback.core.read.ListAppender;
import com.itextpdf.test.annotations.LogMessage;
import com.itextpdf.test.annotations.LogMessages;
import java.lang.annotation.Annotation;
import java.text.MessageFormat;
import java.util.List;
import org.junit.Assert;
import org.junit.rules.TestWatcher;
import org.junit.runner.Description;
import org.slf4j.ILoggerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.helpers.SubstituteLoggerFactory;

public class LogListener
extends TestWatcher {
    private static final String ROOT_ITEXT_PACKAGE = "com.itextpdf";
    private final ListAppender<ILoggingEvent> listAppender = new CustomListAppender();
    private final ILoggerFactory lc = LoggerFactory.getILoggerFactory();
    private final String LEFT_CURLY_BRACES = "{";
    private final String RIGHT_CURLY_BRACES = "}";

    protected void starting(Description description) {
        this.before();
    }

    protected void finished(Description description) {
        this.checkLogMessages(description);
        this.after();
    }

    private int contains(String loggingStatement) {
        List list = this.listAppender.list;
        int index = 0;
        for (ILoggingEvent event : list) {
            if (!this.equalsMessageByTemplate(event.getFormattedMessage(), loggingStatement)) continue;
            ++index;
        }
        return index;
    }

    private boolean equalsMessageByTemplate(String message, String template) {
        if (template.indexOf("}") > 0 && template.indexOf("{") > 0) {
            String templateWithoutParameters = template.replaceAll("\\{.*?\\} ?", "");
            String[] splitTemplate = templateWithoutParameters.split("\\s+");
            int prevPosition = 0;
            for (int i = 0; i < splitTemplate.length; ++i) {
                int foundedIndex = message.indexOf(splitTemplate[i], prevPosition);
                if (foundedIndex < 0 && foundedIndex < prevPosition) {
                    return false;
                }
                prevPosition = foundedIndex;
            }
            return true;
        }
        return message.contains(template);
    }

    public int getSize() {
        return this.listAppender.list.size();
    }

    private void before() {
        this.resetLoggingContext();
        this.addAppenderToPackage();
        this.listAppender.start();
    }

    private void after() {
        this.listAppender.stop();
        this.resetLoggingContext();
    }

    private void addAppenderToPackage() {
        Logger logger = LoggerFactory.getLogger((String)ROOT_ITEXT_PACKAGE);
        if (logger instanceof ch.qos.logback.classic.Logger) {
            ((ch.qos.logback.classic.Logger)logger).addAppender(this.listAppender);
        }
    }

    private void resetLoggingContext() {
        if (this.lc instanceof LoggerContext) {
            ((LoggerContext)this.lc).reset();
        } else if (this.lc instanceof SubstituteLoggerFactory) {
            ((SubstituteLoggerFactory)this.lc).clear();
        }
    }

    private void checkLogMessages(Description description) {
        Annotation annotation = description.getAnnotation(LogMessages.class);
        int checkedMessages = 0;
        if (annotation != null) {
            LogMessage[] messages;
            LogMessages logMessages = (LogMessages)annotation;
            for (LogMessage logMessage : messages = logMessages.messages()) {
                int foundCount = this.contains(logMessage.messageTemplate());
                if (foundCount != logMessage.count() && !logMessages.ignore()) {
                    Assert.fail((String)MessageFormat.format("{0}:{1} Expected to find {2}, but found {3} messages with the following content: \"{4}\"", description.getClassName(), description.getMethodName(), logMessage.count(), foundCount, logMessage.messageTemplate()));
                    continue;
                }
                checkedMessages += foundCount;
            }
        }
        if (this.getSize() > checkedMessages) {
            Assert.fail((String)MessageFormat.format("{0}.{1}: The test does not check the message logging - {2} messages", description.getClassName(), description.getMethodName(), this.getSize() - checkedMessages));
        }
    }

    private class CustomListAppender<E>
    extends ListAppender<ILoggingEvent> {
        private CustomListAppender() {
        }

        protected void append(ILoggingEvent e) {
            System.out.println(e.getLoggerName() + " " + e.getLevel() + " " + e.getMessage());
            this.printStackTraceIfAny(e);
            if (e.getLevel().isGreaterOrEqual(Level.WARN)) {
                this.list.add(e);
            }
        }

        private void printStackTraceIfAny(ILoggingEvent e) {
            IThrowableProxy throwableProxy = e.getThrowableProxy();
            if (throwableProxy != null) {
                System.out.println(throwableProxy.getMessage());
                for (StackTraceElementProxy el : throwableProxy.getStackTraceElementProxyArray()) {
                    System.out.println("\t" + el);
                }
            }
        }
    }
}

