/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.test.runners;

import org.junit.Ignore;
import org.junit.internal.AssumptionViolatedException;
import org.junit.internal.runners.model.EachTestNotifier;
import org.junit.runner.Description;
import org.junit.runner.notification.RunNotifier;
import org.junit.runner.notification.StoppedByUserException;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.Statement;

public class RetryRunner
extends BlockJUnit4ClassRunner {
    private final int retryCount = 3;
    private int failedAttempts = 0;

    public RetryRunner(Class<?> klass) throws InitializationError {
        super(klass);
    }

    public void run(RunNotifier notifier) {
        EachTestNotifier eachTestNotifier = new EachTestNotifier(notifier, this.getDescription());
        Statement statement = this.classBlock(notifier);
        try {
            statement.evaluate();
        }
        catch (org.junit.AssumptionViolatedException ave) {
            eachTestNotifier.fireTestIgnored();
        }
        catch (StoppedByUserException sue) {
            throw sue;
        }
        catch (Throwable throwable) {
            this.retry(eachTestNotifier, statement, throwable);
        }
    }

    protected void runChild(FrameworkMethod method, RunNotifier notifier) {
        Description description = this.describeChild(method);
        if (method.getAnnotation(Ignore.class) != null) {
            notifier.fireTestIgnored(description);
        } else {
            this.runTestUnit(this.methodBlock(method), description, notifier);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void runTestUnit(Statement statement, Description description, RunNotifier notifier) {
        this.failedAttempts = 0;
        EachTestNotifier eachNotifier = new EachTestNotifier(notifier, description);
        eachNotifier.fireTestStarted();
        try {
            statement.evaluate();
        }
        catch (org.junit.AssumptionViolatedException avee) {
            eachNotifier.addFailedAssumption((AssumptionViolatedException)avee);
        }
        catch (Throwable e) {
            this.retry(eachNotifier, statement, e);
        }
        finally {
            eachNotifier.fireTestFinished();
        }
    }

    private void retry(EachTestNotifier notifier, Statement statement, Throwable currentThrowable) {
        Throwable caughtThrowable = currentThrowable;
        while (3 > this.failedAttempts) {
            try {
                statement.evaluate();
            }
            catch (Throwable e) {
                System.out.println("Test Failed on attempt #" + (this.failedAttempts + 1));
                ++this.failedAttempts;
                caughtThrowable = e;
            }
        }
        notifier.addFailure(caughtThrowable);
    }
}

