/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.test;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.IThrowableProxy;
import ch.qos.logback.classic.spi.StackTraceElementProxy;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.read.ListAppender;
import com.itextpdf.test.LoggerHelper;
import com.itextpdf.test.annotations.LogMessage;
import com.itextpdf.test.annotations.LogMessages;
import java.util.List;
import java.util.Map;
import org.junit.rules.TestWatcher;
import org.junit.runner.Description;
import org.slf4j.ILoggerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.helpers.SubstituteLoggerFactory;

public class LogListener
extends TestWatcher {
    private static final String ROOT_ITEXT_PACKAGE = "com.itextpdf";
    private final ListAppender<ILoggingEvent> listAppender = new CustomListAppender();
    private final ILoggerFactory lc = LoggerFactory.getILoggerFactory();
    private Map<ch.qos.logback.classic.Logger, Map<String, Appender<ILoggingEvent>>> appenders;

    protected void starting(Description description) {
        this.before();
    }

    protected void finished(Description description) {
        this.checkLogMessages(description);
        this.after();
    }

    private int contains(String loggingStatement) {
        List list = this.listAppender.list;
        int index = 0;
        for (ILoggingEvent event : list) {
            if (!LoggerHelper.equalsMessageByTemplate(event.getFormattedMessage(), loggingStatement)) continue;
            ++index;
        }
        return index;
    }

    public int getSize() {
        return this.listAppender.list.size();
    }

    private void before() {
        this.listAppender.list.clear();
        this.appenders = LoggerHelper.getAllAppendersMap((LoggerContext)this.lc);
        this.resetLoggingContext();
        this.addAppenderToPackage();
        this.listAppender.start();
    }

    private void after() {
        this.listAppender.stop();
        this.resetLoggingContext();
        LoggerHelper.restoreAppenders(this.appenders);
    }

    private void addAppenderToPackage() {
        Logger logger = LoggerFactory.getLogger((String)ROOT_ITEXT_PACKAGE);
        if (logger instanceof ch.qos.logback.classic.Logger) {
            ((ch.qos.logback.classic.Logger)logger).addAppender(this.listAppender);
        }
    }

    private void resetLoggingContext() {
        if (this.lc instanceof LoggerContext) {
            ((LoggerContext)this.lc).reset();
        } else if (this.lc instanceof SubstituteLoggerFactory) {
            ((SubstituteLoggerFactory)this.lc).clear();
        }
    }

    private void checkLogMessages(Description description) {
        LogMessages logMessages = LoggerHelper.getTestAnnotation(description, LogMessages.class);
        int checkedMessages = 0;
        if (logMessages != null) {
            LogMessage[] messages;
            for (LogMessage logMessage : messages = logMessages.messages()) {
                int foundCount = this.contains(logMessage.messageTemplate());
                if (foundCount != logMessage.count() && !logMessages.ignore()) {
                    LoggerHelper.failWrongMessageCount(logMessage.count(), foundCount, logMessage.messageTemplate(), description);
                    continue;
                }
                checkedMessages += foundCount;
            }
        }
        if (this.getSize() > checkedMessages) {
            LoggerHelper.failWrongTotalCount(this.getSize(), checkedMessages, description);
        }
    }

    private class CustomListAppender<E>
    extends ListAppender<ILoggingEvent> {
        private CustomListAppender() {
        }

        protected void append(ILoggingEvent e) {
            System.out.println(e.getLoggerName() + " " + e.getLevel() + " " + e.getMessage());
            this.printStackTraceIfAny(e);
            if (e.getLevel().isGreaterOrEqual(Level.WARN)) {
                this.list.add(e);
            }
        }

        private void printStackTraceIfAny(ILoggingEvent e) {
            IThrowableProxy throwableProxy = e.getThrowableProxy();
            if (throwableProxy != null) {
                System.out.println(throwableProxy.getMessage());
                for (StackTraceElementProxy el : throwableProxy.getStackTraceElementProxyArray()) {
                    System.out.println("\t" + el);
                }
            }
        }
    }
}

