/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.test;

import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Appender;
import java.lang.annotation.Annotation;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Pattern;
import org.junit.Assert;
import org.junit.runner.Description;
import org.slf4j.LoggerFactory;

public class LoggerHelper {
    static <T extends Annotation> T getTestAnnotation(Description description, Class<T> annotationClass) {
        Annotation annotation = description.getAnnotation(annotationClass);
        if (annotation == null) {
            annotation = description.getTestClass().getAnnotation(annotationClass);
        }
        return (T)annotation;
    }

    static void failWrongMessageCount(int expected, int actual, String messageTemplate, Description description) {
        Assert.fail((String)MessageFormat.format("{0}:{1} Expected to find {2}, but found {3} messages with the following content: \"{4}\"", description.getClassName(), description.getMethodName(), expected, actual, messageTemplate));
    }

    static void failWrongTotalCount(int expected, int actual, Description description) {
        Assert.fail((String)MessageFormat.format("{0}.{1}: The test does not check the message logging - {2} messages", description.getClassName(), description.getMethodName(), expected - actual));
    }

    static boolean equalsMessageByTemplate(String message, String template) {
        if (template.contains("{") && template.contains("}")) {
            String templateWithoutParameters = Pattern.quote(template).replace("''", "'").replaceAll("\\{[0-9]+?}", "\\\\E(.)*?\\\\Q");
            Pattern p = Pattern.compile(templateWithoutParameters, 32);
            return p.matcher(message).matches();
        }
        return message.contains(template);
    }

    public static void restoreAppenders(Map<Logger, Map<String, Appender<ILoggingEvent>>> appenders) {
        for (Logger logger : appenders.keySet()) {
            Map<String, Appender<ILoggingEvent>> appenderMap = appenders.get(logger);
            Logger currentLogger = (Logger)LoggerFactory.getLogger((String)logger.getName());
            for (String appenderName : appenderMap.keySet()) {
                currentLogger.addAppender(appenderMap.get(appenderName));
            }
        }
    }

    public static Map<Logger, Map<String, Appender<ILoggingEvent>>> getAllAppendersMap(LoggerContext loggerContext) {
        HashMap<Logger, Map<String, Appender<ILoggingEvent>>> resultMap = new HashMap<Logger, Map<String, Appender<ILoggingEvent>>>();
        for (Logger logger : loggerContext.getLoggerList()) {
            HashMap<String, Appender> appendersMap = new HashMap<String, Appender>();
            Iterator appenderIterator = logger.iteratorForAppenders();
            while (appenderIterator.hasNext()) {
                Appender appender = (Appender)appenderIterator.next();
                appendersMap.put(appender.getName(), appender);
            }
            resultMap.put(logger, appendersMap);
        }
        return resultMap;
    }
}

